/*
 * Decompiled with CFR 0.152.
 */
package test.functional.inventory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.adempiere.exceptions.AdempiereException;
import test.functional.inventory.MMDocument;

public class MMScenario {
    public final String name;
    public String key = null;
    public final List<MMDocument> docs = new ArrayList<MMDocument>();
    public final HashMap<String, Integer> asiCodes = new HashMap();

    public MMScenario(String name) {
        this.name = name;
    }

    public MMDocument get(String docBaseType, String documentNo) {
        if (documentNo == null) {
            throw new IllegalArgumentException("documentNo is null");
        }
        for (MMDocument doc : this.docs) {
            if (!docBaseType.equals(doc.DocBaseType) || !documentNo.equals(documentNo)) continue;
            return doc;
        }
        throw new AdempiereException("[" + this.name + "] document not found for DocBaseType=" + docBaseType + ", documentNo=" + documentNo);
    }

    public void registerASICode(String asiCode, int M_ASI_ID, boolean isCreated) {
        asiCode = asiCode.trim();
        if (isCreated && this.asiCodes.get(asiCode) != null) {
            throw new AdempiereException("ASI Should be unique : Code=" + asiCode + ", ID=" + M_ASI_ID);
        }
        this.asiCodes.put(asiCode, M_ASI_ID);
    }

    public int getM_ASI_ID(String asiCode) {
        if ((asiCode = asiCode.trim()).equals("0")) {
            return 0;
        }
        Integer asi_id = this.asiCodes.get(asiCode);
        if (asi_id == null) {
            throw new AdempiereException("No ASI created for Code=" + asiCode);
        }
        return asi_id;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("__SCENARIO________________________________________________\n");
        sb.append("   Name : " + this.name).append("\n");
        sb.append("    Key : " + this.key).append("\n");
        sb.append("Lines: \n");
        for (MMDocument mMDocument : this.docs) {
            sb.append("    ").append(mMDocument.toString()).append("\n");
        }
        sb.append("ASI(Code=>ID): ");
        for (Map.Entry entry : this.asiCodes.entrySet()) {
            sb.append("(").append((String)entry.getKey()).append("=>").append(entry.getValue()).append("); ");
        }
        sb.append("\n");
        sb.append("__________________________________________________________\n");
        return sb.toString();
    }
}

