/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import org.compiere.model.MCalendar;
import org.compiere.model.MPeriod;
import org.compiere.util.DB;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.eevolution.model.MHRPayroll;
import org.eevolution.model.MHRPeriod;
import org.eevolution.model.X_HR_Year;

public class MHRYear
extends X_HR_Year {
    private static final long serialVersionUID = -7789699154024839462L;

    public MHRYear(Properties ctx, int HR_Year_ID, String trxName) {
        super(ctx, HR_Year_ID, trxName);
        if (HR_Year_ID == 0) {
            this.setProcessing(false);
        }
    }

    public MHRYear(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MHRYear(MCalendar calendar) {
        this(calendar.getCtx(), 0, calendar.get_TrxName());
        this.setClientOrg(calendar);
    }

    public boolean createPeriods() {
        int sumDays = 0;
        int C_Calendar_ID = DB.getSQLValueEx(this.get_TrxName(), "SELECT C_Calendar_ID FROM C_Year WHERE C_Year_ID = ?", this.getC_Year_ID());
        if (C_Calendar_ID <= 0) {
            return false;
        }
        Timestamp StartDate = null;
        Timestamp EndDate = null;
        MHRPayroll payroll = new MHRPayroll(this.getCtx(), this.getHR_Payroll_ID(), this.get_TrxName());
        int period = 1;
        while (period <= this.getQty()) {
            if (12 == this.getQty() && (28 == this.getNetDays() || 29 == this.getNetDays() || 30 == this.getNetDays() || 31 == this.getNetDays())) {
                StartDate = period > 1 ? TimeUtil.addDays(EndDate, 1) : TimeUtil.addDays(this.getStartDate(), 0);
                EndDate = TimeUtil.getMonthLastDay(StartDate);
            } else {
                sumDays = period == 1 ? 0 : (period - 1) * this.getNetDays();
                StartDate = TimeUtil.addDays(this.getStartDate(), sumDays);
                EndDate = TimeUtil.addDays(StartDate, this.getNetDays() - 1);
            }
            int C_Period_ID = DB.getSQLValueEx(this.get_TrxName(), "SELECT C_Period_ID FROM C_Period p  INNER JOIN C_Year y ON (p.C_Year_ID=y.C_Year_ID)  WHERE  ? BETWEEN p.startdate AND p.endDate AND y.C_Calendar_ID=?", EndDate, C_Calendar_ID);
            if (C_Period_ID <= 0) {
                return false;
            }
            MPeriod m_period = MPeriod.get(this.getCtx(), C_Period_ID);
            MHRPeriod HR_Period = new MHRPeriod(this.getCtx(), 0, this.get_TrxName());
            HR_Period.setAD_Org_ID(this.getAD_Org_ID());
            HR_Period.setHR_Year_ID(this.getHR_Year_ID());
            HR_Period.setHR_Payroll_ID(this.getHR_Payroll_ID());
            HR_Period.setName(String.valueOf(StartDate.toString().substring(0, 10)) + " " + Msg.translate(this.getCtx(), "To") + " " + EndDate.toString().substring(0, 10));
            HR_Period.setDescription(String.valueOf(Msg.translate(this.getCtx(), "HR_Payroll_ID")) + " " + payroll.getName().trim() + " " + Msg.translate(this.getCtx(), "From") + " " + period + " " + Msg.translate(this.getCtx(), "To") + " " + StartDate.toString().substring(0, 10) + " al " + EndDate.toString().substring(0, 10));
            HR_Period.setPeriodNo(period);
            HR_Period.setC_Period_ID(C_Period_ID);
            HR_Period.setC_Year_ID(m_period.getC_Year_ID());
            HR_Period.setStartDate(StartDate);
            HR_Period.setEndDate(EndDate);
            HR_Period.setDateAcct(EndDate);
            HR_Period.setIsActive(true);
            HR_Period.saveEx();
            ++period;
        }
        return true;
    }
}

