/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.EventObject;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import org.compiere.apps.ADialog;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.grid.ed.VComboBox;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VNumber;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.plaf.CompiereColor;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.eevolution.model.MHRConcept;
import org.eevolution.model.MHREmployee;
import org.eevolution.model.MHRMovement;
import org.eevolution.model.MHRPeriod;
import org.eevolution.model.MHRProcess;

public class VHRActionNotice
extends CPanel
implements FormPanel,
VetoableChangeListener,
ActionListener {
    private static final long serialVersionUID = 5905687280280831354L;
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private int HR_Process_ID = 0;
    private int HR_Payroll_ID = 0;
    private int sHR_Movement_ID = 0;
    private Timestamp dateStart = null;
    private Timestamp dateEnd = null;
    private static CLogger log = CLogger.getCLogger(VHRActionNotice.class);
    private CPanel mainPanel = new CPanel();
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel parameterPanel = new CPanel();
    private CLabel labelProcess = new CLabel();
    private VComboBox fieldProcess;
    private CLabel labelEmployee = new CLabel();
    private VComboBox fieldEmployee = new VComboBox();
    private CLabel labelColumnType = new CLabel();
    private CTextField fieldColumnType = new CTextField(18);
    private CLabel labelConcept = new CLabel();
    private VComboBox fieldConcept = new VComboBox();
    private JLabel labelValue = new JLabel();
    private VNumber fieldQty = new VNumber();
    private VNumber fieldAmount = new VNumber();
    private VDate fieldDate = new VDate();
    private CTextField fieldText = new CTextField(22);
    private VNumber fieldRuleE = new VNumber();
    private JLabel dataStatus = new JLabel();
    private JScrollPane dataPane = new JScrollPane();
    private MiniTable miniTable = new MiniTable();
    private CPanel commandPanel = new CPanel();
    private FlowLayout commandLayout = new FlowLayout();
    private JButton bOk = ConfirmPanel.createOKButton(true);
    private CLabel labelValidFrom = new CLabel();
    private VDate fieldValidFrom = new VDate();
    private CLabel labelDescription = new CLabel();
    private CTextField fieldDescription = new CTextField(22);
    private GridBagLayout parameterLayout = new GridBagLayout();

    @Override
    public void init(int WindowNo, FormFrame frame) {
        log.info("");
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        this.jbInit();
        this.dynInit();
        frame.getContentPane().add((Component)this.mainPanel, "Center");
        frame.setSize(1000, 400);
    }

    private void jbInit() {
        CompiereColor.setBackground(this);
        this.mainPanel.setLayout(this.mainLayout);
        this.mainPanel.setPreferredSize(new Dimension(1000, 400));
        this.parameterPanel.setLayout(this.parameterLayout);
        this.labelProcess.setText(Msg.translate(Env.getCtx(), "HR_Process_ID"));
        this.fieldProcess = new VComboBox(this.getProcess());
        this.fieldProcess.setMandatory(true);
        this.fieldProcess.addActionListener(this);
        this.labelEmployee.setText(Msg.translate(Env.getCtx(), "HR_Employee_ID"));
        this.fieldEmployee.setReadWrite(false);
        this.fieldEmployee.setMandatory(true);
        this.fieldEmployee.addActionListener(this);
        this.fieldEmployee.addVetoableChangeListener(this);
        this.labelConcept.setText(Msg.translate(Env.getCtx(), "HR_Concept_ID"));
        this.getConceptValid();
        this.fieldConcept.setReadWrite(false);
        this.fieldConcept.setMandatory(true);
        this.fieldConcept.addActionListener(this);
        this.labelValidFrom.setText(Msg.translate(Env.getCtx(), "Date"));
        this.fieldValidFrom.setReadWrite(false);
        this.fieldValidFrom.setMandatory(true);
        this.fieldValidFrom.addVetoableChangeListener(this);
        this.labelDescription.setText(Msg.translate(Env.getCtx(), "Description"));
        this.fieldDescription.setValue("");
        this.fieldDescription.setReadWrite(false);
        this.labelColumnType.setText(Msg.translate(Env.getCtx(), "ColumnType"));
        this.fieldColumnType.setReadWrite(false);
        this.fieldQty.setReadWrite(false);
        this.fieldQty.setDisplayType(29);
        this.fieldQty.setVisible(true);
        this.fieldAmount.setDisplayType(12);
        this.fieldAmount.setVisible(false);
        this.fieldDate.setVisible(false);
        this.fieldText.setVisible(false);
        this.fieldRuleE.setVisible(false);
        this.bOk.addActionListener(this);
        this.mainPanel.add((Component)this.parameterPanel, "North");
        this.parameterPanel.add((Component)this.labelProcess, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.fieldProcess, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.labelEmployee, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.fieldEmployee, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.labelValidFrom, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.fieldValidFrom, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.labelConcept, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.fieldConcept, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.labelColumnType, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.fieldColumnType, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.labelValue, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.fieldQty, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.fieldAmount, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.fieldDate, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.fieldText, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.labelDescription, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.fieldDescription, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.bOk, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.dataStatus, "South");
        this.mainPanel.add((Component)this.dataPane, "Center");
        this.dataPane.getViewport().add((Component)this.miniTable, null);
        this.commandPanel.setLayout(this.commandLayout);
        this.commandLayout.setAlignment(2);
        this.commandLayout.setHgap(10);
    }

    private void dynInit() {
        this.miniTable.addColumn("HR_Movement_ID");
        this.miniTable.addColumn("AD_Org_ID");
        this.miniTable.addColumn("HR_Concept_ID");
        this.miniTable.addColumn("ValidFrom");
        this.miniTable.addColumn("ColumnType");
        this.miniTable.addColumn("Qty");
        this.miniTable.addColumn("Amount");
        this.miniTable.addColumn("ServiceDate");
        this.miniTable.addColumn("Text");
        this.miniTable.addColumn("AD_Rule_ID");
        this.miniTable.addColumn("Description");
        this.miniTable.setColumnClass(0, IDColumn.class, false, " ");
        this.miniTable.setColumnClass(1, String.class, true, Msg.translate(Env.getCtx(), "AD_Org_ID"));
        this.miniTable.setColumnClass(2, String.class, true, Msg.translate(Env.getCtx(), "HR_Concept_ID"));
        this.miniTable.setColumnClass(3, Timestamp.class, true, Msg.translate(Env.getCtx(), "ValidFrom"));
        this.miniTable.setColumnClass(4, String.class, true, Msg.translate(Env.getCtx(), "ColumnType"));
        this.miniTable.setColumnClass(5, BigDecimal.class, true, Msg.translate(Env.getCtx(), "Qty"));
        this.miniTable.setColumnClass(6, BigDecimal.class, true, Msg.translate(Env.getCtx(), "Amount"));
        this.miniTable.setColumnClass(7, Timestamp.class, true, Msg.translate(Env.getCtx(), "ServiceDate"));
        this.miniTable.setColumnClass(8, String.class, true, Msg.translate(Env.getCtx(), "Text"));
        this.miniTable.setColumnClass(9, String.class, true, Msg.translate(Env.getCtx(), "AD_Rule_ID"));
        this.miniTable.setColumnClass(10, String.class, true, Msg.translate(Env.getCtx(), "Description"));
        this.miniTable.autoSize();
    }

    @Override
    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
        this.fieldConcept.setReadWrite(true);
        log.fine("Event" + e);
        log.fine("Event Source " + e.getSource());
        log.fine("Event Property " + e.getPropertyName());
        this.processChangeEvent(e);
        Integer HR_Period_ID = new MHRProcess(Env.getCtx(), (Integer)this.fieldProcess.getValue(), null).getHR_Period_ID();
        String date = DB.TO_DATE((Timestamp)this.fieldValidFrom.getValue());
        int existRange = DB.getSQLValueEx(null, "SELECT * FROM HR_Period WHERE " + date + " >= StartDate AND " + date + " <= EndDate AND HR_Period_ID = " + HR_Period_ID, new Object[0]);
        if (existRange < 0) {
            this.fieldConcept.setReadWrite(false);
            return;
        }
        if (this.fieldConcept != null) {
            this.sHR_Movement_ID = this.seekMovement();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        log.fine("Event " + e);
        log.fine("Event Source " + e.getSource());
        this.processChangeEvent(e);
    }

    private void processChangeEvent(EventObject e) {
        if (e.getSource().equals(this.fieldProcess)) {
            KeyNamePair pp = (KeyNamePair)this.fieldProcess.getSelectedItem();
            if (pp != null) {
                this.HR_Process_ID = pp.getKey();
                MHRProcess process = new MHRProcess(Env.getCtx(), this.HR_Process_ID, null);
                if (process.getHR_Period_ID() > 0) {
                    MHRPeriod period = MHRPeriod.get(Env.getCtx(), process.getHR_Period_ID());
                    this.dateStart = period.getStartDate();
                    this.dateEnd = period.getEndDate();
                } else {
                    this.dateEnd = process.getDateAcct();
                }
                this.HR_Payroll_ID = process.getHR_Payroll_ID();
                this.getEmployeeValid(process);
                this.fieldEmployee.setReadWrite(true);
            }
        } else if (e.getSource().equals(this.fieldEmployee)) {
            KeyNamePair pp = (KeyNamePair)this.fieldEmployee.getSelectedItem();
            int C_BPartner_ID = 0;
            if (pp != null) {
                C_BPartner_ID = pp.getKey();
            }
            if (C_BPartner_ID > 0) {
                this.fieldValidFrom.setValue(this.dateEnd);
                this.fieldValidFrom.setReadWrite(true);
                this.getConceptValid();
                this.fieldConcept.setReadWrite(true);
                this.executeQuery();
            }
        } else if (e.getSource().equals(this.fieldConcept)) {
            KeyNamePair pp = (KeyNamePair)this.fieldConcept.getSelectedItem();
            int HR_Concept_ID = 0;
            if (pp != null) {
                HR_Concept_ID = pp.getKey();
            }
            if (HR_Concept_ID > 0) {
                MHRConcept concept = MHRConcept.get(Env.getCtx(), HR_Concept_ID);
                this.fieldColumnType.setValue(DB.getSQLValueStringEx(null, this.getSQL_ColumnType("?"), concept.getColumnType()));
                this.sHR_Movement_ID = this.seekMovement();
                if (concept.getColumnType().equals("Q")) {
                    this.fieldQty.setVisible(true);
                    this.fieldQty.setReadWrite(true);
                    this.fieldAmount.setVisible(false);
                    this.fieldDate.setVisible(false);
                    this.fieldText.setVisible(false);
                    this.fieldRuleE.setVisible(false);
                } else if (concept.getColumnType().equals("A")) {
                    this.fieldQty.setVisible(false);
                    this.fieldAmount.setVisible(true);
                    this.fieldAmount.setReadWrite(true);
                    this.fieldDate.setVisible(false);
                    this.fieldText.setVisible(false);
                    this.fieldRuleE.setVisible(false);
                } else if (concept.getColumnType().equals("D")) {
                    this.fieldQty.setVisible(false);
                    this.fieldAmount.setVisible(false);
                    this.fieldDate.setVisible(true);
                    this.fieldDate.setReadWrite(true);
                    this.fieldText.setVisible(false);
                    this.fieldRuleE.setVisible(false);
                } else if (concept.getColumnType().equals("T")) {
                    this.fieldText.setVisible(true);
                    this.fieldText.setReadWrite(true);
                    this.fieldAmount.setVisible(false);
                    this.fieldDate.setVisible(false);
                    this.fieldRuleE.setVisible(false);
                }
                this.fieldDescription.setReadWrite(true);
            }
        } else if (e instanceof ActionEvent && e.getSource().equals(this.bOk)) {
            KeyNamePair pp = (KeyNamePair)this.fieldConcept.getSelectedItem();
            int HR_Concept_ID = pp.getKey();
            if (HR_Concept_ID <= 0 || this.fieldProcess.getValue() == null || (Integer)this.fieldProcess.getValue() <= 0 || this.fieldEmployee.getValue() == null || (Integer)this.fieldEmployee.getValue() <= 0) {
                ADialog.error(this.m_WindowNo, this, String.valueOf(Msg.translate(Env.getCtx(), "FillMandatory")) + Msg.translate(Env.getCtx(), "HR_Process_ID") + ", " + Msg.translate(Env.getCtx(), "HR_Employee_ID") + ", " + Msg.translate(Env.getCtx(), "HR_Concept_ID"));
            } else {
                MHRConcept conceptOK = MHRConcept.get(Env.getCtx(), HR_Concept_ID);
                int mov = this.sHR_Movement_ID > 0 ? this.sHR_Movement_ID : 0;
                MHRMovement movementOK = new MHRMovement(Env.getCtx(), mov, null);
                movementOK.setDescription(this.fieldDescription.getValue() != null ? this.fieldDescription.getValue().toString() : "");
                movementOK.setHR_Process_ID((Integer)this.fieldProcess.getValue());
                movementOK.setC_BPartner_ID((Integer)this.fieldEmployee.getValue());
                movementOK.setHR_Concept_ID((Integer)this.fieldConcept.getValue());
                movementOK.setHR_Concept_Category_ID(conceptOK.getHR_Concept_Category_ID());
                movementOK.setColumnType(conceptOK.getColumnType());
                movementOK.setQty(this.fieldQty.getValue() != null ? (BigDecimal)this.fieldQty.getValue() : Env.ZERO);
                movementOK.setAmount(this.fieldAmount.getValue() != null ? (BigDecimal)this.fieldAmount.getValue() : Env.ZERO);
                movementOK.setTextMsg(this.fieldText.getValue() != null ? this.fieldText.getValue().toString() : "");
                movementOK.setServiceDate(this.fieldDate.getValue() != null ? (Timestamp)this.fieldDate.getValue() : null);
                movementOK.setValidFrom(this.fieldValidFrom.getTimestamp());
                movementOK.setValidTo(this.fieldValidFrom.getTimestamp());
                MHREmployee employee = MHREmployee.getActiveEmployee(Env.getCtx(), movementOK.getC_BPartner_ID(), null);
                if (employee != null) {
                    movementOK.setHR_Department_ID(employee.getHR_Department_ID());
                    movementOK.setHR_Job_ID(employee.getHR_Job_ID());
                    movementOK.setC_Activity_ID(employee.getC_Activity_ID());
                }
                movementOK.setIsRegistered(true);
                movementOK.saveEx();
                if (!(movementOK.getAmount() != null && Env.ZERO.compareTo(movementOK.getAmount()) != 0 || movementOK.getQty() != null && Env.ZERO.compareTo(movementOK.getQty()) != 0 || movementOK.getServiceDate() != null || movementOK.getTextMsg() != null && movementOK.getTextMsg().trim().length() != 0)) {
                    movementOK.deleteEx(false);
                }
                this.executeQuery();
                this.fieldValidFrom.setValue(this.dateEnd);
                this.fieldColumnType.setValue("");
                this.fieldQty.setValue(Env.ZERO);
                this.fieldAmount.setValue(Env.ZERO);
                this.fieldQty.setReadWrite(false);
                this.fieldAmount.setReadWrite(false);
                this.fieldText.setReadWrite(false);
                this.fieldDescription.setReadWrite(false);
                this.sHR_Movement_ID = 0;
                this.fieldDescription.setValue("");
                this.fieldText.setValue("");
                this.fieldDate.setValue(null);
                this.fieldQty.setValue(Env.ZERO);
                this.fieldAmount.setValue(Env.ZERO);
                this.fieldConcept.setSelectedIndex(0);
            }
        }
    }

    private void executeQuery() {
        block7: {
            StringBuffer sqlQuery = new StringBuffer("SELECT DISTINCT o.Name,hp.Name, bp.Name,hc.Name,hm.ValidFrom,(" + this.getSQL_ColumnType("hc.ColumnType") + ") AS ColumnType," + " hm.Qty,hm.Amount,hm.ServiceDate,hm.TextMsg,er.Name,hm.Description " + " , HR_Movement_id, hm.AD_Org_ID,hp.HR_Process_ID,hm.HR_Concept_ID " + " FROM HR_Movement hm " + " INNER JOIN AD_Org o ON (hm.AD_Org_ID=o.AD_Org_ID)" + " INNER JOIN HR_Process hp ON (hm.HR_Process_ID=hp.HR_Process_ID)" + " INNER JOIN C_BPartner bp ON (hm.C_BPartner_ID=bp.C_BPartner_ID)" + " INNER JOIN HR_Employee e ON (e.C_BPartner_ID=bp.C_BPartner_ID)" + " INNER JOIN HR_Concept hc ON (hm.HR_Concept_ID=hc.HR_Concept_ID)" + " LEFT OUTER JOIN AD_Rule er ON (hm.AD_Rule_ID=er.AD_Rule_ID)" + " WHERE hm.Processed='N' AND hp.HR_Process_ID = " + this.fieldProcess.getValue() + " AND hm.C_BPartner_ID = " + this.fieldEmployee.getValue() + " AND (Qty > 0 OR Amount > 0 OR hm.TextMsg IS NOT NULL OR ServiceDate IS NOT NULL) ");
            if (this.fieldValidFrom.getValue() == null) {
                sqlQuery.append(" AND " + DB.TO_DATE(this.dateStart) + " >= hm.ValidFrom  AND " + DB.TO_DATE(this.dateEnd) + " <=  hm.ValidTo ");
            }
            sqlQuery.append(" ORDER BY hm.AD_Org_ID,hp.HR_Process_ID,bp.Name,hm.ValidFrom,hm.HR_Concept_ID");
            int row = 0;
            this.miniTable.setRowCount(row);
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sqlQuery.toString(), null);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        this.miniTable.setRowCount(row + 1);
                        this.miniTable.setColumnClass(0, IDColumn.class, false, " ");
                        this.miniTable.setValueAt(rs.getString(1), row, 1);
                        this.miniTable.setValueAt(rs.getString(4), row, 2);
                        this.miniTable.setValueAt(rs.getTimestamp(5), row, 3);
                        this.miniTable.setValueAt(rs.getString(6), row, 4);
                        this.miniTable.setValueAt(rs.getObject(7) != null ? rs.getBigDecimal(7) : Env.ZERO, row, 5);
                        this.miniTable.setValueAt(rs.getObject(8) != null ? rs.getBigDecimal(8) : Env.ZERO, row, 6);
                        this.miniTable.setValueAt(rs.getTimestamp(9), row, 7);
                        this.miniTable.setValueAt(rs.getString(10), row, 8);
                        this.miniTable.setValueAt(rs.getString(11), row, 9);
                        this.miniTable.setValueAt(rs.getString(12), row, 10);
                        ++row;
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sqlQuery.toString(), e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        this.miniTable.autoSize();
    }

    private KeyNamePair[] getProcess() {
        String sql = String.valueOf(MRole.getDefault().addAccessSQL("SELECT hrp.HR_Process_ID,hrp.DocumentNo ||'-'|| hrp.Name,hrp.DocumentNo,hrp.Name FROM HR_Process hrp", "hrp", true, false)) + " AND hrp.IsActive = 'Y' ";
        sql = String.valueOf(sql) + " ORDER BY hrp.DocumentNo, hrp.Name";
        return DB.getKeyNamePairs(sql, true);
    }

    private void getEmployeeValid(MHRProcess process) {
        block8: {
            if (process == null) {
                return;
            }
            this.fieldEmployee.removeAllItems();
            KeyNamePair pp = new KeyNamePair(0, "");
            this.fieldEmployee.addItem(pp);
            String sql = String.valueOf(MRole.getDefault().addAccessSQL("SELECT DISTINCT bp.C_BPartner_ID,bp.Name FROM HR_Employee hrpe INNER JOIN C_BPartner bp ON(bp.C_BPartner_ID=hrpe.C_BPartner_ID)", "hrpe", true, false)) + " AND hrpe.IsActive = 'Y' ";
            if (process.getHR_Payroll_ID() != 0) {
                sql = String.valueOf(sql) + " AND (hrpe.HR_Payroll_ID =" + process.getHR_Payroll_ID() + " OR hrpe.HR_Payroll_ID is NULL)";
            }
            sql = String.valueOf(sql) + " ORDER BY bp.Name ";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        pp = new KeyNamePair(rs.getInt(1), rs.getString(2));
                        this.fieldEmployee.addItem(pp);
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        this.fieldEmployee.setSelectedIndex(0);
    }

    private void getConceptValid() {
        block8: {
            if (this.fieldProcess == null) {
                return;
            }
            this.fieldConcept.removeAllItems();
            KeyNamePair pp = new KeyNamePair(0, "");
            this.fieldConcept.addItem(pp);
            String sql = "SELECT DISTINCT hrpc.HR_Concept_ID,hrpc.Name,hrpc.Value  FROM HR_Concept hrpc  INNER JOIN HR_Attribute hrpa ON (hrpa.HR_Concept_ID=hrpc.HR_Concept_ID) WHERE hrpc.AD_Client_ID = " + Env.getAD_Client_ID(Env.getCtx()) + " AND hrpc.IsActive = 'Y' AND hrpc.IsRegistered = 'Y' AND hrpc.Type != 'E'" + " AND (hrpa.HR_Payroll_ID = " + this.HR_Payroll_ID + " OR hrpa.HR_Payroll_ID IS NULL)";
            if (this.fieldProcess != null) {
                // empty if block
            }
            sql = String.valueOf(sql) + " ORDER BY hrpc.Value";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        pp = new KeyNamePair(rs.getInt(1), rs.getString(2));
                        this.fieldConcept.addItem(pp);
                    }
                    rs.close();
                    pstmt.close();
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        this.fieldConcept.setSelectedIndex(0);
    }

    public int seekMovement() {
        if (this.fieldConcept.getValue() == null) {
            return 0;
        }
        int HR_Movement_ID = 0;
        String date = DB.TO_DATE((Timestamp)this.fieldValidFrom.getValue());
        int Process_ID = 0;
        KeyNamePair ppp = (KeyNamePair)this.fieldProcess.getSelectedItem();
        int Employee_ID = 0;
        KeyNamePair ppe = (KeyNamePair)this.fieldEmployee.getSelectedItem();
        int Concept_ID = 0;
        KeyNamePair ppc = (KeyNamePair)this.fieldConcept.getSelectedItem();
        Process_ID = ppp != null ? Integer.valueOf(ppp.getKey()) : null;
        Employee_ID = ppe != null ? Integer.valueOf(ppe.getKey()) : null;
        Concept_ID = ppc != null ? Integer.valueOf(ppc.getKey()) : null;
        MHRConcept concept = MHRConcept.get(Env.getCtx(), Concept_ID);
        if (Process_ID + Employee_ID + Concept_ID > 0 && (HR_Movement_ID = DB.getSQLValue(null, "SELECT HR_Movement_ID  FROM HR_Movement WHERE HR_Process_ID = " + Process_ID + " AND C_BPartner_ID =" + Employee_ID + " AND HR_Concept_ID = " + Concept_ID + " AND TRUNC(ValidFrom) = TRUNC(" + date + ")")) > 0) {
            this.sHR_Movement_ID = HR_Movement_ID;
            MHRMovement movementFound = new MHRMovement(Env.getCtx(), this.sHR_Movement_ID, null);
            this.fieldDescription.setValue(movementFound.getDescription());
            this.fieldText.setValue("");
            this.fieldDate.setValue(null);
            this.fieldQty.setValue(Env.ZERO);
            this.fieldAmount.setValue(Env.ZERO);
            if (concept.getColumnType().equals("Q")) {
                this.fieldQty.setValue(movementFound.getQty());
            } else if (concept.getColumnType().equals("A")) {
                this.fieldAmount.setValue(movementFound.getAmount());
            } else if (concept.getColumnType().equals("T")) {
                this.fieldText.setValue(movementFound.getTextMsg());
            } else if (concept.getColumnType().equals("D")) {
                this.fieldDate.setValue(movementFound.getServiceDate());
            }
        }
        return HR_Movement_ID;
    }

    private String getSQL_ColumnType(String sqlValue) {
        int columnType_Ref_ID = MTable.get(Env.getCtx(), MHRConcept.Table_ID).getColumn("ColumnType").getAD_Reference_Value_ID();
        String sql = Env.isBaseLanguage(Env.getCtx(), "AD_Ref_List") ? "SELECT zz.Name FROM AD_Ref_List zz WHERE zz.AD_Reference_ID=" + columnType_Ref_ID : "SELECT zz.Name FROM AD_Ref_List zz, AD_Ref_List_Trl zzt WHERE zz.AD_Reference_ID=" + columnType_Ref_ID + " AND zzt.AD_Ref_List_ID=zz.AD_Ref_List_ID" + " AND zzt.AD_Language=" + DB.TO_STRING(Env.getAD_Language(Env.getCtx()));
        sql = String.valueOf(sql) + " AND zz.Value = " + sqlValue;
        return sql;
    }
}

