/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import org.compiere.Adempiere;
import org.compiere.db.CConnection;
import org.compiere.model.MClient;
import org.compiere.model.MLookupCache;
import org.compiere.model.MRole;
import org.compiere.model.MSession;
import org.compiere.model.PO;
import org.compiere.swing.CFrame;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.CacheMgt;
import org.compiere.util.ContextProvider;
import org.compiere.util.DB;
import org.compiere.util.DefaultContextProvider;
import org.compiere.util.Ini;
import org.compiere.util.Language;
import org.compiere.util.Util;

public final class Env {
    private static CLogger s_log = CLogger.getCLogger(Env.class);
    private static ContextProvider contextProvider = new DefaultContextProvider();
    public static final int WINDOW_MAIN = 0;
    public static final int WINDOW_FIND = 1110;
    public static final int WINDOW_MLOOKUP = 1111;
    public static final int WINDOW_CUSTOMIZE = 1112;
    public static final int WINDOW_INFO = 1113;
    public static final int TAB_INFO = 1113;
    public static final String LANGUAGE = "#AD_Language";
    public static final String POS_ID = "#POS_ID";
    private static ArrayList<Container> s_windows = new ArrayList(20);
    private static ArrayList<CFrame> s_hiddenWindows = new ArrayList();
    private static boolean s_closingWindows = false;
    public static final BigDecimal ZERO = new BigDecimal(0.0);
    public static final BigDecimal ONE = new BigDecimal(1.0);
    public static final BigDecimal ONEHUNDRED = new BigDecimal(100.0);
    public static final String NL = System.getProperty("line.separator");

    public static void setContextProvider(ContextProvider provider) {
        contextProvider = provider;
        Env.getCtx().put(LANGUAGE, Language.getBaseAD_Language());
    }

    public static void exitEnv(int status) {
        MSession session;
        if (DB.isConnected(false) && (session = MSession.get(Env.getCtx(), false)) != null) {
            session.logout();
        }
        Env.reset(true);
        s_log.info("");
        CLogMgt.shutdown();
        if (Ini.isClient()) {
            System.exit(status);
        }
    }

    public static void logout() {
        MSession session = MSession.get(Env.getCtx(), false);
        if (session != null) {
            session.logout();
        }
        Env.reset(true);
        CConnection.get().setAppServerCredential(null, null);
    }

    public static void reset(boolean finalCall) {
        s_log.info("finalCall=" + finalCall);
        if (Ini.isClient()) {
            Env.closeWindows();
            if (s_windows.size() > 0) {
                if (!finalCall) {
                    Container c = s_windows.get(0);
                    s_windows.clear();
                    Env.createWindowNo(c);
                } else {
                    s_windows.clear();
                }
            }
        }
        if (finalCall) {
            Env.getCtx().clear();
        } else {
            Object[] keys = Env.getCtx().keySet().toArray();
            for (int i2 = 0; i2 < keys.length; ++i2) {
                String tag = keys[i2].toString();
                if (!Character.isDigit(tag.charAt(0))) continue;
                Env.getCtx().remove(keys[i2]);
            }
        }
        CacheMgt.get().reset();
        if (Ini.isClient()) {
            DB.closeTarget();
        }
        if (!finalCall) {
            MRole defaultRole;
            if (Ini.isClient()) {
                DB.setDBTarget(CConnection.get());
            }
            if ((defaultRole = MRole.getDefault(Env.getCtx(), false)) != null) {
                defaultRole.loadAccess(true);
            }
        }
    }

    public static final Properties getCtx() {
        return contextProvider.getContext();
    }

    public static void setCtx(Properties ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException("Require Context");
        }
        Env.getCtx().clear();
        Env.getCtx().putAll((Map<?, ?>)ctx);
    }

    public static void setContext(Properties ctx, String context, String value) {
        if (ctx == null || context == null) {
            return;
        }
        s_log.finer("Context " + context + "==" + value);
        if (value == null || value.length() == 0) {
            ctx.remove(context);
        } else {
            ctx.setProperty(context, value);
        }
    }

    public static void setContext(Properties ctx, String context, Timestamp value) {
        if (ctx == null || context == null) {
            return;
        }
        if (value == null) {
            ctx.remove(context);
            s_log.finer("Context " + context + "==" + value);
        } else {
            String stringValue = value.toString();
            stringValue = stringValue.substring(0, stringValue.indexOf("."));
            ctx.setProperty(context, stringValue);
            s_log.finer("Context " + context + "==" + stringValue);
        }
    }

    public static void setContext(Properties ctx, String context, int value) {
        if (ctx == null || context == null) {
            return;
        }
        s_log.finer("Context " + context + "==" + value);
        ctx.setProperty(context, String.valueOf(value));
    }

    public static void setContext(Properties ctx, String context, boolean value) {
        Env.setContext(ctx, context, value ? "Y" : "N");
    }

    public static void setContext(Properties ctx, int WindowNo, String context, String value) {
        if (ctx == null || context == null) {
            return;
        }
        if (WindowNo != 1110 && WindowNo != 1111) {
            s_log.finer("Context(" + WindowNo + ") " + context + "==" + value);
        }
        if (value == null || value.equals("")) {
            ctx.remove(WindowNo + "|" + context);
        } else {
            ctx.setProperty(WindowNo + "|" + context, value);
        }
    }

    public static void setContext(Properties ctx, int WindowNo, String context, Timestamp value) {
        if (ctx == null || context == null) {
            return;
        }
        if (value == null) {
            ctx.remove(WindowNo + "|" + context);
            s_log.finer("Context(" + WindowNo + ") " + context + "==" + value);
        } else {
            String stringValue = value.toString();
            stringValue = stringValue.substring(0, stringValue.indexOf("."));
            ctx.setProperty(WindowNo + "|" + context, stringValue);
            s_log.finer("Context(" + WindowNo + ") " + context + "==" + stringValue);
        }
    }

    public static void setContext(Properties ctx, int WindowNo, String context, int value) {
        if (ctx == null || context == null) {
            return;
        }
        if (WindowNo != 1110 && WindowNo != 1111) {
            s_log.finer("Context(" + WindowNo + ") " + context + "==" + value);
        }
        ctx.setProperty(WindowNo + "|" + context, String.valueOf(value));
    }

    public static void setContext(Properties ctx, int WindowNo, String context, boolean value) {
        Env.setContext(ctx, WindowNo, context, value ? "Y" : "N");
    }

    public static void setContext(Properties ctx, int WindowNo, int TabNo, String context, String value) {
        if (ctx == null || context == null) {
            return;
        }
        if (WindowNo != 1110 && WindowNo != 1111) {
            s_log.finest("Context(" + WindowNo + "," + TabNo + ") " + context + "==" + value);
        }
        if (value == null) {
            value = context.endsWith("_ID") ? new String("0") : new String("");
        }
        ctx.setProperty(WindowNo + "|" + TabNo + "|" + context, value);
    }

    public static void setAutoCommit(Properties ctx, boolean autoCommit) {
        if (ctx == null) {
            return;
        }
        ctx.setProperty("AutoCommit", autoCommit ? "Y" : "N");
    }

    public static void setAutoCommit(Properties ctx, int WindowNo, boolean autoCommit) {
        if (ctx == null) {
            return;
        }
        ctx.setProperty(WindowNo + "|AutoCommit", autoCommit ? "Y" : "N");
    }

    public static void setAutoNew(Properties ctx, boolean autoNew) {
        if (ctx == null) {
            return;
        }
        ctx.setProperty("AutoNew", autoNew ? "Y" : "N");
    }

    public static void setAutoNew(Properties ctx, int WindowNo, boolean autoNew) {
        if (ctx == null) {
            return;
        }
        ctx.setProperty(WindowNo + "|AutoNew", autoNew ? "Y" : "N");
    }

    public static void setSOTrx(Properties ctx, boolean isSOTrx) {
        if (ctx == null) {
            return;
        }
        ctx.setProperty("IsSOTrx", isSOTrx ? "Y" : "N");
    }

    public static String getContext(Properties ctx, String context) {
        if (ctx == null || context == null) {
            throw new IllegalArgumentException("Require Context");
        }
        return ctx.getProperty(context, "");
    }

    public static String getContext(Properties ctx, int WindowNo, String context, boolean onlyWindow) {
        if (ctx == null) {
            throw new IllegalArgumentException("No Ctx");
        }
        if (context == null) {
            throw new IllegalArgumentException("Require Context");
        }
        String s = ctx.getProperty(WindowNo + "|" + context);
        if (s == null) {
            if (context.startsWith("#") || context.startsWith("$")) {
                return Env.getContext(ctx, context);
            }
            if (onlyWindow) {
                return "";
            }
            return Env.getContext(ctx, "#" + context);
        }
        return s;
    }

    public static String getContext(Properties ctx, int WindowNo, String context) {
        return Env.getContext(ctx, WindowNo, context, false);
    }

    public static String getContext(Properties ctx, int WindowNo, int TabNo, String context) {
        if (ctx == null || context == null) {
            throw new IllegalArgumentException("Require Context");
        }
        String s = ctx.getProperty(WindowNo + "|" + TabNo + "|" + context);
        if (1113 == TabNo) {
            return s != null ? s : "";
        }
        if (s == null) {
            return Env.getContext(ctx, WindowNo, context, false);
        }
        return s;
    }

    public static String getContext(Properties ctx, int WindowNo, int TabNo, String context, boolean onlyTab) {
        boolean onlyWindow = onlyTab;
        return Env.getContext(ctx, WindowNo, TabNo, context, onlyTab, onlyWindow);
    }

    public static String getContext(Properties ctx, int WindowNo, int TabNo, String context, boolean onlyTab, boolean onlyWindow) {
        if (ctx == null || context == null) {
            throw new IllegalArgumentException("Require Context");
        }
        String s = ctx.getProperty(WindowNo + "|" + TabNo + "|" + context);
        if (1113 == TabNo) {
            return s != null ? s : "";
        }
        if (s == null && !onlyTab) {
            return Env.getContext(ctx, WindowNo, context, onlyWindow);
        }
        return s;
    }

    public static int getContextAsInt(Properties ctx, String context) {
        if (ctx == null || context == null) {
            throw new IllegalArgumentException("Require Context");
        }
        String s = Env.getContext(ctx, context);
        if (s.length() == 0) {
            s = Env.getContext(ctx, 0, context, false);
        }
        if (s.length() == 0) {
            return 0;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            s_log.log(Level.SEVERE, "(" + context + ") = " + s, e);
            return 0;
        }
    }

    public static int getContextAsInt(Properties ctx, int WindowNo, String context) {
        String s = Env.getContext(ctx, WindowNo, context, false);
        if (s.length() == 0) {
            return 0;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            s_log.log(Level.SEVERE, "(" + context + ") = " + s, e);
            return 0;
        }
    }

    public static int getContextAsInt(Properties ctx, int WindowNo, String context, boolean onlyWindow) {
        String s = Env.getContext(ctx, WindowNo, context, onlyWindow);
        if (s.length() == 0) {
            return 0;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            s_log.log(Level.SEVERE, "(" + context + ") = " + s, e);
            return 0;
        }
    }

    public static int getContextAsInt(Properties ctx, int WindowNo, int TabNo, String context) {
        String s = Env.getContext(ctx, WindowNo, TabNo, context);
        if (s.length() == 0) {
            return 0;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            s_log.log(Level.SEVERE, "(" + context + ") = " + s, e);
            return 0;
        }
    }

    public static boolean isAutoCommit(Properties ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException("Require Context");
        }
        String s = Env.getContext(ctx, "AutoCommit");
        return s != null && s.equals("Y");
    }

    public static boolean isAutoCommit(Properties ctx, int WindowNo) {
        if (ctx == null) {
            throw new IllegalArgumentException("Require Context");
        }
        String s = Env.getContext(ctx, WindowNo, "AutoCommit", false);
        if (s != null) {
            return s.equals("Y");
        }
        return Env.isAutoCommit(ctx);
    }

    public static boolean isAutoNew(Properties ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException("Require Context");
        }
        String s = Env.getContext(ctx, "AutoNew");
        return s != null && s.equals("Y");
    }

    public static boolean isAutoNew(Properties ctx, int WindowNo) {
        if (ctx == null) {
            throw new IllegalArgumentException("Require Context");
        }
        String s = Env.getContext(ctx, WindowNo, "AutoNew", false);
        if (s != null) {
            return s.equals("Y");
        }
        return Env.isAutoNew(ctx);
    }

    public static boolean isSOTrx(Properties ctx) {
        String s = Env.getContext(ctx, "IsSOTrx");
        return s == null || !s.equals("N");
    }

    public static boolean isSOTrx(Properties ctx, int WindowNo) {
        String s = Env.getContext(ctx, WindowNo, "IsSOTrx", true);
        return s == null || !s.equals("N");
    }

    public static Timestamp getContextAsDate(Properties ctx, String context) {
        return Env.getContextAsDate(ctx, 0, context);
    }

    public static Timestamp getContextAsDate(Properties ctx, int WindowNo, String context) {
        if (ctx == null || context == null) {
            throw new IllegalArgumentException("Require Context");
        }
        String s = Env.getContext(ctx, WindowNo, context, false);
        if (s == null || s.equals("")) {
            s_log.log(Level.SEVERE, "No value for: " + context);
            return new Timestamp(System.currentTimeMillis());
        }
        if (s.trim().length() == 10) {
            s = s.trim() + " 00:00:00.0";
        } else if (s.indexOf(46) == -1) {
            s = s.trim() + ".0";
        }
        return Timestamp.valueOf(s);
    }

    public static int getAD_Client_ID(Properties ctx) {
        return Env.getContextAsInt(ctx, "#AD_Client_ID");
    }

    public static int getAD_Org_ID(Properties ctx) {
        return Env.getContextAsInt(ctx, "#AD_Org_ID");
    }

    public static int getAD_User_ID(Properties ctx) {
        return Env.getContextAsInt(ctx, "#AD_User_ID");
    }

    public static int getAD_Role_ID(Properties ctx) {
        return Env.getContextAsInt(ctx, "#AD_Role_ID");
    }

    public static String getPreference(Properties ctx, int AD_Window_ID, String context, boolean system) {
        if (ctx == null || context == null) {
            throw new IllegalArgumentException("Require Context");
        }
        String retValue = null;
        if (!system) {
            retValue = ctx.getProperty("P" + AD_Window_ID + "|" + context);
            if (retValue == null) {
                retValue = ctx.getProperty("P|" + context);
            }
        } else {
            retValue = ctx.getProperty("#" + context);
            if (retValue == null) {
                retValue = ctx.getProperty("$" + context);
            }
        }
        return retValue == null ? "" : retValue;
    }

    public static boolean isBaseLanguage(Properties ctx, String tableName) {
        return Language.isBaseLanguage(Env.getAD_Language(ctx));
    }

    public static boolean isBaseLanguage(String AD_Language, String tableName) {
        return Language.isBaseLanguage(AD_Language);
    }

    public static boolean isBaseLanguage(Language language, String tableName) {
        return language.isBaseLanguage();
    }

    public static boolean isBaseTranslation(String tableName) {
        return tableName.startsWith("AD") || tableName.equals("C_Country_Trl");
    }

    public static boolean isMultiLingualDocument(Properties ctx) {
        return MClient.get(ctx).isMultiLingualDocument();
    }

    public static String getAD_Language(Properties ctx) {
        String lang;
        if (ctx != null && !Util.isEmpty(lang = Env.getContext(ctx, LANGUAGE))) {
            return lang;
        }
        return Language.getBaseAD_Language();
    }

    public static Language getLanguage(Properties ctx) {
        String lang;
        if (ctx != null && !Util.isEmpty(lang = Env.getContext(ctx, LANGUAGE))) {
            return Language.getLanguage(lang);
        }
        return Language.getBaseLanguage();
    }

    public static Language getLoginLanguage(Properties ctx) {
        return Language.getLoginLanguage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void verifyLanguage(Properties ctx, Language language) {
        if (language.isBaseLanguage()) {
            return;
        }
        boolean isSystemLanguage = false;
        ArrayList<String> AD_Languages = new ArrayList<String>();
        String sql = "SELECT DISTINCT AD_Language FROM AD_Message_Trl";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String AD_Language = rs.getString(1);
                if (AD_Language.equals(language.getAD_Language())) {
                    isSystemLanguage = true;
                    break;
                }
                AD_Languages.add(AD_Language);
            }
        }
        catch (SQLException e) {
            try {
                s_log.log(Level.SEVERE, "", e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (isSystemLanguage) {
            return;
        }
        if (AD_Languages.size() == 0) {
            s_log.warning("NO System Language - Set to Base " + Language.getBaseAD_Language());
            language.setAD_Language(Language.getBaseAD_Language());
            return;
        }
        for (int i2 = 0; i2 < AD_Languages.size(); ++i2) {
            String langCompare;
            String AD_Language = (String)AD_Languages.get(i2);
            String lang = AD_Language.substring(0, 2);
            if (!lang.equals(langCompare = language.getAD_Language().substring(0, 2))) continue;
            s_log.fine("Found similar Language " + AD_Language);
            language.setAD_Language(AD_Language);
            return;
        }
        s_log.warning("Not System Language=" + language + " - Set to Base Language " + Language.getBaseAD_Language());
        language.setAD_Language(Language.getBaseAD_Language());
    }

    public static String[] getEntireContext(Properties ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException("Require Context");
        }
        Iterator<Object> keyIterator = ctx.keySet().iterator();
        String[] sList = new String[ctx.size()];
        int i2 = 0;
        while (keyIterator.hasNext()) {
            Object key = keyIterator.next();
            sList[i2++] = key.toString() + " == " + ctx.get(key).toString();
        }
        return sList;
    }

    public static String getHeader(Properties ctx, int WindowNo) {
        StringBuffer sb = new StringBuffer();
        if (WindowNo > 0) {
            sb.append(Env.getContext(ctx, WindowNo, "WindowName", false)).append("  ");
            String documentNo = Env.getContext(ctx, WindowNo, "DocumentNo", false);
            String value = Env.getContext(ctx, WindowNo, "Value", false);
            String name = Env.getContext(ctx, WindowNo, "Name", false);
            if (!"".equals(documentNo)) {
                sb.append(documentNo).append("  ");
            }
            if (!"".equals(value)) {
                sb.append(value).append("  ");
            }
            if (!"".equals(name)) {
                sb.append(name).append("  ");
            }
        }
        sb.append(Env.getContext(ctx, "#AD_User_Name")).append("@").append(Env.getContext(ctx, "#AD_Client_Name")).append(".").append(Env.getContext(ctx, "#AD_Org_Name")).append(" [").append(CConnection.get().toString()).append("]");
        return sb.toString();
    }

    public static void clearWinContext(Properties ctx, int WindowNo) {
        if (ctx == null) {
            throw new IllegalArgumentException("Require Context");
        }
        Object[] keys = ctx.keySet().toArray();
        for (int i2 = 0; i2 < keys.length; ++i2) {
            String tag = keys[i2].toString();
            if (!tag.startsWith(WindowNo + "|")) continue;
            ctx.remove(keys[i2]);
        }
        MLookupCache.cacheReset(WindowNo);
        if (Ini.isClient()) {
            Env.removeWindow(WindowNo);
        }
    }

    public static void clearTabContext(Properties ctx, int WindowNo, int TabNo) {
        if (ctx == null) {
            throw new IllegalArgumentException("Require Context");
        }
        Object[] keys = ctx.keySet().toArray();
        for (int i2 = 0; i2 < keys.length; ++i2) {
            String tag = keys[i2].toString();
            if (!tag.startsWith(WindowNo + "|" + TabNo + "|") || tag.startsWith(WindowNo + "|" + TabNo + "|_TabInfo")) continue;
            ctx.remove(keys[i2]);
        }
    }

    public static void clearContext(Properties ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException("Require Context");
        }
        ctx.clear();
    }

    public static String parseContext(Properties ctx, int WindowNo, String value, boolean onlyWindow, boolean ignoreUnparsable) {
        if (value == null || value.length() == 0) {
            return "";
        }
        String inStr = new String(value);
        StringBuffer outStr = new StringBuffer();
        int i2 = inStr.indexOf(64);
        while (i2 != -1) {
            outStr.append(inStr.substring(0, i2));
            inStr = inStr.substring(i2 + 1, inStr.length());
            int j = inStr.indexOf(64);
            if (j < 0) {
                s_log.log(Level.SEVERE, "No second tag: " + inStr);
                return "";
            }
            String token = inStr.substring(0, j);
            String ctxInfo = Env.getContext(ctx, WindowNo, token, onlyWindow);
            if (ctxInfo.length() == 0 && (token.startsWith("#") || token.startsWith("$"))) {
                ctxInfo = Env.getContext(ctx, token);
            }
            if (ctxInfo.length() == 0) {
                s_log.config("No Context Win=" + WindowNo + " for: " + token);
                if (!ignoreUnparsable) {
                    return "";
                }
            } else {
                outStr.append(ctxInfo);
            }
            inStr = inStr.substring(j + 1, inStr.length());
            i2 = inStr.indexOf(64);
        }
        outStr.append(inStr);
        return outStr.toString();
    }

    public static String parseContext(Properties ctx, int WindowNo, String value, boolean onlyWindow) {
        return Env.parseContext(ctx, WindowNo, value, onlyWindow, false);
    }

    public static String parseVariable(String expression, PO po, String trxName, boolean keepUnparseable) {
        if (expression == null || expression.length() == 0) {
            return "";
        }
        String inStr = new String(expression);
        StringBuffer outStr = new StringBuffer();
        int i2 = inStr.indexOf(64);
        while (i2 != -1) {
            outStr.append(inStr.substring(0, i2));
            inStr = inStr.substring(i2 + 1, inStr.length());
            int j = inStr.indexOf(64);
            if (j < 0) {
                s_log.log(Level.SEVERE, "No second tag: " + inStr);
                return "";
            }
            String token = inStr.substring(0, j);
            String format = "";
            int f = token.indexOf(60);
            if (f > 0 && token.endsWith(">")) {
                format = token.substring(f + 1, token.length() - 1);
                token = token.substring(0, f);
            }
            if (token.startsWith("#") || token.startsWith("$")) {
                Properties ctx = po != null ? po.getCtx() : Env.getCtx();
                String v = Env.getContext(ctx, token);
                if (v != null && v.length() > 0) {
                    outStr.append(v);
                } else if (keepUnparseable) {
                    outStr.append("@" + token + "@");
                }
            } else if (po != null) {
                Object v = po.get_Value(token);
                if (v != null) {
                    if (format != null && format.length() > 0) {
                        Format df;
                        if (v instanceof Integer && token.endsWith("_ID")) {
                            int tblIndex = format.indexOf(".");
                            String table2 = tblIndex > 0 ? format.substring(0, tblIndex) : token.substring(0, token.length() - 3);
                            String column = tblIndex > 0 ? format.substring(tblIndex + 1) : format;
                            outStr.append(DB.getSQLValueString(trxName, "select " + column + " from  " + table2 + " where " + table2 + "_id = ?", (Integer)v));
                        } else if (v instanceof Date) {
                            df = new SimpleDateFormat(format);
                            outStr.append(((DateFormat)df).format((Date)v));
                        } else if (v instanceof Number) {
                            df = new DecimalFormat(format);
                            outStr.append(((NumberFormat)df).format(((Number)v).doubleValue()));
                        } else {
                            MessageFormat mf = new MessageFormat(format);
                            outStr.append(mf.format(v));
                        }
                    } else {
                        outStr.append(v.toString());
                    }
                } else if (keepUnparseable) {
                    outStr.append("@" + token + "@");
                }
            }
            inStr = inStr.substring(j + 1, inStr.length());
            i2 = inStr.indexOf(64);
        }
        outStr.append(inStr);
        return outStr.toString();
    }

    public static int createWindowNo(Container win) {
        int retValue = s_windows.size();
        s_windows.add(win);
        return retValue;
    }

    public static int getWindowNo(Container container) {
        if (container == null) {
            return 0;
        }
        JFrame winFrame = Env.getFrame(container);
        if (winFrame == null) {
            return 0;
        }
        for (int i2 = 0; i2 < s_windows.size(); ++i2) {
            JFrame cmpFrame;
            Container cmp = s_windows.get(i2);
            if (cmp == null || !winFrame.equals(cmpFrame = Env.getFrame(cmp))) continue;
            return i2;
        }
        return 0;
    }

    public static JFrame getWindow(int WindowNo) {
        JFrame retValue = null;
        try {
            retValue = Env.getFrame(s_windows.get(WindowNo));
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, e.toString());
        }
        return retValue;
    }

    private static void removeWindow(int WindowNo) {
        if (WindowNo < s_windows.size()) {
            s_windows.set(WindowNo, null);
        }
    }

    public static void clearWinContext(int WindowNo) {
        Env.clearWinContext(Env.getCtx(), WindowNo);
    }

    public static void clearContext() {
        Env.getCtx().clear();
    }

    public static JFrame getFrame(Container container) {
        for (Container element = container; element != null; element = element.getParent()) {
            if (!(element instanceof JFrame)) continue;
            return (JFrame)element;
        }
        return null;
    }

    public static Graphics getGraphics(Container container) {
        for (Container element = container; element != null; element = element.getParent()) {
            Graphics g = element.getGraphics();
            if (g == null) continue;
            return g;
        }
        return null;
    }

    public static Window getParent(Container container) {
        for (Container element = container; element != null; element = element.getParent()) {
            if (element instanceof JDialog || element instanceof JFrame) {
                return (Window)element;
            }
            if (!(element instanceof Window)) continue;
            return (Window)element;
        }
        return null;
    }

    public static Image getImage(String fileNameInImageDir) {
        URL url = Adempiere.class.getResource("images/" + fileNameInImageDir);
        if (url == null) {
            s_log.log(Level.SEVERE, "Not found: " + fileNameInImageDir);
            return null;
        }
        Toolkit tk = Toolkit.getDefaultToolkit();
        return tk.getImage(url);
    }

    public static ImageIcon getImageIcon(String fileNameInImageDir) {
        URL url = Adempiere.class.getResource("images/" + fileNameInImageDir);
        if (url == null) {
            s_log.log(Level.INFO, "Not found: " + fileNameInImageDir);
            return null;
        }
        return new ImageIcon(url);
    }

    public static ImageIcon getImageIcon2(String fileName) {
        URL url = Adempiere.class.getResource("images/" + fileName + ".gif");
        if (url == null) {
            url = Adempiere.class.getResource("images/" + fileName + ".png");
        }
        if (url == null) {
            s_log.log(Level.INFO, "GIF/PNG Not found: " + fileName);
            return null;
        }
        return new ImageIcon(url);
    }

    public static void startBrowser(String url) {
        s_log.info(url);
        contextProvider.showURL(url);
    }

    public static boolean isMac() {
        String osName = System.getProperty("os.name");
        return (osName = osName.toLowerCase()).indexOf("mac") != -1;
    }

    public static boolean isWindows() {
        String osName = System.getProperty("os.name");
        return (osName = osName.toLowerCase()).indexOf("windows") != -1;
    }

    public static boolean hideWindow(CFrame window) {
        if (!Ini.isCacheWindow() || s_closingWindows) {
            return false;
        }
        for (int i2 = 0; i2 < s_hiddenWindows.size(); ++i2) {
            CFrame hidden = s_hiddenWindows.get(i2);
            s_log.info(i2 + ": " + hidden);
            if (hidden.getAD_Window_ID() != window.getAD_Window_ID()) continue;
            return false;
        }
        if (window.getAD_Window_ID() != 0 && s_hiddenWindows.add(window)) {
            window.setVisible(false);
            s_log.info(window.toString());
            if (s_hiddenWindows.size() > 10) {
                CFrame toClose = s_hiddenWindows.remove(0);
                try {
                    s_closingWindows = true;
                    toClose.dispose();
                }
                finally {
                    s_closingWindows = false;
                }
            }
            return true;
        }
        return false;
    }

    public static CFrame showWindow(int AD_Window_ID) {
        for (int i2 = 0; i2 < s_hiddenWindows.size(); ++i2) {
            CFrame hidden = s_hiddenWindows.get(i2);
            if (hidden.getAD_Window_ID() != AD_Window_ID) continue;
            s_hiddenWindows.remove(i2);
            s_log.info(hidden.toString());
            hidden.setVisible(true);
            int state = hidden.getExtendedState();
            if ((state & 1) > 0) {
                hidden.setExtendedState(state & 0xFFFFFFFE);
            }
            hidden.toFront();
            return hidden;
        }
        return null;
    }

    static void closeWindows() {
        s_closingWindows = true;
        for (int i2 = 0; i2 < s_hiddenWindows.size(); ++i2) {
            CFrame hidden = s_hiddenWindows.get(i2);
            hidden.dispose();
        }
        s_hiddenWindows.clear();
        s_closingWindows = false;
    }

    public static void sleep(int sec) {
        s_log.info("Start - Seconds=" + sec);
        try {
            Thread.sleep(sec * 1000);
        }
        catch (Exception e) {
            s_log.log(Level.WARNING, "", e);
        }
        s_log.info("End");
    }

    public static Set<Window> updateUI() {
        HashSet<Window> updated = new HashSet<Window>();
        for (Container container : s_windows) {
            Component[] childs;
            JFrame w = Env.getFrame(container);
            if (w == null || updated.contains(w)) continue;
            SwingUtilities.updateComponentTreeUI(w);
            w.validate();
            RepaintManager mgr = RepaintManager.currentManager(w);
            Component[] componentArray = childs = w.getComponents();
            int n = componentArray.length;
            for (int j = 0; j < n; ++j) {
                Component child = componentArray[j];
                if (!(child instanceof JComponent)) continue;
                mgr.markCompletelyDirty((JComponent)child);
            }
            w.repaint();
            updated.add(w);
        }
        for (Window window : s_hiddenWindows) {
            Component[] childs;
            if (updated.contains(window)) continue;
            SwingUtilities.updateComponentTreeUI(window);
            window.validate();
            RepaintManager mgr = RepaintManager.currentManager(window);
            for (Component child : childs = window.getComponents()) {
                if (!(child instanceof JComponent)) continue;
                mgr.markCompletelyDirty((JComponent)child);
            }
            window.repaint();
            updated.add(window);
        }
        return updated;
    }

    public static Properties getRemoteCallCtx(Properties ctx) {
        Properties p2 = new Properties();
        Set<Object> keys = ctx.keySet();
        for (Object key : keys) {
            String s = key.toString();
            if (!s.startsWith("#") && !s.startsWith("$")) continue;
            p2.put(key, ctx.get(key));
        }
        return p2;
    }

    static {
        Env.getCtx().put(LANGUAGE, Language.getBaseAD_Language());
    }
}

