/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import org.compiere.util.AmtInWords;

public class AmtInWords_VI
implements AmtInWords {
    private static final String[] majorNames = new String[]{"", " ngh\u00ecn ", " tri\u1ec7u ", " t\u1ec9 ", " ngh\u00ecn ", " tri\u1ec7u ", " t\u1ec9 "};
    private static final String[] numNames = new String[]{"", "m\u1ed9t", "hai", "ba", "b\u1ed1n", "n\u0103m", "s\u00e1u", "b\u1ea9y", "t\u00e1m", "ch\u00edn", "m\u01b0\u1eddi", "m\u01b0\u1eddi m\u1ed9t", "m\u01b0\u1eddi hai", "m\u01b0\u1eddi ba", "m\u01b0\u1eddi b\u1ed1n", "m\u01b0\u1eddi l\u0103m", "m\u01b0\u1eddi s\u00e1u", "m\u01b0\u1eddi b\u1ea9y", "m\u01b0\u1eddi t\u00e1m", "m\u01b0\u1eddi ch\u00edn", "hai m\u01b0\u01a1i", "hai m\u01b0\u01a1i m\u1ed1t", "hai m\u01b0\u01a1i hai", "hai m\u01b0\u01a1i ba", "hai m\u01b0\u01a1i b\u1ed1n", "hai m\u01b0\u01a1i l\u0103m", "hai m\u01b0\u01a1i s\u00e1u", "hai m\u01b0\u01a1i b\u1ea9y", "hai m\u01b0\u01a1i t\u00e1m", "hai m\u01b0\u01a1i ch\u00edn", "ba m\u01b0\u01a1i", "ba m\u01b0\u01a1i m\u1ed1t", "ba m\u01b0\u01a1i hai", "ba m\u01b0\u01a1i ba", "ba m\u01b0\u01a1i b\u1ed1n", "ba m\u01b0\u01a1i l\u0103m", "ba m\u01b0\u01a1i s\u00e1u", "ba m\u01b0\u01a1i b\u1ea9y", "ba m\u01b0\u01a1i t\u00e1m", "ba m\u01b0\u01a1i ch\u00edn", "b\u1ed1n m\u01b0\u01a1i", "b\u1ed1n m\u01b0\u01a1i m\u1ed1t", "b\u1ed1n m\u01b0\u01a1i hai", "b\u1ed1n m\u01b0\u01a1i ba", "b\u1ed1n m\u01b0\u01a1i b\u1ed1n", "b\u1ed1n m\u01b0\u01a1i l\u0103m", "b\u1ed1n m\u01b0\u01a1i s\u00e1u", "b\u1ed1n m\u01b0\u01a1i b\u1ea9y", "b\u1ed1n m\u01b0\u01a1i t\u00e1m", "b\u1ed1n m\u01b0\u01a1i ch\u00edn", "n\u0103m m\u01b0\u01a1i", "n\u0103m m\u01b0\u01a1i m\u1ed1t", "n\u0103m m\u01b0\u01a1i hai", "n\u0103m m\u01b0\u01a1i ba", "n\u0103m m\u01b0\u01a1i b\u1ed1n", "n\u0103m m\u01b0\u01a1i l\u0103m", "n\u0103m m\u01b0\u01a1i s\u00e1u", "n\u0103m m\u01b0\u01a1i b\u1ea9y", "n\u0103m m\u01b0\u01a1i t\u00e1m", "n\u0103m m\u01b0\u01a1i ch\u00edn", "s\u00e1u m\u01b0\u01a1i", "s\u00e1u m\u01b0\u01a1i m\u1ed1t", "s\u00e1u m\u01b0\u01a1i hai", "s\u00e1u m\u01b0\u01a1i ba", "s\u00e1u m\u01b0\u01a1i b\u1ed1n", "s\u00e1u m\u01b0\u01a1i l\u0103m", "s\u00e1u m\u01b0\u01a1i s\u00e1u", "s\u00e1u m\u01b0\u01a1i b\u1ea9y", "s\u00e1u m\u01b0\u01a1i t\u00e1m", "s\u00e1u m\u01b0\u01a1i ch\u00edn", "b\u1ea9y m\u01b0\u01a1i", "b\u1ea9y m\u01b0\u01a1i m\u1ed1t", "b\u1ea9y m\u01b0\u01a1i hai", "b\u1ea9y m\u01b0\u01a1i ba", "b\u1ea9y m\u01b0\u01a1i b\u1ed1n", "b\u1ea9y m\u01b0\u01a1i l\u0103m", "b\u1ea9y m\u01b0\u01a1i s\u00e1u", "b\u1ea9y m\u01b0\u01a1i b\u1ea9y", "b\u1ea9y m\u01b0\u01a1i t\u00e1m", "b\u1ea9y m\u01b0\u01a1i ch\u00edn", "t\u00e1m m\u01b0\u01a1i", "t\u00e1m m\u01b0\u01a1i m\u1ed1t", "t\u00e1m m\u01b0\u01a1i hai", "t\u00e1m m\u01b0\u01a1i ba", "t\u00e1m m\u01b0\u01a1i b\u1ed1n", "t\u00e1m m\u01b0\u01a1i l\u0103m", "t\u00e1m m\u01b0\u01a1i s\u00e1u", "t\u00e1m m\u01b0\u01a1i b\u1ea9y", "t\u00e1m m\u01b0\u01a1i t\u00e1m", "t\u00e1m m\u01b0\u01a1i ch\u00edn", "ch\u00edn m\u01b0\u01a1i", "ch\u00edn m\u01b0\u01a1i m\u1ed1t", "ch\u00edn m\u01b0\u01a1i hai", "ch\u00edn m\u01b0\u01a1i ba", "ch\u00edn m\u01b0\u01a1i b\u1ed1n", "ch\u00edn m\u01b0\u01a1i l\u0103m", "ch\u00edn m\u01b0\u01a1i s\u00e1u", "ch\u00edn m\u01b0\u01a1i b\u1ea9y", "ch\u00edn m\u01b0\u01a1i t\u00e1m", "ch\u00edn m\u01b0\u01a1i ch\u00edn"};

    private String convertLessThanOneThousand(int number) {
        String soFar = "";
        if (number % 100 < 10 && number > 100) {
            soFar = " linh ";
        }
        soFar = soFar + numNames[number % 100];
        if ((number /= 100) == 0) {
            return soFar;
        }
        return numNames[number] + " tr\u0103m " + soFar;
    }

    private String convert(long number) {
        if (number == 0L) {
            return "kh\u00f4ng";
        }
        String prefix = "";
        if (number < 0L) {
            number = -number;
            prefix = "\u00e2m ";
        }
        String soFar = "";
        int place = 0;
        do {
            long n;
            if ((n = number % 1000L) != 0L) {
                String s = this.convertLessThanOneThousand((int)n);
                if (n < 100L && number > 1000L) {
                    if (n > 10L) {
                        s = "kh\u00f4ng tr\u0103m " + s;
                    }
                    if (n < 10L) {
                        s = "kh\u00f4ng tr\u0103m linh " + s;
                    }
                }
                soFar = s + majorNames[place] + soFar;
            }
            ++place;
        } while ((number /= 1000L) > 1000L);
        long m = number % 1000L;
        if (m != 0L) {
            String t = this.convertLessThanOneThousand((int)m);
            soFar = t + majorNames[place] + soFar;
        }
        return (prefix + soFar).trim();
    }

    @Override
    public String getAmtInWords(String amount) throws Exception {
        if (amount == null) {
            return amount;
        }
        int numberOfCommas = 0;
        int numberOfPeriods = 0;
        StringBuffer sb = new StringBuffer();
        int period = amount.lastIndexOf(46);
        numberOfPeriods = amount.replaceAll("[^\\.]", "").length();
        int comma = amount.lastIndexOf(44);
        numberOfCommas = amount.replaceAll("[^,]", "").length();
        int newpos = 0;
        String decamt = "";
        if (comma > period) {
            if (period != -1) {
                decamt = amount.substring(comma + 1, amount.length());
                amount = amount.replaceAll("\\.", "");
                newpos = amount.lastIndexOf(44) + 1;
            } else if (amount.length() - comma - 1 <= 2) {
                decamt = amount.substring(comma + 1, amount.length());
                newpos = comma + 1;
            } else {
                decamt = "";
                amount = amount.replaceAll(",", "");
                newpos = 0;
            }
        }
        if (comma < period) {
            if (comma != -1 | numberOfPeriods == 1) {
                decamt = amount.substring(period + 1, amount.length());
                amount = amount.replaceAll(",", "");
                newpos = amount.lastIndexOf(46) + 1;
            } else {
                decamt = "";
                amount = amount.replaceAll("\\.", "");
                newpos = 0;
            }
        } else if (comma == -1 && period == -1) {
            decamt = "";
            newpos = 0;
        }
        long dollars = 0L;
        long decima = 0L;
        if (newpos != 0) {
            dollars = Long.parseLong(amount.substring(0, newpos - 1));
            sb.append(this.convert(dollars));
            decima = Long.parseLong(decamt);
            sb.append(" ph\u1ea9y ").append(this.convert(decima));
        } else {
            dollars = Long.parseLong(amount.substring(0, amount.length()));
            sb.append(this.convert(dollars));
        }
        return sb.toString().replaceAll("  ", " ").replaceAll("linh ngh\u00ecn", "ngh\u00ecn").replaceAll("linh tri\u1ec7u", "tri\u1ec7u").replaceAll("linh t\u1ec9", "t\u1ec9");
    }

    private void print(String amt) {
        try {
            System.out.println(amt + " = " + this.getAmtInWords(amt));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        AmtInWords_VI aiw = new AmtInWords_VI();
        aiw.print("0.23");
        aiw.print("1.23");
        aiw.print("12,345");
        aiw.print("103.45");
        aiw.print("114,45");
        aiw.print("123.45");
        aiw.print("500000000");
        aiw.print("1234.56");
        aiw.print("12345.78");
        aiw.print("100457.89");
        aiw.print("100,234,578.90");
        aiw.print("12,034,578.90");
        aiw.print("103,004,008.90");
        aiw.print("1,201,034,578.90");
        aiw.print("12,201,034,578.90");
        aiw.print("10220134578");
        aiw.print("1.093.201.034.578");
        aiw.print("100,932,010,345,780");
        aiw.print("109.320.103,48");
    }
}

