/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.report;

import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.logging.Level;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.JobName;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.export.JRPrintServiceExporter;
import net.sf.jasperreports.engine.export.JRPrintServiceExporterParameter;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRResourcesUtil;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DBException;
import org.compiere.db.CConnection;
import org.compiere.interfaces.MD5;
import org.compiere.model.MAttachment;
import org.compiere.model.MAttachmentEntry;
import org.compiere.model.MProcess;
import org.compiere.model.PrintInfo;
import org.compiere.model.X_AD_PrintFormat;
import org.compiere.print.CPrinter;
import org.compiere.print.MPrintFormat;
import org.compiere.print.PrintUtil;
import org.compiere.process.ClientProcess;
import org.compiere.process.ProcessCall;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.report.JRViewerProvider;
import org.compiere.report.SwingJRViewerProvider;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Language;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.compiere.utils.DigestOfFile;

public class ReportStarter
implements ProcessCall,
ClientProcess {
    private static CLogger log = CLogger.getCLogger(ReportStarter.class);
    private static File REPORT_HOME = null;
    private static JRViewerProvider viewerProvider = new SwingJRViewerProvider();
    private static JasperPrint jasperPrint;
    private ProcessInfo processInfo;
    private MAttachment attachment;

    private boolean isRequestedonAS(URL requestURL) {
        boolean tBool = false;
        try {
            InetAddress[] request_iaddrs = InetAddress.getAllByName(requestURL.getHost());
            InetAddress as_iaddr = InetAddress.getByName(CConnection.get().getAppsHost());
            for (int i2 = 0; i2 < request_iaddrs.length; ++i2) {
                log.info("Got " + request_iaddrs[i2].toString() + " for " + requestURL + " as address #" + i2);
                if (!request_iaddrs[i2].equals(as_iaddr)) continue;
                log.info("Requested report is on application server host");
                tBool = true;
                break;
            }
        }
        catch (UnknownHostException e) {
            log.severe("Unknown dns lookup error");
            return false;
        }
        return tBool;
    }

    private boolean isMD5HomeInterfaceAvailable() {
        try {
            Class.forName("org.compiere.interfaces.MD5");
            log.info("EJB client for MD5 remote hashing is present");
            return true;
        }
        catch (ClassNotFoundException e) {
            log.warning("EJB Client for MD5 remote hashing absent\nyou need the class org.compiere.interfaces.MD5 - from webEJB-client.jar - in classpath");
            return false;
        }
    }

    private String ejbGetRemoteMD5(String requestedURLString) {
        InitialContext context = null;
        String md5Hash = null;
        try {
            URL requestURL = new URL(requestedURLString);
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
            env.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
            env.put("java.naming.provider.url", requestURL.getHost() + ":" + CConnection.get().getAppsPort());
            context = new InitialContext(env);
            if (this.isRequestedonAS(requestURL) && this.isMD5HomeInterfaceAvailable()) {
                MD5 md5 = (MD5)context.lookup("ejb/compiere/MD5");
                md5Hash = md5.getFileMD5(requestedURLString);
                log.info("MD5 for " + requestedURLString + " is " + md5Hash);
            }
        }
        catch (MalformedURLException e) {
            log.severe("URL is invalid: " + e.getMessage());
            return null;
        }
        catch (NamingException e) {
            log.warning("Unable to create jndi context did you deployed webApp.ear package?\nRemote hashing is impossible");
            return null;
        }
        return md5Hash;
    }

    private File getRemoteFile(String reportLocation, String localPath) {
        try {
            URL reportURL = new URL(reportLocation);
            InputStream in = reportURL.openStream();
            File downloadedFile = new File(localPath);
            if (downloadedFile.exists()) {
                downloadedFile.delete();
            }
            FileOutputStream fout = new FileOutputStream(downloadedFile);
            byte[] buf = new byte[1024];
            int s = 0;
            while ((s = in.read(buf, 0, 1024)) > 0) {
                fout.write(buf, 0, s);
            }
            in.close();
            fout.flush();
            fout.close();
            return downloadedFile;
        }
        catch (FileNotFoundException e) {
            if (reportLocation.indexOf("Subreport") == -1) {
                log.warning("404 not found: Report cannot be found on server " + e.getMessage());
            }
            return null;
        }
        catch (IOException e) {
            log.severe("I/O error when trying to download (sub)report from server " + e.getMessage());
            return null;
        }
    }

    private File[] getHttpSubreports(String reportName, String reportPath, String fileExtension) {
        File subreport;
        ArrayList<File> subreports = new ArrayList<File>();
        String remoteDir = reportPath.substring(0, reportPath.lastIndexOf("/"));
        for (int i2 = 1; i2 < 10 && (subreport = this.httpDownloadedReport(remoteDir + "/" + reportName + i2 + fileExtension)) != null; ++i2) {
            subreports.add(subreport);
        }
        File[] subreportsTemp = new File[]{};
        subreportsTemp = subreports.toArray(subreportsTemp);
        return subreportsTemp;
    }

    private File httpDownloadedReport(String reportLocation) {
        File reportFile = null;
        File downloadedFile = null;
        log.info(" report deployed to " + reportLocation);
        try {
            String[] tmps = reportLocation.split("/");
            String cleanFile = tmps[tmps.length - 1];
            String localFile = System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + cleanFile;
            String downloadedLocalFile = System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + "TMP" + cleanFile;
            reportFile = new File(localFile);
            if (reportFile.exists()) {
                String localMD5hash = DigestOfFile.GetLocalMD5Hash(reportFile);
                String remoteMD5Hash = this.ejbGetRemoteMD5(reportLocation);
                log.info("MD5 for local file is " + localMD5hash);
                if (remoteMD5Hash != null) {
                    if (localMD5hash.equals(remoteMD5Hash)) {
                        log.info(" no need to download: local report is up-to-date");
                    } else {
                        log.info(" report on server is different that local one, download and replace");
                        downloadedFile = this.getRemoteFile(reportLocation, downloadedLocalFile);
                        reportFile.delete();
                        downloadedFile.renameTo(reportFile);
                    }
                } else {
                    log.warning("Remote hashing is not available did you deployed webApp.ear?");
                    downloadedFile = this.getRemoteFile(reportLocation, downloadedLocalFile);
                    if (DigestOfFile.md5localHashCompare(reportFile, downloadedFile)) {
                        log.info(" no need to replace your existing report");
                    } else {
                        log.info(" report on server is different that local one, replacing");
                        reportFile.delete();
                        downloadedFile.renameTo(reportFile);
                    }
                }
            } else {
                reportFile = this.getRemoteFile(reportLocation, localFile);
            }
        }
        catch (Exception e) {
            log.severe("Unknown exception: " + e.getMessage());
            return null;
        }
        return reportFile;
    }

    protected Connection getConnection() {
        return DB.getConnectionRW();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean startProcess(Properties ctx, ProcessInfo pi, Trx trx) {
        ReportData reportData;
        this.processInfo = pi;
        String Name2 = pi.getTitle();
        int AD_PInstance_ID = pi.getAD_PInstance_ID();
        int Record_ID = pi.getRecord_ID();
        log.info("Name=" + Name2 + "  AD_PInstance_ID=" + AD_PInstance_ID + " Record_ID=" + Record_ID);
        String trxName = null;
        if (trx != null) {
            trxName = trx.getTrxName();
        }
        if ((reportData = this.getReportData(pi, trxName)) == null) {
            this.reportResult(AD_PInstance_ID, "Can not find report data", trxName);
            return false;
        }
        String reportPath = reportData.getReportFilePath();
        if (Util.isEmpty(reportPath, true)) {
            this.reportResult(AD_PInstance_ID, "Can not find report", trxName);
            return false;
        }
        JasperData data = null;
        File reportFile = null;
        String fileExtension = "";
        HashMap<String, Object> params = new HashMap<String, Object>();
        ReportStarter.addProcessParameters(AD_PInstance_ID, params, trxName);
        this.addProcessInfoParameters(params, pi.getParameter());
        reportFile = this.getReportFile(reportPath, (String)params.get("ReportType"));
        if (reportFile == null || !reportFile.exists()) {
            log.severe("No report file found for given type, falling back to " + reportPath);
            reportFile = this.getReportFile(reportPath);
        }
        if (reportFile == null || !reportFile.exists()) {
            String tmp = "Can not find report file at path - " + reportPath;
            log.severe(tmp);
            this.reportResult(AD_PInstance_ID, tmp, trxName);
        }
        if (reportFile == null) {
            return false;
        }
        data = this.processReport(reportFile);
        fileExtension = reportFile.getName().substring(reportFile.getName().lastIndexOf("."), reportFile.getName().length());
        JasperReport jasperReport = data.getJasperReport();
        String jasperName = data.getJasperName();
        String name = jasperReport.getName();
        File reportDir = data.getReportDir();
        ClassLoader scl = ClassLoader.getSystemClassLoader();
        try {
            URLClassLoader ucl = new URLClassLoader(new URL[]{reportDir.toURI().toURL()}, scl);
            JRResourcesUtil.setThreadClassLoader((ClassLoader)ucl);
        }
        catch (MalformedURLException me) {
            log.warning("Could not add report directory to classpath: " + me.getMessage());
        }
        if (jasperReport != null) {
            File[] subreports = reportPath.startsWith("http://") || reportPath.startsWith("https://") ? this.getHttpSubreports(jasperName + "Subreport", reportPath, fileExtension) : (reportPath.startsWith("attachment:") ? this.getAttachmentSubreports(reportPath) : (reportPath.startsWith("resource:") ? this.getResourceSubreports(name + "Subreport", reportPath, fileExtension) : reportDir.listFiles(new FileFilter(jasperName + "Subreport", reportDir, fileExtension))));
            for (int i2 = 0; i2 < subreports.length; ++i2) {
                JasperData subData = this.processReport(subreports[i2]);
                if (subData.getJasperReport() == null) continue;
                params.put(subData.getJasperName(), subData.getJasperFile().getAbsolutePath());
            }
            if (Record_ID > 0) {
                params.put("RECORD_ID", new Integer(Record_ID));
            }
            params.put("AD_PINSTANCE_ID", new Integer(AD_PInstance_ID));
            Language currLang = Env.getLanguage(Env.getCtx());
            String printerName = null;
            X_AD_PrintFormat printFormat = null;
            PrintInfo printInfo = null;
            ProcessInfoParameter[] pip = pi.getParameter();
            if (pip != null) {
                for (int i3 = 0; i3 < pip.length; ++i3) {
                    if ("PRINT_FORMAT".equalsIgnoreCase(pip[i3].getParameterName())) {
                        printFormat = (MPrintFormat)pip[i3].getParameter();
                    }
                    if ("PRINT_INFO".equalsIgnoreCase(pip[i3].getParameterName())) {
                        printInfo = (PrintInfo)pip[i3].getParameter();
                    }
                    if (!"PRINTER_NAME".equalsIgnoreCase(pip[i3].getParameterName())) continue;
                    printerName = (String)pip[i3].getParameter();
                }
            }
            if (printFormat != null) {
                if (printInfo != null && printInfo.isDocument()) {
                    currLang = ((MPrintFormat)printFormat).getLanguage();
                }
                if (printerName == null) {
                    printerName = printFormat.getPrinterName();
                }
            }
            params.put("CURRENT_LANG", currLang.getAD_Language());
            params.put("REPORT_LOCALE", currLang.getLocale());
            File resFile = null;
            if (reportPath.startsWith("attachment:") && this.attachment != null) {
                resFile = this.getAttachmentResourceFile(jasperName, currLang);
            } else if (reportPath.startsWith("resource:")) {
                resFile = this.getResourcesForResourceFile(jasperName, currLang);
            } else {
                resFile = new File(jasperName + "_" + currLang.getLocale().getLanguage() + ".properties");
                if (!resFile.exists()) {
                    resFile = null;
                }
                if (resFile == null && !(resFile = new File(jasperName + ".properties")).exists()) {
                    resFile = null;
                }
            }
            if (resFile != null) {
                try {
                    PropertyResourceBundle res = new PropertyResourceBundle(new FileInputStream(resFile));
                    params.put("RESOURCE", res);
                }
                catch (IOException res) {
                    // empty catch block
                }
            }
            Connection conn = null;
            try {
                conn = this.getConnection();
                jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, params, (Connection)conn);
                if (reportData.isDirectPrint()) {
                    log.info("ReportStarter.startProcess print report -" + jasperPrint.getName());
                    if (!this.processInfo.isBatch()) {
                        PrinterJob printerJob = CPrinter.getPrinterJob(printerName);
                        HashPrintRequestAttributeSet prats = new HashPrintRequestAttributeSet();
                        if (printInfo.isDocumentCopy() || printInfo.getCopies() < 1) {
                            prats.add(new Copies(1));
                        } else {
                            prats.add(new Copies(printInfo.getCopies()));
                        }
                        Locale locale = Language.getLoginLanguage().getLocale();
                        prats.add(new JobName(printFormat.getName() + "_" + pi.getRecord_ID(), locale));
                        prats.add(PrintUtil.getJobPriority(jasperPrint.getPages().size(), printInfo.getCopies(), true));
                        JRPrintServiceExporter exporter = new JRPrintServiceExporter();
                        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
                        exporter.setParameter((JRExporterParameter)JRPrintServiceExporterParameter.PRINT_SERVICE, (Object)printerJob.getPrintService());
                        exporter.setParameter((JRExporterParameter)JRPrintServiceExporterParameter.PRINT_SERVICE_ATTRIBUTE_SET, (Object)printerJob.getPrintService().getAttributes());
                        exporter.setParameter((JRExporterParameter)JRPrintServiceExporterParameter.PRINT_REQUEST_ATTRIBUTE_SET, (Object)prats);
                        exporter.setParameter((JRExporterParameter)JRPrintServiceExporterParameter.DISPLAY_PAGE_DIALOG, (Object)Boolean.FALSE);
                        exporter.setParameter((JRExporterParameter)JRPrintServiceExporterParameter.DISPLAY_PRINT_DIALOG, (Object)Boolean.FALSE);
                        exporter.exportReport();
                    } else {
                        try {
                            File PDF = File.createTempFile("mail", ".pdf");
                            JasperExportManager.exportReportToPdfFile((JasperPrint)jasperPrint, (String)PDF.getAbsolutePath());
                            this.processInfo.setPDFReport(PDF);
                        }
                        catch (IOException e) {
                            log.severe("ReportStarter.startProcess: Can not make PDF File - " + e.getMessage());
                        }
                    }
                } else {
                    log.info("ReportStarter.startProcess run report -" + jasperPrint.getName());
                    JRViewerProvider viewerLauncher = ReportStarter.getReportViewerProvider();
                    viewerLauncher.openViewer(jasperPrint, pi.getTitle() + " - " + reportPath);
                }
            }
            catch (JRException e) {
                log.severe("ReportStarter.startProcess: Can not run report - " + e.getMessage());
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        this.reportResult(AD_PInstance_ID, null, trxName);
        return true;
    }

    public static JasperPrint getJasperPrint() {
        return jasperPrint;
    }

    private File getAttachmentResourceFile(String jasperName, Language currLang) {
        int i2;
        File resFile = null;
        MAttachmentEntry[] entries = this.attachment.getEntries();
        for (i2 = 0; i2 < entries.length; ++i2) {
            if (!entries[i2].getName().equals(jasperName + currLang.getLocale().getLanguage() + ".properties")) continue;
            resFile = this.getAttachmentEntryFile(entries[i2]);
            break;
        }
        if (resFile == null) {
            for (i2 = 0; i2 < entries.length; ++i2) {
                if (!entries[i2].getName().equals(jasperName + ".properties")) continue;
                resFile = this.getAttachmentEntryFile(entries[i2]);
                break;
            }
        }
        return resFile;
    }

    private File getResourcesForResourceFile(String jasperName, Language currLang) {
        File resFile = null;
        try {
            resFile = this.getFileAsResource(jasperName + currLang.getLocale().getLanguage() + ".properties");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return resFile;
    }

    private File[] getAttachmentSubreports(String reportPath) {
        String name = reportPath.substring("attachment:".length()).trim();
        ArrayList<File> subreports = new ArrayList<File>();
        MAttachmentEntry[] entries = this.attachment.getEntries();
        for (int i2 = 0; i2 < entries.length; ++i2) {
            File reportFile;
            if (entries[i2].getName().equals(name) || !entries[i2].getName().toLowerCase().endsWith(".jrxml") && !entries[i2].getName().toLowerCase().endsWith(".jasper") || (reportFile = this.getAttachmentEntryFile(entries[i2])) == null) continue;
            subreports.add(reportFile);
        }
        File[] subreportsTemp = new File[]{};
        subreportsTemp = subreports.toArray(subreportsTemp);
        return subreportsTemp;
    }

    private File[] getResourceSubreports(String reportName, String reportPath, String fileExtension) {
        ArrayList<File> subreports = new ArrayList<File>();
        String remoteDir = reportPath.substring(0, reportPath.lastIndexOf("/"));
        for (int i2 = 1; i2 < 10; ++i2) {
            File subreport = null;
            try {
                subreport = this.getFileAsResource(remoteDir + "/" + reportName + i2 + fileExtension);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (subreport == null) break;
            subreports.add(subreport);
        }
        File[] subreportsTemp = new File[subreports.size()];
        subreportsTemp = subreports.toArray(subreportsTemp);
        return subreportsTemp;
    }

    protected File getReportFile(String reportPath, String reportType) {
        if (reportType != null) {
            int cpos = reportPath.lastIndexOf(46);
            reportPath = reportPath.substring(0, cpos) + "_" + reportType + reportPath.substring(cpos, reportPath.length());
        }
        return this.getReportFile(reportPath);
    }

    protected File getReportFile(String reportPath) {
        File reportFile = null;
        if (reportPath.startsWith("http://") || reportPath.startsWith("https://")) {
            reportFile = this.httpDownloadedReport(reportPath);
        } else if (reportPath.startsWith("attachment:")) {
            reportFile = this.downloadAttachment(reportPath);
        } else if (reportPath.startsWith("/")) {
            reportFile = new File(reportPath);
        } else if (reportPath.startsWith("file:/")) {
            try {
                reportFile = new File(new URI(reportPath));
            }
            catch (URISyntaxException e) {
                log.warning(e.getLocalizedMessage());
                reportFile = null;
            }
        } else if (reportPath.startsWith("resource:")) {
            try {
                reportFile = this.getFileAsResource(reportPath);
            }
            catch (Exception e) {
                log.warning(e.getLocalizedMessage());
                reportFile = null;
            }
        } else {
            reportFile = new File(REPORT_HOME, reportPath);
        }
        if (reportFile != null) {
            System.setProperty("org.compiere.report.path", reportFile.getParentFile().getAbsolutePath());
        }
        return reportFile;
    }

    private File getFileAsResource(String reportPath) throws Exception {
        String name = reportPath.substring("resource:".length()).trim();
        String localName = name.replace('/', '_');
        log.info("reportPath = " + reportPath);
        log.info("getting resource from = " + this.getClass().getClassLoader().getResource(name));
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(name);
        String localFile = System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + localName;
        log.info("localFile = " + localFile);
        File reportFile = new File(localFile);
        FileOutputStream out = null;
        out = new FileOutputStream(reportFile);
        if (out != null) {
            int len;
            byte[] buf = new byte[1024];
            while ((len = inputStream.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((OutputStream)out).close();
            inputStream.close();
        }
        return reportFile;
    }

    private File downloadAttachment(String reportPath) {
        File reportFile = null;
        String name = reportPath.substring("attachment:".length()).trim();
        MProcess process = new MProcess(Env.getCtx(), this.processInfo.getAD_Process_ID(), this.processInfo.getTransactionName());
        this.attachment = process.getAttachment();
        if (this.attachment != null) {
            MAttachmentEntry[] entries = this.attachment.getEntries();
            MAttachmentEntry entry = null;
            for (int i2 = 0; i2 < entries.length; ++i2) {
                if (!entries[i2].getName().equals(name)) continue;
                entry = entries[i2];
                break;
            }
            if (entry != null) {
                reportFile = this.getAttachmentEntryFile(entry);
            }
        }
        return reportFile;
    }

    private File getAttachmentEntryFile(MAttachmentEntry entry) {
        String localFile = System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + entry.getName();
        String downloadedLocalFile = System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + "TMP" + entry.getName();
        File reportFile = new File(localFile);
        if (reportFile.exists()) {
            String entryMD5hash;
            String localMD5hash = DigestOfFile.GetLocalMD5Hash(reportFile);
            if (localMD5hash.equals(entryMD5hash = DigestOfFile.getMD5Hash(entry.getData()))) {
                log.info(" no need to download: local report is up-to-date");
            } else {
                log.info(" report on server is different that local one, download and replace");
                File downloadedFile = new File(downloadedLocalFile);
                entry.getFile(downloadedFile);
                if (!reportFile.delete()) {
                    throw new AdempiereException("Cannot delete temporary file " + reportFile.toString());
                }
                if (!downloadedFile.renameTo(reportFile)) {
                    throw new AdempiereException("Cannot rename temporary file " + downloadedFile.toString() + " to " + reportFile.toString());
                }
            }
        } else {
            entry.getFile(reportFile);
        }
        return reportFile;
    }

    protected void reportResult(int AD_PInstance_ID, String errMsg, String trxName) {
        int result = errMsg == null ? 1 : 0;
        String sql = "UPDATE AD_PInstance SET Result=?, ErrorMsg=? WHERE AD_PInstance_ID=" + AD_PInstance_ID;
        DB.executeUpdateEx(sql, new Object[]{result, errMsg}, trxName);
    }

    protected JasperData processReport(File reportFile) {
        File reportDir;
        File jasperFile;
        log.info("reportFile.getAbsolutePath() = " + reportFile.getAbsolutePath());
        JasperReport jasperReport = null;
        String jasperName = reportFile.getName();
        int pos = jasperName.indexOf(46);
        if (pos != -1) {
            jasperName = jasperName.substring(0, pos);
        }
        if ((jasperFile = new File((reportDir = reportFile.getParentFile()).getAbsolutePath(), jasperName + ".jasper")).exists()) {
            if (reportFile.lastModified() == jasperFile.lastModified()) {
                log.info(" no need to compile use " + jasperFile.getAbsolutePath());
                try {
                    jasperReport = (JasperReport)JRLoader.loadObject((String)jasperFile.getAbsolutePath());
                }
                catch (JRException e) {
                    jasperReport = null;
                    log.severe("Can not load report - " + e.getMessage());
                }
            } else {
                jasperReport = this.compileReport(reportFile, jasperFile);
            }
        } else {
            jasperReport = this.compileReport(reportFile, jasperFile);
        }
        return new JasperData(jasperReport, reportDir, jasperName, jasperFile);
    }

    private static void addProcessParameters(int AD_PInstance_ID, Map<String, Object> params, String trxName) {
        String sql = "SELECT  ParameterName,P_String,P_String_To,P_Number,P_Number_To,P_Date,P_Date_To,Info,Info_To FROM AD_PInstance_Para WHERE AD_PInstance_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement("SELECT  ParameterName,P_String,P_String_To,P_Number,P_Number_To,P_Date,P_Date_To,Info,Info_To FROM AD_PInstance_Para WHERE AD_PInstance_ID=?", 1003, 1007, trxName);
            pstmt.setInt(1, AD_PInstance_ID);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String name = rs.getString(1);
                String pStr = rs.getString(2);
                String pStrTo = rs.getString(3);
                BigDecimal pNum = rs.getBigDecimal(4);
                BigDecimal pNumTo = rs.getBigDecimal(5);
                Timestamp pDate = rs.getTimestamp(6);
                Timestamp pDateTo = rs.getTimestamp(7);
                if (pStr != null) {
                    if (pStrTo != null) {
                        params.put(name + "1", pStr);
                        params.put(name + "2", pStrTo);
                    } else {
                        params.put(name, pStr);
                    }
                } else if (pDate != null) {
                    if (pDateTo != null) {
                        params.put(name + "1", pDate);
                        params.put(name + "2", pDateTo);
                    } else {
                        params.put(name, pDate);
                    }
                } else if (pNum != null) {
                    if (pNumTo != null) {
                        params.put(name + "1", pNum);
                        params.put(name + "2", pNumTo);
                    } else {
                        params.put(name, pNum);
                    }
                }
                String info = rs.getString(8);
                String infoTo = rs.getString(9);
                params.put(name + "_Info1", info != null ? info : "");
                params.put(name + "_Info2", infoTo != null ? infoTo : "");
            }
        }
        catch (SQLException e) {
            try {
                throw new DBException(e, "SELECT  ParameterName,P_String,P_String_To,P_Number,P_Number_To,P_Date,P_Date_To,Info,Info_To FROM AD_PInstance_Para WHERE AD_PInstance_ID=?");
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
    }

    private void addProcessInfoParameters(Map<String, Object> params, ProcessInfoParameter[] para) {
        if (para != null) {
            for (int i2 = 0; i2 < para.length; ++i2) {
                if (para[i2].getParameter_To() == null) {
                    params.put(para[i2].getParameterName(), para[i2].getParameter());
                    continue;
                }
                params.put(para[i2].getParameterName() + "1", para[i2].getParameter());
                params.put(para[i2].getParameterName() + "2", para[i2].getParameter_To());
            }
        }
    }

    private void JWScorrectClassPath() {
        URL jasperreportsAbsoluteURL = Thread.currentThread().getContextClassLoader().getResource("net/sf/jasperreports/engine");
        String jasperreportsAbsolutePath = "";
        if (jasperreportsAbsoluteURL.toString().startsWith("jar:http:") || jasperreportsAbsoluteURL.toString().startsWith("jar:https:")) {
            jasperreportsAbsolutePath = jasperreportsAbsoluteURL.toString().split("!")[0].split("jar:")[1];
            File reqLib = new File(System.getProperty("java.io.tmpdir"), "CompiereJasperReqs.jar");
            if (!reqLib.exists() && reqLib.length() <= 0L) {
                try {
                    URL reqLibURL = new URL(jasperreportsAbsolutePath);
                    InputStream in = reqLibURL.openStream();
                    FileOutputStream fout = new FileOutputStream(reqLib);
                    byte[] buf = new byte[1024];
                    int s = 0;
                    while ((s = in.read(buf, 0, 1024)) > 0) {
                        fout.write(buf, 0, s);
                    }
                    in.close();
                    fout.flush();
                    fout.close();
                }
                catch (FileNotFoundException e) {
                    log.warning("Required library not found " + e.getMessage());
                    reqLib.delete();
                    reqLib = null;
                }
                catch (IOException e) {
                    log.severe("I/O error downloading required library from server " + e.getMessage());
                    reqLib.delete();
                    reqLib = null;
                }
            }
            jasperreportsAbsolutePath = reqLib.getAbsolutePath();
        } else {
            jasperreportsAbsolutePath = jasperreportsAbsoluteURL.toString().split("!")[0].split("file:")[1];
        }
        if (jasperreportsAbsolutePath != null && !jasperreportsAbsolutePath.trim().equals("") && System.getProperty("java.class.path").indexOf(jasperreportsAbsolutePath) < 0) {
            System.setProperty("java.class.path", System.getProperty("java.class.path") + System.getProperty("path.separator") + jasperreportsAbsolutePath);
            log.info("Classpath has been corrected to " + System.getProperty("java.class.path"));
        }
    }

    private JasperReport compileReport(File reportFile, File jasperFile) {
        this.JWScorrectClassPath();
        JasperReport compiledJasperReport = null;
        try {
            JasperCompileManager.compileReportToFile((String)reportFile.getAbsolutePath(), (String)jasperFile.getAbsolutePath());
            jasperFile.setLastModified(reportFile.lastModified());
            compiledJasperReport = (JasperReport)JRLoader.loadObject((File)jasperFile);
        }
        catch (JRException e) {
            log.log(Level.SEVERE, "Error", e);
        }
        return compiledJasperReport;
    }

    public ReportData getReportData(ProcessInfo pi, String trxName) {
        ReportData reportData;
        boolean directPrint;
        String path;
        ResultSet rs;
        CPreparedStatement pstmt;
        String sql;
        block7: {
            log.info("");
            sql = "SELECT pr.JasperReport, pr.IsDirectPrint FROM AD_Process pr, AD_PInstance pi WHERE pr.AD_Process_ID = pi.AD_Process_ID  AND pi.AD_PInstance_ID=?";
            pstmt = null;
            rs = null;
            pstmt = DB.prepareStatement(sql, 1003, 1007, trxName);
            pstmt.setInt(1, pi.getAD_PInstance_ID());
            rs = pstmt.executeQuery();
            path = null;
            directPrint = false;
            boolean isPrintPreview = pi.isPrintPreview();
            if (rs.next()) {
                path = rs.getString(1);
                if ("Y".equalsIgnoreCase(rs.getString(2)) && !Ini.isPropertyBool("PrintPreview") && !isPrintPreview) {
                    directPrint = true;
                }
                break block7;
            }
            log.severe("data not found; sql = " + sql);
            ReportData reportData2 = null;
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            return reportData2;
        }
        try {
            reportData = new ReportData(path, directPrint);
        }
        catch (SQLException e) {
            try {
                throw new DBException(e, sql);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return reportData;
    }

    public static void setReportViewerProvider(JRViewerProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Cannot set report viewer provider to null");
        }
        viewerProvider = provider;
    }

    public static JRViewerProvider getReportViewerProvider() {
        return viewerProvider;
    }

    static {
        String reportPath = System.getProperty("org.compiere.report.path");
        REPORT_HOME = reportPath == null ? new File(Ini.getAdempiereHome() + File.separator + "reports") : new File(reportPath);
    }

    class FileFilter
    implements FilenameFilter {
        private String reportStart;
        private File directory;
        private String extension;

        public FileFilter(String reportStart, File directory, String extension) {
            this.reportStart = reportStart;
            this.directory = directory;
            this.extension = extension;
        }

        @Override
        public boolean accept(File file, String name) {
            int pos;
            return file.equals(this.directory) && name.startsWith(this.reportStart) && (pos = name.lastIndexOf(this.extension)) != -1 && pos == name.length() - this.extension.length();
        }
    }

    public static class JasperData
    implements Serializable {
        private static final long serialVersionUID = 4375195020654531202L;
        private JasperReport jasperReport;
        private File reportDir;
        private String jasperName;
        private File jasperFile;

        public JasperData(JasperReport jasperReport, File reportDir, String jasperName, File jasperFile) {
            this.jasperReport = jasperReport;
            this.reportDir = reportDir;
            this.jasperName = jasperName;
            this.jasperFile = jasperFile;
        }

        public JasperReport getJasperReport() {
            return this.jasperReport;
        }

        public File getReportDir() {
            return this.reportDir;
        }

        public String getJasperName() {
            return this.jasperName;
        }

        public File getJasperFile() {
            return this.jasperFile;
        }
    }

    class ReportData {
        private String reportFilePath;
        private boolean directPrint;

        public ReportData(String reportFilePath, boolean directPrint) {
            this.reportFilePath = reportFilePath;
            this.directPrint = directPrint;
        }

        public String getReportFilePath() {
            return this.reportFilePath;
        }

        public boolean isDirectPrint() {
            return this.directPrint;
        }
    }
}

