/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProject;
import org.compiere.model.MProjectLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ProjectGenOrder
extends SvrProcess {
    private int m_C_Project_ID = 0;
    private BigDecimal disc_pcnt;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        this.m_C_Project_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("C_Project_ID=" + this.m_C_Project_ID);
        if (this.m_C_Project_ID == 0) {
            throw new IllegalArgumentException("C_Project_ID == 0");
        }
        MProject fromProject = ProjectGenOrder.getProject(this.getCtx(), this.m_C_Project_ID, this.get_TrxName());
        Env.setSOTrx(this.getCtx(), true);
        MOrder order = new MOrder(fromProject, true, "WI");
        if (!order.save()) {
            throw new Exception("Could not create Order");
        }
        int count = 0;
        if ("S".equals(fromProject.getProjectCategory())) {
            throw new Exception("Service Charge Projects are on the TODO List");
        }
        MProjectLine[] lines = fromProject.getLines();
        for (int i2 = 0; i2 < lines.length; ++i2) {
            MOrderLine ol = new MOrderLine(order);
            ol.setLine(lines[i2].getLine());
            ol.setDescription(lines[i2].getDescription());
            ol.setM_Product_ID(lines[i2].getM_Product_ID(), true);
            ol.setQty(lines[i2].getPlannedQty().subtract(lines[i2].getInvoicedQty()));
            Integer c_projectline_id = lines[i2].getC_ProjectLine_ID();
            System.out.println("projline : " + c_projectline_id);
            String sql = " Select nvl(disc_pcnt,0),nvl(NETSELLING_PRICE,0),nvl(PRICE_BEFORE_DISC,0) from c_projectline where c_projectline_id = ? ";
            try {
                CPreparedStatement pstmt = DB.prepareStatement(sql, this.get_TrxName());
                pstmt.setInt(1, c_projectline_id);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    this.disc_pcnt = rs.getBigDecimal(1);
                    BigDecimal netsell_price = rs.getBigDecimal(2);
                    BigDecimal price = rs.getBigDecimal(3);
                    ol.setPriceList(price);
                    ol.setPriceActual(netsell_price);
                    ol.setPriceLimit(price);
                    ol.setPriceEntered(netsell_price);
                }
                rs.close();
                pstmt.close();
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, e);
                return e.getLocalizedMessage();
            }
            ol.setTax();
            if (!ol.save()) continue;
            ++count;
        }
        if (lines.length != count) {
            this.log.log(Level.SEVERE, "Lines difference - ProjectLines=" + lines.length + " <> Saved=" + count);
        }
        return "@C_Order_ID@ " + order.getDocumentNo() + " (" + count + ")";
    }

    protected static MProject getProject(Properties ctx, int C_Project_ID, String trxName) {
        MProject fromProject = new MProject(ctx, C_Project_ID, trxName);
        if (fromProject.getC_Project_ID() == 0) {
            throw new IllegalArgumentException("Project not found C_Project_ID=" + C_Project_ID);
        }
        if (fromProject.getM_PriceList_Version_ID() == 0) {
            throw new IllegalArgumentException("Project has no Price List");
        }
        if (fromProject.getM_Warehouse_ID() == 0) {
            throw new IllegalArgumentException("Project has no Warehouse");
        }
        if (fromProject.getC_BPartner_ID() == 0 || fromProject.getC_BPartner_Location_ID() == 0) {
            throw new IllegalArgumentException("Project has no Business Partner/Location");
        }
        return fromProject;
    }
}

