/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MProject;
import org.compiere.model.MProjectLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;

public class ProjectClose
extends SvrProcess {
    private int m_C_Project_ID = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
        }
        this.m_C_Project_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        MProject project = new MProject(this.getCtx(), this.m_C_Project_ID, this.get_TrxName());
        this.log.info("doIt - " + project);
        MProjectLine[] projectLines = project.getLines();
        if ("W".equals(project.getProjectCategory()) || "A".equals(project.getProjectCategory())) {
            // empty if block
        }
        String sqlChk = "Select datefinish from c_project where c_project_id=? ";
        Timestamp DateFin = DB.getSQLValueTS(this.get_TrxName(), sqlChk, this.m_C_Project_ID);
        if (DateFin == null) {
            this.addLog(" Finish Date of the Project should not be blank");
            return " ";
        }
        for (int line = 0; line < projectLines.length; ++line) {
            projectLines[line].setProcessed(true);
            projectLines[line].saveEx();
        }
        try {
            project.setProcessed(true);
            project.setPosted(true);
        }
        catch (Exception e) {
            String string = e.getMessage();
        }
        project.saveEx();
        return "";
    }
}

