/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;

public class Process_Salman_GPVsExp
extends SvrProcess {
    private int AD_PInstance_ID = 0;
    private int SalesManID = 0;
    private Date DateFrom = new Date();
    private Date DateTo = new Date();
    private String formatedDateFrom = new String();
    private String formatedDateTo = new String();

    @Override
    protected void prepare() {
        this.AD_PInstance_ID = this.getAD_PInstance_ID();
        ProcessInfoParameter[] para = this.getParameter();
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("Salesman")) {
                    this.SalesManID = para[i].getParameterAsInt();
                } else if (name.equals("FromDate")) {
                    this.DateFrom = (Date)para[i].getParameter();
                    this.formatedDateFrom = sdf.format(this.DateFrom);
                } else if (name.equals("ToDate")) {
                    this.DateTo = (Date)para[i].getParameter();
                    this.formatedDateTo = sdf.format(this.DateTo);
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        try {
            String SalesAmountSQL = "SELECT nvl(SUM(linetotal),0) FROM betabi_salesproduct WHERE salesrep_id=? AND invoicedate >= TO_DATE(?,'dd/MM/yy') AND invoicedate <= TO_DATE(?,'dd/MM/yy') AND nvl(Beta_SubCat_ID,0)<>1000294 AND ad_org_id=1000011";
            String SalesAmtVal = DB.getSQLValueString(this.get_TrxName(), SalesAmountSQL, this.SalesManID, this.formatedDateFrom, this.formatedDateTo);
            DecimalFormat formatter = new DecimalFormat("#,###.00");
            String formatted = formatter.format(Double.parseDouble(SalesAmtVal));
            String SalesManNameSQL = "SELECT nvl(description,name) FROM ad_user WHERE ad_user_id=?";
            String SalesManName = DB.getSQLValueString(this.get_TrxName(), SalesManNameSQL, this.SalesManID);
            String GrossAmountSQL = "SELECT nvl(SUM(linetotal-totalcost),0) FROM betabi_salesproduct WHERE salesrep_id=? AND invoicedate >= TO_DATE(?,'dd/MM/yy') AND invoicedate <= TO_DATE(?,'dd/MM/yy') AND nvl(Beta_SubCat_ID,0)<>1000294 AND ad_org_id=1000011";
            BigDecimal GrossAmtVal = DB.getSQLValueBD(this.get_TrxName(), GrossAmountSQL, this.SalesManID, this.formatedDateFrom, this.formatedDateTo);
            String TotExpAmountSQL = "SELECT nvl(SUM(direxp+indirexp),0) FROM ad_user WHERE ad_user_id=?";
            BigDecimal TotExpAmountVal = DB.getSQLValueBD(this.get_TrxName(), TotExpAmountSQL, this.SalesManID);
            double GPVsExp = 0.0;
            DecimalFormat df = new DecimalFormat("#,###.00");
            GPVsExp = TotExpAmountVal.compareTo(BigDecimal.ZERO) == 0 ? 0.0 : Double.parseDouble(df.format(GrossAmtVal.doubleValue() / TotExpAmountVal.doubleValue()));
            this.addLog(0, null, null, "<html><br>   Sales Representative - " + SalesManName + "<br><br>    Sales Amount : " + formatted + "<br>=======================<br><br>Gross Profit VS Total Expense : " + GPVsExp + "</html>");
        }
        catch (Exception e) {
            System.out.println("Error recieved Rohan");
        }
        return "";
    }
}

