/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.util.logging.Level;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;

public class Process_GetStockInfo_General
extends SvrProcess {
    private int AD_PInstance_ID = 0;
    private int prdID = 0;
    private int warID = 0;
    private int catID = 0;

    @Override
    protected void prepare() {
        this.AD_PInstance_ID = this.getAD_PInstance_ID();
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("M_Product_ID")) {
                this.prdID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equalsIgnoreCase("M_Warehouse_ID")) {
                this.warID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equalsIgnoreCase("M_Product_Category_ID")) {
                this.catID = para[i2].getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    @Override
    protected String doIt() throws Exception {
        try {
            System.out.println("War Id" + this.warID);
            String prdSql = "Select Value from m_product where m_product_id=?";
            String prdVal = DB.getSQLValueString(this.get_TrxName(), prdSql, this.prdID);
            String wrhSql = "Select name from m_warehouse where m_warehouse_id=?";
            String wrhVal = DB.getSQLValueString(this.get_TrxName(), wrhSql, this.warID);
            String stkSQL = "select nvl(sum(qtyonhand),0) from m_storage where m_product_id=? and m_locator_id=(select nvl(max(m_locator_id),0) from m_locator  where m_warehouse_id=?)";
            BigDecimal stkVal = DB.getSQLValueBD(this.get_TrxName(), stkSQL, this.prdID, this.warID);
            String soSQL = "SELECT NVL((SELECT SUM(ol.qtyordered-ol.qtydelivered) FROM c_orderline ol INNER JOIN c_order oh ON oh.c_order_id=ol.c_order_id WHERE oh.issotrx='Y' AND ol.qtyordered>ol.qtydelivered AND oh.docstatus='CO' AND oh.POSTED='Y' AND ol.m_product_id=? and ol.m_warehouse_id=?  AND oh.c_doctypetarget_id=1000157),0) FROM dual";
            BigDecimal soVal = DB.getSQLValueBD(this.get_TrxName(), soSQL, this.prdID, this.warID);
            String poSQL = "SELECT NVL((SELECT SUM(ol.qtyordered-ol.qtydelivered) FROM c_orderline ol INNER JOIN c_order oh ON oh.c_order_id=ol.c_order_id WHERE oh.issotrx='N' AND ol.qtyordered>ol.qtydelivered AND oh.docstatus='CO' AND oh.POSTED='Y' AND ol.m_product_id=? and ol.m_warehouse_id=?),0) FROM dual";
            BigDecimal poVal = DB.getSQLValueBD(this.get_TrxName(), poSQL, this.prdID, this.warID);
            double netQty = stkVal.doubleValue() + poVal.doubleValue() - soVal.doubleValue();
            this.addLog(0, null, null, "<html><br>Stock Info: Product Code - " + prdVal + "<br><br>Qty on " + wrhVal + " : " + stkVal + "<br> Qty on the Way : " + poVal + "<br> Pending Sales Order : " + soVal + "<br>=======================<br>Net Qty : " + netQty + "<br>=======================<br><br></html>");
        }
        catch (Exception e) {
            String s = e.getLocalizedMessage();
            System.out.println("Error : " + s);
            String[] s1 = s.split(":");
            this.addLog(0, null, null, "Process Stopped");
            this.addLog(0, null, null, s1[1]);
        }
        return "";
    }
}

