/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.io.File;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import org.compiere.db.CConnection;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;

public class Process_Generate_SmanAging
extends SvrProcess {
    private int AD_PInstance_ID = 0;
    private int AD_Client_ID = 0;
    private int p_Org_ID = 0;
    private int p_BPGroup_ID = 0;
    public PreparedStatement pstmt = null;
    public int salID = 0;
    public String salName = null;
    public ResultSet rs1 = null;

    @Override
    protected void prepare() {
        this.AD_PInstance_ID = this.getAD_PInstance_ID();
        this.AD_Client_ID = this.getAD_Client_ID();
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("AD_Org_ID")) {
                this.p_Org_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (!name.equals("C_BP_Group_ID")) continue;
            this.p_BPGroup_ID = para[i2].getParameterAsInt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected String doIt() throws Exception {
        String orgName = "";
        String bpName = "";
        CallableStatement cstmt = null;
        String fileName = "/opt/Adempiere/reports/AgingSal_Exp.jasper";
        orgName = this.p_Org_ID == 1000010 ? "IND" : (this.p_Org_ID == 1000011 ? "TRD" : "ALL");
        if (this.p_BPGroup_ID == 0) {
            bpName = "ALL";
        } else {
            String sqlBP = "Select nvl(substr(name,-3,3),'ALL') from c_bp_group where c_bp_group_id=?";
            bpName = DB.getSQLValueString(this.get_TrxName(), sqlBP, this.p_BPGroup_ID);
        }
        String sql1 = "select ad_user_id,name from ad_user where EXISTS (SELECT * FROM C_BPartner bp WHERE AD_User.C_BPartner_ID=bp.C_BPartner_ID AND bp.IsSalesRep='Y') and isactive='Y' and ad_client_id = ? order by name";
        this.pstmt = null;
        try {
            this.pstmt = DB.prepareStatement(sql1, "DSPL");
            this.pstmt.setInt(1, this.AD_Client_ID);
            this.rs1 = this.pstmt.executeQuery();
        }
        catch (Exception e) {
            String s = e.getLocalizedMessage();
            System.out.println("Error : " + s);
            String string = "";
            return string;
        }
        while (this.rs1.next()) {
            this.salID = this.rs1.getInt(1);
            this.salName = this.rs1.getString(2);
            String outFileName = "/opt/Adempiere/Temp_Aging/Aging_" + bpName + "_" + orgName + "_" + this.salName + ".xls";
            String sql2 = "{call Beta_AgingSal_Export(?,?,?,?,?)}";
            try {
                cstmt = DB.prepareCall(sql2);
                cstmt.setInt(1, this.AD_PInstance_ID);
                cstmt.setInt(2, this.salID);
                cstmt.setInt(3, this.AD_Client_ID);
                cstmt.setInt(4, this.p_Org_ID);
                cstmt.setInt(5, this.p_BPGroup_ID);
                cstmt.executeUpdate();
                cstmt.close();
            }
            catch (Exception e) {
                this.addLog("Error..");
                String string = "";
                DB.close(this.rs1, this.pstmt);
                return string;
            }
            String sql_cnt = " select count(*) from Beta_AgingSal_Exp where SALESREP_ID=?";
            int count = DB.getSQLValue(this.get_TrxName(), sql_cnt, this.salID);
            if (count <= 0) continue;
            HashMap mm = new HashMap();
            JRXlsExporter exporter = new JRXlsExporter();
            Connection con = CConnection.get().getConnection(true, 8);
            JasperPrint prnt = JasperFillManager.fillReport((String)fileName, mm, (Connection)con);
            exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)outFileName);
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)prnt);
            exporter.exportReport();
            File f = new File(outFileName);
            con.commit();
            con.close();
        }
        this.rs1.close();
        this.pstmt.close();
        this.addLog(0, null, null, "Process Completed Successfully. Please open the folder to see the exported files");
        return "";
        finally {
            cstmt.close();
        }
        finally {
            DB.close(this.rs1, this.pstmt);
        }
    }
}

