/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.ValueNamePair;

public class M_Product_CostingUpdate
extends SvrProcess {
    private int p_Record_ID = 0;
    private int p_AD_Client_ID = -1;
    private int p_M_Product_Category_ID = -1;
    private String p_SetFutureCostTo;
    private int p_M_PriceList_Version_ID = -1;
    private String p_SetStandardCost;
    private String v_CostingMethod;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("AD_Client_ID")) {
                this.p_AD_Client_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("M_Product_Category_ID")) {
                this.p_M_Product_Category_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("SetFutureCostTo")) {
                this.p_SetFutureCostTo = (String)para[i2].getParameter();
                continue;
            }
            if (name.equals("M_PriceList_Version_ID")) {
                this.p_M_PriceList_Version_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("SetStandardCost")) {
                this.p_SetStandardCost = (String)para[i2].getParameter();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        this.p_Record_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        StringBuffer sql = null;
        int no = 0;
        int no1 = 0;
        int no2 = 0;
        this.log.info("Create the (new) costing information");
        if (this.p_SetFutureCostTo.equals("S")) {
            this.log.info("Set to Standard Cost");
            sql = new StringBuffer("UPDATE M_Product_Costing SET FutureCostPrice = CostStandard WHERE AD_Client_ID=" + this.p_AD_Client_ID + " AND (" + this.p_M_Product_Category_ID + " = -1 OR EXISTS (SELECT * FROM M_Product p WHERE p.M_Product_Category_ID= " + this.p_M_Product_Category_ID + " AND p.M_Product_ID=M_Product_Costing.M_Product_ID))");
            no = DB.executeUpdate(sql.toString(), this.get_TrxName());
            if (no == -1) {
                this.raiseError("Set to Standard Cost:ERROR", sql.toString());
            }
        } else if (this.p_SetFutureCostTo.equals("DP")) {
            this.log.info("Set to Difference PO");
            sql = new StringBuffer("UPDATE M_Product_Costing SET FutureCostPrice = CostStandard + (CostStandardPOAmt/CostStandardPOQty) WHERE CostStandardPOQty <> 0 AND CostStandardPOAmt <> 0 AND AD_Client_ID=" + this.p_AD_Client_ID + " AND (" + this.p_M_Product_Category_ID + " = -1 OR EXISTS (SELECT * FROM M_Product p WHERE p.M_Product_Category_ID=" + this.p_M_Product_Category_ID + " AND p.M_Product_ID=M_Product_Costing.M_Product_ID))");
            no = DB.executeUpdate(sql.toString(), this.get_TrxName());
            if (no == -1) {
                this.raiseError("Set to Difference PO:ERROR", sql.toString());
            }
        } else if (this.p_SetFutureCostTo.equals("DI")) {
            this.log.info("Set to Difference Inv");
            sql = new StringBuffer("UPDATE M_Product_Costing SET FutureCostPrice = CostStandard + (CostStandardCumAmt/CostStandardCumQty) WHERE CostStandardCumQty <> 0 AND CostStandardCumAmt <> 0 AND AD_Client_ID=" + this.p_AD_Client_ID + " AND (" + this.p_M_Product_Category_ID + " = -1 OR EXISTS (SELECT * FROM M_Product p WHERE p.M_Product_Category_ID=" + this.p_M_Product_Category_ID + " AND p.M_Product_ID=M_Product_Costing.M_Product_ID))");
            no = DB.executeUpdate(sql.toString(), this.get_TrxName());
            if (no == -1) {
                this.raiseError("Set to Difference Inv:ERROR", sql.toString());
            }
        } else if (this.p_SetFutureCostTo.equals("P")) {
            this.log.info("Set to PO Price");
            sql = new StringBuffer("UPDATE M_Product_Costing SET FutureCostPrice = PriceLastPO WHERE PriceLastPO <> 0 AND AD_Client_ID=" + this.p_AD_Client_ID + " AND (" + this.p_M_Product_Category_ID + " = -1 OR EXISTS (SELECT * FROM M_Product p WHERE p.M_Product_Category_ID=" + this.p_M_Product_Category_ID + " AND p.M_Product_ID=M_Product_Costing.M_Product_ID))");
            no = DB.executeUpdate(sql.toString(), this.get_TrxName());
            if (no == -1) {
                this.raiseError("Set to PO Price:ERROR", sql.toString());
            }
        } else if (this.p_SetFutureCostTo.equals("I")) {
            this.log.info("Set to Inv Price");
            sql = new StringBuffer("UPDATE M_Product_Costing SET FutureCostPrice = PriceLastInv WHERE PriceLastInv <> 0 AND AD_Client_ID=" + this.p_AD_Client_ID + " AND (" + this.p_M_Product_Category_ID + " = -1 OR EXISTS (SELECT * FROM M_Product p WHERE p.M_Product_Category_ID=" + this.p_M_Product_Category_ID + " AND p.M_Product_ID=M_Product_Costing.M_Product_ID))");
            no = DB.executeUpdate(sql.toString(), this.get_TrxName());
            if (no == -1) {
                this.raiseError("Set to Inv Price:ERROR", sql.toString());
            }
        } else if (this.p_SetFutureCostTo.equals("A")) {
            this.log.info("Set to Average Cost");
            sql = new StringBuffer("UPDATE M_Product_Costing SET FutureCostPrice = CostAverage WHERE CostAverage <> 0 AND AD_Client_ID=" + this.p_AD_Client_ID + " AND (" + this.p_M_Product_Category_ID + " = -1 OR EXISTS (SELECT * FROM M_Product p WHERE p.M_Product_Category_ID=" + this.p_M_Product_Category_ID + " AND p.M_Product_ID=M_Product_Costing.M_Product_ID))");
            no = DB.executeUpdate(sql.toString(), this.get_TrxName());
            if (no == -1) {
                this.raiseError("Set to Average Cost:ERROR", sql.toString());
            }
        } else if (this.p_SetFutureCostTo.equals("LL") && this.p_M_PriceList_Version_ID > 0) {
            this.log.info("Set to PriceList " + this.p_M_PriceList_Version_ID);
            sql = new StringBuffer("UPDATE M_Product_Costing SET FutureCostPrice = (SELECT pp.PriceLimit FROM M_ProductPrice pp WHERE pp.M_PriceList_Version_ID=" + this.p_M_PriceList_Version_ID + " AND pp.M_Product_ID=M_Product_Costing.M_Product_ID)WHERE\tAD_Client_ID=" + this.p_AD_Client_ID + " AND EXISTS (SELECT * FROM M_ProductPrice pp WHERE pp.M_PriceList_Version_ID=" + this.p_M_PriceList_Version_ID + " AND pp.M_Product_ID=M_Product_Costing.M_Product_ID) AND EXISTS (SELECT * FROM C_AcctSchema a, M_PriceList pl, M_PriceList_Version pv WHERE a.C_AcctSchema_ID=M_Product_CostingUpdate.C_AcctSchema_ID AND pv.M_PriceList_Version_ID=" + this.p_M_PriceList_Version_ID + " AND pv.M_PriceList_ID=pl.M_PriceList_ID AND pl.C_Currency_ID=a.C_Currency_ID) AND (" + this.p_M_Product_Category_ID + " = -1 OR EXISTS (SELECT * FROM M_Product p WHERE p.M_Product_Category_ID=" + this.p_M_Product_Category_ID + " AND p.M_Product_ID=M_Product_Costing.M_Product_ID))");
            no = DB.executeUpdate(sql.toString(), this.get_TrxName());
            if (no == -1) {
                this.raiseError("Set to Average Cost:ERROR", sql.toString());
            }
        } else {
            this.log.info("SetFutureCostTo=" + this.p_SetFutureCostTo + " ?");
        }
        this.log.info(" - Updated: " + no);
        if (this.p_SetStandardCost.equals("Y")) {
            this.log.info("Set Standard Cost");
            sql = new StringBuffer("UPDATE M_Product_Costing SET CostStandard = FutureCostPrice WHERE AD_Client_ID=" + this.p_AD_Client_ID + " AND (" + this.p_M_Product_Category_ID + " = -1 OR EXISTS (SELECT * FROM M_Product p WHERE p.M_Product_Category_ID=" + this.p_M_Product_Category_ID + " AND p.M_Product_ID=M_Product_Costing.M_Product_ID))");
            no1 = DB.executeUpdate(sql.toString(), this.get_TrxName());
            if (no1 == -1) {
                this.raiseError("Set Standard Cost", sql.toString());
            }
        }
        try {
            CPreparedStatement pstmt = DB.prepareStatement("SELECT a.CostingMethod FROM C_AcctSchema a, AD_ClientInfo ci WHERE a.C_AcctSchema_ID=ci.C_AcctSchema1_ID AND ci.AD_Client_ID=" + this.p_AD_Client_ID, this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                this.v_CostingMethod = rs.getString(1);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            throw new Exception("select CostingMethod", e);
        }
        this.log.info("Update Current Cost " + this.v_CostingMethod);
        this.log.info("Set Standard Cost");
        sql = new StringBuffer("UPDATE M_Product_Costing SET CurrentCostPrice = DECODE ('" + this.v_CostingMethod + "', 'A', CostAverage, CostStandard) WHERE AD_Client_ID=" + this.p_AD_Client_ID);
        no2 = DB.executeUpdate(sql.toString(), this.get_TrxName());
        if (no2 == -1) {
            this.raiseError("Set Standard Cost", sql.toString());
        }
        this.log.info(" - Updated: " + no2);
        return "@Updated@: " + no + "/" + no1;
    }

    private void raiseError(String string, String sql) throws Exception {
        DB.rollback(false, this.get_TrxName());
        String msg = string;
        ValueNamePair pp = CLogger.retrieveError();
        if (pp != null) {
            msg = pp.getName() + " - ";
        }
        msg = msg + sql;
        throw new AdempiereUserError(msg);
    }
}

