/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.List;
import java.util.logging.Level;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAcctSchemaDefault;
import org.compiere.model.MDocType;
import org.compiere.model.MFactAcct;
import org.compiere.model.MGLCategory;
import org.compiere.model.MInvoice;
import org.compiere.model.MJournal;
import org.compiere.model.MJournalBatch;
import org.compiere.model.MJournalLine;
import org.compiere.model.MOrg;
import org.compiere.model.Query;
import org.compiere.model.X_T_InvoiceGL;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CLogMgt;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class InvoiceNGL
extends SvrProcess {
    private int p_C_AcctSchema_ID = 0;
    private int p_C_ConversionTypeReval_ID = 0;
    private Timestamp p_DateReval = null;
    private String p_APAR = "A";
    private static String ONLY_AP = "P";
    private static String ONLY_AR = "R";
    private boolean p_IsAllCurrencies = false;
    private int p_C_Currency_ID = 0;
    private int p_C_DocTypeReval_ID = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("C_AcctSchema_ID")) {
                this.p_C_AcctSchema_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("C_ConversionTypeReval_ID")) {
                this.p_C_ConversionTypeReval_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("DateReval")) {
                this.p_DateReval = (Timestamp)para[i2].getParameter();
                continue;
            }
            if (name.equals("APAR")) {
                this.p_APAR = (String)para[i2].getParameter();
                continue;
            }
            if (name.equals("IsAllCurrencies")) {
                this.p_IsAllCurrencies = "Y".equals((String)para[i2].getParameter());
                continue;
            }
            if (name.equals("C_Currency_ID")) {
                this.p_C_Currency_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("C_DocTypeReval_ID")) {
                this.p_C_DocTypeReval_ID = para[i2].getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    @Override
    protected String doIt() throws Exception {
        String sql;
        int no;
        if (this.p_IsAllCurrencies) {
            this.p_C_Currency_ID = 0;
        }
        this.log.info("C_AcctSchema_ID=" + this.p_C_AcctSchema_ID + ",C_ConversionTypeReval_ID=" + this.p_C_ConversionTypeReval_ID + ",DateReval=" + this.p_DateReval + ", APAR=" + this.p_APAR + ", IsAllCurrencies=" + this.p_IsAllCurrencies + ",C_Currency_ID=" + this.p_C_Currency_ID + ", C_DocType_ID=" + this.p_C_DocTypeReval_ID);
        if (this.p_DateReval == null) {
            this.p_DateReval = new Timestamp(System.currentTimeMillis());
        }
        if ((no = DB.executeUpdate(sql = "DELETE T_InvoiceGL WHERE AD_PInstance_ID=" + this.getAD_PInstance_ID(), this.get_TrxName())) > 0) {
            this.log.info("Deleted #" + no);
        }
        String dateStr = DB.TO_DATE(this.p_DateReval, true);
        sql = "INSERT INTO T_InvoiceGL (AD_Client_ID, AD_Org_ID, IsActive, Created,CreatedBy, Updated,UpdatedBy, AD_PInstance_ID, C_Invoice_ID, GrandTotal, OpenAmt,  Fact_Acct_ID, AmtSourceBalance, AmtAcctBalance,  AmtRevalDr, AmtRevalCr, C_DocTypeReval_ID, IsAllCurrencies,  DateReval, C_ConversionTypeReval_ID, AmtRevalDrDiff, AmtRevalCrDiff, APAR) SELECT i.AD_Client_ID, i.AD_Org_ID, i.IsActive, i.Created,i.CreatedBy, i.Updated,i.UpdatedBy," + this.getAD_PInstance_ID() + ", i.C_Invoice_ID, i.GrandTotal, invoiceOpen(i.C_Invoice_ID, 0),  fa.Fact_Acct_ID, fa.AmtSourceDr-fa.AmtSourceCr, fa.AmtAcctDr-fa.AmtAcctCr,  currencyConvert(fa.AmtSourceDr, i.C_Currency_ID, a.C_Currency_ID, " + dateStr + ", " + this.p_C_ConversionTypeReval_ID + ", i.AD_Client_ID, i.AD_Org_ID), currencyConvert(fa.AmtSourceCr, i.C_Currency_ID, a.C_Currency_ID, " + dateStr + ", " + this.p_C_ConversionTypeReval_ID + ", i.AD_Client_ID, i.AD_Org_ID)," + (this.p_C_DocTypeReval_ID == 0 ? "NULL" : String.valueOf(this.p_C_DocTypeReval_ID)) + ", " + (this.p_IsAllCurrencies ? "'Y'," : "'N',") + dateStr + ", " + this.p_C_ConversionTypeReval_ID + ", 0, 0, '" + this.p_APAR + "' FROM C_Invoice_v i INNER JOIN Fact_Acct fa ON (fa.AD_Table_ID=318 AND fa.Record_ID=i.C_Invoice_ID AND (i.GrandTotal=fa.AmtSourceDr OR i.GrandTotal=fa.AmtSourceCr)) INNER JOIN C_AcctSchema a ON (fa.C_AcctSchema_ID=a.C_AcctSchema_ID) WHERE i.IsPaid='N' AND EXISTS (SELECT * FROM C_ElementValue ev WHERE ev.C_ElementValue_ID=fa.Account_ID AND (ev.AccountType='A' OR ev.AccountType='L')) AND fa.C_AcctSchema_ID=" + this.p_C_AcctSchema_ID;
        if (!this.p_IsAllCurrencies) {
            sql = sql + " AND i.C_Currency_ID<>a.C_Currency_ID";
        }
        if (ONLY_AR.equals(this.p_APAR)) {
            sql = sql + " AND i.IsSOTrx='Y'";
        } else if (ONLY_AP.equals(this.p_APAR)) {
            sql = sql + " AND i.IsSOTrx='N'";
        }
        if (!this.p_IsAllCurrencies && this.p_C_Currency_ID != 0) {
            sql = sql + " AND i.C_Currency_ID=" + this.p_C_Currency_ID;
        }
        if ((no = DB.executeUpdate(sql, this.get_TrxName())) != 0) {
            this.log.info("Inserted #" + no);
        } else if (CLogMgt.isLevelFiner()) {
            this.log.warning("Inserted #" + no + " - " + sql);
        } else {
            this.log.warning("Inserted #" + no);
        }
        sql = "UPDATE T_InvoiceGL gl SET (AmtRevalDrDiff,AmtRevalCrDiff)=(SELECT gl.AmtRevalDr-fa.AmtAcctDr, gl.AmtRevalCr-fa.AmtAcctCr FROM Fact_Acct fa WHERE gl.Fact_Acct_ID=fa.Fact_Acct_ID) WHERE AD_PInstance_ID=" + this.getAD_PInstance_ID();
        int noT = DB.executeUpdate(sql, this.get_TrxName());
        if (noT > 0) {
            this.log.config("Difference #" + noT);
        }
        if ((no = DB.executeUpdate(sql = "UPDATE T_InvoiceGL SET Percent = 100 WHERE GrandTotal=OpenAmt AND AD_PInstance_ID=" + this.getAD_PInstance_ID(), this.get_TrxName())) > 0) {
            this.log.info("Not Paid #" + no);
        }
        if ((no = DB.executeUpdate(sql = "UPDATE T_InvoiceGL SET Percent = ROUND(OpenAmt*100/GrandTotal,6) WHERE GrandTotal<>OpenAmt AND GrandTotal <> 0 AND AD_PInstance_ID=" + this.getAD_PInstance_ID(), this.get_TrxName())) > 0) {
            this.log.info("Partial Paid #" + no);
        }
        if ((no = DB.executeUpdate(sql = "UPDATE T_InvoiceGL SET AmtRevalDr = AmtRevalDr * Percent/100, AmtRevalCr = AmtRevalCr * Percent/100, AmtRevalDrDiff = AmtRevalDrDiff * Percent/100, AmtRevalCrDiff = AmtRevalCrDiff * Percent/100 WHERE Percent <> 100 AND AD_PInstance_ID=" + this.getAD_PInstance_ID(), this.get_TrxName())) > 0) {
            this.log.config("Partial Calc #" + no);
        }
        String info = "";
        if (this.p_C_DocTypeReval_ID != 0) {
            if (this.p_C_Currency_ID != 0) {
                this.log.warning("Can create Journal only for all currencies");
            } else {
                info = this.createGLJournal();
            }
        }
        return "#" + noT + info;
    }

    private String createGLJournal() {
        String whereClause = "AD_PInstance_ID=?";
        List list = new Query(this.getCtx(), "T_InvoiceGL", "AD_PInstance_ID=?", this.get_TrxName()).setParameters(this.getAD_PInstance_ID()).setOrderBy("AD_Org_ID").list();
        if (list.size() == 0) {
            return " - No Records found";
        }
        MAcctSchema as = MAcctSchema.get(this.getCtx(), this.p_C_AcctSchema_ID);
        MAcctSchemaDefault asDefaultAccts = MAcctSchemaDefault.get(this.getCtx(), this.p_C_AcctSchema_ID);
        MGLCategory cat = MGLCategory.getDefaultSystem(this.getCtx());
        if (cat == null) {
            MDocType docType = MDocType.get(this.getCtx(), this.p_C_DocTypeReval_ID);
            cat = MGLCategory.get(this.getCtx(), docType.getGL_Category_ID());
        }
        MJournalBatch batch = new MJournalBatch(this.getCtx(), 0, this.get_TrxName());
        batch.setDescription(this.getName());
        batch.setC_DocType_ID(this.p_C_DocTypeReval_ID);
        batch.setDateDoc(new Timestamp(System.currentTimeMillis()));
        batch.setDateAcct(this.p_DateReval);
        batch.setC_Currency_ID(as.getC_Currency_ID());
        if (!batch.save()) {
            return " - Could not create Batch";
        }
        MJournal journal = null;
        BigDecimal drTotal = Env.ZERO;
        BigDecimal crTotal = Env.ZERO;
        int AD_Org_ID = 0;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            MInvoice invoice;
            X_T_InvoiceGL gl = (X_T_InvoiceGL)list.get(i2);
            if (gl.getAmtRevalDrDiff().signum() == 0 && gl.getAmtRevalCrDiff().signum() == 0 || (invoice = new MInvoice(this.getCtx(), gl.getC_Invoice_ID(), null)).getC_Currency_ID() == as.getC_Currency_ID()) continue;
            if (journal == null) {
                journal = new MJournal(batch);
                journal.setC_AcctSchema_ID(as.getC_AcctSchema_ID());
                journal.setC_Currency_ID(as.getC_Currency_ID());
                journal.setC_ConversionType_ID(this.p_C_ConversionTypeReval_ID);
                MOrg org = MOrg.get(this.getCtx(), gl.getAD_Org_ID());
                journal.setDescription(this.getName() + " - " + org.getName());
                journal.setGL_Category_ID(cat.getGL_Category_ID());
                if (!journal.save()) {
                    return " - Could not create Journal";
                }
            }
            MJournalLine line = new MJournalLine(journal);
            line.setLine((i2 + 1) * 10);
            line.setDescription(invoice.getSummary());
            MFactAcct fa = new MFactAcct(this.getCtx(), gl.getFact_Acct_ID(), null);
            line.setC_ValidCombination_ID(MAccount.get(fa));
            BigDecimal dr = gl.getAmtRevalDrDiff();
            BigDecimal cr = gl.getAmtRevalCrDiff();
            drTotal = drTotal.add(dr);
            crTotal = crTotal.add(cr);
            line.setAmtSourceDr(dr);
            line.setAmtAcctDr(dr);
            line.setAmtSourceCr(cr);
            line.setAmtAcctCr(cr);
            line.save();
            if (AD_Org_ID == 0) {
                AD_Org_ID = gl.getAD_Org_ID();
            }
            if (AD_Org_ID == gl.getAD_Org_ID()) continue;
            this.createBalancing(asDefaultAccts, journal, drTotal, crTotal, AD_Org_ID, (i2 + 1) * 10);
            AD_Org_ID = gl.getAD_Org_ID();
            drTotal = Env.ZERO;
            crTotal = Env.ZERO;
            journal = null;
        }
        this.createBalancing(asDefaultAccts, journal, drTotal, crTotal, AD_Org_ID, (list.size() + 1) * 10);
        return " - " + batch.getDocumentNo() + " #" + list.size();
    }

    private void createBalancing(MAcctSchemaDefault asDefaultAccts, MJournal journal, BigDecimal drTotal, BigDecimal crTotal, int AD_Org_ID, int lineNo) {
        MAccount acct;
        MAccount base;
        MJournalLine line;
        if (journal == null) {
            throw new IllegalArgumentException("Jornal is null");
        }
        if (drTotal.signum() != 0) {
            line = new MJournalLine(journal);
            line.setLine(lineNo + 1);
            base = MAccount.get(this.getCtx(), asDefaultAccts.getUnrealizedGain_Acct());
            acct = MAccount.get(this.getCtx(), asDefaultAccts.getAD_Client_ID(), AD_Org_ID, asDefaultAccts.getC_AcctSchema_ID(), base.getAccount_ID(), base.getC_SubAcct_ID(), base.getM_Product_ID(), base.getC_BPartner_ID(), base.getAD_OrgTrx_ID(), base.getC_LocFrom_ID(), base.getC_LocTo_ID(), base.getC_SalesRegion_ID(), base.getC_Project_ID(), base.getC_Campaign_ID(), base.getC_Activity_ID(), base.getUser1_ID(), base.getUser2_ID(), base.getUserElement1_ID(), base.getUserElement2_ID());
            line.setDescription(Msg.getElement(this.getCtx(), "UnrealizedGain_Acct"));
            line.setC_ValidCombination_ID(acct.getC_ValidCombination_ID());
            line.setAmtSourceCr(drTotal);
            line.setAmtAcctCr(drTotal);
            line.save();
        }
        if (crTotal.signum() != 0) {
            line = new MJournalLine(journal);
            line.setLine(lineNo + 2);
            base = MAccount.get(this.getCtx(), asDefaultAccts.getUnrealizedLoss_Acct());
            acct = MAccount.get(this.getCtx(), asDefaultAccts.getAD_Client_ID(), AD_Org_ID, asDefaultAccts.getC_AcctSchema_ID(), base.getAccount_ID(), base.getC_SubAcct_ID(), base.getM_Product_ID(), base.getC_BPartner_ID(), base.getAD_OrgTrx_ID(), base.getC_LocFrom_ID(), base.getC_LocTo_ID(), base.getC_SalesRegion_ID(), base.getC_Project_ID(), base.getC_Campaign_ID(), base.getC_Activity_ID(), base.getUser1_ID(), base.getUser2_ID(), base.getUserElement1_ID(), base.getUserElement2_ID());
            line.setDescription(Msg.getElement(this.getCtx(), "UnrealizedLoss_Acct"));
            line.setC_ValidCombination_ID(acct.getC_ValidCombination_ID());
            line.setAmtSourceDr(crTotal);
            line.setAmtAcctDr(crTotal);
            line.save();
        }
    }
}

