/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.MColumn;
import org.compiere.model.MTable;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.ValueNamePair;

public class ColumnSync
extends SvrProcess {
    private int p_AD_Column_ID = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        this.p_AD_Column_ID = this.getRecord_ID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doIt() throws Exception {
        this.log.info("C_Column_ID=" + this.p_AD_Column_ID);
        if (this.p_AD_Column_ID == 0) {
            throw new AdempiereUserError("@No@ @AD_Column_ID@");
        }
        MColumn column = new MColumn(this.getCtx(), this.p_AD_Column_ID, this.get_TrxName());
        if (column.get_ID() == 0) {
            throw new AdempiereUserError("@NotFound@ @AD_Column_ID@ " + this.p_AD_Column_ID);
        }
        MTable table2 = new MTable(this.getCtx(), column.getAD_Table_ID(), this.get_TrxName());
        if (table2.get_ID() == 0) {
            throw new AdempiereUserError("@NotFound@ @AD_Table_ID@ " + column.getAD_Table_ID());
        }
        Connection conn = null;
        try {
            conn = DB.getConnectionRO();
            DatabaseMetaData md = conn.getMetaData();
            String catalog = DB.getDatabase().getCatalog();
            String schema = DB.getDatabase().getSchema();
            String tableName = table2.getTableName();
            if (md.storesUpperCaseIdentifiers()) {
                tableName = tableName.toUpperCase();
            } else if (md.storesLowerCaseIdentifiers()) {
                tableName = tableName.toLowerCase();
            }
            int noColumns = 0;
            String sql = null;
            ResultSet rs = md.getColumns(catalog, schema, tableName, null);
            while (rs.next()) {
                ++noColumns;
                String columnName = rs.getString("COLUMN_NAME");
                if (!columnName.equalsIgnoreCase(column.getColumnName())) continue;
                boolean notNull = 0 == rs.getInt("NULLABLE");
                sql = column.getSQLModify(table2, column.isMandatory() != notNull);
                break;
            }
            rs.close();
            rs = null;
            if (noColumns == 0) {
                sql = table2.getSQLCreate();
            } else if (sql == null) {
                sql = column.getSQLAdd(table2);
            }
            int no = 0;
            if (sql.indexOf("; ") == -1) {
                no = DB.executeUpdate(sql, false, this.get_TrxName());
                this.addLog(0, null, new BigDecimal(no), sql);
            } else {
                String[] statements = sql.split("; ");
                for (int i2 = 0; i2 < statements.length; ++i2) {
                    int count = DB.executeUpdate(statements[i2], false, this.get_TrxName());
                    this.addLog(0, null, new BigDecimal(count), statements[i2]);
                    no += count;
                }
            }
            if (no == -1) {
                String msg = "@Error@ ";
                ValueNamePair pp = CLogger.retrieveError();
                if (pp != null) {
                    msg = pp.getName() + " - ";
                }
                msg = msg + sql;
                throw new AdempiereUserError(msg);
            }
            String string = sql;
            return string;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

