/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print.layout;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.Properties;
import net.sourceforge.barbecue.Barcode;
import net.sourceforge.barbecue.BarcodeFactory;
import net.sourceforge.barbecue.output.OutputException;
import org.compiere.print.MPrintFont;
import org.compiere.print.MPrintFormatItem;
import org.compiere.print.layout.PrintElement;

public class BarcodeElement
extends PrintElement {
    private boolean m_valid = true;
    private Barcode m_barcode = null;
    private boolean m_allowOverflow = true;
    private float m_scaleFactor = 1.0f;

    public BarcodeElement(String code, MPrintFormatItem item) {
        if (code == null || code.length() == 0 || item == null || item.getBarcodeType() == null || item.getBarcodeType().length() == 0) {
            this.m_valid = false;
        }
        this.createBarcode(code, item);
        if (this.m_barcode == null) {
            this.m_valid = false;
        }
        this.m_allowOverflow = item.isHeightOneLine();
    }

    private void createBarcode(String code, MPrintFormatItem item) {
        MPrintFont mFont;
        String type = item.getBarcodeType();
        try {
            if (type.equals("2o9")) {
                this.m_barcode = BarcodeFactory.create2of7((String)code);
            } else if (type.equals("MON")) {
                this.m_barcode = BarcodeFactory.createMonarch((String)code);
            } else if (type.equals("NW7")) {
                this.m_barcode = BarcodeFactory.createNW7((String)code);
            } else if (type.equals("US4")) {
                this.m_barcode = BarcodeFactory.createUSD4((String)code);
            } else if (type.equals("28A")) {
                this.m_barcode = BarcodeFactory.createCode128A((String)code);
            } else if (type.equals("28B")) {
                this.m_barcode = BarcodeFactory.createCode128B((String)code);
            } else if (type.equals("28C")) {
                this.m_barcode = BarcodeFactory.createCode128C((String)code);
            } else if (type.equals("C28")) {
                this.m_barcode = BarcodeFactory.createCode128((String)code);
            } else if (type.equals("3O9")) {
                this.m_barcode = BarcodeFactory.create3of9((String)code, (boolean)true);
            } else if (type.equals("3o9")) {
                this.m_barcode = BarcodeFactory.create3of9((String)code, (boolean)false);
            } else if (type.equals("C39")) {
                this.m_barcode = BarcodeFactory.createCode39((String)code, (boolean)true);
            } else if (type.equals("c39")) {
                this.m_barcode = BarcodeFactory.createCode39((String)code, (boolean)false);
            } else if (type.equals("US3")) {
                this.m_barcode = BarcodeFactory.createUSD3((String)code, (boolean)true);
            } else if (type.equals("us3")) {
                this.m_barcode = BarcodeFactory.createUSD3((String)code, (boolean)false);
            } else if (type.equals("COD")) {
                this.m_barcode = BarcodeFactory.createCodabar((String)code);
            } else if (type.equals("E28")) {
                this.m_barcode = BarcodeFactory.createEAN128((String)code);
            } else if (type.equals("GTN")) {
                this.m_barcode = BarcodeFactory.createGlobalTradeItemNumber((String)code);
            } else if (type.equals("417")) {
                this.m_barcode = BarcodeFactory.createPDF417((String)code);
            } else if (type.equals("C14")) {
                this.m_barcode = BarcodeFactory.createSCC14ShippingCode((String)code);
            } else if (type.equals("SID")) {
                this.m_barcode = BarcodeFactory.createShipmentIdentificationNumber((String)code);
            } else if (type.equals("C18")) {
                this.m_barcode = BarcodeFactory.createSSCC18((String)code);
            } else if (type.equals("U28")) {
                this.m_barcode = BarcodeFactory.createUCC128((String)"01", (String)code);
            } else if (type.equals("E13")) {
                this.m_barcode = BarcodeFactory.createEAN13((String)code);
            } else if (type.equals("USP")) {
                this.m_barcode = BarcodeFactory.createUSPS((String)code);
                this.m_barcode.setDrawingText(false);
            } else {
                this.log.warning("Invalid Type" + type);
            }
        }
        catch (Exception e) {
            this.log.warning(code + " - " + e.toString());
            this.m_valid = false;
        }
        if (this.m_valid && this.m_barcode != null && item.getAD_PrintFont_ID() != 0 && (mFont = MPrintFont.get(item.getAD_PrintFont_ID())) != null) {
            this.m_barcode.setFont(mFont.getFont());
        }
    }

    public Barcode getBarcode() {
        return this.m_barcode;
    }

    public boolean isValid() {
        return this.m_valid;
    }

    @Override
    protected boolean calculateSize() {
        this.p_width = 0.0f;
        this.p_height = 0.0f;
        if (this.m_barcode == null) {
            return true;
        }
        this.p_width = this.m_barcode.getWidth();
        this.p_height = this.m_barcode.getHeight();
        if (this.p_width * this.p_height == 0.0f) {
            return true;
        }
        this.m_scaleFactor = 1.0f;
        if (this.p_maxWidth != 0.0f && this.p_width > this.p_maxWidth) {
            this.m_scaleFactor = this.p_maxWidth / this.p_width;
        }
        if (this.p_maxHeight != 0.0f && this.p_height > this.p_maxHeight && this.p_maxHeight / this.p_height < this.m_scaleFactor) {
            this.m_scaleFactor = this.p_maxHeight / this.p_height;
        }
        this.p_width = this.m_scaleFactor * this.p_width;
        this.p_height = this.m_scaleFactor * this.p_height;
        return true;
    }

    public float getScaleFactor() {
        if (!this.p_sizeCalculated) {
            this.p_sizeCalculated = this.calculateSize();
        }
        return this.m_scaleFactor;
    }

    public boolean isAllowOverflow() {
        return this.m_allowOverflow;
    }

    @Override
    public void paint(Graphics2D g2D, int pageNo, Point2D pageStart, Properties ctx, boolean isView) {
        if (!this.m_valid || this.m_barcode == null) {
            return;
        }
        Point2D.Double location = this.getAbsoluteLocation(pageStart);
        int x = (int)location.x;
        if ("T".equals(this.p_FieldAlignmentType)) {
            x = (int)((float)x + (this.p_maxWidth - this.p_width));
        } else if ("C".equals(this.p_FieldAlignmentType)) {
            x = (int)((float)x + (this.p_maxWidth - this.p_width) / 2.0f);
        }
        int y = (int)location.y;
        try {
            int w = this.m_barcode.getWidth();
            int h = this.m_barcode.getHeight();
            BufferedImage image = new BufferedImage(w, h, 2);
            Graphics2D temp = (Graphics2D)image.getGraphics();
            this.m_barcode.draw(temp, 0, 0);
            AffineTransform transform = new AffineTransform();
            transform.translate(x, y);
            transform.scale(this.m_scaleFactor, this.m_scaleFactor);
            g2D.drawImage(image, transform, this);
        }
        catch (OutputException outputException) {
            // empty catch block
        }
    }

    @Override
    public String toString() {
        if (this.m_barcode == null) {
            return super.toString();
        }
        return super.toString() + " " + this.m_barcode.getData();
    }
}

