/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.pos;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import org.compiere.model.MProduct;
import org.compiere.model.MWarehousePrice;
import org.compiere.pos.PosPanel;
import org.compiere.pos.PosSubPanel;
import org.compiere.swing.CButton;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class SubProduct
extends PosSubPanel
implements ActionListener,
FocusListener {
    private static final long serialVersionUID = -6626441083848884910L;
    protected CTextField f_name;
    private CButton f_bSearch;
    private MProduct m_product = null;
    private int m_M_Warehouse_ID;
    private int m_M_PriceList_Version_ID;
    private static CLogger log = CLogger.getCLogger(SubProduct.class);

    public SubProduct(PosPanel posPanel) {
        super(posPanel);
    }

    @Override
    public void init() {
        TitledBorder border = new TitledBorder(Msg.translate(this.p_ctx, "M_Product_ID"));
        this.setBorder(border);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = INSETS2;
        this.f_name = new CTextField("");
        this.f_name.setName("Name");
        this.f_name.addActionListener(this);
        this.f_name.addFocusListener(this);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 13;
        gbc.fill = 1;
        gbc.weightx = 0.1;
        this.add((Component)this.f_name, gbc);
        this.f_bSearch = this.createButtonAction("Product", KeyStroke.getKeyStroke(73, 2));
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        this.add((Component)this.f_bSearch, gbc);
    }

    @Override
    public GridBagConstraints getGridBagConstraints() {
        GridBagConstraints gbc = super.getGridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        return gbc;
    }

    @Override
    public void dispose() {
        if (this.f_name != null) {
            this.f_name.removeFocusListener(this);
        }
        this.removeAll();
        super.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action == null || action.length() == 0) {
            return;
        }
        log.info("PosSubProduct - actionPerformed: " + action);
        if (action.equals("Product")) {
            this.setParameter();
            this.p_posPanel.openQuery(this.p_posPanel.f_queryProduct);
        } else if (e.getSource() == this.f_name) {
            this.findProduct();
        }
        this.p_posPanel.updateInfo();
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.isTemporary()) {
            return;
        }
        log.info("PosSubProduct - focusLost");
        this.findProduct();
        this.p_posPanel.updateInfo();
    }

    private void setParameter() {
        this.m_M_Warehouse_ID = this.p_pos.getM_Warehouse_ID();
        this.m_M_PriceList_Version_ID = this.p_posPanel.f_bpartner.getM_PriceList_Version_ID();
        this.p_posPanel.f_queryProduct.setQueryData(this.m_M_PriceList_Version_ID, this.m_M_Warehouse_ID);
    }

    private void findProduct() {
        String query = this.f_name.getText();
        if (query == null || query.length() == 0) {
            return;
        }
        query = query.toUpperCase();
        boolean allNumber = true;
        try {
            Integer.getInteger(query);
        }
        catch (Exception e) {
            allNumber = false;
        }
        String Value = query;
        String Name2 = query;
        String UPC = allNumber ? query : null;
        String SKU = allNumber ? query : null;
        MWarehousePrice[] results = null;
        this.setParameter();
        results = MWarehousePrice.find(this.p_ctx, this.m_M_PriceList_Version_ID, this.m_M_Warehouse_ID, Value, Name2, UPC, SKU, null);
        if (results.length == 0) {
            this.setM_Product_ID(0);
            this.p_posPanel.f_curLine.setPrice(Env.ZERO);
        } else if (results.length == 1) {
            this.setM_Product_ID(results[0].getM_Product_ID());
            this.f_name.setText(results[0].getName());
            this.p_posPanel.f_curLine.setPrice(results[0].getPriceStd());
        } else {
            this.p_posPanel.f_queryProduct.setResults(results);
            this.p_posPanel.openQuery(this.p_posPanel.f_queryProduct);
        }
    }

    public void setPrice() {
        if (this.m_product == null) {
            return;
        }
        this.setParameter();
        MWarehousePrice result = MWarehousePrice.get(this.m_product, this.m_M_PriceList_Version_ID, this.m_M_Warehouse_ID, null);
        if (result != null) {
            this.p_posPanel.f_curLine.setPrice(result.getPriceStd());
        }
    }

    public void setM_Product_ID(int M_Product_ID) {
        log.fine("PosSubProduct.setM_Product_ID=" + M_Product_ID);
        if (M_Product_ID <= 0) {
            this.m_product = null;
        } else {
            this.m_product = MProduct.get(this.p_ctx, M_Product_ID);
            if (this.m_product.get_ID() == 0) {
                this.m_product = null;
            }
        }
        if (this.m_product != null) {
            this.f_name.setText(this.m_product.getName());
            this.f_name.setToolTipText(this.m_product.getDescription());
            this.p_posPanel.f_curLine.setUOM(this.m_product.getUOMSymbol());
        } else {
            this.f_name.setText(null);
            this.f_name.setToolTipText(null);
            this.p_posPanel.f_curLine.setUOM(null);
        }
    }

    public int getM_Product_ID() {
        if (this.m_product != null) {
            return this.m_product.getM_Product_ID();
        }
        return 0;
    }

    public int getC_UOM_ID() {
        if (this.m_product != null) {
            return this.m_product.getC_UOM_ID();
        }
        return 0;
    }

    public String getProductName() {
        if (this.m_product != null) {
            return this.m_product.getName();
        }
        return "";
    }

    public MProduct getProduct() {
        return this.m_product;
    }
}

