/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.pos;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.border.TitledBorder;
import org.compiere.model.MPOSKey;
import org.compiere.model.MPOSKeyLayout;
import org.compiere.pos.PosPanel;
import org.compiere.pos.PosSubPanel;
import org.compiere.print.MPrintColor;
import org.compiere.swing.CButton;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class SubFunctionKeys
extends PosSubPanel
implements ActionListener {
    private static final long serialVersionUID = 2131406504920855582L;
    private MPOSKey[] m_keys;
    private static CLogger log = CLogger.getCLogger(SubFunctionKeys.class);

    public SubFunctionKeys(PosPanel posPanel) {
        super(posPanel);
    }

    @Override
    public void init() {
        int i2;
        TitledBorder border = new TitledBorder(Msg.translate(Env.getCtx(), "C_POSKeyLayout_ID"));
        this.setBorder(border);
        int C_POSKeyLayout_ID = this.p_pos.getC_POSKeyLayout_ID();
        if (C_POSKeyLayout_ID == 0) {
            return;
        }
        MPOSKeyLayout fKeys = MPOSKeyLayout.get(Env.getCtx(), C_POSKeyLayout_ID);
        if (fKeys.get_ID() == 0) {
            return;
        }
        int COLUMNS = 3;
        int ROWS = 6;
        this.m_keys = fKeys.getKeys(false);
        int noKeys = this.m_keys.length;
        int rows = Math.max((noKeys - 1) / COLUMNS + 1, ROWS);
        int cols = (noKeys - 1) % COLUMNS + 1;
        log.fine("PosSubFunctionKeys.init - NoKeys=" + noKeys + " - Rows=" + rows + ", Cols=" + cols);
        CPanel content = new CPanel(new GridLayout(Math.max(rows, 3), Math.max(cols, 3)));
        for (i2 = 0; i2 < this.m_keys.length; ++i2) {
            Color keyColor = Color.lightGray;
            MPOSKey key = this.m_keys[i2];
            StringBuffer buttonHTML = new StringBuffer("<html><p>");
            if (key.getAD_PrintColor_ID() != 0) {
                MPrintColor color = MPrintColor.get(Env.getCtx(), key.getAD_PrintColor_ID());
                keyColor = color.getColor();
                buttonHTML.append("<table").append(">").append(key.getName()).append("</table>");
            } else {
                buttonHTML.append(key.getName());
            }
            buttonHTML.append("</p></html>");
            log.fine("#" + i2 + " - " + keyColor);
            CButton button = new CButton(buttonHTML.toString());
            button.setMargin(INSETS1);
            button.setBackground(keyColor);
            button.setFocusable(false);
            button.setActionCommand(String.valueOf(key.getC_POSKey_ID()));
            button.addActionListener(this);
            content.add(button);
        }
        for (i2 = this.m_keys.length; i2 < rows * COLUMNS; ++i2) {
            CButton button = new CButton("");
            button.setFocusable(false);
            button.setBackground(Color.cyan);
            content.add(button);
        }
        content.setPreferredSize(new Dimension(cols * 80, rows * 50));
        this.add(content);
    }

    @Override
    public GridBagConstraints getGridBagConstraints() {
        GridBagConstraints gbc = super.getGridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridheight = 3;
        return gbc;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action == null || action.length() == 0 || this.m_keys == null) {
            return;
        }
        log.info("PosSubFunctionKeys - actionPerformed: " + action);
        try {
            int C_POSKey_ID = Integer.parseInt(action);
            for (int i2 = 0; i2 < this.m_keys.length; ++i2) {
                MPOSKey key = this.m_keys[i2];
                if (key.getC_POSKey_ID() != C_POSKey_ID) continue;
                this.p_posPanel.f_product.setM_Product_ID(key.getM_Product_ID());
                this.p_posPanel.f_product.setPrice();
                this.p_posPanel.f_curLine.setQty(key.getQty());
                this.p_posPanel.f_curLine.saveLine();
                this.p_posPanel.updateInfo();
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

