/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.pos;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerInfo;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MCurrency;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MUser;
import org.compiere.pos.PosPanel;
import org.compiere.pos.PosSubPanel;
import org.compiere.swing.CButton;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class SubBPartner
extends PosSubPanel
implements ActionListener,
FocusListener {
    private static final long serialVersionUID = 5895558315889871887L;
    private CTextField f_name;
    private CButton f_bNew;
    private CButton f_bEdit;
    private CButton f_bSearch;
    private CComboBox f_location;
    private CComboBox f_user;
    private MBPartner m_bpartner;
    private int m_M_PriceList_Version_ID = 0;
    private static CLogger log = CLogger.getCLogger(SubBPartner.class);

    public SubBPartner(PosPanel posPanel) {
        super(posPanel);
    }

    @Override
    public void init() {
        TitledBorder border = new TitledBorder(Msg.translate(this.p_ctx, "C_BPartner_ID"));
        this.setBorder(border);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = INSETS2;
        this.f_bNew = this.createButtonAction("New", null);
        gbc.gridx = 0;
        gbc.gridheight = 2;
        gbc.anchor = 17;
        this.add((Component)this.f_bNew, gbc);
        this.f_bEdit = this.createButtonAction("Edit", null);
        gbc.gridx = 1;
        this.add((Component)this.f_bEdit, gbc);
        this.f_name = new CTextField("");
        this.f_name.setName("Name");
        this.f_name.addActionListener(this);
        this.f_name.addFocusListener(this);
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 2;
        gbc.weightx = 0.5;
        gbc.fill = 2;
        this.add((Component)this.f_name, gbc);
        this.f_location = new CComboBox();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        this.add((Component)this.f_location, gbc);
        this.f_user = new CComboBox();
        gbc.gridx = 3;
        gbc.gridy = 1;
        gbc.anchor = 13;
        this.add((Component)this.f_user, gbc);
        this.f_bSearch = this.createButtonAction("BPartner", KeyStroke.getKeyStroke(73, 3));
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.gridheight = 2;
        gbc.fill = 0;
        this.add((Component)this.f_bSearch, gbc);
    }

    @Override
    public GridBagConstraints getGridBagConstraints() {
        GridBagConstraints gbc = super.getGridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        return gbc;
    }

    @Override
    public void dispose() {
        if (this.f_name != null) {
            this.f_name.removeFocusListener(this);
        }
        this.f_name = null;
        this.removeAll();
        super.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action == null || action.length() == 0) {
            return;
        }
        log.info("PosSubCustomer - actionPerformed: " + action);
        if (action.equals("New")) {
            this.p_posPanel.newOrder();
        } else if (action.equals("Edit")) {
            this.f_bEdit.setReadWrite(false);
        } else if (action.equals("BPartner")) {
            this.p_posPanel.openQuery(this.p_posPanel.f_queryBPartner);
        } else if (e.getSource() == this.f_name) {
            this.findBPartner();
        }
        this.p_posPanel.updateInfo();
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.isTemporary()) {
            return;
        }
        log.info(e.toString());
        this.findBPartner();
    }

    private void findBPartner() {
        String query = this.f_name.getText();
        if (query == null || query.length() == 0) {
            return;
        }
        query = query.toUpperCase();
        boolean allNumber = true;
        boolean noNumber = true;
        char[] qq = query.toCharArray();
        for (int i2 = 0; i2 < qq.length; ++i2) {
            if (!Character.isDigit(qq[i2])) continue;
            noNumber = false;
            break;
        }
        try {
            Integer.parseInt(query);
        }
        catch (Exception e) {
            allNumber = false;
        }
        String Value = query;
        String Name2 = allNumber ? null : query;
        String EMail2 = query.indexOf(64) != -1 ? query : null;
        String Phone = noNumber ? null : query;
        String City = null;
        MBPartnerInfo[] results = MBPartnerInfo.find(this.p_ctx, Value, Name2, null, EMail2, Phone, City);
        if (results.length == 0) {
            this.setC_BPartner_ID(0);
        } else if (results.length == 1) {
            this.setC_BPartner_ID(results[0].getC_BPartner_ID());
            this.f_name.setText(results[0].getName());
        } else {
            this.p_posPanel.f_queryBPartner.setResults(results);
            this.p_posPanel.openQuery(this.p_posPanel.f_queryBPartner);
        }
    }

    public void setC_BPartner_ID(int C_BPartner_ID) {
        log.fine("PosSubCustomer.setC_BPartner_ID=" + C_BPartner_ID);
        if (C_BPartner_ID == 0) {
            this.m_bpartner = null;
        } else {
            this.m_bpartner = new MBPartner(this.p_ctx, C_BPartner_ID, null);
            if (this.m_bpartner.get_ID() == 0) {
                this.m_bpartner = null;
            }
        }
        if (this.m_bpartner != null) {
            this.f_name.setText(this.m_bpartner.getName());
            this.f_bEdit.setReadWrite(false);
        } else {
            this.f_name.setText(null);
            this.f_bEdit.setReadWrite(false);
        }
        this.m_M_PriceList_Version_ID = 0;
        this.getM_PriceList_Version_ID();
        this.fillCombos();
        this.p_posPanel.f_curLine.setBPartner();
    }

    private void fillCombos() {
        Vector<KeyNamePair> locationVector = new Vector<KeyNamePair>();
        if (this.m_bpartner != null) {
            MBPartnerLocation[] locations = this.m_bpartner.getLocations(false);
            for (int i2 = 0; i2 < locations.length; ++i2) {
                locationVector.add(locations[i2].getKeyNamePair());
            }
        }
        DefaultComboBoxModel locationModel = new DefaultComboBoxModel(locationVector);
        this.f_location.setModel(locationModel);
        Vector<KeyNamePair> userVector = new Vector<KeyNamePair>();
        if (this.m_bpartner != null) {
            MUser[] users = this.m_bpartner.getContacts(false);
            for (int i3 = 0; i3 < users.length; ++i3) {
                userVector.add(users[i3].getKeyNamePair());
            }
        }
        DefaultComboBoxModel userModel = new DefaultComboBoxModel(userVector);
        this.f_user.setModel(userModel);
    }

    public int getC_BPartner_ID() {
        if (this.m_bpartner != null) {
            return this.m_bpartner.getC_BPartner_ID();
        }
        return 0;
    }

    public MBPartner getBPartner() {
        return this.m_bpartner;
    }

    public int getC_BPartner_Location_ID() {
        KeyNamePair pp;
        if (this.m_bpartner != null && (pp = (KeyNamePair)this.f_location.getSelectedItem()) != null) {
            return pp.getKey();
        }
        return 0;
    }

    public int getAD_User_ID() {
        KeyNamePair pp;
        if (this.m_bpartner != null && (pp = (KeyNamePair)this.f_user.getSelectedItem()) != null) {
            return pp.getKey();
        }
        return 0;
    }

    public int getM_PriceList_Version_ID() {
        if (this.m_M_PriceList_Version_ID == 0) {
            int M_PriceList_ID = this.p_pos.getM_PriceList_ID();
            if (this.m_bpartner != null && this.m_bpartner.getM_PriceList_ID() != 0) {
                M_PriceList_ID = this.m_bpartner.getM_PriceList_ID();
            }
            MPriceList pl = MPriceList.get(this.p_ctx, M_PriceList_ID, null);
            this.p_posPanel.f_curLine.setCurrency(MCurrency.getISO_Code(this.p_ctx, pl.getC_Currency_ID()));
            this.f_name.setToolTipText(pl.getName());
            MPriceListVersion plv = pl.getPriceListVersion(this.p_posPanel.getToday());
            if (plv != null && plv.getM_PriceList_Version_ID() != 0) {
                this.m_M_PriceList_Version_ID = plv.getM_PriceList_Version_ID();
            }
        }
        return this.m_M_PriceList_Version_ID;
    }
}

