/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Properties;
import org.compiere.model.MProjectReceipt;
import org.compiere.model.X_C_ProjectReceiptLine;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MProjectReceiptLine
extends X_C_ProjectReceiptLine {
    private MProjectReceipt m_parent = null;

    public MProjectReceiptLine(Properties ctx, int C_ProjectReceiptLine_ID, String trxName) {
        super(ctx, C_ProjectReceiptLine_ID, trxName);
        if (C_ProjectReceiptLine_ID == 0) {
            this.setM_Product_ID(0);
            this.setQTYRECEIVED(Env.ZERO);
        }
    }

    public MProjectReceiptLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MProjectReceipt getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MProjectReceipt(this.getCtx(), this.getC_ProjectReceipt_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        BigDecimal QtyRecvd = this.getQTYRECEIVED();
        Integer PrjLine = this.getC_ProjectLine_ID();
        Integer C_PROJECTRECEIPTLINE_ID = this.getC_ProjectReceiptLine_ID();
        String sql1 = "Select nvl(Sum(QTYRECEIVED),0) from C_PROJECTRECEIPTLINE Where C_ProjectLine_ID = ? and C_PROJECTRECEIPTLINE_ID != ?";
        BigDecimal TotRecvd = DB.getSQLValueBD(this.get_TrxName(), sql1, PrjLine, C_PROJECTRECEIPTLINE_ID);
        String sql2 = "Select nvl(PlannedQty,0) from C_PROJECTLINE Where C_ProjectLine_ID = ? ";
        BigDecimal PlannedQty = DB.getSQLValueBD(this.get_TrxName(), sql2, PrjLine);
        if (TotRecvd.add(QtyRecvd).compareTo(PlannedQty) == 1) {
            this.log.saveError("Error", Msg.getMsg(this.getCtx(), "Total Qty received exceeds the Planned Qty (" + PlannedQty + ") for this project"));
            return false;
        }
        if (QtyRecvd.doubleValue() == 0.0) {
            this.log.saveError("Error", Msg.getMsg(this.getCtx(), "Qty Received Should be Greater than Zero"));
            return false;
        }
        if (newRecord || this.is_ValueChanged("M_Product_ID")) {
            MProjectReceiptLine[] rcptLines;
            boolean isDuplicated = false;
            for (MProjectReceiptLine oLine : rcptLines = this.getParent().getLines()) {
                if (oLine.getM_Product_ID() != this.getM_Product_ID()) continue;
                isDuplicated = true;
                break;
            }
            if (isDuplicated) {
                this.log.saveError("Error", Msg.getMsg(this.getCtx(), "The Product can't appear 2 times in a Document "));
                return false;
            }
        }
        return true;
    }

    private boolean updhdr() {
        boolean no = true;
        return no;
    }
}

