/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.io.FileWriter;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MBPBankAccount;
import org.compiere.model.MCurrency;
import org.compiere.model.MPaySelection;
import org.compiere.model.MPaySelectionLine;
import org.compiere.model.MPayment;
import org.compiere.model.MPaymentAllocate;
import org.compiere.model.MPaymentBatch;
import org.compiere.model.X_C_PaySelectionCheck;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public final class MPaySelectionCheck
extends X_C_PaySelectionCheck {
    private static final long serialVersionUID = 1059335268247781843L;
    private static CLogger s_log = CLogger.getCLogger(MPaySelectionCheck.class);
    private static final int BP_VALUE = 0;
    private static final int BP_NAME = 1;
    private static final int BP_CONTACT = 2;
    private static final int BP_ADDR1 = 3;
    private static final int BP_ADDR2 = 4;
    private static final int BP_CITY = 5;
    private static final int BP_REGION = 6;
    private static final int BP_POSTAL = 7;
    private static final int BP_COUNTRY = 8;
    private static final int BP_REFNO = 9;
    private MPaySelection m_parent = null;
    private MPaySelectionLine[] m_lines = null;

    public static MPaySelectionCheck getOfPayment(Properties ctx, int C_Payment_ID, String trxName) {
        MPaySelectionCheck retValue = null;
        String sql = "SELECT * FROM C_PaySelectionCheck WHERE C_Payment_ID=?";
        int count = 0;
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setInt(1, C_Payment_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MPaySelectionCheck psc = new MPaySelectionCheck(ctx, rs, trxName);
                if (retValue == null) {
                    retValue = psc;
                } else if (!retValue.isProcessed() && psc.isProcessed()) {
                    retValue = psc;
                }
                ++count;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (count > 1) {
            s_log.warning("More then one for C_Payment_ID=" + C_Payment_ID);
        }
        return retValue;
    }

    public static MPaySelectionCheck createForPayment(Properties ctx, int C_Payment_ID, String trxName) {
        if (C_Payment_ID == 0) {
            return null;
        }
        MPayment payment = new MPayment(ctx, C_Payment_ID, null);
        String PaymentRule = "S";
        if (payment.getTenderType().equals("C")) {
            PaymentRule = "K";
        } else if (payment.getTenderType().equals("D")) {
            PaymentRule = "D";
        } else if (payment.getTenderType().equals("A")) {
            PaymentRule = "T";
        }
        MPaySelection ps = new MPaySelection(ctx, 0, trxName);
        ps.setAD_Org_ID(payment.getAD_Org_ID());
        ps.setC_BankAccount_ID(payment.getC_BankAccount_ID());
        ps.setName(Msg.translate(ctx, "C_Payment_ID") + ": " + payment.getDocumentNo());
        ps.setDescription(payment.getDescription());
        ps.setPayDate(payment.getDateTrx());
        ps.setTotalAmt(payment.getPayAmt());
        ps.setIsApproved(true);
        ps.save();
        MPaySelectionCheck psc = new MPaySelectionCheck(ps, PaymentRule);
        psc.setC_BPartner_ID(payment.getC_BPartner_ID());
        psc.setC_Payment_ID(payment.getC_Payment_ID());
        psc.setIsReceipt(payment.isReceipt());
        psc.setPayAmt(payment.getPayAmt());
        psc.setDiscountAmt(payment.getDiscountAmt());
        psc.setQty(1);
        psc.setDocumentNo(payment.getDocumentNo());
        psc.setProcessed(true);
        psc.setIsGeneratedDraft(!payment.isProcessed());
        psc.save();
        MPaySelectionLine psl = null;
        if (payment.getC_Invoice_ID() != 0) {
            psl = new MPaySelectionLine(ps, 10, PaymentRule);
            psl.setC_Invoice_ID(payment.getC_Invoice_ID());
            psl.setIsSOTrx(payment.isReceipt());
            psl.setOpenAmt(payment.getPayAmt().add(payment.getDiscountAmt()));
            psl.setPayAmt(payment.getPayAmt());
            psl.setDiscountAmt(payment.getDiscountAmt());
            psl.setDifferenceAmt(Env.ZERO);
            psl.setC_PaySelectionCheck_ID(psc.getC_PaySelectionCheck_ID());
            psl.setProcessed(true);
            psl.save();
        } else {
            MPaymentAllocate[] pAllocs = MPaymentAllocate.get(payment);
            if (pAllocs.length != 0) {
                int numInv = 0;
                for (int i2 = 0; i2 < pAllocs.length; ++i2) {
                    MPaymentAllocate pAlloc = pAllocs[i2];
                    if (pAlloc.getC_Invoice_ID() == 0) continue;
                    MPaySelectionLine psla = null;
                    psla = new MPaySelectionLine(ps, 10 * (i2 + 1), PaymentRule);
                    psla.setC_Invoice_ID(pAlloc.getC_Invoice_ID());
                    psla.setIsSOTrx(payment.isReceipt());
                    psla.setOpenAmt(pAlloc.getAmount().add(pAlloc.getDiscountAmt()));
                    psla.setPayAmt(pAlloc.getAmount());
                    psla.setDiscountAmt(pAlloc.getDiscountAmt());
                    psla.setDifferenceAmt(Env.ZERO);
                    psla.setC_PaySelectionCheck_ID(psc.getC_PaySelectionCheck_ID());
                    psla.setProcessed(true);
                    psla.save();
                    ++numInv;
                }
                if (numInv > 0) {
                    psc.setQty(numInv);
                    psc.save();
                }
            }
        }
        ps.setProcessed(true);
        ps.save();
        return psc;
    }

    public static MPaySelectionCheck[] get(int C_PaySelection_ID, String PaymentRule, int startDocumentNo, String trxName) {
        s_log.fine("C_PaySelection_ID=" + C_PaySelection_ID + ", PaymentRule=" + PaymentRule + ", startDocumentNo=" + startDocumentNo);
        ArrayList<MPaySelectionCheck> list = new ArrayList<MPaySelectionCheck>();
        int docNo = startDocumentNo;
        String sql = "SELECT * FROM C_PaySelectionCheck WHERE C_PaySelection_ID=? AND PaymentRule=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setInt(1, C_PaySelection_ID);
            pstmt.setString(2, PaymentRule);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MPaySelectionCheck check = new MPaySelectionCheck(Env.getCtx(), rs, trxName);
                check.setDocumentNo(String.valueOf(docNo++));
                check.save();
                list.add(check);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        MPaySelectionCheck[] retValue = new MPaySelectionCheck[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static int exportToFile(MPaySelectionCheck[] checks, File file) {
        if (checks == null || checks.length == 0) {
            return 0;
        }
        if (file.isDirectory()) {
            s_log.log(Level.WARNING, "File is directory - " + file.getAbsolutePath());
            return 0;
        }
        try {
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            s_log.log(Level.WARNING, "Could not delete - " + file.getAbsolutePath(), e);
        }
        char x = '\"';
        int noLines = 0;
        StringBuffer line = null;
        try {
            FileWriter fw = new FileWriter(file);
            line = new StringBuffer();
            line.append(x).append("Value").append(x).append(",").append(x).append("Name").append(x).append(",").append(x).append("Contact").append(x).append(",").append(x).append("Addr1").append(x).append(",").append(x).append("Addr2").append(x).append(",").append(x).append("City").append(x).append(",").append(x).append("State").append(x).append(",").append(x).append("ZIP").append(x).append(",").append(x).append("Country").append(x).append(",").append(x).append("ReferenceNo").append(x).append(",").append(x).append("DocumentNo").append(x).append(",").append(x).append("PayDate").append(x).append(",").append(x).append("Currency").append(x).append(",").append(x).append("PayAmount").append(x).append(",").append(x).append("Comment").append(x).append(Env.NL);
            fw.write(line.toString());
            ++noLines;
            for (int i2 = 0; i2 < checks.length; ++i2) {
                MPaySelectionCheck mpp = checks[i2];
                if (mpp == null) continue;
                String[] bp = MPaySelectionCheck.getBPartnerInfo(mpp.getC_BPartner_ID());
                StringBuffer comment = new StringBuffer();
                MPaySelectionLine[] psls = mpp.getPaySelectionLines(false);
                for (int l = 0; l < psls.length; ++l) {
                    if (l > 0) {
                        comment.append(", ");
                    }
                    comment.append(psls[l].getInvoice().getDocumentNo());
                }
                line = new StringBuffer();
                line.append(x).append(bp[0]).append(x).append(",").append(x).append(bp[1]).append(x).append(",").append(x).append(bp[2]).append(x).append(",").append(x).append(bp[3]).append(x).append(",").append(x).append(bp[4]).append(x).append(",").append(x).append(bp[5]).append(x).append(",").append(x).append(bp[6]).append(x).append(",").append(x).append(bp[7]).append(x).append(",").append(x).append(bp[8]).append(x).append(",").append(x).append(bp[9]).append(x).append(",").append(x).append(mpp.getDocumentNo()).append(x).append(",").append(mpp.getParent().getPayDate()).append(",").append(x).append(MCurrency.getISO_Code(Env.getCtx(), mpp.getParent().getC_Currency_ID())).append(x).append(",").append(mpp.getPayAmt()).append(",").append(x).append(comment.toString()).append(x).append(Env.NL);
                fw.write(line.toString());
                ++noLines;
            }
            fw.flush();
            fw.close();
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, "", e);
        }
        return noLines;
    }

    private static String[] getBPartnerInfo(int C_BPartner_ID) {
        String[] bp = new String[10];
        String sql = "SELECT bp.Value, bp.Name, c.Name AS Contact, a.Address1, a.Address2, a.City, r.Name AS Region, a.Postal, cc.Name AS Country, bp.ReferenceNo FROM C_BPartner bp, AD_User c, C_BPartner_Location l, C_Location a, C_Region r, C_Country cc WHERE bp.C_BPartner_ID=? AND bp.C_BPartner_ID=c.C_BPartner_ID(+) AND bp.C_BPartner_ID=l.C_BPartner_ID AND l.C_Location_ID=a.C_Location_ID AND a.C_Region_ID=r.C_Region_ID(+) AND a.C_Country_ID=cc.C_Country_ID ORDER BY l.IsBillTo DESC";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, C_BPartner_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                bp[0] = rs.getString(1);
                if (bp[0] == null) {
                    bp[0] = "";
                }
                bp[1] = rs.getString(2);
                if (bp[1] == null) {
                    bp[1] = "";
                }
                bp[2] = rs.getString(3);
                if (bp[2] == null) {
                    bp[2] = "";
                }
                bp[3] = rs.getString(4);
                if (bp[3] == null) {
                    bp[3] = "";
                }
                bp[4] = rs.getString(5);
                if (bp[4] == null) {
                    bp[4] = "";
                }
                bp[5] = rs.getString(6);
                if (bp[5] == null) {
                    bp[5] = "";
                }
                bp[6] = rs.getString(7);
                if (bp[6] == null) {
                    bp[6] = "";
                }
                bp[7] = rs.getString(8);
                if (bp[7] == null) {
                    bp[7] = "";
                }
                bp[8] = rs.getString(9);
                if (bp[8] == null) {
                    bp[8] = "";
                }
                bp[9] = rs.getString(10);
                if (bp[9] == null) {
                    bp[9] = "";
                }
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        return bp;
    }

    public static int confirmPrint(MPaySelectionCheck[] checks, MPaymentBatch batch) {
        int lastDocumentNo = 0;
        for (int i2 = 0; i2 < checks.length; ++i2) {
            MPaySelectionCheck check = checks[i2];
            MPayment payment = new MPayment(check.getCtx(), check.getC_Payment_ID(), check.get_TrxName());
            if (check.getC_Payment_ID() != 0) {
                if (check.getPaymentRule().equals("S")) {
                    payment.setCheckNo(check.getDocumentNo());
                    if (!payment.save()) {
                        s_log.log(Level.SEVERE, "Payment not saved: " + payment);
                    }
                }
            } else {
                int C_Payment_ID;
                payment = new MPayment(check.getCtx(), 0, check.get_TrxName());
                payment.setAD_Org_ID(check.getAD_Org_ID());
                if (check.getPaymentRule().equals("S")) {
                    payment.setBankCheck(check.getParent().getC_BankAccount_ID(), false, check.getDocumentNo());
                } else if (check.getPaymentRule().equals("K")) {
                    payment.setTenderType("C");
                } else if (check.getPaymentRule().equals("T") || check.getPaymentRule().equals("D")) {
                    payment.setBankACH(check);
                } else {
                    s_log.log(Level.SEVERE, "Unsupported Payment Rule=" + check.getPaymentRule());
                    continue;
                }
                payment.setTrxType("C");
                payment.setAmount(check.getParent().getC_Currency_ID(), check.getPayAmt());
                payment.setDiscountAmt(check.getDiscountAmt());
                payment.setDateTrx(check.getParent().getPayDate());
                payment.setDateAcct(payment.getDateTrx());
                payment.setC_BPartner_ID(check.getC_BPartner_ID());
                if (batch != null) {
                    if (batch.getC_PaymentBatch_ID() == 0) {
                        batch.save();
                    }
                    payment.setC_PaymentBatch_ID(batch.getC_PaymentBatch_ID());
                }
                MPaySelectionLine[] psls = check.getPaySelectionLines(false);
                s_log.fine("confirmPrint - " + check + " (#SelectionLines=" + psls.length + ")");
                if (check.getQty() == 1 && psls != null && psls.length == 1) {
                    MPaySelectionLine psl = psls[0];
                    s_log.fine("Map to Invoice " + psl);
                    payment.setC_Invoice_ID(psl.getC_Invoice_ID());
                    payment.setDiscountAmt(psl.getDiscountAmt());
                    payment.setWriteOffAmt(psl.getDifferenceAmt());
                    BigDecimal overUnder = psl.getOpenAmt().subtract(psl.getPayAmt()).subtract(psl.getDiscountAmt()).subtract(psl.getDifferenceAmt());
                    payment.setOverUnderAmt(overUnder);
                } else {
                    payment.setDiscountAmt(Env.ZERO);
                }
                payment.setWriteOffAmt(Env.ZERO);
                if (!payment.save()) {
                    s_log.log(Level.SEVERE, "Payment not saved: " + payment);
                }
                if ((C_Payment_ID = payment.get_ID()) < 1) {
                    s_log.log(Level.SEVERE, "Payment not created=" + check);
                } else {
                    check.setC_Payment_ID(C_Payment_ID);
                    check.save();
                    payment.processIt("CO");
                    if (!payment.save()) {
                        s_log.log(Level.SEVERE, "Payment not saved: " + payment);
                    }
                }
            }
            try {
                int no = Integer.parseInt(check.getDocumentNo());
                if (lastDocumentNo < no) {
                    lastDocumentNo = no;
                }
            }
            catch (NumberFormatException ex) {
                s_log.log(Level.SEVERE, "DocumentNo=" + check.getDocumentNo(), ex);
            }
            check.setIsPrinted(true);
            check.setProcessed(true);
            if (check.save()) continue;
            s_log.log(Level.SEVERE, "Check not saved: " + check);
        }
        s_log.fine("Last Document No = " + lastDocumentNo);
        return lastDocumentNo;
    }

    public MPaySelectionCheck(Properties ctx, int C_PaySelectionCheck_ID, String trxName) {
        super(ctx, C_PaySelectionCheck_ID, trxName);
        if (C_PaySelectionCheck_ID == 0) {
            this.setPayAmt(Env.ZERO);
            this.setDiscountAmt(Env.ZERO);
            this.setIsPrinted(false);
            this.setIsReceipt(false);
            this.setQty(0);
        }
    }

    public MPaySelectionCheck(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MPaySelectionCheck(MPaySelectionLine line, String PaymentRule) {
        this(line.getCtx(), 0, line.get_TrxName());
        this.setClientOrg(line);
        this.setC_PaySelection_ID(line.getC_PaySelection_ID());
        int C_BPartner_ID = line.getInvoice().getC_BPartner_ID();
        this.setC_BPartner_ID(C_BPartner_ID);
        if ("D".equals(PaymentRule)) {
            MBPBankAccount[] bas = MBPBankAccount.getOfBPartner(line.getCtx(), C_BPartner_ID);
            for (int i2 = 0; i2 < bas.length; ++i2) {
                MBPBankAccount account = bas[i2];
                if (!account.isDirectDebit()) continue;
                this.setC_BP_BankAccount_ID(account.getC_BP_BankAccount_ID());
                break;
            }
        } else if ("T".equals(PaymentRule)) {
            MBPBankAccount[] bas = MBPBankAccount.getOfBPartner(line.getCtx(), C_BPartner_ID);
            for (int i3 = 0; i3 < bas.length; ++i3) {
                MBPBankAccount account = bas[i3];
                if (!account.isDirectDeposit()) continue;
                this.setC_BP_BankAccount_ID(account.getC_BP_BankAccount_ID());
                break;
            }
        }
        this.setPaymentRule(PaymentRule);
        this.setIsReceipt(line.isSOTrx());
        this.setPayAmt(line.getPayAmt());
        this.setDiscountAmt(line.getDiscountAmt());
        this.setQty(1);
    }

    public MPaySelectionCheck(MPaySelection ps, String PaymentRule) {
        this(ps.getCtx(), 0, ps.get_TrxName());
        this.setClientOrg(ps);
        this.setC_PaySelection_ID(ps.getC_PaySelection_ID());
        this.setPaymentRule(PaymentRule);
    }

    public void addLine(MPaySelectionLine line) {
        if (this.getC_BPartner_ID() != line.getInvoice().getC_BPartner_ID()) {
            throw new IllegalArgumentException("Line for fifferent BPartner");
        }
        if (this.isReceipt() == line.isSOTrx()) {
            this.setPayAmt(this.getPayAmt().add(line.getPayAmt()));
            this.setDiscountAmt(this.getDiscountAmt().add(line.getDiscountAmt()));
        } else {
            this.setPayAmt(this.getPayAmt().subtract(line.getPayAmt()));
            this.setDiscountAmt(this.getDiscountAmt().subtract(line.getDiscountAmt()));
        }
        this.setQty(this.getQty() + 1);
    }

    public MPaySelection getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MPaySelection(this.getCtx(), this.getC_PaySelection_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    public boolean isValid() {
        if (this.getC_BP_BankAccount_ID() != 0) {
            return true;
        }
        return !this.isDirect();
    }

    public boolean isDirect() {
        return "T".equals(this.getPaymentRule()) || "D".equals(this.getPaymentRule());
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MPaymentCheck[");
        sb.append(this.get_ID()).append("-").append(this.getDocumentNo()).append("-").append(this.getPayAmt()).append(",PaymetRule=").append(this.getPaymentRule()).append(",Qty=").append(this.getQty()).append("]");
        return sb.toString();
    }

    public MPaySelectionLine[] getPaySelectionLines(boolean requery) {
        if (this.m_lines != null && !requery) {
            MPaySelectionCheck.set_TrxName(this.m_lines, this.get_TrxName());
            return this.m_lines;
        }
        ArrayList<MPaySelectionLine> list = new ArrayList<MPaySelectionLine>();
        String sql = "SELECT * FROM C_PaySelectionLine WHERE C_PaySelectionCheck_ID=? ORDER BY Line";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getC_PaySelectionCheck_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MPaySelectionLine(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_lines = new MPaySelectionLine[list.size()];
        list.toArray(this.m_lines);
        return this.m_lines;
    }

    public static boolean deleteGeneratedDraft(Properties ctx, int C_Payment_ID, String trxName) {
        MPaySelectionCheck mpsc = MPaySelectionCheck.getOfPayment(ctx, C_Payment_ID, trxName);
        if (mpsc != null && mpsc.isGeneratedDraft()) {
            MPaySelection mps = new MPaySelection(ctx, mpsc.getC_PaySelection_ID(), trxName);
            MPaySelectionLine[] mpsl = mps.getLines(true);
            for (int i2 = 0; i2 < mpsl.length; ++i2) {
                if (mpsl[i2].delete(true, trxName)) continue;
                return false;
            }
            if (!mpsc.delete(true, trxName)) {
                return false;
            }
            if (!mps.delete(true, trxName)) {
                return false;
            }
        }
        return true;
    }
}

