/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MAcctSchemaGL;
import org.compiere.model.MDocType;
import org.compiere.model.MFactAcct;
import org.compiere.model.MJournalBatch;
import org.compiere.model.MJournalLine;
import org.compiere.model.MPeriod;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_GL_Journal;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MJournal
extends X_GL_Journal
implements DocAction {
    private static final long serialVersionUID = -364132249042527640L;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public MJournal(Properties ctx, int GL_Journal_ID, String trxName) {
        super(ctx, GL_Journal_ID, trxName);
        if (GL_Journal_ID == 0) {
            this.setCurrencyRate(Env.ONE);
            this.setDateAcct(new Timestamp(System.currentTimeMillis()));
            this.setDateDoc(new Timestamp(System.currentTimeMillis()));
            this.setDocAction("CO");
            this.setDocStatus("DR");
            this.setPostingType("A");
            this.setTotalCr(Env.ZERO);
            this.setTotalDr(Env.ZERO);
            this.setIsApproved(false);
            this.setIsPrinted(false);
            this.setPosted(false);
            this.setProcessed(false);
        }
    }

    public MJournal(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MJournal(MJournalBatch parent) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        this.setClientOrg(parent);
        this.setGL_JournalBatch_ID(parent.getGL_JournalBatch_ID());
        this.setC_DocType_ID(parent.getC_DocType_ID());
        this.setPostingType(parent.getPostingType());
        this.setDateDoc(parent.getDateDoc());
        this.setC_Period_ID(parent.getC_Period_ID());
        this.setDateAcct(parent.getDateAcct());
        this.setC_Currency_ID(parent.getC_Currency_ID());
    }

    public MJournal(MJournal original) {
        this(original.getCtx(), 0, original.get_TrxName());
        this.setClientOrg(original);
        this.setGL_JournalBatch_ID(original.getGL_JournalBatch_ID());
        this.setC_AcctSchema_ID(original.getC_AcctSchema_ID());
        this.setGL_Budget_ID(original.getGL_Budget_ID());
        this.setGL_Category_ID(original.getGL_Category_ID());
        this.setPostingType(original.getPostingType());
        this.setDescription(original.getDescription());
        this.setC_DocType_ID(original.getC_DocType_ID());
        this.setControlAmt(original.getControlAmt());
        this.setC_Currency_ID(original.getC_Currency_ID());
        this.setC_ConversionType_ID(original.getC_ConversionType_ID());
        this.setCurrencyRate(original.getCurrencyRate());
    }

    @Override
    public void setClientOrg(int AD_Client_ID, int AD_Org_ID) {
        super.setClientOrg(AD_Client_ID, AD_Org_ID);
    }

    @Override
    public void setDateAcct(Timestamp DateAcct) {
        super.setDateAcct(DateAcct);
        if (DateAcct == null) {
            return;
        }
        if (this.getC_Period_ID() != 0) {
            return;
        }
        int C_Period_ID = MPeriod.getC_Period_ID(this.getCtx(), DateAcct, this.getAD_Org_ID());
        if (C_Period_ID == 0) {
            this.log.warning("setDateAcct - Period not found");
        } else {
            this.setC_Period_ID(C_Period_ID);
        }
    }

    public void setCurrency(int C_Currency_ID, int C_ConversionType_ID, BigDecimal CurrencyRate) {
        if (C_Currency_ID != 0) {
            this.setC_Currency_ID(C_Currency_ID);
        }
        if (C_ConversionType_ID != 0) {
            this.setC_ConversionType_ID(C_ConversionType_ID);
        }
        if (CurrencyRate != null && CurrencyRate.compareTo(Env.ZERO) == 0) {
            this.setCurrencyRate(CurrencyRate);
        }
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    public MJournalLine[] getLines(boolean requery) {
        String whereClause = "GL_Journal_ID=?";
        List<MJournalLine> list = new Query(this.getCtx(), "GL_JournalLine", "GL_Journal_ID=?", null).setParameters(this.getGL_Journal_ID()).setOrderBy("Line").list();
        MJournalLine[] retValue = new MJournalLine[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public int copyLinesFrom(MJournal fromJournal, Timestamp dateAcct, char typeCR) {
        if (this.isProcessed() || fromJournal == null) {
            return 0;
        }
        int count = 0;
        MJournalLine[] fromLines = fromJournal.getLines(false);
        for (int i2 = 0; i2 < fromLines.length; ++i2) {
            MJournalLine toLine = new MJournalLine(this.getCtx(), 0, fromJournal.get_TrxName());
            PO.copyValues(fromLines[i2], toLine, this.getAD_Client_ID(), this.getAD_Org_ID());
            toLine.setGL_Journal_ID(this.getGL_Journal_ID());
            if (dateAcct != null) {
                toLine.setDateAcct(dateAcct);
            }
            if (typeCR == 'C') {
                toLine.setAmtSourceDr(fromLines[i2].getAmtSourceDr().negate());
                toLine.setAmtSourceCr(fromLines[i2].getAmtSourceCr().negate());
            } else if (typeCR == 'R') {
                toLine.setAmtSourceDr(fromLines[i2].getAmtSourceCr());
                toLine.setAmtSourceCr(fromLines[i2].getAmtSourceDr());
            }
            toLine.setIsGenerated(true);
            toLine.setProcessed(false);
            if (!toLine.save()) continue;
            ++count;
        }
        if (fromLines.length != count) {
            this.log.log(Level.SEVERE, "Line difference - JournalLines=" + fromLines.length + " <> Saved=" + count);
        }
        return count;
    }

    @Override
    public void setProcessed(boolean processed) {
        super.setProcessed(processed);
        if (this.get_ID() == 0) {
            return;
        }
        String sql = "UPDATE GL_JournalLine SET Processed='" + (processed ? "Y" : "N") + "' WHERE GL_Journal_ID=" + this.getGL_Journal_ID();
        int noLine = DB.executeUpdate(sql, this.get_TrxName());
        this.log.fine(processed + " - Lines=" + noLine);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getDateDoc() == null) {
            if (this.getDateAcct() == null) {
                this.setDateDoc(new Timestamp(System.currentTimeMillis()));
            } else {
                this.setDateDoc(this.getDateAcct());
            }
        }
        if (this.getDateAcct() == null) {
            this.setDateAcct(this.getDateDoc());
        }
        if (this.is_ValueChanged("DateAcct")) {
            int no = DB.executeUpdate("UPDATE GL_JournalLine SET DateAcct=? WHERE GL_Journal_ID=?", new Object[]{this.getDateAcct(), this.getGL_Journal_ID()}, false, this.get_TrxName());
            this.log.finest("Updated GL_JournalLine.DateAcct #" + no);
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        return this.updateBatch();
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (!success) {
            return success;
        }
        return this.updateBatch();
    }

    private boolean updateBatch() {
        String sql = "UPDATE GL_JournalBatch jb SET (TotalDr, TotalCr) = (SELECT COALESCE(SUM(TotalDr),0), COALESCE(SUM(TotalCr),0) FROM GL_Journal j WHERE j.IsActive='Y' AND jb.GL_JournalBatch_ID=j.GL_JournalBatch_ID) WHERE GL_JournalBatch_ID=" + this.getGL_JournalBatch_ID();
        int no = DB.executeUpdate(sql, this.get_TrxName());
        if (no != 1) {
            this.log.warning("afterSave - Update Batch #" + no);
        }
        return no == 1;
    }

    @Override
    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        this.log.info(this.toString());
        this.setProcessing(false);
        return true;
    }

    @Override
    public boolean invalidateIt() {
        this.log.info(this.toString());
        return true;
    }

    @Override
    public String prepareIt() {
        MAcctSchemaGL gl;
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        MPeriod period = MPeriod.get(this.getCtx(), this.getDateAcct(), this.getAD_Org_ID());
        if (period == null) {
            this.log.warning("No Period for " + this.getDateAcct());
            this.m_processMsg = "@PeriodNotFound@";
            return "IN";
        }
        if (period.getC_Period_ID() != this.getC_Period_ID() && period.isStandardPeriod()) {
            this.m_processMsg = "@PeriodNotValid@";
            return "IN";
        }
        boolean open = period.isOpen(dt.getDocBaseType(), this.getDateAcct());
        if (!open) {
            this.log.warning(period.getName() + ": Not open for " + dt.getDocBaseType() + " (" + this.getDateAcct() + ")");
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        MJournalLine[] lines = this.getLines(true);
        if (lines.length == 0) {
            this.m_processMsg = "@NoLines@";
            return "IN";
        }
        BigDecimal AmtSourceDr = Env.ZERO;
        BigDecimal AmtSourceCr = Env.ZERO;
        for (int i2 = 0; i2 < lines.length; ++i2) {
            MJournalLine line = lines[i2];
            if (!this.isActive()) continue;
            if (!line.getAccountElementValue().isActive()) {
                this.m_processMsg = "@InActiveAccount@ - @Line@=" + line.getLine() + " - " + line.getAccountElementValue();
                return "IN";
            }
            if (line.isDocControlled() && this.getPostingType().equals("A") || this.getPostingType().equals("E") || this.getPostingType().equals("R")) {
                this.m_processMsg = "@DocControlledError@ - @Line@=" + line.getLine() + " - " + line.getAccountElementValue();
                return "IN";
            }
            if (this.getPostingType().equals("A") && !line.getAccountElementValue().isPostActual()) {
                this.m_processMsg = "@PostingTypeActualError@ - @Line@=" + line.getLine() + " - " + line.getAccountElementValue();
                return "IN";
            }
            if (this.getPostingType().equals("B") && !line.getAccountElementValue().isPostBudget()) {
                this.m_processMsg = "@PostingTypeBudgetError@ - @Line@=" + line.getLine() + " - " + line.getAccountElementValue();
                return "IN";
            }
            if (this.getPostingType().equals("S") && !line.getAccountElementValue().isPostStatistical()) {
                this.m_processMsg = "@PostingTypeStatisticalError@ - @Line@=" + line.getLine() + " - " + line.getAccountElementValue();
                return "IN";
            }
            AmtSourceDr = AmtSourceDr.add(line.getAmtSourceDr());
            AmtSourceCr = AmtSourceCr.add(line.getAmtSourceCr());
        }
        this.setTotalDr(AmtSourceDr);
        this.setTotalCr(AmtSourceCr);
        if (Env.ZERO.compareTo(this.getControlAmt()) != 0 && this.getControlAmt().compareTo(this.getTotalDr()) != 0) {
            this.m_processMsg = "@ControlAmtError@";
            return "IN";
        }
        if (!(AmtSourceDr.compareTo(AmtSourceCr) == 0 || (gl = MAcctSchemaGL.get(this.getCtx(), this.getC_AcctSchema_ID())) != null && gl.isUseSuspenseBalancing())) {
            this.m_processMsg = "@UnbalancedJornal@";
            return "IN";
        }
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        return "IP";
    }

    @Override
    public boolean approveIt() {
        this.log.info(this.toString());
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        this.log.info(this.toString());
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info(this.toString());
        String valid = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setDefiniteDocumentNo();
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    private void setDefiniteDocumentNo() {
        String value;
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (dt.isOverwriteDateOnComplete()) {
            this.setDateDoc(new Timestamp(System.currentTimeMillis()));
        }
        if (dt.isOverwriteSeqOnComplete() && (value = DB.getDocumentNo(this.getC_DocType_ID(), this.get_TrxName(), true, (PO)this)) != null) {
            this.setDocumentNo(value);
        }
    }

    @Override
    public boolean voidIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        boolean ok_to_void = false;
        if (!"DR".equals(this.getDocStatus()) && !"IN".equals(this.getDocStatus())) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        ok_to_void = true;
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        return ok_to_void;
    }

    @Override
    public boolean closeIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 3);
        if (this.m_processMsg != null) {
            return false;
        }
        boolean ok_to_close = false;
        if (!"CO".equals(this.getDocStatus())) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        ok_to_close = true;
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 11);
        if (this.m_processMsg != null) {
            return false;
        }
        return ok_to_close;
    }

    @Override
    public boolean reverseCorrectIt() {
        boolean ok_correct;
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 5);
        if (this.m_processMsg != null) {
            return false;
        }
        boolean bl = ok_correct = this.reverseCorrectIt(this.getGL_JournalBatch_ID()) != null;
        if (!ok_correct) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 13);
        if (this.m_processMsg != null) {
            return false;
        }
        return ok_correct;
    }

    public MJournal reverseCorrectIt(int GL_JournalBatch_ID) {
        this.log.info(this.toString());
        MJournal reverse = new MJournal(this);
        reverse.setGL_JournalBatch_ID(GL_JournalBatch_ID);
        reverse.setDateDoc(this.getDateDoc());
        reverse.setC_Period_ID(this.getC_Period_ID());
        reverse.setDateAcct(this.getDateAcct());
        reverse.addDescription("(->" + this.getDocumentNo() + ")");
        reverse.setReversal_ID(this.getGL_Journal_ID());
        if (!reverse.save()) {
            return null;
        }
        this.addDescription("(" + reverse.getDocumentNo() + "<-)");
        reverse.copyLinesFrom(this, null, 'C');
        this.setProcessed(true);
        this.setReversal_ID(reverse.getGL_Journal_ID());
        this.setDocAction("--");
        return reverse;
    }

    @Override
    public boolean reverseAccrualIt() {
        boolean ok_reverse;
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 6);
        if (this.m_processMsg != null) {
            return false;
        }
        boolean bl = ok_reverse = this.reverseAccrualIt(this.getGL_JournalBatch_ID()) != null;
        if (!ok_reverse) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 14);
        if (this.m_processMsg != null) {
            return false;
        }
        return ok_reverse;
    }

    public MJournal reverseAccrualIt(int GL_JournalBatch_ID) {
        this.log.info(this.toString());
        MJournal reverse = new MJournal(this);
        reverse.setGL_JournalBatch_ID(GL_JournalBatch_ID);
        reverse.setDateDoc(new Timestamp(System.currentTimeMillis()));
        reverse.set_ValueNoCheck("C_Period_ID", null);
        reverse.setDateAcct(reverse.getDateDoc());
        String description = reverse.getDescription();
        description = description == null ? "** " + this.getDocumentNo() + " **" : description + " ** " + this.getDocumentNo() + " **";
        reverse.setDescription(description);
        if (!reverse.save()) {
            return null;
        }
        reverse.copyLinesFrom(this, reverse.getDateAcct(), 'R');
        this.setProcessed(true);
        this.setDocAction("--");
        return reverse;
    }

    @Override
    public boolean reActivateIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        MPeriod.testPeriodOpen(this.getCtx(), this.getDateAcct(), this.getC_DocType_ID(), this.getAD_Org_ID());
        MFactAcct.deleteEx(Table_ID, this.get_ID(), this.get_TrxName());
        this.setPosted(false);
        this.setProcessed(false);
        this.setDocAction("CO");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 12);
        return this.m_processMsg == null;
    }

    @Override
    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDocumentNo());
        sb.append(": ").append(Msg.translate(this.getCtx(), "TotalDr")).append("=").append(this.getTotalDr()).append(" ").append(Msg.translate(this.getCtx(), "TotalCR")).append("=").append(this.getTotalCr()).append(" (#").append(this.getLines(false).length).append(")");
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MJournal[");
        sb.append(this.get_ID()).append(",").append(this.getDescription()).append(",DR=").append(this.getTotalDr()).append(",CR=").append(this.getTotalCr()).append("]");
        return sb.toString();
    }

    @Override
    public String getDocumentInfo() {
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        return dt.getName() + " " + this.getDocumentNo();
    }

    @Override
    public File createPDF() {
        try {
            File temp = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getCreatedBy();
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return this.getTotalDr();
    }

    public boolean isComplete() {
        String ds = this.getDocStatus();
        return "CO".equals(ds) || "CL".equals(ds) || "RE".equals(ds);
    }
}

