/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Properties;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLineMA;
import org.compiere.model.MLocator;
import org.compiere.model.MProduct;
import org.compiere.model.MStorage;
import org.compiere.model.Query;
import org.compiere.model.X_M_InventoryLine;
import org.compiere.model.X_M_InventoryLineMA;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MInventoryLine
extends X_M_InventoryLine {
    private static final long serialVersionUID = 5649152656460089476L;
    private boolean m_isManualEntry = true;
    private MInventory m_parent = null;
    private MProduct m_product = null;

    public static MInventoryLine get(MInventory inventory, int M_Locator_ID, int M_Product_ID, int M_AttributeSetInstance_ID) {
        String whereClause = "M_Inventory_ID=? AND M_Locator_ID=? AND M_Product_ID=? AND M_AttributeSetInstance_ID=?";
        return (MInventoryLine)new Query(inventory.getCtx(), "M_InventoryLine", "M_Inventory_ID=? AND M_Locator_ID=? AND M_Product_ID=? AND M_AttributeSetInstance_ID=?", inventory.get_TrxName()).setParameters(inventory.get_ID(), M_Locator_ID, M_Product_ID, M_AttributeSetInstance_ID).firstOnly();
    }

    public MInventoryLine(Properties ctx, int M_InventoryLine_ID, String trxName) {
        super(ctx, M_InventoryLine_ID, trxName);
        if (M_InventoryLine_ID == 0) {
            this.setLine(0);
            this.setM_AttributeSetInstance_ID(0);
            this.setInventoryType("D");
            this.setQtyBook(Env.ZERO);
            this.setQtyCount(Env.ZERO);
            this.setProcessed(false);
        }
    }

    public MInventoryLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MInventoryLine(MInventory inventory, int M_Locator_ID, int M_Product_ID, int M_AttributeSetInstance_ID, BigDecimal QtyBook, BigDecimal QtyCount) {
        this(inventory.getCtx(), 0, inventory.get_TrxName());
        if (inventory.get_ID() == 0) {
            throw new IllegalArgumentException("Header not saved");
        }
        this.m_parent = inventory;
        this.setM_Inventory_ID(inventory.getM_Inventory_ID());
        this.setClientOrg(inventory.getAD_Client_ID(), inventory.getAD_Org_ID());
        this.setM_Locator_ID(M_Locator_ID);
        this.setM_Product_ID(M_Product_ID);
        this.setM_AttributeSetInstance_ID(M_AttributeSetInstance_ID);
        if (QtyBook != null) {
            this.setQtyBook(QtyBook);
        }
        if (QtyCount != null && QtyCount.signum() != 0) {
            this.setQtyCount(QtyCount);
        }
        this.m_isManualEntry = false;
    }

    public MProduct getProduct() {
        int M_Product_ID = this.getM_Product_ID();
        if (M_Product_ID == 0) {
            return null;
        }
        if (this.m_product != null && this.m_product.getM_Product_ID() != M_Product_ID) {
            this.m_product = null;
        }
        if (this.m_product == null) {
            this.m_product = MProduct.get(this.getCtx(), M_Product_ID);
        }
        return this.m_product;
    }

    @Override
    public void setQtyCount(BigDecimal QtyCount) {
        MProduct product;
        if (QtyCount != null && (product = this.getProduct()) != null) {
            int precision = product.getUOMPrecision();
            QtyCount = QtyCount.setScale(precision, 4);
        }
        super.setQtyCount(QtyCount);
    }

    @Override
    public void setQtyInternalUse(BigDecimal QtyInternalUse) {
        MProduct product;
        if (QtyInternalUse != null && (product = this.getProduct()) != null) {
            int precision = product.getUOMPrecision();
            QtyInternalUse = QtyInternalUse.setScale(precision, 4);
        }
        super.setQtyInternalUse(QtyInternalUse);
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    protected void setParent(MInventory parent) {
        this.m_parent = parent;
    }

    public MInventory getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MInventory(this.getCtx(), this.getM_Inventory_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MInventoryLine[");
        sb.append(this.get_ID()).append("-M_Product_ID=").append(this.getM_Product_ID()).append(",QtyCount=").append(this.getQtyCount()).append(",QtyInternalUse=").append(this.getQtyInternalUse()).append(",QtyBook=").append(this.getQtyBook()).append(",M_AttributeSetInstance_ID=").append(this.getM_AttributeSetInstance_ID()).append("]");
        return sb.toString();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        MProduct product;
        if (newRecord && this.getParent().isComplete()) {
            this.log.saveError("ParentComplete", Msg.translate(this.getCtx(), "M_InventoryLine"));
            return false;
        }
        if (newRecord && this.m_isManualEntry && this.getM_AttributeSetInstance_ID() == 0 && (product = MProduct.get(this.getCtx(), this.getM_Product_ID())) != null && product.isASIMandatory(this.isSOTrx())) {
            this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "M_AttributeSetInstance_ID"));
            return false;
        }
        if (this.getLine() == 0) {
            String sql = "SELECT COALESCE(MAX(Line),0)+10 AS DefaultValue FROM M_InventoryLine WHERE M_Inventory_ID=?";
            int ii = DB.getSQLValue(this.get_TrxName(), sql, this.getM_Inventory_ID());
            this.setLine(ii);
        }
        if (this.getQtyCount().signum() < 0) {
            this.log.saveError("Warning", Msg.getElement(this.getCtx(), "QtyCount") + " < 0");
            return false;
        }
        if (newRecord || this.is_ValueChanged("QtyCount")) {
            this.setQtyCount(this.getQtyCount());
        }
        if (newRecord || this.is_ValueChanged("QtyInternalUse")) {
            this.setQtyInternalUse(this.getQtyInternalUse());
        }
        Integer ParentId = this.getM_Inventory_ID();
        String isMTV = null;
        String SqlDocTypeID = "Select nvl(ISMTV,'N') from M_Inventory where M_Inventory_ID = ?";
        try {
            isMTV = DB.getSQLValueString(this.get_TrxName(), SqlDocTypeID, ParentId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.getQtyInternalUse().signum() != 0) {
            if (!"C".equals(this.getInventoryType())) {
                this.setInventoryType("C");
            }
            if (this.getC_Charge_ID() == 0) {
                this.log.saveError("InternalUseNeedsCharge", "");
                return false;
            }
        } else if ("C".equals(this.getInventoryType())) {
            if (this.getC_Charge_ID() == 0) {
                this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "C_Charge_ID"));
                return false;
            }
        } else if (this.getC_Charge_ID() != 0) {
            this.setC_Charge_ID(0);
        }
        if (this.getC_Charge_ID() == 0) {
            this.setAD_Org_ID(this.getParent().getAD_Org_ID());
        }
        MProduct product2 = MProduct.get(this.getCtx(), this.getM_Product_ID());
        MLocator locator = MLocator.get(this.getCtx(), this.getM_Locator_ID());
        String sql = "SELECT nvl(SUM(ps.QtyOnHand),0) FROM M_Product_Stock_v ps WHERE ps.m_product_id =" + product2.getM_Product_ID() + " AND ps.M_Warehouse_ID = " + locator.getM_Warehouse_ID();
        BigDecimal QtyOnHand = Env.ZERO;
        try {
            QtyOnHand = DB.getSQLValueBD(this.get_TrxName(), sql, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.getQtyInternalUse().compareTo(QtyOnHand) == 1) {
            this.log.saveError("Error", "Trx.Qty (" + this.getQtyInternalUse() + ") should not be greater than On Hand Qty (" + QtyOnHand + ")");
            return false;
        }
        BigDecimal TrQty = this.getQtyInternalUse();
        if (TrQty.doubleValue() == 0.0) {
            this.log.saveError("Error", Msg.getMsg(this.getCtx(), "Qty Should not be Zero"));
            return false;
        }
        Integer iocID = this.getIOCLINE_ID();
        if (iocID != null & iocID > 0) {
            BigDecimal curQty = this.getQtyInternalUse();
            Integer invLineID = this.getM_InventoryLine_ID();
            String sqlRet = "Select nvl(sum(QtyInternalUse),0) from m_inventoryline where iocline_id=? and m_inventoryline_id<>?";
            BigDecimal prevQty = DB.getSQLValueBD(this.get_TrxName(), sqlRet, iocID, invLineID);
            String sqlIoc = "Select nvl(QtyInternalUse,0) from m_inventoryline where m_inventoryline_id=?";
            BigDecimal iocQty = DB.getSQLValueBD(this.get_TrxName(), sqlIoc, iocID);
            if (curQty.doubleValue() * -1.0 + prevQty.doubleValue() * -1.0 > iocQty.doubleValue()) {
                this.log.saveError("Error", Msg.getMsg(this.getCtx(), "Sample Return Qty should not be greater than Issue Qty"));
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        return success;
    }

    private void createMA() {
        MStorage[] storages = MStorage.getAll(this.getCtx(), this.getM_Product_ID(), this.getM_Locator_ID(), this.get_TrxName());
        boolean allZeroASI = true;
        for (int i2 = 0; i2 < storages.length; ++i2) {
            if (storages[i2].getM_AttributeSetInstance_ID() == 0) continue;
            allZeroASI = false;
            break;
        }
        if (allZeroASI) {
            return;
        }
        X_M_InventoryLineMA ma = null;
        BigDecimal sum = Env.ZERO;
        for (int i3 = 0; i3 < storages.length; ++i3) {
            MStorage storage = storages[i3];
            if (storage.getQtyOnHand().signum() == 0) continue;
            if (ma != null && ma.getM_AttributeSetInstance_ID() == storage.getM_AttributeSetInstance_ID()) {
                ma.setMovementQty(ma.getMovementQty().add(storage.getQtyOnHand()));
            } else {
                ma = new MInventoryLineMA(this, storage.getM_AttributeSetInstance_ID(), storage.getQtyOnHand());
            }
            if (!ma.save()) {
                // empty if block
            }
            sum = sum.add(storage.getQtyOnHand());
        }
        if (sum.compareTo(this.getQtyBook()) != 0) {
            this.log.warning("QtyBook=" + this.getQtyBook() + " corrected to Sum of MA=" + sum);
            this.setQtyBook(sum);
        }
    }

    public boolean isInternalUseInventory() {
        return this.getQtyInternalUse().signum() != 0;
    }

    public BigDecimal getMovementQty() {
        if (this.isInternalUseInventory()) {
            return this.getQtyInternalUse().negate();
        }
        return this.getQtyCount().subtract(this.getQtyBook());
    }

    public boolean isSOTrx() {
        return this.getMovementQty().signum() < 0;
    }
}

