/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.AdempiereProcessor;
import org.compiere.model.AdempiereProcessorLog;
import org.compiere.model.MIMPProcessorLog;
import org.compiere.model.X_IMP_Processor;
import org.compiere.model.X_IMP_ProcessorParameter;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class MIMPProcessor
extends X_IMP_Processor
implements AdempiereProcessor {
    private static final long serialVersionUID = 8634765494025824138L;
    private static CLogger s_log = CLogger.getCLogger(MIMPProcessor.class);

    public MIMPProcessor(Properties ctx, int EXP_ReplicationProcessor_ID, String trxName) {
        super(ctx, EXP_ReplicationProcessor_ID, trxName);
        if (EXP_ReplicationProcessor_ID == 0) {
            this.setName("Default Import Processor");
            this.setFrequencyType("H");
            this.setFrequency(1);
            this.setKeepLogDays(7);
        }
    }

    public MIMPProcessor(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    public Timestamp getDateNextRun(boolean requery) {
        if (requery) {
            this.load(this.get_TrxName());
        }
        return this.getDateNextRun();
    }

    @Override
    public AdempiereProcessorLog[] getLogs() {
        ArrayList<MIMPProcessorLog> list = new ArrayList<MIMPProcessorLog>();
        String sql = "SELECT * FROM IMP_ProcessorLog WHERE IMP_Processor_ID=? ORDER BY Created DESC";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getIMP_Processor_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MIMPProcessorLog(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        AdempiereProcessorLog[] retValue = new MIMPProcessorLog[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public int deleteLog() {
        if (this.getKeepLogDays() < 1) {
            return 0;
        }
        String sql = "DELETE IMP_ProcessorLog WHERE IMP_Processor_ID=" + this.getIMP_Processor_ID() + " AND (Created+" + this.getKeepLogDays() + ") < SysDate";
        int no = DB.executeUpdate(sql, this.get_TrxName());
        return no;
    }

    @Override
    public String getServerID() {
        return "ReplicationProcessor" + this.get_ID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public X_IMP_ProcessorParameter[] getIMP_ProcessorParameters(String trxName) {
        ArrayList<X_IMP_ProcessorParameter> resultList = new ArrayList<X_IMP_ProcessorParameter>();
        StringBuffer sql = new StringBuffer("SELECT * ").append(" FROM ").append("IMP_ProcessorParameter").append(" WHERE ").append("IMP_Processor_ID").append("=?").append(" AND IsActive = ?");
        CPreparedStatement pstmt = null;
        X_IMP_ProcessorParameter processorParameter = null;
        try {
            pstmt = DB.prepareStatement(sql.toString(), trxName);
            pstmt.setInt(1, this.getIMP_Processor_ID());
            pstmt.setString(2, "Y");
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                processorParameter = new X_IMP_ProcessorParameter(this.getCtx(), rs, trxName);
                resultList.add(processorParameter);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (SQLException e) {
            s_log.log(Level.SEVERE, sql.toString(), e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                pstmt = null;
            }
            catch (Exception e) {
                pstmt = null;
            }
        }
        X_IMP_ProcessorParameter[] result = resultList.toArray(new X_IMP_ProcessorParameter[0]);
        return result;
    }

    public static MIMPProcessor[] getActive(Properties ctx) {
        ArrayList<MIMPProcessor> list = new ArrayList<MIMPProcessor>();
        String sql = "SELECT * FROM IMP_Processor WHERE IsActive='Y'";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MIMPProcessor(ctx, rs, null));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MIMPProcessor[] retValue = new MIMPProcessor[list.size()];
        list.toArray(retValue);
        return retValue;
    }
}

