/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import org.compiere.model.MAsset;
import org.compiere.model.MAssetChange;
import org.compiere.model.MRefList;
import org.compiere.model.X_A_Asset_Addition;
import org.compiere.model.X_A_Depreciation_Workfile;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class MAssetAddition
extends X_A_Asset_Addition {
    private static final long serialVersionUID = 511552459407382309L;

    public MAssetAddition(Properties ctx, int A_Asset_Addition_ID, String trxName) {
        super(ctx, A_Asset_Addition_ID, trxName);
        if (A_Asset_Addition_ID == 0) {
            // empty if block
        }
    }

    public MAssetAddition(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean beforeSave(boolean newRecord) {
        this.log.info("beforeSave");
        int p_A_Asset_ID = 0;
        p_A_Asset_ID = this.getA_Asset_ID();
        String sql = "SELECT COUNT(*) FROM A_Depreciation_Workfile WHERE A_Asset_ID=?";
        if (DB.getSQLValue(null, sql, p_A_Asset_ID) == 0) {
            X_A_Depreciation_Workfile assetwk = new X_A_Depreciation_Workfile(this.getCtx(), 0, null);
            assetwk.setA_Asset_ID(p_A_Asset_ID);
            assetwk.setPostingType("A");
            assetwk.setA_QTY_Current(this.getA_QTY_Current());
            assetwk.setA_Asset_Cost(this.getAssetValueAmt());
            assetwk.save();
            MAsset asset = new MAsset(this.getCtx(), p_A_Asset_ID, null);
            asset.setA_QTY_Original(this.getA_QTY_Current().add(asset.getA_QTY_Original()));
            asset.setA_QTY_Current(this.getA_QTY_Current().add(asset.getA_QTY_Current()));
            asset.save();
            MAssetChange change = new MAssetChange(this.getCtx(), 0, null);
            change.setA_Asset_ID(p_A_Asset_ID);
            change.setA_QTY_Current(this.getA_QTY_Current());
            change.setChangeType("ADD");
            change.setTextDetails(MRefList.getListDescription(this.getCtx(), "A_Update_Type", "ADD"));
            change.setPostingType("A");
            change.setAssetValueAmt(this.getAssetValueAmt());
            change.setA_QTY_Current(this.getA_QTY_Current());
            change.save();
        } else {
            sql = "SELECT * FROM A_Depreciation_Workfile WHERE A_Asset_ID=? AND IsActive='Y'";
            CPreparedStatement pstmt = null;
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, p_A_Asset_ID);
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    X_A_Depreciation_Workfile assetwk = new X_A_Depreciation_Workfile(this.getCtx(), rs, null);
                    assetwk.setA_Asset_Cost(this.getAssetValueAmt().add(assetwk.getA_Asset_Cost()));
                    assetwk.setA_QTY_Current(this.getA_QTY_Current().add(assetwk.getA_QTY_Current()));
                    assetwk.save();
                    MAssetChange change = new MAssetChange(this.getCtx(), 0, null);
                    change.setA_Asset_ID(p_A_Asset_ID);
                    change.setA_QTY_Current(this.getA_QTY_Current());
                    change.setChangeType("ADD");
                    change.setTextDetails(MRefList.getListDescription(this.getCtx(), "A_Update_Type", "ADD"));
                    change.setPostingType(rs.getString("PostingType"));
                    change.setAssetValueAmt(this.getAssetValueAmt());
                    change.setA_QTY_Current(this.getA_QTY_Current());
                    change.save();
                    MAsset asset = new MAsset(this.getCtx(), p_A_Asset_ID, null);
                    asset.setA_QTY_Original(this.getA_QTY_Current().add(asset.getA_QTY_Original()));
                    asset.setA_QTY_Current(this.getA_QTY_Current().add(asset.getA_QTY_Current()));
                    asset.setProcessing(false);
                    asset.save();
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                this.log.info("getAssets" + e);
            }
            finally {
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception exception) {}
                pstmt = null;
            }
        }
        return true;
    }
}

