/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Properties;
import org.compiere.model.X_Beta_AMC_ContractLine;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MAMCContractLine
extends X_Beta_AMC_ContractLine {
    private MAMCContractLine m_parent = null;

    public MAMCContractLine(Properties ctx, int Beta_AMC_ContractLine_ID, String trxName) {
        super(ctx, Beta_AMC_ContractLine_ID, trxName);
        if (Beta_AMC_ContractLine_ID == 0) {
            this.setAmount(Env.ZERO);
        }
    }

    public MAMCContractLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MAMCContractLine getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MAMCContractLine(this.getCtx(), this.getBeta_AMC_ContractLine_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        Integer contlineid = this.getBeta_AMC_ContractLine_ID();
        Integer contid = this.getBeta_AMC_Contract_ID();
        BigDecimal curAmt = this.getAmount();
        String sqlcont = "Select contamt from beta_amc_contract where beta_amc_contract_id = ?";
        BigDecimal contamt = DB.getSQLValueBD(null, sqlcont, contid);
        BigDecimal entamt = Env.ZERO;
        String sqlent = "Select nvl(Sum(amount),0) from Beta_AMC_ContractLine Where beta_amc_contract_id = ? and Beta_AMC_ContractLine_ID != ?";
        entamt = DB.getSQLValueBD(null, sqlent, contid, contlineid);
        if (curAmt.doubleValue() == 0.0) {
            this.log.saveError("Error", Msg.getMsg(this.getCtx(), "Amount Should be Greater than Zero"));
            return false;
        }
        if (entamt.add(curAmt).compareTo(contamt) == 1) {
            this.log.saveError("Error", Msg.getMsg(this.getCtx(), "Amount entered exceeds the Contract Amount"));
            return false;
        }
        return true;
    }
}

