/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MPayment;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class Callout_PDCAllocate
extends CalloutEngine {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String invoice(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_Invoice_ID = (Integer)value;
        if (this.isCalloutActive() || C_Invoice_ID == null || C_Invoice_ID == 0) {
            return "";
        }
        int C_Payment_ID = Env.getContextAsInt(ctx, WindowNo, "C_Payment_ID");
        MPayment payment = new MPayment(ctx, C_Payment_ID, null);
        if (payment.getC_Charge_ID() != 0 || payment.getC_Invoice_ID() != 0 || payment.getC_Order_ID() != 0) {
            return Msg.getMsg(ctx, "PaymentIsAllocated");
        }
        mTab.setValue("DiscountAmt", (Object)Env.ZERO);
        mTab.setValue("WriteOffAmt", (Object)Env.ZERO);
        mTab.setValue("OverUnderAmt", (Object)Env.ZERO);
        int C_InvoicePaySchedule_ID = 0;
        if (Env.getContextAsInt(ctx, WindowNo, 1113, "C_Invoice_ID") == C_Invoice_ID && Env.getContextAsInt(ctx, WindowNo, 1113, "C_InvoicePaySchedule_ID") != 0) {
            C_InvoicePaySchedule_ID = Env.getContextAsInt(ctx, WindowNo, 1113, "C_InvoicePaySchedule_ID");
        }
        Timestamp ts = Env.getContextAsDate(ctx, WindowNo, "DateTrx");
        String sql = "SELECT C_BPartner_ID,C_Currency_ID, invoiceOpen(C_Invoice_ID, ?), invoiceDiscount(C_Invoice_ID,?,?), IsSOTrx FROM C_Invoice WHERE C_Invoice_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, C_InvoicePaySchedule_ID);
            pstmt.setTimestamp(2, ts);
            pstmt.setInt(3, C_InvoicePaySchedule_ID);
            pstmt.setInt(4, C_Invoice_ID);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                BigDecimal DiscountAmt;
                BigDecimal InvoiceOpen = rs.getBigDecimal(3);
                if (InvoiceOpen == null) {
                    InvoiceOpen = Env.ZERO;
                }
                if ((DiscountAmt = rs.getBigDecimal(4)) == null) {
                    DiscountAmt = Env.ZERO;
                }
                mTab.setValue("InvoiceAmt", (Object)InvoiceOpen);
                mTab.setValue("Amount", (Object)InvoiceOpen.subtract(DiscountAmt));
                mTab.setValue("DiscountAmt", (Object)DiscountAmt);
                Env.setContext(ctx, WindowNo, "C_Invoice_ID", C_Invoice_ID.toString());
                mTab.setValue("C_Invoice_ID", (Object)C_Invoice_ID);
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
            String string = e.getLocalizedMessage();
            return string;
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return "";
    }

    public String amounts(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value, Object oldValue) {
        String colName;
        if (this.isCalloutActive()) {
            return "";
        }
        int C_Invoice_ID = Env.getContextAsInt(ctx, WindowNo, "C_Invoice_ID");
        if (C_Invoice_ID == 0) {
            return "";
        }
        BigDecimal Amount = (BigDecimal)mTab.getValue("Amount");
        BigDecimal DiscountAmt = (BigDecimal)mTab.getValue("DiscountAmt");
        BigDecimal WriteOffAmt = (BigDecimal)mTab.getValue("WriteOffAmt");
        BigDecimal OverUnderAmt = (BigDecimal)mTab.getValue("OverUnderAmt");
        BigDecimal InvoiceAmt = (BigDecimal)mTab.getValue("InvoiceAmt");
        this.log.fine("Amt=" + Amount + ", Discount=" + DiscountAmt + ", WriteOff=" + WriteOffAmt + ", OverUnder=" + OverUnderAmt + ", Invoice=" + InvoiceAmt);
        if (Amount == null) {
            Amount = Env.ZERO;
        }
        if (DiscountAmt == null) {
            DiscountAmt = Env.ZERO;
        }
        if (WriteOffAmt == null) {
            WriteOffAmt = Env.ZERO;
        }
        if (OverUnderAmt == null) {
            OverUnderAmt = Env.ZERO;
        }
        if (InvoiceAmt == null) {
            InvoiceAmt = Env.ZERO;
        }
        if ((colName = mField.getColumnName()).equals("Amount")) {
            OverUnderAmt = InvoiceAmt.subtract(Amount).subtract(DiscountAmt).subtract(WriteOffAmt);
            mTab.setValue("OverUnderAmt", (Object)OverUnderAmt);
        } else {
            Amount = InvoiceAmt.subtract(DiscountAmt).subtract(WriteOffAmt).subtract(OverUnderAmt);
            mTab.setValue("Amount", (Object)Amount);
        }
        return "";
    }

    public String SetInvAmounts(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value, Object oldValue) {
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        Callout_PDCAllocate.setCalloutActive(true);
        Integer C_INVOICE_ID = (Integer)mTab.getValue("C_INVOICE_ID");
        String sql = "select fn_pending_inv(?) from dual";
        BigDecimal inv_amt = DB.getSQLValueBD(null, sql, C_INVOICE_ID);
        mTab.setValue("InvoiceAmt", (Object)inv_amt);
        Integer XX_PDC_PAYMENT_ID = (Integer)mTab.getValue("XX_PDC_PAYMENT_ID");
        String sql1 = "SELECT MAX(p.pdc_AMOUNT)-COALESCE(SUM(a.Amount),0) FROM xx_pdc_Payment p LEFT OUTER JOIN xx_pdc_allocate a ON (p.xx_pdc_Payment_id=a.xx_pdc_Payment_id) WHERE p.XX_PDC_PAYMENT_ID= ?";
        BigDecimal Remain_Amt = DB.getSQLValueBD(null, sql1, XX_PDC_PAYMENT_ID);
        mTab.setValue("Amount", (Object)inv_amt.min(Remain_Amt));
        System.out.println("Amount :" + inv_amt.min(Remain_Amt));
        System.out.println("REMAIN:" + Remain_Amt);
        System.out.println("Inv_amt" + inv_amt);
        if (inv_amt.compareTo(Remain_Amt) > 0) {
            BigDecimal overdue = inv_amt.subtract(Remain_Amt);
            mTab.setValue("OverUnderAmt", (Object)overdue);
        }
        Callout_PDCAllocate.setCalloutActive(false);
        return "";
    }

    public String SetAmts(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value, Object oldValue) {
        if (this.isCalloutActive()) {
            return "";
        }
        int C_Invoice_ID = Env.getContextAsInt(ctx, WindowNo, "C_Invoice_ID");
        if (C_Invoice_ID == 0) {
            return "";
        }
        Callout_PDCAllocate.setCalloutActive(true);
        BigDecimal Amount = (BigDecimal)mTab.getValue("Amount");
        BigDecimal DiscountAmt = (BigDecimal)mTab.getValue("DiscountAmt");
        BigDecimal WriteOffAmt = (BigDecimal)mTab.getValue("WriteOffAmt");
        BigDecimal OverUnderAmt = (BigDecimal)mTab.getValue("OverUnderAmt");
        BigDecimal InvoiceAmt = (BigDecimal)mTab.getValue("InvoiceAmt");
        String colName = mField.getColumnName();
        if (colName.equals("WriteOffAmt")) {
            BigDecimal prev_od_amt = InvoiceAmt.subtract(Amount);
            BigDecimal overdue = prev_od_amt.subtract(WriteOffAmt);
            if (overdue.compareTo(new BigDecimal(0)) < 0) {
                mTab.setValue("OverUnderAmt", (Object)Env.ZERO);
            } else {
                mTab.setValue("OverUnderAmt", (Object)overdue);
            }
        }
        Callout_PDCAllocate.setCalloutActive(false);
        return "";
    }
}

