/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MInventoryLine;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class CalloutInventory
extends CalloutEngine {
    public String product(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive()) {
            return "";
        }
        Integer InventoryLine = (Integer)mTab.getValue("M_InventoryLine_ID");
        BigDecimal bd = null;
        if (InventoryLine != null && InventoryLine != 0) {
            MInventoryLine _ILine = new MInventoryLine(ctx, InventoryLine, null);
            Integer M_Product_ID = (Integer)mTab.getValue("M_Product_ID");
            Integer M_Locator_ID = (Integer)mTab.getValue("M_Locator_ID");
            Integer M_AttributeSetInstance_ID = 0;
            if (M_Product_ID != null && M_Product_ID.intValue() != _ILine.getM_Product_ID() || M_Locator_ID != null && M_Locator_ID.intValue() != _ILine.getM_Locator_ID()) {
                if (M_Product_ID.intValue() == _ILine.getM_Product_ID()) {
                    M_AttributeSetInstance_ID = (Integer)mTab.getValue("M_AttributeSetInstance_ID");
                    if (M_AttributeSetInstance_ID == null) {
                        M_AttributeSetInstance_ID = 0;
                    }
                } else {
                    mTab.setValue("M_AttributeSetInstance_ID", null);
                }
                try {
                    bd = this.setQtyBook(M_AttributeSetInstance_ID, M_Product_ID, M_Locator_ID);
                    mTab.setValue("QtyBook", (Object)bd);
                }
                catch (Exception e) {
                    return mTab.setValue("QtyBook", (Object)bd);
                }
            }
            return "";
        }
        int M_Product_ID = 0;
        Integer Product = (Integer)mTab.getValue("M_Product_ID");
        if (Product != null) {
            M_Product_ID = Product;
        }
        if (M_Product_ID == 0) {
            return "";
        }
        int M_Locator_ID = 0;
        Integer Locator2 = (Integer)mTab.getValue("M_Locator_ID");
        if (Locator2 != null) {
            M_Locator_ID = Locator2;
        }
        if (M_Locator_ID == 0) {
            return "";
        }
        int M_AttributeSetInstance_ID = 0;
        Integer ASI = (Integer)mTab.getValue("M_AttributeSetInstance_ID");
        if (ASI != null) {
            M_AttributeSetInstance_ID = ASI;
        }
        if ("M_Product_ID".equals(mField.getColumnName())) {
            M_AttributeSetInstance_ID = Env.getContextAsInt(ctx, WindowNo, 1113, "M_Product_ID") == M_Product_ID ? Env.getContextAsInt(ctx, WindowNo, 1113, "M_AttributeSetInstance_ID") : 0;
            if (M_AttributeSetInstance_ID != 0) {
                mTab.setValue("M_AttributeSetInstance_ID", (Object)M_AttributeSetInstance_ID);
            } else {
                mTab.setValue("M_AttributeSetInstance_ID", null);
            }
        }
        try {
            bd = this.setQtyBook(M_AttributeSetInstance_ID, M_Product_ID, M_Locator_ID);
            mTab.setValue("QtyBook", (Object)bd);
        }
        catch (Exception e) {
            return mTab.setValue("QtyBook", (Object)bd);
        }
        Integer InventoryID = (Integer)mTab.getValue("M_Inventory_ID");
        String sqlDocID = "Select c_doctype_id from m_inventory where m_inventory_id = ?";
        Integer docID = DB.getSQLValue(null, sqlDocID, InventoryID);
        if (docID == 1000154 || docID == 1000153) {
            Integer productID = (Integer)mTab.getValue("M_Product_ID");
            if (productID != null) {
                String sqlCatID = "Select m_product_category_id from m_product where m_product_id = ?";
                Integer catID = DB.getSQLValue(null, sqlCatID, productID);
                String sqlGrpID = "Select beta_subcat_id from m_product where m_product_id = ?";
                Integer grpID = DB.getSQLValue(null, sqlGrpID, productID);
                if (catID == 1000014) {
                    mTab.setValue("IsProjectYN", (Object)"Y");
                } else if (grpID == 1000180) {
                    mTab.setValue("IsProjectYN", (Object)"Y");
                } else {
                    mTab.setValue("IsProjectYN", (Object)"N");
                }
            }
        } else {
            mTab.setValue("IsProjectYN", (Object)"N");
        }
        this.log.info("M_Product_ID=" + M_Product_ID + ", M_Locator_ID=" + M_Locator_ID + ", M_AttributeSetInstance_ID=" + M_AttributeSetInstance_ID + " - QtyBook=" + bd);
        return "";
    }

    private BigDecimal setQtyBook(int M_AttributeSetInstance_ID, int M_Product_ID, int M_Locator_ID) throws Exception {
        BigDecimal bd = null;
        String sql = "SELECT QtyOnHand FROM M_Storage WHERE M_Product_ID=? AND M_Locator_ID=? AND M_AttributeSetInstance_ID=?";
        if (M_AttributeSetInstance_ID == 0) {
            sql = "SELECT SUM(QtyOnHand) FROM M_Storage WHERE M_Product_ID=? AND M_Locator_ID=?";
        }
        try {
            ResultSet rs;
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, M_Product_ID);
            pstmt.setInt(2, M_Locator_ID);
            if (M_AttributeSetInstance_ID != 0) {
                pstmt.setInt(3, M_AttributeSetInstance_ID);
            }
            if ((rs = pstmt.executeQuery()).next()) {
                bd = rs.getBigDecimal(1);
                if (bd != null) {
                    return bd;
                }
            } else {
                return new BigDecimal(0);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
            throw new Exception(e.getLocalizedMessage());
        }
        return new BigDecimal(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String setIssueItem(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer iocLine = (Integer)mTab.getValue("IOCLine_ID");
        if (iocLine != null) {
            String sqlIoc = "SELECT m_product_id,m_locator_id,qtyinternaluse,c_charge_id FROM m_inventoryline WHERE m_inventoryline_id=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                pstmt = DB.prepareStatement(sqlIoc, null);
                pstmt.setInt(1, iocLine);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    mTab.setValue("M_Product_ID", (Object)rs.getBigDecimal("m_product_id"));
                    mTab.setValue("M_Locator_ID", (Object)rs.getBigDecimal("m_locator_id"));
                    mTab.setValue("QtyInternalUse", (Object)new BigDecimal(rs.getBigDecimal("qtyinternaluse").doubleValue() * -1.0));
                    mTab.setValue("C_Charge_ID", (Object)rs.getBigDecimal("c_charge_id"));
                }
                rs.close();
                pstmt.close();
            }
            catch (Exception exception) {
                DB.close(rs, pstmt);
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    throw throwable;
                }
            }
            DB.close(rs, pstmt);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String setOrderInfo(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer soID = (Integer)mTab.getValue("C_Order_ID");
        if (soID != null) {
            String sqlOrd = "SELECT c_bpartner_id,custname,salesrep_id,beta_cust_project_id FROM c_order WHERE c_order_id=?";
            CPreparedStatement pstmtOrd = null;
            ResultSet rsOrd = null;
            try {
                pstmtOrd = DB.prepareStatement(sqlOrd, null);
                pstmtOrd.setInt(1, soID);
                rsOrd = pstmtOrd.executeQuery();
                if (rsOrd.next()) {
                    mTab.setValue("C_BPartner_ID", (Object)rsOrd.getBigDecimal("c_bpartner_id"));
                    mTab.setValue("SalesRep_ID", (Object)rsOrd.getBigDecimal("salesrep_id"));
                    mTab.setValue("CUSTNAME", (Object)rsOrd.getString("custname"));
                    BigDecimal custid = rsOrd.getBigDecimal("beta_cust_project_id");
                    mTab.setValue("Beta_Cust_Project_ID", (Object)rsOrd.getBigDecimal("beta_cust_project_id"));
                }
                rsOrd.close();
                pstmtOrd.close();
            }
            catch (Exception exception) {
                DB.close(rsOrd, pstmtOrd);
                catch (Throwable throwable) {
                    DB.close(rsOrd, pstmtOrd);
                    throw throwable;
                }
            }
            DB.close(rsOrd, pstmtOrd);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String setOrdLineInfo(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer soLineID = (Integer)mTab.getValue("C_OrderLine_ID");
        if (soLineID != null) {
            String sqlOrdLine = "SELECT col.m_product_id,col.qtyentered,mp.value FROM c_orderline col inner join m_product mp ON mp.m_product_id=col.m_product_id WHERE c_orderline_id=?";
            CPreparedStatement pstmtOrdLine = null;
            ResultSet rsOrdLine = null;
            try {
                pstmtOrdLine = DB.prepareStatement(sqlOrdLine, null);
                pstmtOrdLine.setInt(1, soLineID);
                rsOrdLine = pstmtOrdLine.executeQuery();
                if (rsOrdLine.next()) {
                    mTab.setValue("M_Product_ID", (Object)rsOrdLine.getBigDecimal("m_product_id"));
                    mTab.setValue("QtyInternalUse", (Object)rsOrdLine.getBigDecimal("qtyentered"));
                    mTab.setValue("Value", (Object)rsOrdLine.getString("value"));
                }
                rsOrdLine.close();
                pstmtOrdLine.close();
            }
            catch (Exception exception) {
                DB.close(rsOrdLine, pstmtOrdLine);
                catch (Throwable throwable) {
                    DB.close(rsOrdLine, pstmtOrdLine);
                    throw throwable;
                }
            }
            DB.close(rsOrdLine, pstmtOrdLine);
        }
        return "";
    }
}

