/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MConversionRate;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class CalloutGLJournal
extends CalloutEngine {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String period(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        block14: {
            ResultSet rs;
            CPreparedStatement pstmt;
            block12: {
                int C_Period_ID;
                Timestamp DateAcct;
                block15: {
                    int AD_Client_ID;
                    String colName;
                    block13: {
                        colName = mField.getColumnName();
                        if (value == null) {
                            return "";
                        }
                        AD_Client_ID = Env.getContextAsInt(ctx, WindowNo, "AD_Client_ID");
                        DateAcct = null;
                        DateAcct = colName.equals("DateAcct") ? (Timestamp)value : (Timestamp)mTab.getValue("DateAcct");
                        C_Period_ID = 0;
                        if (colName.equals("C_Period_ID")) {
                            C_Period_ID = (Integer)value;
                        }
                        if (!colName.equals("DateDoc")) break block13;
                        mTab.setValue("DateAcct", value);
                        break block14;
                    }
                    if (!colName.equals("DateAcct")) break block15;
                    String sql = "SELECT C_Period_ID FROM C_Period WHERE C_Year_ID IN \t(SELECT C_Year_ID FROM C_Year WHERE C_Calendar_ID =  (SELECT C_Calendar_ID FROM AD_ClientInfo WHERE AD_Client_ID=?)) AND ? BETWEEN StartDate AND EndDate AND IsActive='Y' AND PeriodType='S'";
                    CPreparedStatement pstmt2 = null;
                    ResultSet rs2 = null;
                    try {
                        pstmt2 = DB.prepareStatement(sql, null);
                        pstmt2.setInt(1, AD_Client_ID);
                        pstmt2.setTimestamp(2, DateAcct);
                        rs2 = pstmt2.executeQuery();
                        if (rs2.next()) {
                            C_Period_ID = rs2.getInt(1);
                        }
                        rs2.close();
                        pstmt2.close();
                        pstmt2 = null;
                    }
                    catch (SQLException e) {
                        String string;
                        try {
                            this.log.log(Level.SEVERE, sql, e);
                            string = e.getLocalizedMessage();
                        }
                        catch (Throwable throwable) {
                            DB.close(rs2, pstmt2);
                            throw throwable;
                        }
                        DB.close(rs2, pstmt2);
                        return string;
                    }
                    DB.close(rs2, pstmt2);
                    if (C_Period_ID != 0) {
                        mTab.setValue("C_Period_ID", (Object)new Integer(C_Period_ID));
                    }
                    break block14;
                }
                String sql = "SELECT PeriodType, StartDate, EndDate FROM C_Period WHERE C_Period_ID=?";
                pstmt = null;
                rs = null;
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, C_Period_ID);
                    rs = pstmt.executeQuery();
                    if (!rs.next()) break block12;
                    String PeriodType = rs.getString(1);
                    Timestamp StartDate = rs.getTimestamp(2);
                    Timestamp EndDate = rs.getTimestamp(3);
                    if (!PeriodType.equals("S") || DateAcct != null && !DateAcct.before(StartDate) && !DateAcct.after(EndDate)) break block12;
                    mTab.setValue("DateAcct", (Object)EndDate);
                }
                catch (SQLException e) {
                    String string;
                    try {
                        this.log.log(Level.SEVERE, sql, e);
                        string = e.getLocalizedMessage();
                    }
                    catch (Throwable throwable) {
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        throw throwable;
                    }
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    return string;
                }
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return "";
    }

    @Override
    public String rate(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (value == null) {
            return "";
        }
        Integer Currency_ID = (Integer)mTab.getValue("C_Currency_ID");
        int C_Currency_ID = Currency_ID;
        Integer ConversionType_ID = (Integer)mTab.getValue("C_ConversionType_ID");
        int C_ConversionType_ID = ConversionType_ID;
        Timestamp DateAcct = (Timestamp)mTab.getValue("DateAcct");
        if (DateAcct == null) {
            DateAcct = new Timestamp(System.currentTimeMillis());
        }
        int C_AcctSchema_ID = Env.getContextAsInt(ctx, WindowNo, "C_AcctSchema_ID");
        MAcctSchema as = MAcctSchema.get(ctx, C_AcctSchema_ID);
        int AD_Client_ID = Env.getContextAsInt(ctx, WindowNo, "AD_Client_ID");
        int AD_Org_ID = Env.getContextAsInt(ctx, WindowNo, "AD_Org_ID");
        BigDecimal CurrencyRate = MConversionRate.getRate(C_Currency_ID, as.getC_Currency_ID(), DateAcct, C_ConversionType_ID, AD_Client_ID, AD_Org_ID);
        this.log.fine("rate = " + CurrencyRate);
        if (CurrencyRate == null) {
            CurrencyRate = Env.ZERO;
        }
        mTab.setValue("CurrencyRate", (Object)CurrencyRate);
        return "";
    }

    public String amt(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        BigDecimal AmtSourceCr;
        BigDecimal AmtSourceDr;
        String colName = mField.getColumnName();
        if (value == null || this.isCalloutActive()) {
            return "";
        }
        int C_AcctSchema_ID = Env.getContextAsInt(ctx, WindowNo, "C_AcctSchema_ID");
        MAcctSchema as = MAcctSchema.get(ctx, C_AcctSchema_ID);
        int Precision = as.getStdPrecision();
        BigDecimal CurrencyRate = (BigDecimal)mTab.getValue("CurrencyRate");
        if (CurrencyRate == null) {
            CurrencyRate = Env.ONE;
            mTab.setValue("CurrencyRate", (Object)CurrencyRate);
        }
        if ((AmtSourceDr = (BigDecimal)mTab.getValue("AmtSourceDr")) == null) {
            AmtSourceDr = Env.ZERO;
        }
        if ((AmtSourceCr = (BigDecimal)mTab.getValue("AmtSourceCr")) == null) {
            AmtSourceCr = Env.ZERO;
        }
        BigDecimal AmtAcctDr = AmtSourceDr.multiply(CurrencyRate);
        AmtAcctDr = AmtAcctDr.setScale(Precision, 4);
        mTab.setValue("AmtAcctDr", (Object)AmtAcctDr);
        BigDecimal AmtAcctCr = AmtSourceCr.multiply(CurrencyRate);
        AmtAcctCr = AmtAcctCr.setScale(Precision, 4);
        mTab.setValue("AmtAcctCr", (Object)AmtAcctCr);
        return "";
    }

    public String DebitCreditChk(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        BigDecimal AmtSourceDr = (BigDecimal)mTab.getValue("AmtSourceDr");
        BigDecimal AmtSourceCr = (BigDecimal)mTab.getValue("AmtSourceCr");
        Double Dr = new Double("" + AmtSourceDr);
        Double Cr = new Double("" + AmtSourceCr);
        if (Dr != 0.0 && Cr != 0.0) {
            mTab.fireDataStatusEEvent(" Amount ", "Debit and Credit amount for same account is not allowed", true);
        }
        return "";
    }
}

