/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Properties;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MProjectLine;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class CallOutProjectReceipt
extends CalloutEngine {
    public String projectLine(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_ProjectLine_ID = (Integer)value;
        if (C_ProjectLine_ID == null || C_ProjectLine_ID == 0) {
            return "";
        }
        MProjectLine ol = new MProjectLine(ctx, C_ProjectLine_ID, null);
        if (ol.get_ID() != 0) {
            mTab.setValue("M_Product_ID", (Object)new Integer(ol.getM_Product_ID()));
            BigDecimal RecQty = (BigDecimal)mTab.getValue("QTYRECEIVED");
            BigDecimal PlanPrice = (BigDecimal)mTab.getValue("PlannedPrice");
            BigDecimal Total = RecQty.multiply(PlanPrice);
            mTab.setValue("TotalLine", (Object)Total);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String QtyReceived(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (value == null || value.equals(Env.ZERO)) {
            return "";
        }
        BigDecimal RecQty = (BigDecimal)mTab.getValue("QTYRECEIVED");
        Integer C_ProjectLine_ID = (Integer)mTab.getValue("C_PROJECTLINE_ID");
        Integer C_PROJECTRECEIPTLINE_ID = (Integer)mTab.getValue("C_PROJECTRECEIPTLINE_ID");
        MProjectLine ol = new MProjectLine(ctx, C_ProjectLine_ID, null);
        BigDecimal PlannedQty = ol.getPlannedQty();
        BigDecimal TotalReceivedQty = Env.ZERO;
        String sql = "Select nvl(Sum(QTYRECEIVED),0) from C_PROJECTRECEIPTLINE Where C_ProjectLine_ID = ? and C_PROJECTRECEIPTLINE_ID != ?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, C_ProjectLine_ID);
            pstmt.setInt(2, C_PROJECTRECEIPTLINE_ID);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                TotalReceivedQty = rs.getBigDecimal(1);
            }
            rs.close();
            pstmt.close();
        }
        catch (Exception exception) {
            DB.close(rs, pstmt);
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        if (TotalReceivedQty.add(RecQty).compareTo(PlannedQty) == 1) {
            mTab.fireDataStatusEEvent("Total Quantity", "Total Qty received so far exceeds the Planned Qty", true);
        } else {
            BigDecimal PlanPrice = (BigDecimal)mTab.getValue("PlannedPrice");
            BigDecimal Total = RecQty.multiply(PlanPrice);
            mTab.setValue("TotalLine", (Object)Total);
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return "";
    }
}

