/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.minigrid;

import java.awt.Component;
import java.awt.Insets;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import javax.swing.DefaultCellEditor;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.compiere.apps.search.Info_Column;
import org.compiere.grid.ed.VCellRenderer;
import org.compiere.grid.ed.VHeaderRenderer;
import org.compiere.minigrid.CheckRenderer;
import org.compiere.minigrid.ColumnInfo;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.IDColumnEditor;
import org.compiere.minigrid.IDColumnRenderer;
import org.compiere.minigrid.IMiniTable;
import org.compiere.minigrid.MiniCellEditor;
import org.compiere.minigrid.ROCellEditor;
import org.compiere.model.MRole;
import org.compiere.model.PO;
import org.compiere.swing.CCheckBox;
import org.compiere.swing.CTable;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Util;

public class MiniTable
extends CTable
implements IMiniTable {
    private static final long serialVersionUID = 2853772547464132496L;
    private ArrayList<Integer> m_readWriteColumn = new ArrayList();
    private ArrayList<Integer> m_minWidth = new ArrayList();
    private int m_colorColumnIndex = -1;
    private Object m_colorDataCompare = Env.ZERO;
    private boolean m_multiSelection = false;
    private ColumnInfo[] m_layout = null;
    private static CLogger log = CLogger.getCLogger(MiniTable.class);
    private boolean showTotals = false;

    public MiniTable() {
        this.setCellSelectionEnabled(false);
        this.setRowSelectionAllowed(false);
        this.setCellEditor(new ROCellEditor());
    }

    public TableColumn getColumn(int col) {
        return this.getColumnModel().getColumn(col);
    }

    @Override
    public int getColumnCount() {
        return this.getColumnModel().getColumnCount();
    }

    @Override
    public void autoSize() {
        long start = System.currentTimeMillis();
        int SLACK = 8;
        int MAXSIZE = 300;
        TableModel model = this.getModel();
        int size = model.getColumnCount();
        for (int col = 0; col < size; ++col) {
            TableCellRenderer renderer;
            TableColumn tc = this.getColumnModel().getColumn(col);
            int width = 0;
            if (this.m_minWidth.size() > col) {
                width = this.m_minWidth.get(col);
            }
            if ((renderer = tc.getHeaderRenderer()) == null) {
                renderer = new DefaultTableCellRenderer();
            }
            Component comp = renderer.getTableCellRendererComponent(this, tc.getHeaderValue(), false, false, 0, 0);
            width = Math.max(width, comp.getPreferredSize().width + 8);
            int maxRow = Math.min(30, this.getRowCount());
            for (int row = 0; row < maxRow; ++row) {
                renderer = this.getCellRenderer(row, col);
                comp = renderer.getTableCellRendererComponent(this, this.getValueAt(row, col), false, false, row, col);
                if (comp == null) continue;
                int rowWidth = comp.getPreferredSize().width + 8;
                width = Math.max(width, rowWidth);
            }
            width = Math.min(300, width);
            tc.setPreferredWidth(width);
        }
        log.finer("Cols=" + size + " - " + (System.currentTimeMillis() - start) + "ms");
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (column != 0 && this.getValueAt(row, 0) instanceof Boolean && !((Boolean)this.getValueAt(row, 0)).booleanValue()) {
            return false;
        }
        return this.m_readWriteColumn.contains(new Integer(column));
    }

    @Override
    public void setColumnReadOnly(int column, boolean readOnly) {
        if (this.m_readWriteColumn.contains(new Integer(column))) {
            if (readOnly) {
                int size = this.m_readWriteColumn.size();
                for (int i = 0; i < size; ++i) {
                    if (this.m_readWriteColumn.get(i) != column) continue;
                    this.m_readWriteColumn.remove(i);
                    break;
                }
            }
        } else if (!readOnly) {
            this.m_readWriteColumn.add(new Integer(column));
        }
    }

    @Override
    public String prepareTable(ColumnInfo[] layout, String from, String where, boolean multiSelection, String tableName) {
        int i;
        this.m_layout = layout;
        this.m_multiSelection = multiSelection;
        StringBuffer sql = new StringBuffer("SELECT ");
        for (i = 0; i < layout.length; ++i) {
            if (i > 0) {
                sql.append(", ");
            }
            sql.append(layout[i].getColSQL());
            if (layout[i].isKeyPairCol()) {
                sql.append(",").append(layout[i].getKeyPairColSQL());
            }
            this.addColumn(layout[i].getColHeader());
            if (layout[i].isColorColumn()) {
                this.setColorColumn(i);
            }
            if (layout[i].getColClass() != IDColumn.class) continue;
            this.p_keyColumnIndex = i;
        }
        for (i = 0; i < layout.length; ++i) {
            this.setColumnClass(i, layout[i].getColClass(), layout[i].isReadOnly(), layout[i].getColHeader());
        }
        sql.append(" FROM ").append(from);
        sql.append(" WHERE ").append(where);
        this.setRowSelectionAllowed(true);
        if (from.length() == 0) {
            return sql.toString();
        }
        String finalSQL = MRole.getDefault().addAccessSQL(sql.toString(), tableName, true, false);
        log.finest(finalSQL);
        return finalSQL;
    }

    @Override
    public void addColumn(String header) {
        if (!(this.getModel() instanceof DefaultTableModel)) {
            throw new IllegalArgumentException("Model must be instance of DefaultTableModel");
        }
        DefaultTableModel model = (DefaultTableModel)this.getModel();
        model.addColumn(Util.cleanAmp(header));
    }

    @Override
    public void setColumnClass(int index, Class c, boolean readOnly) {
        this.setColumnClass(index, c, readOnly, null);
    }

    @Override
    public void setColumnClass(int index, Class c, boolean readOnly, String header) {
        TableColumn tc = this.getColumnModel().getColumn(index);
        if (tc == null) {
            return;
        }
        this.setColumnReadOnly(index, readOnly);
        if (header != null && header.length() > 0) {
            tc.setHeaderValue(Util.cleanAmp(header));
        }
        if (c == IDColumn.class) {
            tc.setCellRenderer(new IDColumnRenderer(this.m_multiSelection));
            if (this.m_multiSelection) {
                tc.setCellEditor(new IDColumnEditor());
                this.setColumnReadOnly(index, false);
            } else {
                tc.setCellEditor(new ROCellEditor());
            }
            this.m_minWidth.add(new Integer(10));
            tc.setMaxWidth(20);
            tc.setPreferredWidth(20);
            tc.setResizable(false);
            tc.setHeaderRenderer(new VHeaderRenderer(22));
        } else if (c == Boolean.class) {
            tc.setCellRenderer(new CheckRenderer());
            if (readOnly) {
                tc.setCellEditor(new ROCellEditor());
            } else {
                CCheckBox check = new CCheckBox();
                check.setMargin(new Insets(0, 0, 0, 0));
                check.setHorizontalAlignment(0);
                tc.setCellEditor(new DefaultCellEditor(check));
            }
            this.m_minWidth.add(new Integer(30));
            tc.setHeaderRenderer(new VHeaderRenderer(20));
        } else if (c == Timestamp.class) {
            tc.setCellRenderer(new VCellRenderer(15));
            if (readOnly) {
                tc.setCellEditor(new ROCellEditor());
            } else {
                tc.setCellEditor(new MiniCellEditor(c));
            }
            this.m_minWidth.add(new Integer(30));
            tc.setHeaderRenderer(new VHeaderRenderer(16));
        } else if (c == BigDecimal.class) {
            tc.setCellRenderer(new VCellRenderer(12));
            if (readOnly) {
                tc.setCellEditor(new ROCellEditor());
                this.m_minWidth.add(new Integer(70));
            } else {
                tc.setCellEditor(new MiniCellEditor(c));
                this.m_minWidth.add(new Integer(80));
            }
            tc.setHeaderRenderer(new VHeaderRenderer(22));
        } else if (c == Double.class) {
            tc.setCellRenderer(new VCellRenderer(22));
            if (readOnly) {
                tc.setCellEditor(new ROCellEditor());
                this.m_minWidth.add(new Integer(70));
            } else {
                tc.setCellEditor(new MiniCellEditor(c));
                this.m_minWidth.add(new Integer(80));
            }
            tc.setHeaderRenderer(new VHeaderRenderer(22));
        } else if (c == Integer.class) {
            tc.setCellRenderer(new VCellRenderer(11));
            if (readOnly) {
                tc.setCellEditor(new ROCellEditor());
            } else {
                tc.setCellEditor(new MiniCellEditor(c));
            }
            this.m_minWidth.add(new Integer(30));
            tc.setHeaderRenderer(new VHeaderRenderer(22));
        } else {
            tc.setCellRenderer(new VCellRenderer(10));
            if (readOnly) {
                tc.setCellEditor(new ROCellEditor());
            } else {
                tc.setCellEditor(new MiniCellEditor(String.class));
            }
            this.m_minWidth.add(new Integer(30));
            tc.setHeaderRenderer(new VHeaderRenderer(10));
        }
    }

    @Override
    public void setRowCount(int no) {
        if (!(this.getModel() instanceof DefaultTableModel)) {
            throw new IllegalArgumentException("Model must be instance of DefaultTableModel");
        }
        DefaultTableModel model = (DefaultTableModel)this.getModel();
        model.setRowCount(no);
    }

    @Override
    public void loadTable(ResultSet rs) {
        if (this.m_layout == null) {
            throw new UnsupportedOperationException("Layout not defined");
        }
        this.setRowCount(0);
        try {
            while (rs.next()) {
                int row = this.getRowCount();
                this.setRowCount(row + 1);
                int colOffset = 1;
                for (int col = 0; col < this.m_layout.length; ++col) {
                    Object data = null;
                    Class<?> c = this.m_layout[col].getColClass();
                    int colIndex = col + colOffset;
                    if (c == IDColumn.class) {
                        data = new IDColumn(rs.getInt(colIndex));
                    } else if (c == Boolean.class) {
                        data = new Boolean("Y".equals(rs.getString(colIndex)));
                    } else if (c == Timestamp.class) {
                        data = rs.getTimestamp(colIndex);
                    } else if (c == BigDecimal.class) {
                        data = rs.getBigDecimal(colIndex);
                    } else if (c == Double.class) {
                        data = rs.getDouble(colIndex);
                    } else if (c == Integer.class) {
                        data = rs.getInt(colIndex);
                    } else if (c == KeyNamePair.class) {
                        String display = rs.getString(colIndex);
                        int key = rs.getInt(colIndex + 1);
                        data = new KeyNamePair(key, display);
                        ++colOffset;
                    } else {
                        String s = rs.getString(colIndex);
                        if (s != null) {
                            data = s.trim();
                        }
                    }
                    this.setValueAt(data, row, col);
                }
            }
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "", e);
        }
        if (this.getShowTotals()) {
            this.addTotals(this.m_layout);
        }
        this.autoSize();
        log.config("Row(rs)=" + this.getRowCount());
    }

    @Override
    public void loadTable(PO[] pos) {
        if (this.m_layout == null) {
            throw new UnsupportedOperationException("Layout not defined");
        }
        this.setRowCount(0);
        for (int i = 0; i < pos.length; ++i) {
            PO myPO = pos[i];
            int row = this.getRowCount();
            this.setRowCount(row + 1);
            for (int col = 0; col < this.m_layout.length; ++col) {
                String columnName = this.m_layout[col].getColSQL();
                Object data = myPO.get_Value(columnName);
                if (data != null) {
                    Class<?> c = this.m_layout[col].getColClass();
                    if (c == IDColumn.class) {
                        data = new IDColumn((int)((Integer)data));
                    } else if (c == Double.class) {
                        data = new Double(((BigDecimal)data).doubleValue());
                    }
                }
                this.setValueAt(data, row, col);
            }
        }
        if (this.getShowTotals()) {
            this.addTotals(this.m_layout);
        }
        this.autoSize();
        log.config("Row(array)=" + this.getRowCount());
    }

    @Override
    public Integer getSelectedRowKey() {
        if (this.m_layout == null) {
            throw new UnsupportedOperationException("Layout not defined");
        }
        int row = this.getSelectedRow();
        if (row != -1 && this.p_keyColumnIndex != -1) {
            Object data = this.getModel().getValueAt(row, this.p_keyColumnIndex);
            if (data instanceof IDColumn) {
                data = ((IDColumn)data).getRecord_ID();
            }
            if (data instanceof Integer) {
                return (Integer)data;
            }
        }
        return null;
    }

    public Collection<Integer> getSelectedKeys() {
        if (this.m_layout == null) {
            throw new UnsupportedOperationException("Layout not defined");
        }
        if (this.p_keyColumnIndex < 0) {
            throw new UnsupportedOperationException("Key Column is not defined");
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int row = 0; row < this.getRowCount(); ++row) {
            IDColumn record;
            Object data = this.getModel().getValueAt(row, this.p_keyColumnIndex);
            if (!(data instanceof IDColumn) || !(record = (IDColumn)data).isSelected()) continue;
            list.add(record.getRecord_ID());
        }
        return list;
    }

    @Override
    public ColumnInfo[] getLayoutInfo() {
        return this.m_layout;
    }

    @Override
    public void setMultiSelection(boolean multiSelection) {
        this.m_multiSelection = multiSelection;
    }

    @Override
    public boolean isMultiSelection() {
        return this.m_multiSelection;
    }

    public void setColorColumn(int modelIndex) {
        this.m_colorColumnIndex = modelIndex;
    }

    @Override
    public void setColorCompare(Object dataCompare) {
        this.m_colorDataCompare = dataCompare;
    }

    @Override
    public int getColorCode(int row) {
        if (this.m_colorColumnIndex == -1) {
            return 0;
        }
        Object data = this.getModel().getValueAt(row, this.m_colorColumnIndex);
        int cmp = 0;
        if (data == null) {
            return 0;
        }
        try {
            if (data instanceof Timestamp) {
                if (this.m_colorDataCompare == null || !(this.m_colorDataCompare instanceof Timestamp)) {
                    this.m_colorDataCompare = new Timestamp(System.currentTimeMillis());
                }
                cmp = ((Timestamp)this.m_colorDataCompare).compareTo((Timestamp)data);
            } else {
                if (this.m_colorDataCompare == null || !(this.m_colorDataCompare instanceof BigDecimal)) {
                    this.m_colorDataCompare = Env.ZERO;
                }
                if (!(data instanceof BigDecimal)) {
                    data = new BigDecimal(data.toString());
                }
                cmp = ((BigDecimal)this.m_colorDataCompare).compareTo((BigDecimal)data);
            }
        }
        catch (Exception e) {
            return 0;
        }
        if (cmp > 0) {
            return -1;
        }
        if (cmp < 0) {
            return 1;
        }
        return 0;
    }

    public void setShowTotals(boolean show) {
        this.showTotals = show;
    }

    public boolean getShowTotals() {
        return this.showTotals;
    }

    public void addTotals(ColumnInfo[] layout) {
        int col;
        int row;
        if (this.getRowCount() == 0 || layout.length == 0) {
            return;
        }
        Object[] total = new Object[layout.length];
        for (row = 0; row < this.getRowCount(); ++row) {
            for (col = 0; col < layout.length; ++col) {
                Number amt;
                Number subtotal;
                Object data = this.getModel().getValueAt(row, col);
                Class<?> c = layout[col].getColClass();
                if (c == BigDecimal.class) {
                    subtotal = Env.ZERO;
                    if (total[col] != null) {
                        subtotal = (BigDecimal)total[col];
                    }
                    amt = (BigDecimal)data;
                    if (subtotal == null) {
                        subtotal = Env.ZERO;
                    }
                    if (amt == null) {
                        amt = Env.ZERO;
                    }
                    total[col] = ((BigDecimal)subtotal).add((BigDecimal)amt);
                    continue;
                }
                if (c != Double.class) continue;
                subtotal = new Double(0.0);
                if (total[col] != null) {
                    subtotal = (Double)total[col];
                }
                amt = (Double)data;
                if (subtotal == null) {
                    subtotal = new Double(0.0);
                }
                if (amt == null) {
                    subtotal = new Double(0.0);
                }
                total[col] = (Double)subtotal + (Double)amt;
            }
        }
        row = this.getRowCount() + 1;
        this.setRowCount(row);
        for (col = 0; col < layout.length; ++col) {
            Class<?> c = layout[col].getColClass();
            if (c == BigDecimal.class) {
                this.setValueAt(total[col], row - 1, col);
                continue;
            }
            if (c == Double.class) {
                this.setValueAt(total[col], row - 1, col);
                continue;
            }
            if (col == 0) {
                this.setValueAt(" \u03a3  ", row - 1, col);
                continue;
            }
            this.setValueAt(null, row - 1, col);
        }
    }

    public void addTotals(Info_Column[] layout) {
        int col;
        int row;
        if (this.getRowCount() == 0 || layout.length == 0) {
            return;
        }
        Object[] total = new Object[layout.length];
        for (row = 0; row < this.getRowCount(); ++row) {
            for (col = 0; col < layout.length; ++col) {
                Number amt;
                Number subtotal;
                Object data = this.getModel().getValueAt(row, col);
                Class<?> c = layout[col].getColClass();
                if (c == BigDecimal.class) {
                    subtotal = Env.ZERO;
                    if (total[col] != null) {
                        subtotal = (BigDecimal)total[col];
                    }
                    amt = (BigDecimal)data;
                    if (subtotal == null) {
                        subtotal = Env.ZERO;
                    }
                    if (amt == null) {
                        amt = Env.ZERO;
                    }
                    total[col] = ((BigDecimal)subtotal).add((BigDecimal)amt);
                    continue;
                }
                if (c != Double.class) continue;
                subtotal = new Double(0.0);
                if (total[col] != null) {
                    subtotal = (Double)total[col];
                }
                amt = (Double)data;
                if (subtotal == null) {
                    subtotal = new Double(0.0);
                }
                if (amt == null) {
                    subtotal = new Double(0.0);
                }
                total[col] = (Double)subtotal + (Double)amt;
            }
        }
        row = this.getRowCount() + 1;
        this.setRowCount(row);
        for (col = 0; col < layout.length; ++col) {
            Class<?> c = layout[col].getColClass();
            if (c == BigDecimal.class) {
                this.setValueAt(total[col], row - 1, col);
                continue;
            }
            if (c == Double.class) {
                this.setValueAt(total[col], row - 1, col);
                continue;
            }
            if (col == 1) {
                this.setValueAt(" \u03a3  ", row - 1, col);
                continue;
            }
            this.setValueAt(null, row - 1, col);
        }
    }
}

