/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.FieldRecordInfo;
import org.compiere.grid.ed.VEditor;
import org.compiere.grid.ed.VPAttributeDialog;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MPAttributeLookup;
import org.compiere.model.MProduct;
import org.compiere.swing.CButton;
import org.compiere.swing.CMenuItem;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class VPAttribute
extends JComponent
implements VEditor,
ActionListener {
    private static final long serialVersionUID = 108156477716619163L;
    private Object m_value = new Object();
    private MPAttributeLookup m_mPAttribute;
    private JTextField m_text = new JTextField(15);
    private CButton m_button = new CButton();
    JPopupMenu popupMenu = new JPopupMenu();
    private CMenuItem menuEditor;
    private boolean m_readWrite;
    private boolean m_mandatory;
    private int m_WindowNo;
    private int m_C_BPartner_ID;
    private GridTab m_GridTab;
    private GridField m_GridField;
    private int m_AD_Column_ID = 0;
    private GridField m_mField;
    private static Integer NO_INSTANCE = new Integer(0);
    private static CLogger log = CLogger.getCLogger(VPAttribute.class);

    public VPAttribute() {
        this(null, false, false, true, 0, null);
    }

    public VPAttribute(boolean mandatory, boolean isReadOnly, boolean isUpdateable, int WindowNo, MPAttributeLookup lookup) {
        this(null, mandatory, isReadOnly, isUpdateable, WindowNo, lookup);
    }

    public VPAttribute(GridTab gridTab, boolean mandatory, boolean isReadOnly, boolean isUpdateable, int WindowNo, MPAttributeLookup lookup) {
        super.setName("M_AttributeSetInstance_ID");
        this.m_GridTab = gridTab;
        this.m_WindowNo = WindowNo;
        this.m_mPAttribute = lookup;
        this.m_C_BPartner_ID = Env.getContextAsInt(Env.getCtx(), WindowNo, "C_BPartner_ID");
        LookAndFeel.installBorder(this, "TextField.border");
        this.setLayout(new BorderLayout());
        this.setPreferredSize(this.m_text.getPreferredSize());
        int height = this.m_text.getPreferredSize().height;
        this.m_text.setEditable(false);
        this.m_text.setFocusable(false);
        this.m_text.setBorder(null);
        this.m_text.setHorizontalAlignment(10);
        this.setMandatory(mandatory);
        this.add((Component)this.m_text, "Center");
        this.m_button.setIcon(Env.getImageIcon("PAttribute10.gif"));
        this.m_button.setMargin(new Insets(0, 0, 0, 0));
        this.m_button.setPreferredSize(new Dimension(height, height));
        this.m_button.addActionListener(this);
        this.m_button.setFocusable(true);
        this.add((Component)this.m_button, "East");
        this.setPreferredSize(this.getPreferredSize());
        if (isReadOnly || !isUpdateable) {
            this.setReadWrite(false);
        } else {
            this.setReadWrite(true);
        }
        this.m_text.addMouseListener(new VPAttribute_mouseAdapter(this));
        this.menuEditor = new CMenuItem(Msg.getMsg(Env.getCtx(), "PAttribute"), Env.getImageIcon("Zoom16.gif"));
        this.menuEditor.addActionListener(this);
        this.popupMenu.add(this.menuEditor);
    }

    @Override
    public void dispose() {
        this.m_text = null;
        this.m_button = null;
        this.m_mPAttribute.dispose();
        this.m_mPAttribute = null;
        this.m_GridField = null;
        this.m_GridTab = null;
    }

    @Override
    public void setMandatory(boolean mandatory) {
        this.m_mandatory = mandatory;
        this.m_button.setMandatory(mandatory);
        this.setBackground(false);
    }

    @Override
    public boolean isMandatory() {
        return this.m_mandatory;
    }

    @Override
    public void setReadWrite(boolean rw) {
        this.m_readWrite = rw;
        this.m_button.setReadWrite(rw);
        this.setBackground(false);
    }

    @Override
    public boolean isReadWrite() {
        return this.m_readWrite;
    }

    @Override
    public void setForeground(Color color) {
        this.m_text.setForeground(color);
    }

    @Override
    public void setBackground(boolean error) {
        if (error) {
            this.setBackground(AdempierePLAF.getFieldBackground_Error());
        } else if (!this.m_readWrite) {
            this.setBackground(AdempierePLAF.getFieldBackground_Inactive());
        } else if (this.m_mandatory) {
            this.setBackground(AdempierePLAF.getFieldBackground_Mandatory());
        } else {
            this.setBackground(AdempierePLAF.getInfoBackground());
        }
    }

    @Override
    public void setBackground(Color color) {
        this.m_text.setBackground(color);
    }

    @Override
    public void setValue(Object value) {
        if (value == null || NO_INSTANCE.equals(value)) {
            this.m_text.setText("");
            this.m_value = value;
            return;
        }
        if (value.equals(this.m_value)) {
            return;
        }
        log.fine("Value=" + value);
        this.m_value = value;
        this.m_text.setText(this.m_mPAttribute.getDisplay(value));
    }

    @Override
    public Object getValue() {
        return this.m_value;
    }

    @Override
    public String getDisplay() {
        return this.m_text.getText();
    }

    @Override
    public void setField(GridField mField) {
        this.m_AD_Column_ID = mField.getAD_Column_ID();
        this.m_GridField = mField;
        this.m_mField = mField;
        if (this.m_mField != null) {
            FieldRecordInfo.addMenu(this, this.popupMenu);
        }
    }

    @Override
    public void addActionListener(ActionListener listener) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        MProduct product;
        int M_AttributeSet_ID;
        int oldValueInt;
        if (e.getActionCommand().equals("ChangeLog")) {
            FieldRecordInfo.start(this.m_mField);
            return;
        }
        if (!this.m_button.isEnabled()) {
            return;
        }
        this.m_button.setEnabled(false);
        Integer oldValue = (Integer)this.getValue();
        int M_AttributeSetInstance_ID = oldValueInt = oldValue == null ? 0 : oldValue;
        int M_Product_ID = Env.getContextAsInt(Env.getCtx(), this.m_WindowNo, "M_Product_ID");
        int M_ProductBOM_ID = Env.getContextAsInt(Env.getCtx(), this.m_WindowNo, "M_ProductBOM_ID");
        int M_Locator_ID = -1;
        log.config("M_Product_ID=" + M_Product_ID + "/" + M_ProductBOM_ID + ",M_AttributeSetInstance_ID=" + M_AttributeSetInstance_ID + ", AD_Column_ID=" + this.m_AD_Column_ID);
        boolean productWindow = this.m_AD_Column_ID == 8418;
        boolean exclude = true;
        if (M_Product_ID != 0 && (M_AttributeSet_ID = (product = MProduct.get(Env.getCtx(), M_Product_ID)).getM_AttributeSet_ID()) != 0) {
            MAttributeSet mas = MAttributeSet.get(Env.getCtx(), M_AttributeSet_ID);
            exclude = mas.excludeEntry(this.m_AD_Column_ID, Env.isSOTrx(Env.getCtx(), this.m_WindowNo));
        }
        boolean changed = false;
        if (M_ProductBOM_ID != 0) {
            M_Product_ID = M_ProductBOM_ID;
        }
        if (!productWindow && (M_Product_ID == 0 || exclude)) {
            changed = true;
            this.m_text.setText(null);
            M_AttributeSetInstance_ID = 0;
        } else {
            VPAttributeDialog vad = new VPAttributeDialog(Env.getFrame(this), M_AttributeSetInstance_ID, M_Product_ID, this.m_C_BPartner_ID, productWindow, this.m_AD_Column_ID, this.m_WindowNo);
            if (vad.isChanged()) {
                this.m_text.setText(vad.getM_AttributeSetInstanceName());
                M_AttributeSetInstance_ID = vad.getM_AttributeSetInstance_ID();
                if (!productWindow && vad.getM_Locator_ID() > 0) {
                    M_Locator_ID = vad.getM_Locator_ID();
                }
                changed = true;
            }
        }
        if (changed) {
            log.finest("Changed M_AttributeSetInstance_ID=" + M_AttributeSetInstance_ID);
            this.m_value = new Object();
            if (M_AttributeSetInstance_ID == 0) {
                this.setValue(null);
            } else {
                this.setValue(new Integer(M_AttributeSetInstance_ID));
            }
            if (this.m_GridTab != null && M_Locator_ID > 0) {
                log.finest("Change M_Locator_ID=" + M_Locator_ID);
                this.m_GridTab.setValue("M_Locator_ID", (Object)M_Locator_ID);
            }
            try {
                String columnName = "M_AttributeSetInstance_ID";
                if (this.m_GridField != null) {
                    columnName = this.m_GridField.getColumnName();
                }
                this.fireVetoableChange(columnName, new Object(), this.getValue());
            }
            catch (PropertyVetoException pve) {
                log.log(Level.SEVERE, "", pve);
            }
            if (M_AttributeSetInstance_ID == oldValueInt && this.m_GridTab != null && this.m_GridField != null) {
                this.m_GridTab.processFieldChange(this.m_GridField);
            }
        }
        this.m_button.setEnabled(true);
        this.requestFocus();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("FieldValue")) {
            this.setValue(evt.getNewValue());
        }
    }

    final class VPAttribute_mouseAdapter
    extends MouseAdapter {
        private VPAttribute m_adaptee;

        VPAttribute_mouseAdapter(VPAttribute adaptee) {
            this.m_adaptee = adaptee;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() > 1) {
                this.m_adaptee.actionPerformed(new ActionEvent(e.getSource(), e.getID(), "Mouse"));
            }
            if (SwingUtilities.isRightMouseButton(e)) {
                this.m_adaptee.popupMenu.show((Component)e.getSource(), e.getX(), e.getY());
            }
        }
    }
}

