/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import org.compiere.swing.CButton;
import org.compiere.swing.CTable;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;

public final class VHeaderRenderer
implements TableCellRenderer {
    private CButton m_button;
    private int m_alignment;

    public VHeaderRenderer() {
        this.m_button = new CButton();
        this.m_button.setMargin(new Insets(0, 0, 0, 0));
        this.m_button.putClientProperty("Plastic.is3D", Boolean.FALSE);
    }

    public VHeaderRenderer(int displayType) {
        this.m_alignment = DisplayType.isNumeric(displayType) ? 4 : (displayType == 20 ? 0 : 2);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table2, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        TableCellRenderer headerRenderer;
        Component headerComponent;
        CTable cTable;
        ImageIcon icon = null;
        if (table2 instanceof CTable && (cTable = (CTable)table2).getSortColumn() == table2.convertColumnIndexToModel(column)) {
            icon = cTable.isSortAscending() ? Env.getImageIcon2("uparrow") : Env.getImageIcon2("downarrow");
        }
        Component component = headerComponent = (headerRenderer = table2.getTableHeader().getDefaultRenderer()) == null ? null : headerRenderer.getTableCellRendererComponent(table2, value, isSelected, hasFocus, row, column);
        if (headerComponent != null && headerComponent instanceof JComponent) {
            if (headerComponent instanceof JLabel) {
                JLabel label = (JLabel)headerComponent;
                label.setHorizontalAlignment(this.m_alignment);
                if (value == null) {
                    label.setPreferredSize(new Dimension(0, 0));
                } else {
                    label.setText(value.toString());
                }
                label.setIcon(icon);
                label.setHorizontalTextPosition(10);
                return label;
            }
            this.m_button.setBorder(((JComponent)headerComponent).getBorder());
        } else {
            this.m_button.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        }
        if (value == null) {
            this.m_button.setPreferredSize(new Dimension(0, 0));
            return this.m_button;
        }
        this.m_button.setText(value.toString());
        this.m_button.setIcon(icon);
        this.m_button.setHorizontalTextPosition(10);
        return this.m_button;
    }
}

