/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Level;
import javax.swing.KeyStroke;
import org.compiere.grid.VTable;
import org.compiere.model.GridField;
import org.compiere.model.GridTable;
import org.compiere.model.Lookup;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class VTableExcelAdapter
implements ActionListener {
    public static final String CMD_Copy = "VTable.copyPaste";
    public static final String CMD_CopyWithHeaders = "VTable.copyPasteH";
    private static KeyStroke KS_copy = KeyStroke.getKeyStroke(67, 2, false);
    private static KeyStroke KS_copyWithHeader = KeyStroke.getKeyStroke(67, 3, false);
    private CLogger log = CLogger.getCLogger(this.getClass());
    private Clipboard system;
    private VTable table;
    private static Locale sysLocale = new Locale(System.getProperty("user.language"), System.getProperty("user.country"));
    private static NumberFormat sysNumberFormat = NumberFormat.getNumberInstance(sysLocale);
    private static DateFormat sysDateFormat = DateFormat.getDateInstance(2, sysLocale);

    public VTableExcelAdapter(VTable table2) {
        this.table = table2;
        table2.registerKeyboardAction(this, CMD_Copy, KS_copy, 0);
        table2.registerKeyboardAction(this, CMD_CopyWithHeaders, KS_copyWithHeader, 0);
        this.system = Toolkit.getDefaultToolkit().getSystemClipboard();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!(this.table.getModel() instanceof GridTable)) {
            if (CLogMgt.isLevelFine()) {
                this.log.fine("Not supported - " + this.table.getModel());
            }
            return;
        }
        boolean isCopy = CMD_Copy.equals(e.getActionCommand());
        boolean isCopyWithHeaders = CMD_CopyWithHeaders.equals(e.getActionCommand());
        if (isCopy || isCopyWithHeaders) {
            try {
                int[] selectedRows = this.table.getSelectedRows();
                if (selectedRows == null || selectedRows.length == 0) {
                    return;
                }
                int colscount = this.table.getColumnCount();
                StringBuffer sb = new StringBuffer();
                GridTable model = (GridTable)this.table.getModel();
                GridField[] fields = model.getFields();
                if (isCopyWithHeaders) {
                    for (int col = 0; col < colscount; ++col) {
                        String value = "";
                        try {
                            GridField field = fields[col];
                            if (!field.isDisplayed(false)) continue;
                            value = field.getHeader();
                        }
                        catch (Exception ex) {
                            this.log.log(Level.WARNING, "Copy-headers", ex);
                        }
                        value = this.fixString(value);
                        sb.append(value).append("\t");
                    }
                    sb.append(Env.NL);
                }
                for (int row : selectedRows) {
                    for (int col = 0; col < colscount; ++col) {
                        Lookup lookup = null;
                        String value = null;
                        Object key = null;
                        GridField field = null;
                        try {
                            key = this.table.getValueAt(row, col);
                            field = fields[col];
                            if (!field.isDisplayed(false)) continue;
                            if (field.isEncryptedColumn() || field.isEncryptedField()) {
                                value = "*";
                            } else if (key instanceof Boolean) {
                                value = Msg.getMsg(Env.getCtx(), (Boolean)key != false ? "Yes" : "No");
                            } else if (key instanceof BigDecimal) {
                                try {
                                    value = sysNumberFormat.format(key != null ? key : Env.ZERO);
                                }
                                catch (Exception exception) {}
                            } else if (key instanceof Date) {
                                try {
                                    value = sysDateFormat.format(key);
                                }
                                catch (Exception exception) {}
                            } else {
                                lookup = field != null ? field.getLookup() : null;
                                String string = value = lookup != null && key != null ? lookup.getDisplay(key) : null;
                                if (value == null && key != null) {
                                    value = key.toString();
                                }
                            }
                        }
                        catch (Exception ex) {
                            this.log.log(Level.WARNING, "Copy-rows", ex);
                        }
                        value = this.fixString(value);
                        sb.append(value).append("\t");
                        if (!CLogMgt.isLevelFinest()) continue;
                        this.log.finest("col=" + col + ", row=" + row + ": key=" + key + " => value=" + value + ", " + field + ", " + lookup);
                    }
                    sb.append(Env.NL);
                }
                StringSelection stsel = new StringSelection(sb.toString());
                this.system = Toolkit.getDefaultToolkit().getSystemClipboard();
                this.system.setContents(stsel, stsel);
            }
            catch (Exception ex) {
                this.log.log(Level.WARNING, "Copy", ex);
            }
        }
    }

    private String fixString(String s) {
        if (s == null || s.length() == 0) {
            return "";
        }
        String s2 = s.replaceAll("[\t\n\f\r]+", " ");
        return s2;
    }
}

