/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.math.BigDecimal;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import org.compiere.apps.AEnv;
import org.compiere.grid.SelectActuatorActuator;
import org.compiere.grid.VSelectActuatorDialog;
import org.compiere.grid.ed.VLookup;
import org.compiere.model.GridTab;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class VSelectActuatorUI
extends SelectActuatorActuator
implements ActionListener,
VetoableChangeListener {
    private static final int WINDOW_CUSTOMER_RETURN = 53097;
    private static final int WINDOW_RETURN_TO_VENDOR = 53098;
    private VSelectActuatorDialog dialog;
    private int p_WindowNo;
    private CLogger log = CLogger.getCLogger(this.getClass());
    private JLabel prLabel = new JLabel();
    private VLookup prField;
    String PrdVal = "";
    private VLookup qline;
    private JButton searchButton = new JButton();
    private JLabel lblonoffmod = new JLabel();
    private JComboBox onoffmodField = new JComboBox();
    private JLabel lblvolt = new JLabel();
    private JComboBox voltField = new JComboBox();
    private JLabel lblArea = new JLabel();
    private JTextField areaField = new JTextField();
    private JCheckBox withswitch = new JCheckBox();
    private JCheckBox withspringret = new JCheckBox();
    private boolean m_actionActive = false;

    public VSelectActuatorUI(GridTab mTab) {
        super(mTab);
        this.log.info(this.getGridTab().toString());
        this.dialog = new VSelectActuatorDialog(this, this.getGridTab().getWindowNo(), true);
        this.p_WindowNo = this.getGridTab().getWindowNo();
        try {
            if (!this.dynInit()) {
                return;
            }
            this.jbInit();
            this.setInitOK(true);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "", e);
            this.setInitOK(false);
        }
        AEnv.positionCenterWindow(Env.getWindow(this.p_WindowNo), this.dialog);
    }

    @Override
    public boolean dynInit() throws Exception {
        this.log.config("");
        super.dynInit();
        this.dialog.setTitle(this.getTitle());
        this.withswitch.setSelected(false);
        this.withswitch.addActionListener(this);
        this.withspringret.setSelected(false);
        this.withspringret.addActionListener(this);
        this.initArea();
        this.onoffmodField.addActionListener(this);
        this.voltField.addActionListener(this);
        this.areaField.setEditable(false);
        return true;
    }

    private void jbInit() throws Exception {
        boolean isRMAWindow = this.getGridTab().getAD_Window_ID() == 53098 || this.getGridTab().getAD_Window_ID() == 53097;
        this.lblonoffmod.setText("OnOff / Modulating");
        this.lblvolt.setText(Msg.getElement(Env.getCtx(), "Volt", false));
        this.withswitch.setText("With Auxiliary Switch [Y/N]");
        this.withspringret.setText("With Spring Return [Y/N]");
        KeyNamePair pp1 = new KeyNamePair(0, "ON/OFF");
        this.onoffmodField.addItem(pp1);
        KeyNamePair pp = new KeyNamePair(1, "MODULATING");
        this.onoffmodField.addItem(pp);
        KeyNamePair pv = new KeyNamePair(230, "230V");
        this.voltField.addItem(pv);
        KeyNamePair pv1 = new KeyNamePair(24, "24V");
        this.voltField.addItem(pv1);
        CPanel parameterPanel = this.dialog.getParameterPanel();
        parameterPanel.setLayout(new BorderLayout());
        CPanel parameterStdPanel = new CPanel(new GridBagLayout());
        parameterPanel.add((Component)parameterStdPanel, "Center");
        parameterStdPanel.add((Component)this.lblvolt, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        parameterStdPanel.add((Component)this.voltField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        parameterStdPanel.add((Component)this.lblonoffmod, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        parameterStdPanel.add((Component)this.onoffmodField, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        parameterStdPanel.add((Component)this.lblArea, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        parameterStdPanel.add((Component)this.areaField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        parameterStdPanel.add((Component)this.withswitch, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        parameterStdPanel.add((Component)this.withspringret, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        if (this.PrdVal.equalsIgnoreCase("EBP1") | this.PrdVal.equalsIgnoreCase("EBP2") | this.PrdVal.equalsIgnoreCase("EBP3") | this.PrdVal.equalsIgnoreCase("EBP4") | this.PrdVal.equalsIgnoreCase("EBP5") | this.PrdVal.equalsIgnoreCase("EBP6") | this.PrdVal.equalsIgnoreCase("EBP7") | this.PrdVal.equalsIgnoreCase("EBP8") | this.PrdVal.equalsIgnoreCase("SDVBP") | this.PrdVal.equalsIgnoreCase("SDVBPE")) {
            this.withspringret.setEnabled(false);
            this.onoffmodField.removeAllItems();
            this.onoffmodField.addItem(pp);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        KeyNamePair pp;
        this.log.config("Action=" + e.getActionCommand());
        if (this.m_actionActive) {
            return;
        }
        this.m_actionActive = true;
        this.log.config("Action=" + e.getActionCommand());
        if (e.getSource().equals(this.onoffmodField)) {
            this.dialog.getMiniTable().getModel().removeTableModelListener(this.dialog);
            pp = (KeyNamePair)this.onoffmodField.getSelectedItem();
            if (pp != null) {
                this.OnOffMod = pp.getKey() == 0 ? "O" : "M";
            }
            this.loadActuator();
        }
        if (e.getSource().equals(this.voltField)) {
            this.dialog.getMiniTable().getModel().removeTableModelListener(this.dialog);
            pp = (KeyNamePair)this.voltField.getSelectedItem();
            if (pp != null) {
                this.volt = pp.getKey();
            }
            this.loadActuator();
        }
        if (e.getSource().equals(this.withspringret)) {
            this.dialog.getMiniTable().getModel().removeTableModelListener(this.dialog);
            this.fspring = this.withspringret.isSelected() ? (char)84 : (char)70;
            this.loadActuator();
        }
        if (e.getSource().equals(this.withswitch)) {
            this.dialog.getMiniTable().getModel().removeTableModelListener(this.dialog);
            this.fswitch = this.withswitch.isSelected() ? (char)84 : (char)70;
            this.loadActuator();
        }
        if (e.getSource().equals(this.searchButton)) {
            this.loadActuator();
        }
        this.m_actionActive = false;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent e) {
        this.log.config(e.getPropertyName() + "=" + e.getNewValue());
        if (e.getPropertyName().equals("OK")) {
            int n = (Integer)e.getNewValue();
        }
        this.dialog.tableChanged(null);
    }

    protected void initArea() throws Exception {
        String dqString;
        int AD_Column_ID = 1000455;
        BigDecimal arp = null;
        MLookup lookup = MLookupFactory.get(Env.getCtx(), this.p_WindowNo, 0, AD_Column_ID, 30);
        this.prField = new VLookup("M_Product_ID", true, false, true, lookup);
        AD_Column_ID = 1000453;
        MLookup lookup1 = MLookupFactory.get(Env.getCtx(), this.p_WindowNo, 0, AD_Column_ID, 30);
        this.qline = new VLookup("C_QUOTATIONLINE_ID", true, false, true, lookup);
        int qline_id = Env.getContextAsInt(Env.getCtx(), this.p_WindowNo, "C_QUOTATIONLINE_ID");
        int M_Product_ID = Env.getContextAsInt(Env.getCtx(), this.p_WindowNo, "M_Product_ID");
        String sqlprd = " select Value from m_product where m_product_id = ? ";
        this.PrdVal = DB.getSQLValueString(null, sqlprd, M_Product_ID);
        if (this.PrdVal.equalsIgnoreCase("SDVBP") | this.PrdVal.equalsIgnoreCase("SDVBPE") | this.PrdVal.equalsIgnoreCase("VDR") | this.PrdVal.equalsIgnoreCase("VDR-SMC") | this.PrdVal.equalsIgnoreCase("VDRBB")) {
            dqString = " select A from C_QUOTATIONLINE where C_QUOTATIONLINE_ID = ? ";
            String AvalS = DB.getSQLValueString(null, dqString, qline_id);
            float Aval = Float.parseFloat(AvalS) / 2.0f;
            dqString = " select unit from C_QUOTATIONLINE where C_QUOTATIONLINE_ID = ? ";
            String unitval = DB.getSQLValueString(null, dqString, qline_id);
            if (unitval.equals("M")) {
                Aval = (float)((double)Aval * 0.001);
            } else if (unitval.equals("I")) {
                Aval = (float)((double)Aval * 0.0254);
            }
            this.areav = (float)(3.14 * (double)(Aval * Aval));
            this.actqty = new BigDecimal(1);
            arp = new BigDecimal(this.areav);
            arp = arp.setScale(3, 4);
        } else if (this.PrdVal.equalsIgnoreCase("EBP1") | this.PrdVal.equalsIgnoreCase("EBP2") | this.PrdVal.equalsIgnoreCase("EBP3") | this.PrdVal.equalsIgnoreCase("EBP4")) {
            this.areav = 1.0f;
            this.actqty = new BigDecimal(1);
            arp = new BigDecimal(this.areav);
            arp = arp.setScale(3, 4);
        } else if (this.PrdVal.equalsIgnoreCase("EBP5") | this.PrdVal.equalsIgnoreCase("EBP6") | this.PrdVal.equalsIgnoreCase("EBP7") | this.PrdVal.equalsIgnoreCase("EBP8")) {
            this.areav = 1.0f;
            this.actqty = new BigDecimal(1);
            arp = new BigDecimal(this.areav);
            arp = arp.setScale(3, 4);
        } else {
            dqString = " select A from C_QUOTATIONLINE where C_QUOTATIONLINE_ID = ? ";
            String Aht = DB.getSQLValueString(null, dqString, qline_id);
            float Ahtv = Float.parseFloat(Aht);
            dqString = " select B from C_QUOTATIONLINE where C_QUOTATIONLINE_ID = ? ";
            String Bwd = DB.getSQLValueString(null, dqString, qline_id);
            float Bwdv = Float.parseFloat(Bwd);
            dqString = " select unit from C_QUOTATIONLINE where C_QUOTATIONLINE_ID = ? ";
            String unitval = DB.getSQLValueString(null, dqString, qline_id);
            if (unitval.equalsIgnoreCase("M")) {
                Ahtv = (float)((double)Ahtv * 0.001);
                Bwdv = (float)((double)Bwdv * 0.001);
            } else if (unitval.equalsIgnoreCase("I")) {
                Ahtv = (float)((double)Ahtv * 0.0254);
                Bwdv = (float)((double)Bwdv * 0.0254);
            }
            this.areav = Ahtv * Bwdv;
            arp = new BigDecimal(this.areav);
            arp = arp.setScale(3, 4);
        }
        String ar = Float.toString(this.areav);
        this.areaField.setText(arp.toString());
        if (this.PrdVal.equalsIgnoreCase("AUVCDF") | this.PrdVal.equalsIgnoreCase("AUVCDB") | this.PrdVal.equalsIgnoreCase("AUVCDH") | this.PrdVal.equalsIgnoreCase("AUVCDS") | this.PrdVal.equalsIgnoreCase("AGVCDF") | this.PrdVal.equalsIgnoreCase("AGVCDB") | this.PrdVal.equalsIgnoreCase("AGVCDS") | this.PrdVal.equalsIgnoreCase("LVCDF") | this.PrdVal.equalsIgnoreCase("LVCDH") | this.PrdVal.equalsIgnoreCase("3VCDF") | this.PrdVal.equalsIgnoreCase("3VCDB") | this.PrdVal.equalsIgnoreCase("3VCDH") | this.PrdVal.equalsIgnoreCase("3VCDS") | this.PrdVal.equalsIgnoreCase("PI3VCD") | this.PrdVal.equalsIgnoreCase("PIAVCD")) {
            String dqString2 = " select A from C_QUOTATIONLINE where C_QUOTATIONLINE_ID = ? ";
            String Aht = DB.getSQLValueString(null, dqString2, qline_id);
            float Ahtv = Float.parseFloat(Aht);
            dqString2 = " select B from C_QUOTATIONLINE where C_QUOTATIONLINE_ID = ? ";
            String Bwd = DB.getSQLValueString(null, dqString2, qline_id);
            float Bwdv = Float.parseFloat(Bwd);
            dqString2 = " select unit from C_QUOTATIONLINE where C_QUOTATIONLINE_ID = ? ";
            String unitval = DB.getSQLValueString(null, dqString2, qline_id);
            if (Bwdv > 0.0f & Ahtv > 0.0f) {
                double aMM = 0.0;
                double bMM = 0.0;
                BigDecimal actQty = Env.ZERO;
                if (unitval.equalsIgnoreCase("I")) {
                    aMM = Math.round(Ahtv * 25.0f);
                    bMM = Math.round(Bwdv * 25.0f);
                } else if (unitval.equalsIgnoreCase("M")) {
                    aMM = Ahtv;
                    bMM = Bwdv;
                }
                if (aMM <= 1200.0 & bMM <= 1200.0) {
                    actQty = new BigDecimal(1);
                } else if (aMM > 1200.0 & bMM <= 1200.0) {
                    actQty = new BigDecimal(2);
                } else if (aMM <= 1200.0 & bMM > 1200.0) {
                    actQty = new BigDecimal(2);
                } else if (aMM > 1200.0 & bMM > 1200.0) {
                    actQty = new BigDecimal(4);
                }
                this.actqty = actQty;
                this.actqty = actQty;
                this.areav /= actQty.floatValue();
                ar = Float.toString(this.areav);
                arp = new BigDecimal(ar);
                arp = arp.setScale(3, 4);
                if (actQty.intValue() > 1) {
                    this.lblArea.setText("");
                    this.lblArea.setText("Multi Section Area(m2) ");
                } else {
                    this.lblArea.setText(" Area(m2) ");
                }
            }
        } else {
            this.lblArea.setText(" Area(m2) ");
        }
        this.areaField.setText(arp.toString());
    }

    protected void loadActuator() {
        this.loadTableOIS(this.getActuatorData());
    }

    protected void loadTableOIS(Vector<?> data) {
        this.dialog.getMiniTable().getModel().removeTableModelListener(this.dialog);
        DefaultTableModel model = new DefaultTableModel(data, this.getOISColumnNames());
        model.addTableModelListener(this.dialog);
        this.dialog.getMiniTable().setModel(model);
        this.configureMiniTable(this.dialog.getMiniTable());
    }

    @Override
    public void showWindow() {
        this.dialog.setVisible(true);
    }

    @Override
    public void closeWindow() {
        this.dialog.dispose();
    }

    public void okWindow() {
    }
}

