/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.logging.Level;
import org.compiere.grid.ISelectActuator;
import org.compiere.grid.VSelectActuatorUI;
import org.compiere.model.GridTab;
import org.compiere.model.I_C_QUOTATIONLINE;
import org.compiere.util.CLogger;

public class VSelectActuatorFactory {
    private static CLogger s_log = CLogger.getCLogger(VSelectActuatorFactory.class);
    private static HashMap<Integer, Class<? extends ISelectActuator>> s_registeredClasses = null;

    public static final void registerClass(int ad_table_id, Class<? extends ISelectActuator> cl) {
        s_registeredClasses.put(ad_table_id, cl);
        s_log.info("Registered AD_Table_ID=" + ad_table_id + ", Class=" + cl);
    }

    public static ISelectActuator create(GridTab mTab) {
        int AD_Table_ID = 1000025;
        ISelectActuator retValue = null;
        Class<? extends ISelectActuator> cl = s_registeredClasses.get(AD_Table_ID);
        if (cl != null) {
            try {
                Constructor<? extends ISelectActuator> ctor = cl.getConstructor(GridTab.class);
                retValue = ctor.newInstance(mTab);
            }
            catch (Throwable e) {
                s_log.log(Level.SEVERE, e.getLocalizedMessage(), e);
                return null;
            }
        }
        if (retValue == null) {
            s_log.info("Unsupported AD_Table_ID=" + AD_Table_ID);
            return null;
        }
        return retValue;
    }

    static {
        s_registeredClasses = new HashMap();
        s_registeredClasses.put(I_C_QUOTATIONLINE.Table_ID, VSelectActuatorUI.class);
    }
}

