/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.db;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import javax.sql.RowSet;
import org.adempiere.exceptions.DBException;
import org.compiere.util.CCachedRowSet;
import org.compiere.util.CLogger;
import org.compiere.util.CStatementVO;
import org.compiere.util.DB;
import org.compiere.util.Trx;

public class StatementProxy
implements InvocationHandler {
    protected Connection m_conn = null;
    private boolean close = false;
    protected transient CLogger log = CLogger.getCLogger(this.getClass());
    protected transient Statement p_stmt = null;
    protected CStatementVO p_vo = null;

    public StatementProxy(int resultSetType, int resultSetConcurrency, String trxName) {
        this.p_vo = new CStatementVO(resultSetType, resultSetConcurrency);
        this.p_vo.setTrxName(trxName);
        this.init();
    }

    public StatementProxy(CStatementVO vo) {
        this.p_vo = vo;
        this.init();
    }

    protected StatementProxy() {
    }

    @Override
    public Object invoke(Object obj, Method method, Object[] args) throws Throwable {
        String name = method.getName();
        if (name.equals("executeQuery") || name.equals("executeUpdate") || name.equals("execute") || name.equals("addBatch")) {
            if (args != null && args.length > 0 && args[0] != null && args[0] instanceof String) {
                String sql = (String)args[0];
                this.p_vo.setSql(DB.getDatabase().convertStatement(sql));
                args[0] = this.p_vo.getSql();
            }
        } else {
            if (name.equals("close") && (args == null || args.length == 0)) {
                this.close();
                return null;
            }
            if (name.equals("getRowSet") && (args == null || args.length == 0)) {
                return this.getRowSet();
            }
            if (name.equals("isClosed") && (args == null || args.length == 0)) {
                return this.close;
            }
            if (name.equals("finalize") && (args == null || args.length == 0)) {
                if (this.p_stmt != null && !this.close) {
                    this.close();
                }
                return null;
            }
            if (name.equals("commit") && (args == null || args.length == 0)) {
                this.commit();
                return null;
            }
            if (name.equals("getSql") && (args == null || args.length == 0)) {
                return this.getSql();
            }
        }
        Method m = this.p_stmt.getClass().getMethod(name, method.getParameterTypes());
        try {
            return m.invoke((Object)this.p_stmt, args);
        }
        catch (InvocationTargetException e) {
            throw DB.getSQLException(e);
        }
    }

    protected void init() {
        try {
            Trx trx;
            Connection conn = null;
            Trx trx2 = trx = this.p_vo.getTrxName() == null ? null : Trx.get(this.p_vo.getTrxName(), false);
            if (trx != null) {
                conn = trx.getConnection();
            } else {
                this.m_conn = this.p_vo.getResultSetConcurrency() == 1008 ? DB.getConnectionRW() : DB.getConnectionRO();
                conn = this.m_conn;
            }
            if (conn == null) {
                throw new DBException("No Connection");
            }
            this.p_stmt = conn.createStatement(this.p_vo.getResultSetType(), this.p_vo.getResultSetConcurrency());
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "CStatement", e);
            throw new DBException(e);
        }
    }

    private void close() throws SQLException {
        if (this.close) {
            return;
        }
        try {
            if (this.p_stmt != null) {
                this.p_stmt.close();
            }
        }
        finally {
            if (this.m_conn != null) {
                try {
                    this.m_conn.close();
                }
                catch (Exception exception) {}
            }
            this.m_conn = null;
            this.close = true;
        }
    }

    protected RowSet getRowSet() {
        this.log.finest("getRowSet");
        RowSet rowSet = null;
        ResultSet rs = null;
        try {
            rs = this.p_stmt.executeQuery(this.p_vo.getSql());
            rowSet = CCachedRowSet.getRowSet(rs);
        }
        catch (Exception ex) {
            try {
                this.log.log(Level.SEVERE, this.p_vo.toString(), ex);
                throw new RuntimeException(ex);
            }
            catch (Throwable throwable) {
                DB.close(rs);
                throw throwable;
            }
        }
        DB.close(rs);
        return rowSet;
    }

    private void commit() throws SQLException {
        if (this.m_conn != null && !this.m_conn.getAutoCommit()) {
            this.m_conn.commit();
        }
    }

    public String getSql() {
        if (this.p_vo != null) {
            return this.p_vo.getSql();
        }
        return null;
    }
}

