/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.wf;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableModel;
import org.compiere.apps.ADialog;
import org.compiere.apps.AEnv;
import org.compiere.apps.AMenu;
import org.compiere.apps.AWindow;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.StatusBar;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.grid.ed.VLookup;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.MColumn;
import org.compiere.model.MQuery;
import org.compiere.model.MRefList;
import org.compiere.model.MRole;
import org.compiere.model.MSysConfig;
import org.compiere.swing.CButton;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CScrollPane;
import org.compiere.swing.CTextArea;
import org.compiere.swing.CTextField;
import org.compiere.swing.CTextPane;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.ValueNamePair;
import org.compiere.wf.MWFActivity;
import org.compiere.wf.MWFNode;

public class WFActivity
extends CPanel
implements FormPanel,
ActionListener,
ListSelectionListener {
    private static final long serialVersionUID = 6917300855914216420L;
    private static final int MAX_ACTIVITIES_IN_LIST = MSysConfig.getIntValue("MAX_ACTIVITIES_IN_LIST", 200, Env.getAD_Client_ID(Env.getCtx()));
    private int m_WindowNo = 0;
    private FormFrame m_frame = null;
    private AMenu m_menu = null;
    private MWFActivity m_activity = null;
    private MColumn m_column = null;
    private int columnValue = -1;
    private int columnNewValue = -1;
    private static CLogger log = CLogger.getCLogger(WFActivity.class);
    DefaultTableModel selTableModel = new DefaultTableModel(new String[]{"ID", Msg.translate(Env.getCtx(), "Priority"), Msg.translate(Env.getCtx(), "AD_WF_Node_ID"), Msg.translate(Env.getCtx(), "Summary")}, 0);
    private MiniTable selTable = new MiniTable();
    private CScrollPane selPane = new CScrollPane(this.selTable);
    private CPanel centerPanel = new CPanel();
    private GridBagLayout centerLayout = new GridBagLayout();
    private CLabel lNode = new CLabel(Msg.translate(Env.getCtx(), "AD_WF_Node_ID"));
    private CTextField fNode = new CTextField();
    private CLabel lDesctiption = new CLabel(Msg.translate(Env.getCtx(), "Description"));
    private CTextArea fDescription = new CTextArea();
    private CLabel lHelp = new CLabel(Msg.translate(Env.getCtx(), "Help"));
    private CTextArea fHelp = new CTextArea();
    private CLabel lHistory = new CLabel(Msg.translate(Env.getCtx(), "History"));
    private CTextPane fHistory = new CTextPane();
    private CLabel lAnswer = new CLabel(Msg.getMsg(Env.getCtx(), "Answer"));
    private CPanel answers = new CPanel(new FlowLayout(3));
    private CTextField fAnswerText = new CTextField();
    private CComboBox fAnswerList = new CComboBox();
    private CButton fAnswerButton = new CButton();
    private CButton bZoom = AEnv.getButton("Zoom");
    private CLabel lTextMsg = new CLabel(Msg.getMsg(Env.getCtx(), "Messages"));
    private CTextArea fTextMsg = new CTextArea();
    private CButton bOK = ConfirmPanel.createOKButton(true);
    private VLookup fForward = null;
    private CLabel lForward = new CLabel(Msg.getMsg(Env.getCtx(), "Forward"));
    private CLabel lOptional = new CLabel("(" + Msg.translate(Env.getCtx(), "Optional") + ")");
    private StatusBar statusBar = new StatusBar();

    public WFActivity() {
    }

    public WFActivity(AMenu menu) {
        log.config("");
        try {
            this.dynInit(0);
            this.jbInit();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
        this.m_menu = menu;
    }

    private void dynInit(int WindowNo) {
        this.loadActivities();
        this.fForward = VLookup.createUser(WindowNo);
    }

    private void jbInit() throws Exception {
        int width = 150;
        this.centerPanel.setLayout(this.centerLayout);
        this.fNode.setReadWrite(false);
        this.fDescription.setReadWrite(false);
        this.fDescription.setPreferredSize(new Dimension(width, 40));
        this.fHelp.setReadWrite(false);
        this.fHelp.setPreferredSize(new Dimension(width, 40));
        this.fHistory.setReadWrite(false);
        this.fHistory.setPreferredSize(new Dimension(width, 80));
        this.fTextMsg.setPreferredSize(new Dimension(width, 40));
        this.selTable.setModel(this.selTableModel);
        this.selTable.setColumnClass(0, IDColumn.class, false, " ");
        this.selTable.setColumnClass(1, Integer.class, true);
        this.selTable.setColumnClass(2, String.class, true);
        this.selTable.setColumnClass(3, String.class, true);
        this.selTable.getSelectionModel().addListSelectionListener(this);
        this.selTable.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnMoved(TableColumnModelEvent e) {
                if (WFActivity.this.columnValue == -1) {
                    WFActivity.this.columnValue = e.getFromIndex();
                }
                WFActivity.this.columnNewValue = e.getToIndex();
            }

            @Override
            public void columnAdded(TableColumnModelEvent e) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        });
        this.selTable.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (WFActivity.this.columnValue != -1 && (WFActivity.this.columnValue == 0 || WFActivity.this.columnNewValue == 0)) {
                    WFActivity.this.selTable.moveColumn(WFActivity.this.columnNewValue, WFActivity.this.columnValue);
                }
                WFActivity.this.columnValue = -1;
                WFActivity.this.columnNewValue = -1;
            }
        });
        this.bZoom.addActionListener(this);
        this.bOK.addActionListener(this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.centerPanel, "Center");
        this.add((Component)this.statusBar, "South");
        this.answers.add(this.fAnswerText);
        this.answers.add(this.fAnswerList);
        this.answers.add(this.fAnswerButton);
        this.fAnswerButton.addActionListener(this);
        int row = 0;
        this.selPane.setPreferredSize(new Dimension(width, 60));
        this.selPane.setMinimumSize(new Dimension(100, 60));
        this.centerPanel.add((Component)this.selPane, new GridBagConstraints(0, row, 4, 1, 0.3, 0.3, 18, 1, new Insets(5, 10, 5, 10), 0, 0));
        this.centerPanel.add((Component)this.lNode, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 10, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.fNode, new GridBagConstraints(1, row, 3, 2, 0.5, 0.0, 18, 2, new Insets(5, 0, 5, 10), 0, 0));
        this.centerPanel.add((Component)this.lDesctiption, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 10, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.fDescription, new GridBagConstraints(1, row, 3, 1, 0.0, 0.0, 18, 2, new Insets(5, 0, 5, 10), 0, 0));
        this.centerPanel.add((Component)this.lHelp, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 12, 0, new Insets(2, 10, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.fHelp, new GridBagConstraints(1, row, 3, 1, 0.0, 0.0, 18, 2, new Insets(2, 0, 5, 10), 0, 0));
        this.centerPanel.add((Component)this.lHistory, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 10, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.fHistory, new GridBagConstraints(1, row, 3, 1, 0.5, 0.5, 18, 1, new Insets(5, 0, 5, 10), 0, 0));
        this.centerPanel.add((Component)this.lAnswer, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.answers, new GridBagConstraints(1, row, 2, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.bZoom, new GridBagConstraints(3, row, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 0, 10, 10), 0, 0));
        this.centerPanel.add((Component)this.lTextMsg, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 10, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.fTextMsg, new GridBagConstraints(1, row, 3, 1, 0.5, 0.0, 18, 2, new Insets(5, 0, 5, 10), 0, 0));
        this.centerPanel.add((Component)this.lForward, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.fForward, new GridBagConstraints(1, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 5, 0), 0, 0));
        this.centerPanel.add((Component)this.lOptional, new GridBagConstraints(2, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.bOK, new GridBagConstraints(3, row, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 5, 5, 10), 0, 0));
    }

    @Override
    public void init(int WindowNo, FormFrame frame) {
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        log.info("");
        try {
            this.dynInit(WindowNo);
            this.jbInit();
            frame.getContentPane().add((Component)this, "Center");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
    }

    @Override
    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActivitiesCount() {
        int count = 0;
        String sql = "SELECT count(*) FROM AD_WF_Activity a WHERE a.Processed='N' AND a.WFState='OS' AND ( a.AD_User_ID=? OR EXISTS (SELECT * FROM AD_WF_Responsible r WHERE a.AD_WF_Responsible_ID=r.AD_WF_Responsible_ID AND COALESCE(r.AD_User_ID,0)=0 AND COALESCE(r.AD_Role_ID,0)=0 AND (a.AD_User_ID=? OR a.AD_User_ID IS NULL)) OR EXISTS (SELECT * FROM AD_WF_Responsible r WHERE a.AD_WF_Responsible_ID=r.AD_WF_Responsible_ID AND r.AD_User_ID=?) OR EXISTS (SELECT * FROM AD_WF_Responsible r INNER JOIN AD_User_Roles ur ON (r.AD_Role_ID=ur.AD_Role_ID) WHERE a.AD_WF_Responsible_ID=r.AD_WF_Responsible_ID AND ur.AD_User_ID=?))";
        int AD_User_ID = Env.getAD_User_ID(Env.getCtx());
        MRole role = MRole.get(Env.getCtx(), Env.getAD_Role_ID(Env.getCtx()));
        sql = role.addAccessSQL(sql, "a", true, false);
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_User_ID);
            pstmt.setInt(2, AD_User_ID);
            pstmt.setInt(3, AD_User_ID);
            pstmt.setInt(4, AD_User_ID);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                count = rs.getInt(1);
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int loadActivities() {
        while (this.selTableModel.getRowCount() > 0) {
            this.selTableModel.removeRow(0);
        }
        long start = System.currentTimeMillis();
        ArrayList list = new ArrayList();
        String sql = "SELECT * FROM AD_WF_Activity a WHERE a.Processed='N' AND a.WFState='OS' AND ( a.AD_User_ID=? OR EXISTS (SELECT * FROM AD_WF_Responsible r WHERE a.AD_WF_Responsible_ID=r.AD_WF_Responsible_ID AND COALESCE(r.AD_User_ID,0)=0 AND COALESCE(r.AD_Role_ID,0)=0 AND (a.AD_User_ID=? OR a.AD_User_ID IS NULL)) OR EXISTS (SELECT * FROM AD_WF_Responsible r WHERE a.AD_WF_Responsible_ID=r.AD_WF_Responsible_ID AND r.AD_User_ID=?) OR EXISTS (SELECT * FROM AD_WF_Responsible r INNER JOIN AD_User_Roles ur ON (r.AD_Role_ID=ur.AD_Role_ID) WHERE a.AD_WF_Responsible_ID=r.AD_WF_Responsible_ID AND ur.AD_User_ID=?)) ORDER BY a.Priority DESC, Created";
        int AD_User_ID = Env.getAD_User_ID(Env.getCtx());
        MRole role = MRole.get(Env.getCtx(), Env.getAD_Role_ID(Env.getCtx()));
        sql = role.addAccessSQL(sql, "a", true, false);
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_User_ID);
            pstmt.setInt(2, AD_User_ID);
            pstmt.setInt(3, AD_User_ID);
            pstmt.setInt(4, AD_User_ID);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                MWFActivity activity = new MWFActivity(Env.getCtx(), rs, null);
                Object[] rowData = new Object[]{new IDColumn(activity.get_ID()), activity.getPriority(), activity.getNodeName(), activity.getSummary()};
                this.selTableModel.addRow(rowData);
                if (list.size() <= MAX_ACTIVITIES_IN_LIST) continue;
                log.warning("More than " + MAX_ACTIVITIES_IN_LIST + " Activities - ignored");
                break;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        this.selTable.autoSize(false);
        log.fine("#" + this.selTable.getModel().getRowCount() + "(" + (System.currentTimeMillis() - start) + "ms)");
        return this.selTable.getModel().getRowCount();
    }

    public void display(IDColumn id) {
        log.fine("ID=" + id);
        this.m_activity = this.resetDisplay(id);
        if (this.m_menu != null) {
            this.m_menu.updateActivities(this.selTable.getModel().getRowCount());
        }
        if (this.m_activity == null) {
            return;
        }
        this.fNode.setText(this.m_activity.getNodeName());
        this.fDescription.setText(this.m_activity.getNodeDescription());
        this.fHelp.setText(this.m_activity.getNodeHelp());
        this.fHistory.setText(this.m_activity.getHistoryHTML());
        MWFNode node = this.m_activity.getNode();
        if ("C".equals(node.getAction())) {
            if (this.m_column == null) {
                this.m_column = node.getColumn();
            }
            if (this.m_column != null && this.m_column.get_ID() != 0) {
                int dt = this.m_column.getAD_Reference_ID();
                if (dt == 20) {
                    ValueNamePair[] values = MRefList.getList(Env.getCtx(), 319, false);
                    this.fAnswerList.setModel(new DefaultComboBoxModel<ValueNamePair>(values));
                    this.fAnswerList.setVisible(true);
                } else if (dt == 17) {
                    ValueNamePair[] values = MRefList.getList(Env.getCtx(), this.m_column.getAD_Reference_Value_ID(), false);
                    this.fAnswerList.setModel(new DefaultComboBoxModel<ValueNamePair>(values));
                    this.fAnswerList.setVisible(true);
                } else {
                    this.fAnswerText.setText("");
                    this.fAnswerText.setVisible(true);
                }
            }
        } else if ("W".equals(node.getAction()) || "X".equals(node.getAction())) {
            this.fAnswerButton.setText(node.getName());
            this.fAnswerButton.setToolTipText(node.getDescription());
            this.fAnswerButton.setVisible(true);
        } else {
            log.log(Level.SEVERE, "Unknown Node Action: " + node.getAction());
        }
        this.statusBar.setStatusDB(String.valueOf(this.selTable.getSelectedRow() + 1) + "/" + this.selTable.getRowCount());
        this.statusBar.setStatusLine(Msg.getMsg(Env.getCtx(), "WFActivities"));
    }

    private MWFActivity resetDisplay(IDColumn id) {
        this.fAnswerText.setVisible(false);
        this.fAnswerList.setVisible(false);
        this.fAnswerButton.setVisible(false);
        this.fTextMsg.setReadWrite(id != null);
        this.bZoom.setEnabled(id != null);
        this.bOK.setEnabled(id != null);
        this.fForward.setValue(null);
        this.fForward.setEnabled(id != null);
        this.statusBar.setStatusDB(String.valueOf(this.selTable.getSelectedRow() + 1) + "/" + this.selTable.getRowCount());
        this.m_activity = null;
        this.m_column = null;
        this.m_activity = new MWFActivity(Env.getCtx(), (int)id.getRecord_ID(), null);
        if (this.m_activity == null) {
            this.fNode.setText("");
            this.fDescription.setText("");
            this.fHelp.setText("");
            this.fHistory.setText("");
            this.statusBar.setStatusDB("0/0");
            this.statusBar.setStatusLine(Msg.getMsg(Env.getCtx(), "WFNoActivities"));
        }
        return this.m_activity;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        IDColumn id;
        if (this.selTable.getSelectedRow() >= 0 && (id = (IDColumn)this.selTable.getValueAt(this.selTable.getSelectedRow(), 0)) != null) {
            this.display(id);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (e.getSource() == this.bZoom) {
            this.cmd_zoom();
        } else if (e.getSource() == this.bOK) {
            this.cmd_OK();
        } else if (e.getSource() == this.fAnswerButton) {
            this.cmd_button();
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void cmd_zoom() {
        log.config("Activity=" + this.m_activity);
        if (this.m_activity == null) {
            return;
        }
        AEnv.zoom(this.m_activity.getAD_Table_ID(), this.m_activity.getRecord_ID());
    }

    private void cmd_button() {
        log.config("Activity=" + this.m_activity);
        if (this.m_activity == null) {
            return;
        }
        MWFNode node = this.m_activity.getNode();
        if ("W".equals(node.getAction())) {
            int AD_Window_ID = node.getAD_Window_ID();
            String ColumnName = this.m_activity.getPO().get_TableName() + "_ID";
            int Record_ID = this.m_activity.getRecord_ID();
            MQuery query = MQuery.getEqualQuery(ColumnName, Record_ID);
            boolean IsSOTrx = this.m_activity.isSOTrx();
            log.info("Zoom to AD_Window_ID=" + AD_Window_ID + " - " + query + " (IsSOTrx=" + IsSOTrx + ")");
            AWindow frame = new AWindow();
            if (!frame.initWindow(AD_Window_ID, query)) {
                return;
            }
            AEnv.addToWindowManager(frame);
            AEnv.showCenterScreen(frame);
            frame = null;
        } else if ("X".equals(node.getAction())) {
            int AD_Form_ID = node.getAD_Form_ID();
            FormFrame ff = new FormFrame();
            ff.openForm(AD_Form_ID);
            ff.pack();
            AEnv.addToWindowManager(ff);
            AEnv.showCenterScreen(ff);
        } else {
            log.log(Level.SEVERE, "No User Action:" + node.getAction());
        }
    }

    private void cmd_OK() {
        log.config("Activity=" + this.m_activity);
        if (this.m_activity == null) {
            return;
        }
        int AD_User_ID = Env.getAD_User_ID(Env.getCtx());
        String textMsg = this.fTextMsg.getText();
        MWFNode node = this.m_activity.getNode();
        Object forward = this.fForward.getValue();
        Trx trx = Trx.get(Trx.createTrxName("FWFA"), true);
        this.m_activity.set_TrxName(trx.getTrxName());
        if (forward != null) {
            log.config("Forward to " + forward);
            int fw = (Integer)forward;
            if (fw == AD_User_ID || fw == 0) {
                log.log(Level.SEVERE, "Forward User=" + fw);
                trx.rollback();
                trx.close();
                return;
            }
            if (!this.m_activity.forwardTo(fw, textMsg)) {
                ADialog.error(this.m_WindowNo, this, "CannotForward");
                trx.rollback();
                trx.close();
                return;
            }
        } else {
            if ("C".equals(node.getAction())) {
                if (this.m_column == null) {
                    this.m_column = node.getColumn();
                }
                int dt = this.m_column.getAD_Reference_ID();
                String value = this.fAnswerText.getText();
                if (dt == 20 || dt == 17) {
                    ValueNamePair pp = (ValueNamePair)this.fAnswerList.getSelectedItem();
                    value = pp.getValue();
                }
                if (value == null || value.length() == 0) {
                    ADialog.error(this.m_WindowNo, this, "FillMandatory", Msg.getMsg(Env.getCtx(), "Answer"));
                    trx.rollback();
                    trx.close();
                    return;
                }
                log.config("Answer=" + value + " - " + textMsg);
                try {
                    this.m_activity.setUserChoice(AD_User_ID, value, dt, textMsg);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, node.getName(), e);
                    ADialog.error(this.m_WindowNo, this, "Error", e.toString());
                    trx.rollback();
                    trx.close();
                    return;
                }
            }
            log.config("Action=" + node.getAction() + " - " + textMsg);
            try {
                this.m_activity.setUserConfirmation(AD_User_ID, textMsg);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, node.getName(), e);
                ADialog.error(this.m_WindowNo, this, "Error", e.toString());
                trx.rollback();
                trx.close();
                return;
            }
        }
        trx.commit();
        trx.close();
        this.loadActivities();
    }
}

