/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.search;

import java.awt.Component;
import java.awt.Frame;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.ALayout;
import org.compiere.apps.ALayoutConstraint;
import org.compiere.apps.search.Info;
import org.compiere.apps.search.Info_Column;
import org.compiere.grid.ed.VCheckBox;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLookup;
import org.compiere.grid.ed.VNumber;
import org.compiere.minigrid.IDColumn;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MQuery;
import org.compiere.swing.CLabel;
import org.compiere.swing.CTextField;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class InfoOrder
extends Info {
    private static final long serialVersionUID = 2246871771555208114L;
    private Info_Column[] m_generalLayout;
    private ArrayList m_queryColumns = new ArrayList();
    private String m_tableName;
    private String m_keyColumn;
    private CLabel lDocumentNo = new CLabel(Msg.translate(Env.getCtx(), "DocumentNo"));
    private CTextField fDocumentNo = new CTextField(10);
    private CLabel lDescription = new CLabel(Msg.translate(Env.getCtx(), "Description"));
    private CTextField fDescription = new CTextField(10);
    private CLabel lPOReference = new CLabel(Msg.translate(Env.getCtx(), "POReference"));
    private CTextField fPOReference = new CTextField(10);
    private CLabel lBPartner_ID = new CLabel(Msg.translate(Env.getCtx(), "BPartner"));
    private VLookup fBPartner_ID;
    private CLabel lDateFrom = new CLabel(Msg.translate(Env.getCtx(), "DateOrdered"));
    private VDate fDateFrom = new VDate("DateFrom", false, false, true, 15, Msg.translate(Env.getCtx(), "DateFrom"));
    private CLabel lDateTo = new CLabel("-");
    private VDate fDateTo = new VDate("DateTo", false, false, true, 15, Msg.translate(Env.getCtx(), "DateTo"));
    private CLabel lAmtFrom = new CLabel(Msg.translate(Env.getCtx(), "GrandTotal"));
    private VNumber fAmtFrom = new VNumber("AmtFrom", false, false, true, 12, Msg.translate(Env.getCtx(), "AmtFrom"));
    private CLabel lAmtTo = new CLabel("-");
    private VNumber fAmtTo = new VNumber("AmtTo", false, false, true, 12, Msg.translate(Env.getCtx(), "AmtTo"));
    private VCheckBox fIsSOTrx = new VCheckBox("IsSOTrx", false, false, true, Msg.translate(Env.getCtx(), "IsSOTrx"), "", false);
    private static final Info_Column[] s_invoiceLayout = new Info_Column[]{new Info_Column(" ", "o.C_Order_ID", IDColumn.class), new Info_Column(Msg.translate(Env.getCtx(), "C_BPartner_ID"), "(SELECT Name FROM C_BPartner bp WHERE bp.C_BPartner_ID=o.C_BPartner_ID)", String.class), new Info_Column(Msg.translate(Env.getCtx(), "DateOrdered"), "o.DateOrdered", Timestamp.class), new Info_Column(Msg.translate(Env.getCtx(), "DocumentNo"), "o.DocumentNo", String.class), new Info_Column(Msg.translate(Env.getCtx(), "C_Currency_ID"), "(SELECT ISO_Code FROM C_Currency c WHERE c.C_Currency_ID=o.C_Currency_ID)", String.class), new Info_Column(Msg.translate(Env.getCtx(), "GrandTotal"), "o.GrandTotal", BigDecimal.class), new Info_Column(Msg.translate(Env.getCtx(), "ConvertedAmount"), "currencyBase(o.GrandTotal,o.C_Currency_ID,o.DateAcct, o.AD_Client_ID,o.AD_Org_ID)", BigDecimal.class), new Info_Column(Msg.translate(Env.getCtx(), "IsSOTrx"), "o.IsSOTrx", Boolean.class), new Info_Column(Msg.translate(Env.getCtx(), "Description"), "o.Description", String.class), new Info_Column(Msg.translate(Env.getCtx(), "POReference"), "o.POReference", String.class)};

    protected InfoOrder(Frame frame, boolean modal, int WindowNo, String value, boolean multiSelection, String whereClause) {
        super(frame, modal, WindowNo, "o", "C_Order_ID", multiSelection, whereClause);
        this.log.info("InfoOrder");
        this.setTitle(Msg.getMsg(Env.getCtx(), "InfoOrder"));
        try {
            this.statInit();
            this.p_loadedOK = this.initInfo();
        }
        catch (Exception e) {
            return;
        }
        int no = this.p_table.getRowCount();
        this.setStatusLine(Integer.toString(no) + " " + Msg.getMsg(Env.getCtx(), "SearchRows_EnterQuery"), false);
        this.setStatusDB(Integer.toString(no));
        if (value != null && value.length() > 0) {
            this.fDocumentNo.setValue(value);
            this.executeQuery();
        }
        this.pack();
        this.fDocumentNo.requestFocus();
    }

    private void statInit() throws Exception {
        this.lDocumentNo.setLabelFor(this.fDocumentNo);
        this.fDocumentNo.setBackground(AdempierePLAF.getInfoBackground());
        this.fDocumentNo.addActionListener(this);
        this.lDescription.setLabelFor(this.fDescription);
        this.fDescription.setBackground(AdempierePLAF.getInfoBackground());
        this.fDescription.addActionListener(this);
        this.lPOReference.setLabelFor(this.fPOReference);
        this.fPOReference.setBackground(AdempierePLAF.getInfoBackground());
        this.fPOReference.addActionListener(this);
        this.fIsSOTrx.setSelected(!"N".equals(Env.getContext(Env.getCtx(), this.p_WindowNo, "IsSOTrx")));
        this.fIsSOTrx.addActionListener(this);
        this.fBPartner_ID = new VLookup("C_BPartner_ID", false, false, true, MLookupFactory.get(Env.getCtx(), this.p_WindowNo, 0, 3499, 30));
        this.lBPartner_ID.setLabelFor(this.fBPartner_ID);
        this.fBPartner_ID.setBackground(AdempierePLAF.getInfoBackground());
        this.lDateFrom.setLabelFor(this.fDateFrom);
        this.fDateFrom.setBackground(AdempierePLAF.getInfoBackground());
        this.fDateFrom.setToolTipText(Msg.translate(Env.getCtx(), "DateFrom"));
        this.lDateTo.setLabelFor(this.fDateTo);
        this.fDateTo.setBackground(AdempierePLAF.getInfoBackground());
        this.fDateTo.setToolTipText(Msg.translate(Env.getCtx(), "DateTo"));
        this.lAmtFrom.setLabelFor(this.fAmtFrom);
        this.fAmtFrom.setBackground(AdempierePLAF.getInfoBackground());
        this.fAmtFrom.setToolTipText(Msg.translate(Env.getCtx(), "AmtFrom"));
        this.lAmtTo.setLabelFor(this.fAmtTo);
        this.fAmtTo.setBackground(AdempierePLAF.getInfoBackground());
        this.fAmtTo.setToolTipText(Msg.translate(Env.getCtx(), "AmtTo"));
        this.parameterPanel.setLayout(new ALayout());
        this.parameterPanel.add((Component)this.lDocumentNo, new ALayoutConstraint(0, 0));
        this.parameterPanel.add((Component)this.fDocumentNo, null);
        this.parameterPanel.add((Component)this.lBPartner_ID, null);
        this.parameterPanel.add((Component)this.fBPartner_ID, null);
        this.parameterPanel.add((Component)this.fIsSOTrx, new ALayoutConstraint(0, 5));
        this.parameterPanel.add((Component)this.lDescription, new ALayoutConstraint(1, 0));
        this.parameterPanel.add((Component)this.fDescription, null);
        this.parameterPanel.add((Component)this.lDateFrom, null);
        this.parameterPanel.add((Component)this.fDateFrom, null);
        this.parameterPanel.add((Component)this.lDateTo, null);
        this.parameterPanel.add((Component)this.fDateTo, null);
        this.parameterPanel.add((Component)this.lPOReference, new ALayoutConstraint(2, 0));
        this.parameterPanel.add((Component)this.fPOReference, null);
        this.parameterPanel.add((Component)this.lAmtFrom, null);
        this.parameterPanel.add((Component)this.fAmtFrom, null);
        this.parameterPanel.add((Component)this.lAmtTo, null);
        this.parameterPanel.add((Component)this.fAmtTo, null);
    }

    private boolean initInfo() {
        String bp = Env.getContext(Env.getCtx(), this.p_WindowNo, "C_BPartner_ID");
        if (bp != null && bp.length() != 0) {
            this.fBPartner_ID.setValue(new Integer(bp));
        }
        StringBuffer where = new StringBuffer("o.IsActive='Y'");
        if (this.p_whereClause.length() > 0) {
            where.append(" AND ").append(Util.replace(this.p_whereClause, "C_Order.", "o."));
        }
        this.prepareTable(s_invoiceLayout, " C_Order o", where.toString(), "2,3,4");
        return true;
    }

    @Override
    protected String getSQLWhere() {
        Comparable<Date> to;
        Comparable<Date> from;
        StringBuffer sql = new StringBuffer();
        if (this.fDocumentNo.getText().length() > 0) {
            sql.append(" AND UPPER(o.DocumentNo) LIKE ?");
        }
        if (this.fDescription.getText().length() > 0) {
            sql.append(" AND UPPER(o.Description) LIKE ?");
        }
        if (this.fPOReference.getText().length() > 0) {
            sql.append(" AND UPPER(o.POReference) LIKE ?");
        }
        if (this.fBPartner_ID.getValue() != null) {
            sql.append(" AND o.C_BPartner_ID=?");
        }
        if (this.fDateFrom.getValue() != null || this.fDateTo.getValue() != null) {
            from = (Timestamp)this.fDateFrom.getValue();
            to = (Timestamp)this.fDateTo.getValue();
            if (from == null && to != null) {
                sql.append(" AND TRUNC(o.DateOrdered) <= ?");
            } else if (from != null && to == null) {
                sql.append(" AND TRUNC(o.DateOrdered) >= ?");
            } else if (from != null && to != null) {
                sql.append(" AND TRUNC(o.DateOrdered) BETWEEN ? AND ?");
            }
        }
        if (this.fAmtFrom.getValue() != null || this.fAmtTo.getValue() != null) {
            from = (BigDecimal)this.fAmtFrom.getValue();
            to = (BigDecimal)this.fAmtTo.getValue();
            if (from == null && to != null) {
                sql.append(" AND o.GrandTotal <= ?");
            } else if (from != null && to == null) {
                sql.append(" AND o.GrandTotal >= ?");
            } else if (from != null && to != null) {
                sql.append(" AND o.GrandTotal BETWEEN ? AND ?");
            }
        }
        sql.append(" AND o.IsSOTrx=?");
        this.log.finer(sql.toString());
        return sql.toString();
    }

    @Override
    protected void setParameters(PreparedStatement pstmt, boolean forCount) throws SQLException {
        Comparable<Date> to;
        Comparable<Date> from;
        int index = 1;
        if (this.fDocumentNo.getText().length() > 0) {
            pstmt.setString(index++, this.getSQLText(this.fDocumentNo));
        }
        if (this.fDescription.getText().length() > 0) {
            pstmt.setString(index++, this.getSQLText(this.fDescription));
        }
        if (this.fPOReference.getText().length() > 0) {
            pstmt.setString(index++, this.getSQLText(this.fPOReference));
        }
        if (this.fBPartner_ID.getValue() != null) {
            Integer bp = (Integer)this.fBPartner_ID.getValue();
            pstmt.setInt(index++, bp);
            this.log.fine("BPartner=" + bp);
        }
        if (this.fDateFrom.getValue() != null || this.fDateTo.getValue() != null) {
            from = (Timestamp)this.fDateFrom.getValue();
            to = (Timestamp)this.fDateTo.getValue();
            this.log.fine("Date From=" + from + ", To=" + to);
            if (from == null && to != null) {
                pstmt.setTimestamp(index++, (Timestamp)to);
            } else if (from != null && to == null) {
                pstmt.setTimestamp(index++, (Timestamp)from);
            } else if (from != null && to != null) {
                pstmt.setTimestamp(index++, (Timestamp)from);
                pstmt.setTimestamp(index++, (Timestamp)to);
            }
        }
        if (this.fAmtFrom.getValue() != null || this.fAmtTo.getValue() != null) {
            from = (BigDecimal)this.fAmtFrom.getValue();
            to = (BigDecimal)this.fAmtTo.getValue();
            this.log.fine("Amt From=" + from + ", To=" + to);
            if (from == null && to != null) {
                pstmt.setBigDecimal(index++, (BigDecimal)to);
            } else if (from != null && to == null) {
                pstmt.setBigDecimal(index++, (BigDecimal)from);
            } else if (from != null && to != null) {
                pstmt.setBigDecimal(index++, (BigDecimal)from);
                pstmt.setBigDecimal(index++, (BigDecimal)to);
            }
        }
        pstmt.setString(index++, this.fIsSOTrx.isSelected() ? "Y" : "N");
    }

    private String getSQLText(CTextField f) {
        String s = f.getText().toUpperCase();
        if (!s.endsWith("%")) {
            s = s + "%";
        }
        this.log.fine("String=" + s);
        return s;
    }

    @Override
    protected void zoom() {
        this.log.info("");
        Integer C_Order_ID = this.getSelectedRowKey();
        if (C_Order_ID == null) {
            return;
        }
        MQuery query = new MQuery("C_Order");
        query.addRestriction("C_Order_ID", "=", C_Order_ID);
        query.setRecordCount(1);
        int AD_WindowNo = this.getAD_Window_ID("C_Order", this.fIsSOTrx.isSelected());
        this.zoom(AD_WindowNo, query);
    }

    @Override
    protected boolean hasZoom() {
        return true;
    }
}

