/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.Vector;
import java.util.logging.Level;
import org.compiere.apps.form.Allocation;
import org.compiere.minigrid.IMiniTable;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class VShipmentEnquiry {
    public DecimalFormat format = DisplayType.getNumberFormat(12);
    public static CLogger log = CLogger.getCLogger(Allocation.class);
    public int m_order = 0;
    public int m_bpartner = 0;
    public String m_lgst = "P";
    public String m_dcst = "W";
    public String m_fst = "P";
    public BigDecimal m_wd = new BigDecimal(0.0);
    public BigDecimal m_ht = new BigDecimal(0.0);
    public int tot_qty = 0;
    public int s_qty = 0;
    public Timestamp newDateAcct;

    protected void prepare() {
    }

    public void dynInit() throws Exception {
    }

    public Vector<Vector<Object>> getOrders() {
        int id = 0;
        boolean flg = false;
        BigDecimal id1 = new BigDecimal(id);
        Vector<Vector<Object>> data = new Vector<Vector<Object>>();
        String q1 = this.m_order > 0 ? " and shp.c_order_id=?  " : " ";
        String q2 = this.m_bpartner > 0 ? " and shp.c_bpartner_id=? " : " ";
        String q3 = this.m_lgst == "N" ? " " : " and shp.logst=? ";
        String q4 = this.m_dcst == "N" ? " " : " and shp.docst=? ";
        String q5 = this.m_fst == "N" ? " " : " and shp.finalst=? ";
        StringBuffer sql = new StringBuffer(" select co.documentno vorder,shp.dateordered vdte,cp.name sup, shp.paymentterm pterm, shp.expdeldate deldte,shp.grandtotal gtot,shp.docrecdate recdte ,shp.docst dst,shp.logst lgst,shp.logremarks lgre, shp.accremarks acre,shp.finalst fst,shp.finalremarks fre   from Beta_Shipcontrol shp inner join c_order co on co.c_order_id=shp.c_order_id inner join c_bpartner cp on cp.c_bpartner_id=shp.c_bpartner_id where shp.isactive='Y' " + q1 + q2 + q3 + q4 + q5 + " order by co.documentno  ");
        log.fine("InvSQL=" + sql.toString());
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
            int i = 1;
            if (this.m_order > 0) {
                pstmt.setInt(i, this.m_order);
                ++i;
            }
            if (this.m_bpartner > 0) {
                pstmt.setInt(i, this.m_bpartner);
                ++i;
            }
            if (this.m_lgst != "N") {
                pstmt.setString(i, this.m_lgst);
                ++i;
            }
            if (this.m_dcst != "N") {
                pstmt.setString(i, this.m_dcst);
                ++i;
            }
            if (this.m_fst != "N") {
                pstmt.setString(i, this.m_fst);
                ++i;
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                Vector<Object> line = new Vector<Object>();
                line.add(rs.getString("vorder"));
                line.add(rs.getTimestamp("vdte"));
                line.add(rs.getString("sup"));
                line.add(rs.getString("pterm"));
                line.add(rs.getTimestamp("deldte"));
                line.add(rs.getInt("gtot"));
                String dcst = rs.getString("dst");
                if (dcst.equals("W")) {
                    System.out.print("doc status== " + dcst);
                    line.add("Waiting For Original");
                } else if (dcst.equals("E")) {
                    System.out.print("doc status== " + dcst);
                    line.add("EX Work Door To Door");
                } else if (dcst.equals("O")) {
                    System.out.print("doc status== " + dcst);
                    line.add("Original Received");
                }
                line.add(rs.getTimestamp("recdte"));
                String lgst = rs.getString("lgst");
                if (lgst.equals("P")) {
                    System.out.print("logistic status== " + lgst);
                    line.add("Pending");
                } else if (lgst.equals("U")) {
                    System.out.print("logistic status== " + lgst);
                    line.add("Under Clearance");
                } else if (lgst.equals("C")) {
                    System.out.print("logistic status== " + lgst);
                    line.add("Cleared");
                }
                line.add(rs.getString("lgre"));
                line.add(rs.getString("acre"));
                String ffst = rs.getString("fst");
                if (ffst.equals("P")) {
                    System.out.print("final status== " + ffst);
                    line.add("Pending");
                } else if (ffst.equals("M")) {
                    System.out.print("final status== " + ffst);
                    line.add("Material Received");
                }
                line.add(rs.getString("fre"));
                System.out.print("full line" + line);
                data.add(line);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql.toString(), e);
        }
        return data;
    }

    public Vector<String> getColumnNames() {
        Vector<String> columnNames = new Vector<String>();
        columnNames.add(Msg.getMsg(Env.getCtx(), "Order#"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "Date"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "Supplier"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "Payment Term"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "Delivery Date"));
        columnNames.add(Msg.getMsg(Env.getCtx(), " Grand Total"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "Document Status"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "Document Receive Date"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "Logistics Status"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "Logistics Remarks"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "Accounts Remarks"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "Final Status"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "Final Remarks"));
        return columnNames;
    }

    public void setordColumnClass1(IMiniTable ordTable) {
        int i = 0;
        ordTable.setColumnClass(i++, String.class, true);
        ordTable.setColumnClass(i++, Timestamp.class, true);
        ordTable.setColumnClass(i++, String.class, true);
        ordTable.setColumnClass(i++, String.class, true);
        ordTable.setColumnClass(i++, Timestamp.class, true);
        ordTable.setColumnClass(i++, Integer.class, true);
        ordTable.setColumnClass(i++, String.class, true);
        ordTable.setColumnClass(i++, Timestamp.class, true);
        ordTable.setColumnClass(i++, String.class, true);
        ordTable.setColumnClass(i++, String.class, true);
        ordTable.setColumnClass(i++, String.class, true);
        ordTable.setColumnClass(i++, String.class, true);
        ordTable.setColumnClass(i++, String.class, true);
        ordTable.autoSize();
    }
}

