/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.Vector;
import java.util.logging.Level;
import org.compiere.apps.form.Allocation;
import org.compiere.minigrid.IMiniTable;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class StakeholderEnquiry {
    public DecimalFormat format = DisplayType.getNumberFormat(12);
    public static CLogger log = CLogger.getCLogger(Allocation.class);
    public String entitytype;
    public String stakeholder;
    public String activity;
    public int tot_qty = 0;
    public int s_qty = 0;
    public Timestamp newDateAcct;

    protected void prepare() {
    }

    public void dynInit() throws Exception {
    }

    public Vector<Vector<Object>> getStakeholders() {
        int id = 0;
        boolean flg = false;
        BigDecimal id1 = new BigDecimal(id);
        Vector<Vector<Object>> data = new Vector<Vector<Object>>();
        StringBuffer sql = new StringBuffer("SELECT st.name stakeholder, co.name country, st.type type, st.contperson1 contact, st.position1 position, st.activity act, NVL(TO_CHAR(st.regexpirydate, 'DD-MM-YYYY'), '') reg, st.telno1 tell, st.mobileno1 mob, st.emailid1 email, st.website web FROM Beta_stakeholder st INNER JOIN c_country co ON co.c_country_id = st.c_country_id WHERE st.isactive = 'Y'");
        if (this.entitytype.length() > 0) {
            this.entitytype = this.entitytype.toUpperCase();
            String q1 = " AND upper(st.type) LIKE ?";
            sql.append(q1);
        }
        if (this.stakeholder.length() > 0) {
            this.stakeholder = this.stakeholder.toUpperCase();
            String q2 = " AND upper(st.name) LIKE ?";
            sql.append(q2);
        }
        if (this.activity.length() > 0) {
            this.activity = this.activity.toUpperCase();
            String q3 = " AND upper(st.activity) LIKE ?";
            sql.append(q3);
        }
        sql.append(" ORDER BY st.value");
        System.out.println("Final SQL Query: " + sql.toString());
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
            int i = 1;
            if (this.entitytype.length() > 0) {
                pstmt.setString(i++, "%" + this.entitytype + "%");
            }
            if (this.stakeholder.length() > 0) {
                pstmt.setString(i++, "%" + this.stakeholder + "%");
            }
            if (this.activity.length() > 0) {
                pstmt.setString(i++, "%" + this.activity + "%");
            }
            System.out.print("SQL====" + sql);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                Vector<String> line = new Vector<String>();
                line.add(rs.getString("stakeholder"));
                line.add(rs.getString("type"));
                line.add(rs.getString("country"));
                line.add(rs.getString("act"));
                line.add(rs.getString("reg"));
                line.add(rs.getString("contact"));
                line.add(rs.getString("position"));
                line.add(rs.getString("tell"));
                line.add(rs.getString("mob"));
                line.add(rs.getString("email"));
                line.add(rs.getString("web"));
                data.add(line);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql.toString(), e);
        }
        this.insertStakeholderInfo(data);
        return data;
    }

    public void insertStakeholderInfo(Vector<Vector<Object>> data) {
        Throwable throwable;
        String truncateSQL = "TRUNCATE TABLE beta_stakeholder_enquiry";
        try {
            Throwable throwable2 = null;
            throwable = null;
            try (CPreparedStatement truncateStmt = DB.prepareStatement(truncateSQL, null);){
                truncateStmt.executeUpdate();
                log.info("Table beta_stakeholder_enquiry successfully truncated.");
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "Error truncating beta_stakeholder_enquiry table", e);
            return;
        }
        String sql = "INSERT INTO beta_stakeholder_enquiry (stakeholder, entity_type, country, activity, regexp, contact_person, position, tel_number, mobile, email, website) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        try {
            throwable = null;
            Object var5_10 = null;
            try (CPreparedStatement pstmt = DB.prepareStatement(sql, null);){
                for (Vector<Object> row : data) {
                    pstmt.setString(1, (String)row.get(0));
                    pstmt.setString(2, (String)row.get(1));
                    pstmt.setString(3, (String)row.get(2));
                    pstmt.setString(4, (String)row.get(3));
                    pstmt.setString(5, (String)row.get(4));
                    pstmt.setString(6, (String)row.get(5));
                    pstmt.setString(7, (String)row.get(6));
                    pstmt.setString(8, (String)row.get(7));
                    pstmt.setString(9, (String)row.get(8));
                    pstmt.setString(10, (String)row.get(9));
                    pstmt.setString(11, (String)row.get(10));
                    pstmt.executeUpdate();
                }
                log.info("Data successfully inserted into stakeholder_info table.");
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "Error inserting stakeholder data", e);
        }
    }

    public Vector<String> getColumnNames() {
        Vector<String> columnNames = new Vector<String>();
        columnNames.add(Msg.getMsg(Env.getCtx(), "Stakeholder"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "Entity Type"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "Country"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "Activity"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "Registration Expiry"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "Contact Person"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "Position"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "Tel. Number"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "Mobile"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "Email"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "Website"));
        return columnNames;
    }

    public void setordColumnClass1(IMiniTable ordTable) {
        int i = 0;
        ordTable.setColumnClass(i++, String.class, true);
        ordTable.setColumnClass(i++, String.class, true);
        ordTable.setColumnClass(i++, String.class, true);
        ordTable.setColumnClass(i++, String.class, true);
        ordTable.setColumnClass(i++, String.class, true);
        ordTable.setColumnClass(i++, String.class, true);
        ordTable.setColumnClass(i++, String.class, true);
        ordTable.setColumnClass(i++, String.class, true);
        ordTable.setColumnClass(i++, String.class, true);
        ordTable.setColumnClass(i++, String.class, true);
        ordTable.setColumnClass(i++, String.class, true);
        ordTable.autoSize();
    }
}

