/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.sql.Timestamp;
import org.compiere.model.MArchive;
import org.compiere.model.MBPartner;
import org.compiere.model.MRole;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.TimeUtil;

public class Archive {
    public int m_WindowNo = 0;
    public MArchive[] m_archives = new MArchive[0];
    public int m_index = 0;
    public int m_AD_Table_ID = 0;
    public int m_Record_ID = 0;
    public static CLogger log = CLogger.getCLogger(Archive.class);

    public KeyNamePair[] getProcessData() {
        MRole role = MRole.getDefault();
        boolean trl = !Env.isBaseLanguage(Env.getCtx(), "AD_Process");
        String lang = Env.getAD_Language(Env.getCtx());
        String sql = "SELECT DISTINCT p.AD_Process_ID," + (trl ? "trl.Name" : "p.Name ") + " FROM AD_Process p INNER JOIN AD_Process_Access pa ON (p.AD_Process_ID=pa.AD_Process_ID) " + (trl ? "LEFT JOIN AD_Process_Trl trl on (trl.AD_Process_ID=p.AD_Process_ID and trl.AD_Language=" + DB.TO_STRING(lang) + ")" : "") + " WHERE " + role.getIncludedRolesWhereClause("pa.AD_Role_ID", null) + " AND p.IsReport='Y' AND p.IsActive='Y' AND pa.IsActive='Y' ORDER BY 2";
        return DB.getKeyNamePairs(sql, true);
    }

    public KeyNamePair[] getTableData() {
        MRole role = MRole.getDefault();
        boolean trl = !Env.isBaseLanguage(Env.getCtx(), "AD_Table");
        String lang = Env.getAD_Language(Env.getCtx());
        String sql = "SELECT DISTINCT t.AD_Table_ID," + (trl ? "trl.Name" : "t.Name") + " FROM AD_Table t INNER JOIN AD_Tab tab ON (tab.AD_Table_ID=t.AD_Table_ID) INNER JOIN AD_Window_Access wa ON (tab.AD_Window_ID=wa.AD_Window_ID) " + (trl ? "LEFT JOIN AD_Table_Trl trl on (trl.AD_Table_ID=t.AD_Table_ID and trl.AD_Language=" + DB.TO_STRING(lang) + ")" : "") + " WHERE " + role.getIncludedRolesWhereClause("wa.AD_Role_ID", null) + " AND t.IsActive='Y' AND tab.IsActive='Y' ORDER BY 2";
        return DB.getKeyNamePairs(sql, true);
    }

    public KeyNamePair[] getUserData() {
        String sql = "SELECT AD_User_ID, Name FROM AD_User u WHERE EXISTS (SELECT * FROM AD_User_Roles ur WHERE u.AD_User_ID=ur.AD_User_ID) ORDER BY 2";
        return DB.getKeyNamePairs(sql, true);
    }

    public boolean isSame(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        if (s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public void cmd_query(boolean reports, KeyNamePair process, KeyNamePair table2, Integer C_BPartner_ID, String name, String description, String help, KeyNamePair createdBy, Timestamp createdFrom, Timestamp createdTo) {
        StringBuffer sql = new StringBuffer();
        MRole role = MRole.getDefault();
        if (!role.isCanReport()) {
            log.warning("User/Role cannot Report AD_User_ID=" + Env.getAD_User_ID(Env.getCtx()));
            return;
        }
        sql.append(" AND IsReport=").append(reports ? "'Y'" : "'N'");
        if (reports && process != null && process.getKey() > 0) {
            sql.append(" AND AD_Process_ID=").append(process.getKey());
        }
        if (this.m_AD_Table_ID > 0) {
            sql.append(" AND ((AD_Table_ID=").append(this.m_AD_Table_ID);
            if (this.m_Record_ID > 0) {
                sql.append(" AND Record_ID=").append(this.m_Record_ID);
            }
            sql.append(")");
            if (this.m_AD_Table_ID == MBPartner.Table_ID && this.m_Record_ID > 0) {
                sql.append(" OR C_BPartner_ID=").append(this.m_Record_ID);
            }
            sql.append(")");
            this.m_AD_Table_ID = 0;
            this.m_Record_ID = 0;
        } else if (table2 != null && table2.getKey() > 0) {
            sql.append(" AND AD_Table_ID=").append(table2.getKey());
        }
        if (!reports) {
            if (C_BPartner_ID != null) {
                sql.append(" AND C_BPartner_ID=").append(C_BPartner_ID);
            } else {
                sql.append(" AND C_BPartner_ID IS NOT NULL");
            }
        }
        if (name != null && name.length() > 0) {
            if (name.indexOf(37) != -1 || name.indexOf(95) != -1) {
                sql.append(" AND Name LIKE ").append(DB.TO_STRING(name));
            } else {
                sql.append(" AND Name=").append(DB.TO_STRING(name));
            }
        }
        if (description != null && description.length() > 0) {
            if (description.indexOf(37) != -1 || description.indexOf(95) != -1) {
                sql.append(" AND Description LIKE ").append(DB.TO_STRING(description));
            } else {
                sql.append(" AND Description=").append(DB.TO_STRING(description));
            }
        }
        if (help != null && help.length() > 0) {
            if (help.indexOf(37) != -1 || help.indexOf(95) != -1) {
                sql.append(" AND Help LIKE ").append(DB.TO_STRING(help));
            } else {
                sql.append(" AND Help=").append(DB.TO_STRING(help));
            }
        }
        if (createdBy != null && createdBy.getKey() > 0) {
            sql.append(" AND CreatedBy=").append(createdBy.getKey());
        }
        if (createdFrom != null) {
            sql.append(" AND Created>=").append(DB.TO_DATE(createdFrom, true));
        }
        if (createdTo != null) {
            sql.append(" AND Created<").append(DB.TO_DATE(TimeUtil.addDays(createdTo, 1), true));
        }
        log.fine(sql.toString());
        sql.append(" AND (AD_Process_ID IS NULL OR AD_Process_ID IN (SELECT AD_Process_ID FROM AD_Process_Access WHERE AD_Role_ID=").append(role.getAD_Role_ID()).append(" OR ").append(role.getIncludedRolesWhereClause("AD_Role_ID", null)).append("))");
        sql.append(" AND (AD_Table_ID IS NULL OR (AD_Table_ID IS NOT NULL AND AD_Process_ID IS NOT NULL) OR AD_Table_ID IN (SELECT t.AD_Table_ID FROM AD_Tab t INNER JOIN AD_Window_Access wa ON (t.AD_Window_ID=wa.AD_Window_ID) WHERE wa.AD_Role_ID=").append(role.getAD_Role_ID()).append(" OR ").append(role.getIncludedRolesWhereClause("wa.AD_Role_ID", null)).append("))");
        log.finest(sql.toString());
        this.m_archives = MArchive.get(Env.getCtx(), sql.toString());
        log.info("Length=" + this.m_archives.length);
    }
}

