/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.Box;
import javax.swing.JLabel;
import org.compiere.apps.ADialog;
import org.compiere.apps.AEnv;
import org.compiere.apps.ConfirmPanel;
import org.compiere.grid.ed.VEditor;
import org.compiere.grid.ed.VEditorFactory;
import org.compiere.model.GridField;
import org.compiere.model.GridFieldVO;
import org.compiere.model.MClient;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MProcess;
import org.compiere.process.ProcessInfo;
import org.compiere.swing.CDialog;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ProcessParameter
extends CDialog
implements ActionListener,
VetoableChangeListener {
    private static final long serialVersionUID = -3898982577949513358L;
    private Frame m_frame;
    private int m_WindowNo;
    private ProcessInfo m_processInfo;
    private boolean m_isOK = false;
    private static CLogger log = CLogger.getCLogger(ProcessParameter.class);
    private GridBagConstraints gbc = new GridBagConstraints();
    private Insets nullInset = new Insets(0, 0, 0, 0);
    private Insets labelInset = new Insets(2, 12, 2, 0);
    private Insets fieldInset = new Insets(2, 5, 2, 0);
    private Insets fieldInsetRight = new Insets(2, 5, 2, 12);
    private int m_line = 0;
    private ArrayList<VEditor> m_vEditors = new ArrayList();
    private ArrayList<VEditor> m_vEditors2 = new ArrayList();
    private ArrayList<GridField> m_mFields = new ArrayList();
    private ArrayList<GridField> m_mFields2 = new ArrayList();
    private CPanel mainPanel = new CPanel();
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel centerPanel = new CPanel();
    private GridBagLayout centerLayout = new GridBagLayout();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);

    public ProcessParameter(Frame frame, int WindowNo, ProcessInfo pi) {
        super(frame, pi.getTitle(), true);
        this.m_frame = frame;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, ex.getMessage());
        }
        this.m_WindowNo = WindowNo;
        this.m_processInfo = pi;
    }

    void jbInit() throws Exception {
        this.mainPanel.setLayout(this.mainLayout);
        this.centerPanel.setLayout(this.centerLayout);
        this.getContentPane().add(this.mainPanel);
        this.mainPanel.add((Component)this.centerPanel, "Center");
        this.mainPanel.add((Component)this.confirmPanel, "South");
        this.confirmPanel.addActionListener(this);
    }

    @Override
    public void dispose() {
        this.m_vEditors.clear();
        this.m_vEditors2.clear();
        this.m_mFields.clear();
        this.m_mFields2.clear();
        this.removeAll();
        super.dispose();
    }

    public boolean initDialog() {
        log.config("");
        this.gbc.anchor = 18;
        this.gbc.weightx = 0.0;
        this.gbc.weighty = 0.0;
        this.gbc.gridy = this.m_line++;
        this.gbc.gridx = 0;
        this.gbc.gridwidth = 1;
        this.gbc.insets = this.nullInset;
        this.gbc.fill = 2;
        this.centerPanel.add(Box.createVerticalStrut(10), this.gbc);
        MClient client = MClient.get(Env.getCtx());
        String ASPFilter = "";
        if (client.isUseASP()) {
            ASPFilter = "   AND (   p.AD_Process_Para_ID IN (               SELECT pp.AD_Process_Para_ID                 FROM ASP_Process_Para pp, ASP_Process p, ASP_Level l, ASP_ClientLevel cl                WHERE p.ASP_Level_ID = l.ASP_Level_ID                  AND cl.AD_Client_ID = " + client.getAD_Client_ID() + "                 AND cl.ASP_Level_ID = l.ASP_Level_ID                  AND pp.ASP_Process_ID = p.ASP_Process_ID                  AND pp.IsActive = 'Y'                  AND p.IsActive = 'Y'                  AND l.IsActive = 'Y'                  AND cl.IsActive = 'Y'                  AND pp.ASP_Status = 'S')         OR p.AD_Process_Para_ID IN (               SELECT AD_Process_Para_ID                 FROM ASP_ClientException ce                WHERE ce.AD_Client_ID = " + client.getAD_Client_ID() + "                 AND ce.IsActive = 'Y'                  AND ce.AD_Process_Para_ID IS NOT NULL                  AND ce.AD_Tab_ID IS NULL                  AND ce.AD_Field_ID IS NULL                  AND ce.ASP_Status = 'S')        )    AND p.AD_Process_Para_ID NOT IN (           SELECT AD_Process_Para_ID             FROM ASP_ClientException ce            WHERE ce.AD_Client_ID = " + client.getAD_Client_ID() + "             AND ce.IsActive = 'Y'              AND ce.AD_Process_Para_ID IS NOT NULL              AND ce.AD_Tab_ID IS NULL              AND ce.AD_Field_ID IS NULL              AND ce.ASP_Status = 'H')";
        }
        String sql = null;
        sql = Env.isBaseLanguage(Env.getCtx(), "AD_Process_Para") ? "SELECT p.Name, p.Description, p.Help, p.AD_Reference_ID, p.AD_Process_Para_ID, p.FieldLength, p.IsMandatory, p.IsRange, p.ColumnName, p.ReadOnlyLogic, p.DisplayLogic, p.DefaultValue, p.DefaultValue2, p.VFormat, p.ValueMin, p.ValueMax, p.SeqNo, p.AD_Reference_Value_ID, vr.Code AS ValidationCode FROM AD_Process_Para p LEFT OUTER JOIN AD_Val_Rule vr ON (p.AD_Val_Rule_ID=vr.AD_Val_Rule_ID) WHERE p.AD_Process_ID=? AND p.IsActive='Y' " + ASPFilter + " ORDER BY SeqNo" : "SELECT t.Name, t.Description, t.Help, p.AD_Reference_ID, p.AD_Process_Para_ID, p.FieldLength, p.IsMandatory, p.IsRange, p.ColumnName, p.ReadOnlyLogic, p.DisplayLogic, p.DefaultValue, p.DefaultValue2, p.VFormat, p.ValueMin, p.ValueMax, p.SeqNo, p.AD_Reference_Value_ID, vr.Code AS ValidationCode FROM AD_Process_Para p INNER JOIN AD_Process_Para_Trl t ON (p.AD_Process_Para_ID=t.AD_Process_Para_ID) LEFT OUTER JOIN AD_Val_Rule vr ON (p.AD_Val_Rule_ID=vr.AD_Val_Rule_ID) WHERE p.AD_Process_ID=? AND t.AD_Language='" + Env.getAD_Language(Env.getCtx()) + "' AND p.IsActive='Y' " + ASPFilter + " ORDER BY SeqNo";
        boolean hasFields = false;
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.m_processInfo.getAD_Process_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                hasFields = true;
                this.createField(rs);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
        if (this.m_mFields.size() != this.m_mFields2.size() || this.m_mFields.size() != this.m_vEditors.size() || this.m_mFields2.size() != this.m_vEditors2.size()) {
            log.log(Level.SEVERE, "View & Model vector size is different");
        }
        if (hasFields) {
            this.gbc.gridy = this.m_line++;
            this.centerPanel.add(Box.createVerticalStrut(10), this.gbc);
            this.gbc.gridx = 3;
            this.centerPanel.add(Box.createHorizontalStrut(12), this.gbc);
            AEnv.positionCenterWindow(this.m_frame, this);
        } else {
            this.dispose();
        }
        return hasFields;
    }

    private void createField(ResultSet rs) {
        GridFieldVO voF = GridFieldVO.createParameter(Env.getCtx(), this.m_WindowNo, rs);
        GridField mField = new GridField(voF);
        this.m_mFields.add(mField);
        this.gbc.gridy = this.m_line++;
        this.gbc.gridwidth = 1;
        this.gbc.fill = 2;
        this.gbc.gridx = 0;
        this.gbc.weightx = 0.0;
        CLabel label = VEditorFactory.getLabel(mField);
        if (label == null) {
            this.gbc.insets = this.nullInset;
            this.centerPanel.add(Box.createHorizontalStrut(12), this.gbc);
        } else {
            this.gbc.insets = this.labelInset;
            this.centerPanel.add((Component)label, this.gbc);
        }
        this.gbc.insets = this.fieldInset;
        this.gbc.fill = 2;
        this.gbc.gridwidth = 1;
        this.gbc.gridx = 1;
        this.gbc.weightx = 1.0;
        VEditor vEditor = VEditorFactory.getEditor(mField, false);
        vEditor.addVetoableChangeListener(this);
        mField.addPropertyChangeListener(vEditor);
        Object defaultObject = mField.getDefault();
        mField.setValue(defaultObject, true);
        this.centerPanel.add((Component)((Object)vEditor), this.gbc);
        this.m_vEditors.add(vEditor);
        if (voF.isRange) {
            this.gbc.gridx = 2;
            this.gbc.weightx = 0.0;
            this.gbc.fill = 0;
            this.centerPanel.add((Component)new JLabel(" - "), this.gbc);
            this.gbc.gridx = 3;
            this.gbc.insets = this.fieldInsetRight;
            this.gbc.weightx = 1.0;
            this.gbc.fill = 2;
            this.gbc.anchor = 17;
            GridFieldVO voF2 = GridFieldVO.createParameter(voF);
            GridField mField2 = new GridField(voF2);
            this.m_mFields2.add(mField2);
            VEditor vEditor2 = VEditorFactory.getEditor(mField2, false);
            mField2.addPropertyChangeListener(vEditor2);
            Object defaultObject2 = mField2.getDefault();
            mField2.setValue(defaultObject2, true);
            this.centerPanel.add((Component)((Object)vEditor2), this.gbc);
            this.m_vEditors2.add(vEditor2);
        } else {
            this.m_mFields2.add(null);
            this.m_vEditors2.add(null);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.m_isOK = false;
        if (e.getActionCommand().equals("Ok")) {
            if (this.saveParameters()) {
                this.m_isOK = true;
                this.dispose();
            }
        } else if (e.getActionCommand().equals("Cancel")) {
            this.dispose();
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        String value = evt.getNewValue() == null ? "" : evt.getNewValue().toString();
        Env.setContext(Env.getCtx(), this.m_WindowNo, evt.getPropertyName(), value);
    }

    private boolean saveParameters() {
        int i;
        log.config("");
        StringBuffer sb = new StringBuffer();
        int size = this.m_mFields.size();
        for (i = 0; i < size; ++i) {
            GridField field = this.m_mFields.get(i);
            if (!field.isMandatory(true)) continue;
            VEditor vEditor = this.m_vEditors.get(i);
            Object data = vEditor.getValue();
            if (data == null || data.toString().length() == 0) {
                field.setInserting(true);
                field.setError(true);
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(field.getHeader());
            } else {
                field.setError(false);
            }
            VEditor vEditor2 = this.m_vEditors2.get(i);
            if (vEditor2 == null) continue;
            Object data2 = vEditor.getValue();
            GridField field2 = this.m_mFields2.get(i);
            if (data2 == null || data2.toString().length() == 0) {
                field.setInserting(true);
                field2.setError(true);
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(field.getHeader());
                continue;
            }
            field2.setError(false);
        }
        if (sb.length() != 0) {
            ADialog.error(this.m_WindowNo, this, "FillMandatory", sb.toString());
            return false;
        }
        for (i = 0; i < this.m_mFields.size(); ++i) {
            VEditor editor = this.m_vEditors.get(i);
            VEditor editor2 = this.m_vEditors2.get(i);
            Object result = editor.getValue();
            Object result2 = null;
            if (editor2 != null) {
                result2 = editor2.getValue();
            }
            if (result == null && result2 == null) continue;
            MPInstancePara para = new MPInstancePara(Env.getCtx(), this.m_processInfo.getAD_PInstance_ID(), i);
            GridField mField = this.m_mFields.get(i);
            para.setParameterName(mField.getColumnName());
            if (result instanceof Timestamp || result2 instanceof Timestamp) {
                para.setP_Date((Timestamp)result);
                if (editor2 != null && result2 != null) {
                    para.setP_Date_To((Timestamp)result2);
                }
            } else if (result instanceof Integer || result2 instanceof Integer) {
                Integer ii;
                if (result != null) {
                    ii = (Integer)result;
                    para.setP_Number((int)ii);
                }
                if (editor2 != null && result2 != null) {
                    ii = (Integer)result2;
                    para.setP_Number_To((int)ii);
                }
            } else if (result instanceof BigDecimal || result2 instanceof BigDecimal) {
                para.setP_Number((BigDecimal)result);
                if (editor2 != null && result2 != null) {
                    para.setP_Number_To((BigDecimal)result2);
                }
            } else if (result instanceof Boolean) {
                Boolean bb = (Boolean)result;
                String value = bb != false ? "Y" : "N";
                para.setP_String(value);
            } else {
                if (result != null) {
                    para.setP_String(result.toString());
                }
                if (editor2 != null && result2 != null) {
                    para.setP_String_To(result2.toString());
                }
            }
            para.setInfo(editor.getDisplay());
            if (editor2 != null) {
                para.setInfo_To(editor2.getDisplay());
            }
            para.save();
            log.fine(para.toString());
        }
        return true;
    }

    public boolean isOK() {
        return this.m_isOK;
    }

    @Override
    public void setVisible(boolean b) {
        MProcess m_process = new MProcess(Env.getCtx(), this.m_processInfo.getAD_Process_ID(), null);
        if (m_process.getShowHelp() != null && m_process.getShowHelp().equals("S")) {
            if (this.saveParameters()) {
                this.m_isOK = true;
                this.dispose();
            }
        } else {
            super.setVisible(b);
        }
    }
}

