/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MJournal;
import org.compiere.model.MJournalLine;
import org.compiere.util.Env;

public class Doc_GLJournal
extends Doc {
    private String m_PostingType = null;
    private int m_C_AcctSchema_ID = 0;

    public Doc_GLJournal(MAcctSchema[] ass, ResultSet rs, String trxName) {
        super(ass, MJournal.class, rs, null, trxName);
    }

    @Override
    protected String loadDocumentDetails() {
        MJournal journal = (MJournal)this.getPO();
        this.m_PostingType = journal.getPostingType();
        this.m_C_AcctSchema_ID = journal.getC_AcctSchema_ID();
        this.p_lines = this.loadLines(journal);
        this.log.fine("Lines=" + this.p_lines.length);
        return null;
    }

    private DocLine[] loadLines(MJournal journal) {
        ArrayList<DocLine> list = new ArrayList<DocLine>();
        MJournalLine[] lines = journal.getLines(false);
        for (int i = 0; i < lines.length; ++i) {
            MJournalLine line = lines[i];
            DocLine docLine = new DocLine(line, this);
            docLine.setAmount(line.getAmtSourceDr(), line.getAmtSourceCr());
            docLine.setConvertedAmt(this.m_C_AcctSchema_ID, line.getAmtAcctDr(), line.getAmtAcctCr());
            MAccount account = line.getAccount();
            docLine.setAccount(account);
            list.add(docLine);
        }
        int size = list.size();
        DocLine[] dls = new DocLine[size];
        list.toArray(dls);
        return dls;
    }

    @Override
    public BigDecimal getBalance() {
        BigDecimal retValue = Env.ZERO;
        StringBuffer sb = new StringBuffer(" [");
        for (int i = 0; i < this.p_lines.length; ++i) {
            retValue = retValue.add(this.p_lines[i].getAmtSource());
            sb.append("+").append(this.p_lines[i].getAmtSource());
        }
        sb.append("]");
        this.log.fine(this.toString() + " Balance=" + retValue + sb.toString());
        return retValue;
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        ArrayList<Fact> facts = new ArrayList<Fact>();
        if (as.getC_AcctSchema_ID() != this.m_C_AcctSchema_ID) {
            return facts;
        }
        Fact fact = new Fact(this, as, this.m_PostingType);
        if (this.getDocumentType().equals("GLJ")) {
            for (int i = 0; i < this.p_lines.length; ++i) {
                if (this.p_lines[i].getC_AcctSchema_ID() != as.getC_AcctSchema_ID()) continue;
                FactLine factLine = fact.createLine(this.p_lines[i], this.p_lines[i].getAccount(), this.getC_Currency_ID(), this.p_lines[i].getAmtSourceDr(), this.p_lines[i].getAmtSourceCr());
            }
        } else {
            this.p_Error = "DocumentType unknown: " + this.getDocumentType();
            this.log.log(Level.SEVERE, this.p_Error);
            fact = null;
        }
        facts.add(fact);
        return facts;
    }
}

