/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.FA;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.compiere.FA.Conventions;
import org.compiere.FA.Depreciation;
import org.compiere.FA.DepreciationAdj;
import org.compiere.model.X_A_Depreciation;
import org.compiere.model.X_A_Depreciation_Build;
import org.compiere.model.X_A_Depreciation_Convention;
import org.compiere.model.X_A_Depreciation_Exp;
import org.compiere.model.X_A_Depreciation_Method;
import org.compiere.model.X_A_Depreciation_Workfile;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class BuildDepWorkFile
extends SvrProcess {
    private int p_Depreciation_Build_ID = 0;
    private boolean m_DeleteOld = false;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            if (name.equals("DeleteOld")) {
                this.m_DeleteOld = "Y".equals(para[i].getParameter());
                continue;
            }
            this.log.info("prepare - Unknown Parameter: " + name);
        }
        this.p_Depreciation_Build_ID = this.getRecord_ID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doIt() throws Exception {
        this.log.info("doIt - Depreciation_Build_ID=" + this.p_Depreciation_Build_ID);
        if (this.p_Depreciation_Build_ID == 0) {
            throw new IllegalArgumentException("No Record");
        }
        String clientCheck = " AND AD_Client_ID=" + this.getAD_Client_ID();
        int no = 0;
        X_A_Depreciation_Build DepBuild = new X_A_Depreciation_Build(this.getCtx(), this.p_Depreciation_Build_ID, null);
        String sql = null;
        sql = "DELETE FROM A_DEPRECIATION_EXP WHERE PostingType = '" + DepBuild.getPostingType() + "' and A_Asset_ID >= " + DepBuild.getA_Start_Asset_ID() + " and A_Asset_ID  <= " + DepBuild.getA_End_Asset_ID() + " AND A_Entry_Type = 'DEP'" + clientCheck;
        no = DB.executeUpdate(sql, null);
        this.log.info("doIt - Clear DepExpense = " + no);
        sql = null;
        sql = "UPDATE A_DEPRECIATION_WORKFILE SET A_CURR_DEP_EXP = 0, A_CURRENT_PERIOD = 0 WHERE POSTINGTYPE = '" + DepBuild.getPostingType() + "' and A_Asset_ID >= " + DepBuild.getA_Start_Asset_ID() + " and A_Asset_ID  <= " + DepBuild.getA_End_Asset_ID() + clientCheck;
        no = DB.executeUpdate(sql, null);
        this.log.info("doIt - DepExpense Reset= " + no);
        sql = null;
        sql = " SELECT A_ASSET.A_ASSET_ID, A_ASSET.USELIFEYEARS, A_ASSET.USELIFEMONTHS, A_ASSET.LIFEUSEUNITS, A_ASSET.USEUNITS, A_ASSET.ISOWNED, A_ASSET.ISDISPOSED,A_DEPRECIATION_WORKFILE.A_PERIOD_POSTED,  A_DEPRECIATION_WORKFILE.A_CURR_DEP_EXP, A_ASSET.ASSETDEPRECIATIONDATE, A_ASSET.ISFULLYDEPRECIATED,  A_ASSET.ASSETSERVICEDATE, A_DEPRECIATION_WORKFILE.A_ASSET_ID as v_Asset_ID, A_DEPRECIATION_WORKFILE.POSTINGTYPE,  A_DEPRECIATION_BUILD.A_START_ASSET_ID, A_DEPRECIATION_BUILD.A_END_ASSET_ID, A_DEPRECIATION_WORKFILE.A_ACCUMULATED_DEPR,  A_DEPRECIATION_BUILD.PERIODNO, A_DEPRECIATION_BUILD.AD_CLIENT_ID, A_DEPRECIATION_BUILD.AD_ORG_ID,  A_DEPRECIATION_BUILD.CREATEDBY, A_DEPRECIATION_BUILD.UPDATEDBY, A_DEPRECIATION_BUILD.POSTINGTYPE as v_PostingType,  A_DEPRECIATION_BUILD.DATEACCT, A_DEPRECIATION_BUILD.C_PERIOD_ID, A_DEPRECIATION_WORKFILE.A_DEPRECIATION_WORKFILE_ID,  A_DEPRECIATION_BUILD.DATEDOC  FROM A_DEPRECIATION_WORKFILE, A_ASSET, A_DEPRECIATION_BUILD  WHERE A_ASSET.A_ASSET_ID = A_DEPRECIATION_WORKFILE.A_ASSET_ID AND A_ASSET.ISOWNED = 'Y' AND  A_DEPRECIATION_BUILD.DATEACCT >= A_ASSET.ASSETSERVICEDATE AND A_DEPRECIATION_BUILD.A_START_ASSET_ID  <= A_ASSET.A_ASSET_ID  AND A_DEPRECIATION_BUILD.A_END_ASSET_ID >= A_ASSET.A_ASSET_ID AND A_ASSET.ISFULLYDEPRECIATED = 'N' AND A_ASSET.ISDEPRECIATED = 'Y'  AND A_DEPRECIATION_WORKFILE.POSTINGTYPE = ? ";
        CPreparedStatement pstmt = null;
        pstmt = DB.prepareStatement(sql, 1003, 1008, null);
        ResultSet rs = null;
        try {
            pstmt.setString(1, DepBuild.getPostingType());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                X_A_Depreciation_Workfile assetwk = new X_A_Depreciation_Workfile(this.getCtx(), rs.getInt("A_DEPRECIATION_WORKFILE_ID"), null);
                String sql2 = null;
                sql2 = " SELECT * FROM A_ASSET_ACCT WHERE PostingType = '" + DepBuild.getPostingType() + "' and A_Asset_ID = " + rs.getInt("A_ASSET_ID");
                CPreparedStatement pstmt2 = null;
                pstmt2 = DB.prepareStatement(sql2, 1004, 1008, null);
                ResultSet rs2 = null;
                try {
                    rs2 = pstmt2.executeQuery();
                    BigDecimal v_Dep_Exp_Inception = new BigDecimal("0.0");
                    BigDecimal v_Dep_Exp_Inception2 = new BigDecimal("0.0");
                    BigDecimal v_HalfYearConv = new BigDecimal("0.0");
                    BigDecimal v_HalfYearConv_Adj = new BigDecimal("0.0");
                    BigDecimal v_Dep_Exp_Adjustment = new BigDecimal("0.0");
                    BigDecimal v_Dep_Exp_Monthly = new BigDecimal("0.0");
                    BigDecimal v_total_adjustment = new BigDecimal("0.0");
                    int asset_id_current = 0;
                    double v_current = 0.0;
                    BigDecimal v_current_adj = new BigDecimal(0.0);
                    while (rs2.next()) {
                        X_A_Depreciation_Exp depexp3;
                        X_A_Depreciation_Exp depexp2;
                        X_A_Depreciation depreciation = new X_A_Depreciation(this.getCtx(), rs2.getInt("A_DEPRECIATION_ID"), null);
                        X_A_Depreciation_Convention depreciation_conv = new X_A_Depreciation_Convention(this.getCtx(), rs2.getInt("A_DEPRECIATION_CONV_ID"), null);
                        GregorianCalendar calendar = new GregorianCalendar();
                        calendar.setTime(rs.getDate("ASSETSERVICEDATE"));
                        int AssetServiceDateYear = calendar.get(1);
                        int AssetServiceDateMonth = calendar.get(2);
                        calendar.setTime(rs.getDate("DATEACCT"));
                        int DateAcctYear = calendar.get(1);
                        int DateAcctMonth = calendar.get(2);
                        double v_period = Math.ceil(DateAcctMonth) + (Math.floor(DateAcctYear) - Math.floor(AssetServiceDateYear)) * 12.0 - Math.floor(AssetServiceDateMonth);
                        v_current_adj = rs2.getInt("A_ASSET_ID") != asset_id_current ? new BigDecimal(0.0) : v_current_adj.subtract(new BigDecimal(0.0));
                        int method = 0;
                        method = rs2.getInt("A_DEPRECIATION_METHOD_ID");
                        Calendar cal = GregorianCalendar.getInstance();
                        Timestamp ts = rs.getTimestamp("ASSETSERVICEDATE");
                        cal.setTime(ts);
                        assetwk.setDateAcct(ts);
                        assetwk.setA_Period_Forecast(new BigDecimal(assetwk.getA_Period_Posted()));
                        assetwk.save();
                        while (v_current < v_period) {
                            v_Dep_Exp_Inception2 = Depreciation.Dep_Type(depreciation.getDepreciationType(), rs2.getInt("A_Asset_ID"), v_current, rs2.getString("PostingType"), rs2.getInt("A_ASSET_ACCT_ID"), v_Dep_Exp_Inception);
                            v_HalfYearConv_Adj = new BigDecimal(Conventions.Dep_Convention(depreciation_conv.getConventionType(), rs2.getInt("A_Asset_ID"), rs2.getString("PostingType"), rs2.getInt("A_ASSET_ACCT_ID"), 1, v_current - 1.0));
                            v_HalfYearConv = v_HalfYearConv.add(v_HalfYearConv_Adj);
                            cal.add(2, 1);
                            cal.set(5, cal.getActualMaximum(5));
                            ts.setTime(cal.getTimeInMillis());
                            assetwk.setDateAcct(ts);
                            v_current_adj = v_current_adj.add(v_HalfYearConv_Adj);
                            assetwk.setA_Period_Forecast(v_current_adj);
                            assetwk.save();
                            v_Dep_Exp_Inception = v_Dep_Exp_Inception.add(v_Dep_Exp_Inception2.multiply(v_HalfYearConv_Adj));
                            v_current += 1.0;
                        }
                        X_A_Depreciation_Method depreciation_method = new X_A_Depreciation_Method(this.getCtx(), method, null);
                        if (v_Dep_Exp_Inception.compareTo(assetwk.getA_Accumulated_Depr()) != 0) {
                            v_Dep_Exp_Adjustment = DepreciationAdj.Dep_Adj(depreciation_method.getDepreciationType(), rs2.getInt("A_Asset_ID"), v_Dep_Exp_Inception.subtract(assetwk.getA_Accumulated_Depr()), Math.floor(DateAcctMonth), rs2.getString("PostingType"), rs2.getInt("A_ASSET_ACCT_ID"));
                            v_total_adjustment = v_Dep_Exp_Inception.subtract(assetwk.getA_Accumulated_Depr());
                        }
                        if (v_Dep_Exp_Adjustment.setScale(2, 4).compareTo(new BigDecimal(0.0)) != 0) {
                            X_A_Depreciation_Exp depexp1 = new X_A_Depreciation_Exp(this.getCtx(), 0, null);
                            depexp1.setA_Entry_Type("DEP");
                            depexp1.setA_Asset_ID(rs.getInt("A_ASSET_ID"));
                            depexp1.setA_Account_Number(rs2.getInt("A_Depreciation_Acct"));
                            depexp1.setPostingType(rs.getString("PostingType"));
                            depexp1.setExpense(v_Dep_Exp_Adjustment.setScale(2, 4).multiply(new BigDecimal(rs2.getFloat("A_Split_Percent"))));
                            depexp1.setDescription("Depreciation Expense Adj.");
                            depexp1.setA_Period(rs.getInt("C_Period_ID"));
                            depexp1.setIsDepreciated(true);
                            depexp1.setDateAcct(rs.getTimestamp("DateAcct"));
                            depexp1.save();
                            depexp2 = new X_A_Depreciation_Exp(this.getCtx(), 0, null);
                            depexp2.setA_Asset_ID(rs.getInt("A_ASSET_ID"));
                            depexp2.setA_Account_Number(rs2.getInt("A_AccumDepreciation_Acct"));
                            depexp2.setPostingType(rs.getString("PostingType"));
                            depexp2.setExpense(v_Dep_Exp_Adjustment.setScale(2, 4).multiply(new BigDecimal(-1.0f * rs2.getFloat("A_Split_Percent"))));
                            depexp2.setDescription("Depreciation Expense Adj.");
                            depexp2.setA_Period(rs.getInt("C_Period_ID"));
                            depexp2.setIsDepreciated(false);
                            depexp2.setDateAcct(rs.getTimestamp("DateAcct"));
                            depexp2.setA_Entry_Type("DEP");
                            depexp2.save();
                            v_total_adjustment = v_total_adjustment.setScale(5, 4).subtract(v_Dep_Exp_Adjustment.setScale(5, 4));
                        }
                        int lastdepexp2 = 0;
                        v_Dep_Exp_Monthly = Depreciation.Dep_Type(depreciation.getDepreciationType(), rs2.getInt("A_Asset_ID"), (v_current += 1.0) - 1.0, rs2.getString("PostingType"), rs2.getInt("A_ASSET_ACCT_ID"), v_Dep_Exp_Inception);
                        v_HalfYearConv_Adj = new BigDecimal(Conventions.Dep_Convention(depreciation_conv.getConventionType(), rs2.getInt("A_Asset_ID"), rs2.getString("PostingType"), rs2.getInt("A_ASSET_ACCT_ID"), 0, 1.0));
                        v_Dep_Exp_Monthly = v_Dep_Exp_Monthly.multiply(v_HalfYearConv_Adj);
                        v_HalfYearConv = v_HalfYearConv.add(v_HalfYearConv_Adj);
                        depexp2 = new X_A_Depreciation_Exp(this.getCtx(), 0, null);
                        if (v_total_adjustment.setScale(2, 4).compareTo(new BigDecimal(0.0)) != 0) {
                            v_total_adjustment = v_total_adjustment.setScale(5, 4).subtract(v_Dep_Exp_Adjustment.setScale(5, 4));
                            depexp2.setPostingType(DepBuild.getPostingType());
                            depexp2.setA_Asset_ID(rs.getInt("A_ASSET_ID"));
                            depexp2.setA_Account_Number(rs2.getInt("A_Depreciation_Acct"));
                            depexp2.setPostingType(rs.getString("PostingType"));
                            depexp2.setExpense(v_Dep_Exp_Monthly.setScale(2, 4).multiply(new BigDecimal(rs2.getFloat("A_Split_Percent"))));
                            depexp2.setDescription("Depreciation Expense");
                            depexp2.setA_Period(rs.getInt("C_Period_ID"));
                            depexp2.setIsDepreciated(true);
                            depexp2.setDateAcct(rs.getTimestamp("DateAcct"));
                            depexp2.setA_Entry_Type("DEP");
                            depexp2.save();
                            depexp3 = new X_A_Depreciation_Exp(this.getCtx(), 0, null);
                            depexp3.setA_Asset_ID(rs.getInt("A_ASSET_ID"));
                            depexp3.setA_Account_Number(rs2.getInt("A_AccumDepreciation_Acct"));
                            depexp3.setPostingType(rs.getString("PostingType"));
                            depexp3.setExpense(v_Dep_Exp_Monthly.setScale(2, 4).multiply(new BigDecimal(-1.0f * rs2.getFloat("A_Split_Percent"))));
                            depexp3.setDescription("Depreciation Expense");
                            depexp3.setA_Period(rs.getInt("C_Period_ID"));
                            depexp3.setIsDepreciated(false);
                            depexp3.setDateAcct(rs.getTimestamp("DateAcct"));
                            depexp3.setA_Entry_Type("DEP");
                            depexp3.save();
                            v_Dep_Exp_Inception = v_Dep_Exp_Inception.add(v_Dep_Exp_Monthly.setScale(2, 4)).setScale(2, 4);
                        } else {
                            depexp2.setA_Asset_ID(rs.getInt("A_ASSET_ID"));
                            depexp2.setA_Account_Number(rs2.getInt("A_Depreciation_Acct"));
                            depexp2.setPostingType(rs.getString("PostingType"));
                            depexp2.setExpense(v_Dep_Exp_Monthly.setScale(2, 4).multiply(new BigDecimal(rs2.getFloat("A_Split_Percent"))));
                            depexp2.setDescription("Depreciation Expense");
                            depexp2.setA_Period(rs.getInt("C_Period_ID"));
                            depexp2.setIsDepreciated(true);
                            depexp2.setDateAcct(rs.getTimestamp("DateAcct"));
                            depexp2.setA_Entry_Type("DEP");
                            depexp2.save();
                            depexp3 = new X_A_Depreciation_Exp(this.getCtx(), 0, null);
                            depexp3.setA_Asset_ID(rs.getInt("A_ASSET_ID"));
                            depexp3.setA_Account_Number(rs2.getInt("A_AccumDepreciation_Acct"));
                            depexp3.setPostingType(rs.getString("PostingType"));
                            depexp3.setExpense(v_Dep_Exp_Monthly.setScale(2, 4).multiply(new BigDecimal(-1.0f * rs2.getFloat("A_Split_Percent"))));
                            depexp3.setDescription("Depreciation Expense");
                            depexp3.setA_Period(rs.getInt("C_Period_ID"));
                            depexp3.setIsDepreciated(false);
                            depexp3.setDateAcct(rs.getTimestamp("DateAcct"));
                            depexp3.setA_Entry_Type("DEP");
                            depexp3.save();
                            v_Dep_Exp_Inception = v_Dep_Exp_Inception.add(v_Dep_Exp_Monthly).setScale(2, 4);
                        }
                        lastdepexp2 = depexp2.get_ID();
                        cal.add(2, 1);
                        cal.set(5, cal.getActualMaximum(5));
                        ts.setTime(cal.getTimeInMillis());
                        v_current_adj = v_current_adj.add(v_HalfYearConv_Adj).setScale(2, 4);
                        assetwk.setA_Period_Forecast(v_current_adj);
                        assetwk.setDateAcct(ts);
                        assetwk.setA_Current_Period((int)v_current);
                        assetwk.save();
                        asset_id_current = rs2.getInt("A_ASSET_ID");
                        this.log.info("" + asset_id_current);
                    }
                }
                catch (Exception e) {
                    this.log.info("getAssets" + e);
                }
                finally {
                    DB.close(rs, pstmt);
                    rs2 = null;
                    pstmt2 = null;
                }
            }
        }
        catch (Exception e) {
            try {
                this.log.info("getAssets" + e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return "";
    }
}

