/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.FA;

import java.math.BigDecimal;
import java.sql.ResultSet;
import org.compiere.model.MAssetChange;
import org.compiere.model.MAssetTransfer;
import org.compiere.model.MRefList;
import org.compiere.model.X_A_Depreciation_Exp;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class AssetTransfer
extends SvrProcess {
    private int p_Asset_Transfer_ID = 0;
    private boolean m_DeleteOld = false;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            if (name.equals("DeleteOld")) {
                this.m_DeleteOld = "Y".equals(para[i].getParameter());
                continue;
            }
            this.log.info("prepare - Unknown Parameter: " + name);
        }
        this.p_Asset_Transfer_ID = this.getRecord_ID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doIt() throws Exception {
        this.log.info("doIt - Asset_Transfer_ID=" + this.p_Asset_Transfer_ID);
        if (this.p_Asset_Transfer_ID == 0) {
            throw new IllegalArgumentException("No Record");
        }
        int no = 0;
        BigDecimal v_Balance = new BigDecimal("0.0");
        MAssetTransfer AssetTransfer2 = new MAssetTransfer(this.getCtx(), this.p_Asset_Transfer_ID, null);
        String sql = null;
        this.log.info("doIt - Starting Transfer = " + no);
        sql = "SELECT A_ASSET_ID, CHANGEAMT FROM A_ASSET_CHANGE WHERE A_ASSET_CHANGE.A_ASSET_ID = " + AssetTransfer2.getA_Asset_ID() + " AND A_ASSET_CHANGE.POSTINGTYPE = '" + AssetTransfer2.getPostingType() + "' AND A_ASSET_CHANGE.CHANGETYPE= 'D' AND TRUNC(A_ASSET_CHANGE.DATEACCT, 'YY') = TRUNC( " + DB.TO_DATE(AssetTransfer2.getDateAcct()) + ", 'YY') AND TRUNC(A_ASSET_CHANGE.DATEACCT, 'MM') <= TRUNC( " + DB.TO_DATE(AssetTransfer2.getDateAcct()) + ", 'MM') AND A_ASSET_CHANGE.C_VALIDCOMBINATION_ID = " + AssetTransfer2.getA_Depreciation_Acct();
        CPreparedStatement pstmt = null;
        pstmt = DB.prepareStatement(sql, null);
        this.log.info("doIt - SQL=" + sql);
        ResultSet rs = null;
        String clientCheck = " AND AD_Client_ID=" + AssetTransfer2.getAD_Client_ID();
        if (this.m_DeleteOld) {
            sql = "DELETE A_DEPRECIATION_EXP WHERE Processed='Y' AND A_Entry_Type = 'TRN'" + clientCheck;
            no = DB.executeUpdate(sql, null);
            this.log.info("doIt - Delete old processed entries =" + no);
        }
        try {
            rs = pstmt.executeQuery();
            if (AssetTransfer2.isA_Transfer_Balance_IS()) {
                while (rs.next()) {
                }
                v_Balance = v_Balance.add(rs.getBigDecimal("ChangeAmt"));
                X_A_Depreciation_Exp depexp0 = new X_A_Depreciation_Exp(this.getCtx(), 0, null);
                depexp0.setPostingType(AssetTransfer2.getPostingType());
                depexp0.setA_Asset_ID(AssetTransfer2.getA_Asset_ID());
                depexp0.setExpense(v_Balance);
                depexp0.setDateAcct(AssetTransfer2.getDateAcct());
                depexp0.setA_Account_Number(AssetTransfer2.getA_Depreciation_Acct_New());
                depexp0.setDescription("Asset Transfer");
                depexp0.setIsDepreciated(false);
                depexp0.setA_Period(AssetTransfer2.getC_Period_ID());
                depexp0.setA_Entry_Type("TRN");
                depexp0.save();
                X_A_Depreciation_Exp depexp1 = new X_A_Depreciation_Exp(this.getCtx(), 0, null);
                depexp1.setPostingType(AssetTransfer2.getPostingType());
                depexp1.setA_Asset_ID(AssetTransfer2.getA_Asset_ID());
                depexp1.setExpense(v_Balance.multiply(new BigDecimal(-1)));
                depexp1.setDateAcct(AssetTransfer2.getDateAcct());
                depexp1.setA_Account_Number(AssetTransfer2.getA_Depreciation_Acct_New());
                depexp1.setDescription("Asset Transfer");
                depexp1.setIsDepreciated(false);
                depexp1.setA_Period(AssetTransfer2.getC_Period_ID());
                depexp1.setA_Entry_Type("TRN");
                depexp1.save();
            }
        }
        catch (Exception e) {
            this.log.info("getDeliveries" + e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        sql = null;
        sql = "SELECT A_ASSET_COST, A_ACCUMULATED_DEPR FROM A_DEPRECIATION_WORKFILE WHERE  A_ASSET_ID = " + AssetTransfer2.getA_Asset_ID() + " AND POSTINGTYPE = '" + AssetTransfer2.getPostingType() + "' AND AD_CLIENT_ID = " + AssetTransfer2.getAD_Client_ID() + " AND AD_ORG_ID = " + AssetTransfer2.getAD_Org_ID();
        pstmt = null;
        pstmt = DB.prepareStatement(sql, 1005, 1008, null);
        try {
            rs = pstmt.executeQuery();
            rs.first();
            X_A_Depreciation_Exp depexp2 = new X_A_Depreciation_Exp(this.getCtx(), 0, null);
            depexp2.setPostingType(AssetTransfer2.getPostingType());
            depexp2.setA_Asset_ID(AssetTransfer2.getA_Asset_ID());
            depexp2.setExpense(rs.getBigDecimal("A_ACCUMULATED_DEPR"));
            depexp2.setDateAcct(AssetTransfer2.getDateAcct());
            depexp2.setA_Account_Number(AssetTransfer2.getA_Accumdepreciation_Acct_New());
            depexp2.setDescription("Asset Transfer Accum Dep");
            depexp2.setIsDepreciated(false);
            depexp2.setA_Period(AssetTransfer2.getC_Period_ID());
            depexp2.setA_Entry_Type("TRN");
            depexp2.save();
            X_A_Depreciation_Exp depexp3 = new X_A_Depreciation_Exp(this.getCtx(), 0, null);
            depexp3.setPostingType(AssetTransfer2.getPostingType());
            depexp3.setA_Asset_ID(AssetTransfer2.getA_Asset_ID());
            depexp3.setExpense(rs.getBigDecimal("A_ACCUMULATED_DEPR").multiply(new BigDecimal(-1)));
            depexp3.setDateAcct(AssetTransfer2.getDateAcct());
            depexp3.setA_Account_Number(AssetTransfer2.getA_Accumdepreciation_Acct());
            depexp3.setDescription("Asset Transfer Accum Dep");
            depexp3.setIsDepreciated(false);
            depexp3.setA_Period(AssetTransfer2.getC_Period_ID());
            depexp3.setA_Entry_Type("TRN");
            depexp3.save();
            X_A_Depreciation_Exp depexp4 = new X_A_Depreciation_Exp(this.getCtx(), 0, null);
            depexp4.setPostingType(AssetTransfer2.getPostingType());
            depexp4.setA_Asset_ID(AssetTransfer2.getA_Asset_ID());
            depexp4.setExpense(rs.getBigDecimal("A_Asset_Cost"));
            depexp4.setDateAcct(AssetTransfer2.getDateAcct());
            depexp4.setA_Account_Number(AssetTransfer2.getA_Asset_Acct_New());
            depexp4.setDescription("Asset Transfer Cost");
            depexp4.setIsDepreciated(false);
            depexp4.setA_Period(AssetTransfer2.getC_Period_ID());
            depexp4.setA_Entry_Type("TRN");
            depexp4.save();
            X_A_Depreciation_Exp depexp5 = new X_A_Depreciation_Exp(this.getCtx(), 0, null);
            depexp5.setPostingType(AssetTransfer2.getPostingType());
            depexp5.setA_Asset_ID(AssetTransfer2.getA_Asset_ID());
            depexp5.setExpense(rs.getBigDecimal("A_Asset_Cost").multiply(new BigDecimal(-1)));
            depexp5.setDateAcct(AssetTransfer2.getDateAcct());
            depexp5.setA_Account_Number(AssetTransfer2.getA_Asset_Acct());
            depexp5.setDescription("Asset Transfer Cost");
            depexp5.setIsDepreciated(false);
            depexp5.setA_Period(AssetTransfer2.getC_Period_ID());
            depexp5.setA_Entry_Type("TRN");
            depexp5.save();
            sql = null;
            sql = "UPDATE A_ASSET_ACCT SET A_DEPRECIATION_ACCT = " + AssetTransfer2.getA_Depreciation_Acct_New() + ", A_ACCUMDEPRECIATION_ACCT = " + AssetTransfer2.getA_Accumdepreciation_Acct_New() + ", A_DISPOSAL_LOSS = " + AssetTransfer2.getA_Disposal_Loss_New() + ", A_DISPOSAL_REVENUE = " + AssetTransfer2.getA_Disposal_Revenue_New() + ", A_ASSET_ACCT = " + AssetTransfer2.getA_Asset_Acct_New() + " WHERE A_ASSET_ID = " + AssetTransfer2.getA_Asset_ID() + " AND POSTINGTYPE = '" + AssetTransfer2.getPostingType() + "' AND A_PERIOD_START = " + AssetTransfer2.getA_Period_Start() + " AND A_PERIOD_END = " + AssetTransfer2.getA_Period_End();
            MAssetChange change = new MAssetChange(this.getCtx(), 0, null);
            change.setChangeType("TRN");
            change.setTextDetails(MRefList.getListDescription(this.getCtx(), "A_Update_Type", "TRN"));
            change.setPostingType(AssetTransfer2.getPostingType());
            change.setA_Split_Percent(AssetTransfer2.getA_Split_Percent());
            change.setA_Asset_ID(AssetTransfer2.getA_Asset_ID());
            change.setA_Period_Start(AssetTransfer2.getA_Period_Start());
            change.setA_Period_End(AssetTransfer2.getA_Period_End());
            change.setA_Asset_Acct(AssetTransfer2.getA_Asset_Acct_New());
            change.setC_AcctSchema_ID(AssetTransfer2.getC_AcctSchema_ID());
            change.setA_Accumdepreciation_Acct(AssetTransfer2.getA_Accumdepreciation_Acct_New());
            change.setA_Depreciation_Acct(AssetTransfer2.getA_Depreciation_Acct_New());
            change.setA_Disposal_Revenue(AssetTransfer2.getA_Disposal_Revenue_New());
            change.setA_Disposal_Loss(AssetTransfer2.getA_Disposal_Loss_New());
            change.setAssetAccumDepreciationAmt(rs.getBigDecimal("A_ACCUMULATED_DEPR"));
            change.setAssetBookValueAmt(rs.getBigDecimal("A_Asset_Cost"));
            change.setChangeAmt(v_Balance);
            change.save();
            DB.executeUpdate(sql, null);
            AssetTransfer2.setIsActive(false);
            AssetTransfer2.save();
        }
        catch (Exception e) {
            this.log.info("TransferAssets" + e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return "";
    }
}

