/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.FA;

import java.math.BigDecimal;
import java.sql.ResultSet;
import org.compiere.model.MAssetChange;
import org.compiere.model.MRefList;
import org.compiere.model.X_A_Asset_Disposed;
import org.compiere.model.X_A_Depreciation_Exp;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class AssetDisposed
extends SvrProcess {
    private int p_Asset_Disposed_ID = 0;
    private boolean m_DeleteOld = false;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            if (name.equals("DeleteOld")) {
                this.m_DeleteOld = "Y".equals(para[i].getParameter());
                continue;
            }
            this.log.info("prepare - Unknown Parameter: " + name);
        }
        this.p_Asset_Disposed_ID = this.getRecord_ID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doIt() throws Exception {
        this.log.info("doIt - Asset_Disposed_ID=" + this.p_Asset_Disposed_ID);
        if (this.p_Asset_Disposed_ID == 0) {
            throw new IllegalArgumentException("No Record");
        }
        String sql = null;
        int no = 0;
        BigDecimal v_Balance = new BigDecimal("0.0");
        X_A_Asset_Disposed AssetDisposed2 = new X_A_Asset_Disposed(this.getCtx(), this.p_Asset_Disposed_ID, null);
        String clientCheck = " AND AD_Client_ID=" + AssetDisposed2.getAD_Client_ID();
        if (this.m_DeleteOld) {
            sql = "DELETE A_DEPRECIATION_EXP WHERE Processed='Y' AND A_Entry_Type = 'DIS'" + clientCheck;
            no = DB.executeUpdate(sql, null);
            this.log.info("doIt - Delete old processed entries =" + no);
        }
        sql = null;
        this.log.info("doIt - Starting Disposal = " + no);
        sql = "SELECT A.A_ASSET_ID, A.POSTINGTYPE, A.A_DEPRECIATION_ACCT,  A.A_ACCUMDEPRECIATION_ACCT, A.A_DISPOSAL_LOSS, A.A_DISPOSAL_REVENUE,  A.A_ASSET_ACCT, A.A_SPLIT_PERCENT, A.AD_ORG_ID, A.AD_CLIENT_ID,  B.A_ASSET_COST, B.A_ACCUMULATED_DEPR  FROM A_ASSET_ACCT A,  A_DEPRECIATION_WORKFILE B  WHERE A.A_ASSET_ID = " + AssetDisposed2.getA_Asset_ID() + " and B.A_ASSET_ID = " + AssetDisposed2.getA_Asset_ID() + " and A.POSTINGTYPE = B.POSTINGTYPE and A.AD_CLIENT_ID = B.AD_CLIENT_ID";
        CPreparedStatement pstmt = null;
        pstmt = DB.prepareStatement(sql, null);
        this.log.info("doIt - SQL=" + sql);
        String v_PostingType = null;
        ResultSet rs = null;
        try {
            rs = pstmt.executeQuery();
            while (rs.next()) {
                if (v_PostingType != null && !v_PostingType.equals(rs.getString("PostingType"))) {
                    sql = "UPDATE A_DEPRECIATION_WORKFILE SET A_ACCUMULATED_DEPR = " + v_Balance + "WHERE A_DEPRECIATION_WORKFILE.A_ASSET_ID = " + AssetDisposed2.getA_Asset_ID() + "AND A_DEPRECIATION_WORKFILE.POSTINGTYPE = '" + v_PostingType + "'";
                    DB.executeUpdate(sql, null);
                    v_Balance = new BigDecimal("0.0");
                    v_PostingType = rs.getString("PostingType");
                } else if (v_PostingType == null) {
                    v_PostingType = rs.getString("PostingType");
                }
                X_A_Depreciation_Exp depexp0 = new X_A_Depreciation_Exp(this.getCtx(), 0, null);
                depexp0.setPostingType(rs.getString("PostingType"));
                depexp0.setA_Asset_ID(AssetDisposed2.getA_Asset_ID());
                depexp0.setExpense(rs.getBigDecimal("A_Asset_Cost").multiply(new BigDecimal(-1)).multiply(rs.getBigDecimal("A_Split_Percent")));
                depexp0.setDateAcct(AssetDisposed2.getDateAcct());
                depexp0.setA_Account_Number(rs.getInt("A_Asset_Acct"));
                depexp0.setDescription("Asset Disposed - Cost of Asset");
                depexp0.setIsDepreciated(true);
                depexp0.setA_Period(AssetDisposed2.getC_Period_ID());
                depexp0.setA_Entry_Type("DIS");
                depexp0.save();
                X_A_Depreciation_Exp depexp1 = new X_A_Depreciation_Exp(this.getCtx(), 0, null);
                depexp1.setPostingType(rs.getString("PostingType"));
                depexp1.setA_Asset_ID(AssetDisposed2.getA_Asset_ID());
                depexp1.setExpense(rs.getBigDecimal("A_Asset_Cost").multiply(rs.getBigDecimal("A_Split_Percent")));
                depexp1.setDateAcct(AssetDisposed2.getDateAcct());
                depexp1.setA_Account_Number(rs.getInt("A_Disposal_Loss"));
                depexp1.setDescription("Asset Disposed - Cost of Asset");
                depexp1.setIsDepreciated(false);
                depexp1.setA_Period(AssetDisposed2.getC_Period_ID());
                depexp1.setA_Entry_Type("DIS");
                depexp1.save();
                v_Balance = v_Balance.add(rs.getBigDecimal("A_Asset_Cost").multiply(rs.getBigDecimal("A_Split_Percent")));
                X_A_Depreciation_Exp depexp2 = new X_A_Depreciation_Exp(this.getCtx(), 0, null);
                depexp2.setPostingType(rs.getString("PostingType"));
                depexp2.setA_Asset_ID(AssetDisposed2.getA_Asset_ID());
                depexp2.setExpense(rs.getBigDecimal("A_Accumulated_Depr").multiply(rs.getBigDecimal("A_Split_Percent")));
                depexp2.setDateAcct(AssetDisposed2.getDateAcct());
                depexp2.setA_Account_Number(rs.getInt("A_Accumdepreciation_Acct"));
                depexp2.setDescription("Asset Disposed - Accum Depr");
                depexp2.setIsDepreciated(true);
                depexp2.setA_Period(AssetDisposed2.getC_Period_ID());
                depexp2.setA_Entry_Type("DIS");
                depexp2.save();
                X_A_Depreciation_Exp depexp3 = new X_A_Depreciation_Exp(this.getCtx(), 0, null);
                depexp3.setPostingType(rs.getString("PostingType"));
                depexp3.setA_Asset_ID(AssetDisposed2.getA_Asset_ID());
                depexp3.setExpense(rs.getBigDecimal("A_Accumulated_Depr").multiply(new BigDecimal(-1)).multiply(rs.getBigDecimal("A_Split_Percent")));
                depexp3.setDateAcct(AssetDisposed2.getDateAcct());
                depexp3.setA_Account_Number(rs.getInt("A_Disposal_Loss"));
                depexp3.setDescription("Asset Disposed - Accum Depr");
                depexp3.setIsDepreciated(false);
                depexp3.setA_Period(AssetDisposed2.getC_Period_ID());
                depexp3.setA_Entry_Type("DIS");
                depexp3.save();
            }
            sql = "UPDATE A_ASSET SET ISDISPOSED = 'Y', ASSETDISPOSALDATE = " + DB.TO_DATE(AssetDisposed2.getA_Disposed_Date()) + " WHERE A_ASSET_ID = " + AssetDisposed2.getA_Asset_ID();
            DB.executeUpdate(sql, null);
            sql = "UPDATE A_DEPRECIATION_WORKFILE SET A_ACCUMULATED_DEPR = " + v_Balance + "WHERE A_DEPRECIATION_WORKFILE.A_ASSET_ID = " + AssetDisposed2.getA_Asset_ID() + "AND A_DEPRECIATION_WORKFILE.POSTINGTYPE = '" + v_PostingType + "'";
            DB.executeUpdate(sql, null);
            MAssetChange change = new MAssetChange(this.getCtx(), 0, null);
            change.setA_Asset_ID(AssetDisposed2.getA_Asset_ID());
            change.setChangeType("DIS");
            change.setTextDetails(MRefList.getListDescription(this.getCtx(), "A_Update_Type", "DIS"));
            change.setAssetDisposalDate(AssetDisposed2.getA_Disposed_Date());
            change.setAssetAccumDepreciationAmt(v_Balance);
            change.setIsFullyDepreciated(true);
            change.setIsDisposed(true);
            change.save();
        }
        catch (Exception e) {
            this.log.info("getDeliveries" + e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return "";
    }
}

