/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.compiere.model.MClient;
import org.compiere.model.MColumn;
import org.compiere.model.MEXPFormat;
import org.compiere.model.MEXPFormatLine;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class Export
extends SvrProcess {
    private static final String TOTAL_SEGMENTS = "${totalSegments}";
    protected int p_AD_Client_ID = 0;
    protected int p_AD_Table_ID = 0;
    protected int p_Record_ID = 0;
    private Document outDocument = null;
    int AD_Table_ID = 0;

    @Override
    protected void prepare() {
        this.p_Record_ID = this.getRecord_ID();
        if (this.p_AD_Client_ID == 0) {
            this.p_AD_Client_ID = Env.getAD_Client_ID(this.getCtx());
        }
        this.AD_Table_ID = this.getTable_ID();
        StringBuffer sb = new StringBuffer("AD_Table_ID=").append(this.AD_Table_ID);
        sb.append("; Record_ID=").append(this.getRecord_ID());
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            if (name.equals("AD_Table_ID")) {
                this.p_AD_Table_ID = para[i].getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        this.log.info(sb.toString());
    }

    Document createNewDocument() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder.newDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doIt() throws Exception {
        this.outDocument = this.createNewDocument();
        MClient client = MClient.get(this.getCtx(), this.p_AD_Client_ID);
        this.log.info(client.toString());
        int EXP_Format_ID = 1000000;
        MTable table = MTable.get(this.getCtx(), this.AD_Table_ID);
        this.log.info("Table = " + table);
        PO po = table.getPO(this.p_Record_ID, this.get_TrxName());
        if (po.get_KeyColumns().length > 1 || po.get_KeyColumns().length < 1) {
            throw new Exception(Msg.getMsg(this.getCtx(), "ExportMultiColumnNotSupported"));
        }
        MEXPFormat exportFormat = new MEXPFormat(this.getCtx(), EXP_Format_ID, this.get_TrxName());
        StringBuffer sql = new StringBuffer("SELECT * ").append("FROM ").append(table.getTableName()).append(" ").append("WHERE ").append(po.get_KeyColumns()[0]).append("=?");
        if (exportFormat.getWhereClause() != null & !"".equals(exportFormat.getWhereClause())) {
            sql.append(" AND ").append(exportFormat.getWhereClause());
        }
        ResultSet rs = null;
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql.toString(), this.get_TrxName());
            pstmt.setInt(1, this.p_Record_ID);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                HashMap<String, Integer> variableMap = new HashMap<String, Integer>();
                variableMap.put(TOTAL_SEGMENTS, new Integer(1));
                Element rootElement = this.outDocument.createElement(exportFormat.getValue());
                rootElement.appendChild(this.outDocument.createComment(exportFormat.getDescription()));
                this.outDocument.appendChild(rootElement);
                this.generateExportFormat(rootElement, exportFormat, rs, po, this.p_Record_ID, variableMap);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (SQLException sQLException) {}
            rs = null;
            pstmt = null;
        }
        this.addLog(0, null, null, Msg.getMsg(this.getCtx(), "ExportProcessResult") + "\n" + this.outDocument.toString());
        return this.outDocument.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateExportFormat(Element rootElement, MEXPFormat exportFormat, ResultSet rs, PO masterPO, int masterID, HashMap<String, Integer> variableMap) throws SQLException, Exception {
        List<MEXPFormatLine> formatLines = exportFormat.getFormatLines();
        boolean elementHasValue = false;
        for (MEXPFormatLine formatLine : formatLines) {
            if (formatLine.getType().equals("E")) {
                Element newElement = this.outDocument.createElement(formatLine.getValue());
                if (formatLine.getAD_Column_ID() == 0) {
                    throw new Exception(Msg.getMsg(this.getCtx(), "EXPColumnMandatory"));
                }
                MColumn column = MColumn.get(this.getCtx(), formatLine.getAD_Column_ID());
                if (column == null) {
                    throw new Exception(Msg.getMsg(this.getCtx(), "EXPColumnMandatory"));
                }
                if (column.isVirtualColumn()) {
                    this.log.info("This is Virtual Column!");
                }
                Object value = rs.getObject(column.getColumnName());
                String valueString = null;
                if (value != null) {
                    valueString = value.toString();
                } else if (formatLine.isMandatory()) {
                    throw new Exception(Msg.getMsg(this.getCtx(), "EXPFieldMandatory"));
                }
                this.log.info("EXP Field - column=[" + column.getColumnName() + "]; value=" + value);
                if (valueString == null || "".equals(valueString) || "null".equals(valueString)) continue;
                Text newText = this.outDocument.createTextNode(valueString);
                newElement.appendChild(newText);
                rootElement.appendChild(newElement);
                elementHasValue = true;
                continue;
            }
            if (formatLine.getType().equals("A")) {
                if (formatLine.getAD_Column_ID() == 0) {
                    throw new Exception(Msg.getMsg(this.getCtx(), "EXPColumnMandatory"));
                }
                MColumn column = MColumn.get(this.getCtx(), formatLine.getAD_Column_ID());
                if (column == null) {
                    throw new Exception(Msg.getMsg(this.getCtx(), "EXPColumnMandatory"));
                }
                if (column.isVirtualColumn()) {
                    this.log.info("This is Virtual Column!");
                }
                Object value = rs.getObject(column.getColumnName());
                String valueString = null;
                if (value != null) {
                    valueString = value.toString();
                } else if (formatLine.isMandatory()) {
                    throw new Exception(Msg.getMsg(this.getCtx(), "EXPFieldMandatory"));
                }
                this.log.info("EXP Field - column=[" + column.getColumnName() + "]; value=" + value);
                if (valueString == null || "".equals(valueString) || "null".equals(valueString)) continue;
                rootElement.setAttribute(formatLine.getValue(), valueString);
                elementHasValue = true;
                continue;
            }
            if (formatLine.getType().equals("M")) {
                int embeddedFormat_ID = formatLine.getEXP_EmbeddedFormat_ID();
                MEXPFormat embeddedFormat = new MEXPFormat(this.getCtx(), embeddedFormat_ID, this.get_TrxName());
                MTable tableEmbedded = MTable.get(this.getCtx(), embeddedFormat.getAD_Table_ID());
                this.log.info("Table Embedded = " + tableEmbedded);
                StringBuffer sql = new StringBuffer("SELECT * ").append("FROM ").append(tableEmbedded.getTableName()).append(" ").append("WHERE ").append(masterPO.get_KeyColumns()[0]).append("=?");
                if (embeddedFormat.getWhereClause() != null & !"".equals(embeddedFormat.getWhereClause())) {
                    sql.append(" AND ").append(embeddedFormat.getWhereClause());
                }
                ResultSet rsEmbedded = null;
                CPreparedStatement pstmt = null;
                try {
                    pstmt = DB.prepareStatement(sql.toString(), this.get_TrxName());
                    pstmt.setInt(1, masterID);
                    rsEmbedded = pstmt.executeQuery();
                    while (rsEmbedded.next()) {
                        int embeddedID = rsEmbedded.getInt(tableEmbedded.getTableName() + "_ID");
                        PO poEmbedded = tableEmbedded.getPO(embeddedID, this.get_TrxName());
                        Element embeddedElement = this.outDocument.createElement(formatLine.getValue());
                        embeddedElement.appendChild(this.outDocument.createComment(formatLine.getDescription()));
                        this.generateExportFormat(embeddedElement, embeddedFormat, rsEmbedded, poEmbedded, embeddedID, variableMap);
                        rootElement.appendChild(embeddedElement);
                    }
                    continue;
                }
                finally {
                    try {
                        if (rsEmbedded != null) {
                            rsEmbedded.close();
                        }
                        if (pstmt != null) {
                            pstmt.close();
                        }
                    }
                    catch (SQLException sQLException) {}
                    rsEmbedded = null;
                    pstmt = null;
                    continue;
                }
            }
            throw new Exception(Msg.getMsg(this.getCtx(), "EXPUnknownLineType"));
        }
    }

    private void increaseVariable(HashMap<String, Integer> variableMap, String variableName) {
        if (variableName != null && !"".equals(variableName)) {
            Integer var = variableMap.get(variableName);
            if (var == null) {
                var = new Integer(0);
            }
            int intValue = var;
            variableMap.put(variableName, new Integer(++intValue));
        }
    }
}

