/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.plaf;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import org.adempiere.plaf.AdempierePLAF;
import org.adempiere.plaf.GlassPane;
import org.adempiere.plaf.PLAFEditor;
import org.adempiere.plaf.PreviewPanel;
import org.compiere.swing.CButton;
import org.compiere.swing.CCheckBox;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTabbedPane;
import org.compiere.swing.CTextField;
import org.compiere.util.ValueNamePair;
import sun.awt.AppContext;

public class PLAFEditorPanel
extends CPanel {
    private static Logger log = Logger.getLogger(PLAFEditor.class.getName());
    static ResourceBundle s_res = ResourceBundle.getBundle("org.compiere.plaf.PlafRes");
    static Object[] s_columns = new Object[]{"-0-", "-1-"};
    static Object[][] s_data = new Object[][]{{"-00-", "-01-"}, {"-10-", "-11-"}, {"-20-", "-21-"}, {"-30-", "-31-"}, {"-O0-", "-O1-"}, {"-l0-", "-l1-"}};
    private PreviewPanel previewPanel = new PreviewPanel();
    private JList lookList = new JList<ValueNamePair>(AdempierePLAF.getPLAFs());
    private JList themeList = new JList();
    private boolean m_setting;
    private CTextField error = new CTextField(s_res.getString("Error"));
    private CTextField mandatory = new CTextField(s_res.getString("Mandatory"));
    CButton button = new CButton("Button");
    CPanel tabPage1 = new CPanel();

    public PLAFEditorPanel() {
        this.init();
    }

    private void init() {
        this.setupUI();
        this.setupPreview();
        this.setLFSelection();
    }

    private void setupUI() {
        this.setLayout(new BorderLayout());
        CPanel selectionPanel = new CPanel();
        CPanel previewPart = new CPanel();
        this.add((Component)selectionPanel, "Center");
        this.add((Component)previewPart, "South");
        selectionPanel.setLayout(new GridBagLayout());
        CLabel label = new CLabel(s_res.getString("LookAndFeel"));
        label.setForeground(AdempierePLAF.getPrimary1());
        label.setFont(label.getFont().deriveFont(1));
        selectionPanel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        label = new CLabel(s_res.getString("Theme"));
        label.setForeground(AdempierePLAF.getPrimary1());
        label.setFont(label.getFont().deriveFont(1));
        selectionPanel.add((Component)label, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.lookList.setVisibleRowCount(12);
        JScrollPane scrollPane = new JScrollPane(this.lookList);
        scrollPane.setBorder(BorderFactory.createLineBorder(AdempierePLAF.getSecondary1(), 1));
        selectionPanel.add((Component)scrollPane, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 18, 3, new Insets(0, 5, 2, 2), 100, 0));
        this.themeList.setVisibleRowCount(12);
        scrollPane = new JScrollPane(this.themeList);
        scrollPane.setBorder(BorderFactory.createLineBorder(AdempierePLAF.getSecondary1(), 1));
        selectionPanel.add((Component)scrollPane, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 2, 2, 5), 0, 0));
        previewPart.setBorder(BorderFactory.createEmptyBorder());
        previewPart.setLayout(new GridBagLayout());
        label = new CLabel(s_res.getString("Preview"));
        label.setForeground(AdempierePLAF.getPrimary1());
        label.setFont(label.getFont().deriveFont(1));
        previewPart.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        previewPart.add((Component)this.previewPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 18, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.lookList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                PLAFEditorPanel.this.lookAndFeelSelectionChanged(e);
            }
        });
        this.themeList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                PLAFEditorPanel.this.themeSelectionChanged(e);
            }
        });
    }

    protected void themeSelectionChanged(ListSelectionEvent e) {
        if (this.m_setting) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        ValueNamePair laf = (ValueNamePair)this.lookList.getSelectedValue();
        ValueNamePair theme = (ValueNamePair)this.themeList.getSelectedValue();
        LookAndFeel currentLaf = UIManager.getLookAndFeel();
        MetalTheme currentTheme = MetalLookAndFeel.getCurrentTheme();
        AdempierePLAF.setPLAF(laf, theme, false);
        this.previewPanel.refresh(currentLaf, currentTheme);
        SwingUtilities.updateComponentTreeUI(this.previewPanel);
        this.updatePreviewComponents();
        this.setLFSelection();
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.repaint();
    }

    protected void lookAndFeelSelectionChanged(ListSelectionEvent e) {
        if (this.m_setting) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        ValueNamePair laf = (ValueNamePair)this.lookList.getSelectedValue();
        LookAndFeel currentLaf = UIManager.getLookAndFeel();
        MetalTheme currentTheme = MetalLookAndFeel.getCurrentTheme();
        AdempierePLAF.setPLAF(laf, null, false);
        this.previewPanel.refresh(currentLaf, currentTheme);
        SwingUtilities.updateComponentTreeUI(this.previewPanel);
        this.updatePreviewComponents();
        this.setLFSelection();
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.repaint();
    }

    private void updatePreviewComponents() {
        this.error.setBackground(true);
        this.mandatory.setMandatory(true);
        this.button.setOpaque(true);
        this.tabPage1.setOpaque(false);
    }

    private void setupPreview() {
        JRootPane rootPane = new JRootPane();
        this.previewPanel.setLayout(new BorderLayout());
        this.previewPanel.add((Component)rootPane, "Center");
        this.previewPanel.setBorder(BorderFactory.createLineBorder(AdempierePLAF.getSecondary1(), 1));
        GridLayout gridLayout = new GridLayout(1, 3);
        gridLayout.setHgap(4);
        rootPane.getContentPane().setLayout(gridLayout);
        rootPane.setGlassPane(new GlassPane());
        rootPane.getGlassPane().setVisible(true);
        CPanel column1 = new CPanel();
        rootPane.getContentPane().add(column1);
        CPanel column2 = new CPanel();
        rootPane.getContentPane().add(column2);
        CPanel column3 = new CPanel();
        rootPane.getContentPane().add(column3);
        column1.setLayout(new GridBagLayout());
        JTree jtree = new JTree();
        jtree.setFocusable(false);
        jtree.setBorder(BorderFactory.createLineBorder(AdempierePLAF.getSecondary1(), 1));
        column1.add((Component)jtree, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 2, 2), 0, 0));
        CTextField normal = new CTextField("Text Field");
        normal.setFocusable(false);
        column1.add((Component)normal, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 5, 5, 2), 0, 0));
        this.error.setBackground(true);
        this.error.setFocusable(false);
        column1.add((Component)this.error, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 5, 2), 0, 0));
        column2.setLayout(new GridBagLayout());
        JTable jtable = new JTable(s_data, s_columns);
        JScrollPane scrollPane = new JScrollPane(jtable);
        jtable.setFocusable(false);
        scrollPane.setPreferredSize(jtable.getPreferredSize());
        column2.add((Component)scrollPane, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 2, 2, 2), 0, 0));
        this.mandatory.setMandatory(true);
        this.mandatory.setFocusable(false);
        column2.add((Component)this.mandatory, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 5, 2), 0, 0));
        CTextField inactive = new CTextField(s_res.getString("Inactive"));
        inactive.setEnabled(false);
        column2.add((Component)inactive, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 5, 2), 0, 0));
        column3.setLayout(new GridBagLayout());
        CTabbedPane tab = new CTabbedPane();
        column3.add((Component)tab, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 2, 2, 5), 0, 0));
        CComboBox editable = new CComboBox(new Object[]{"Editable"});
        editable.setEditable(true);
        editable.setFocusable(false);
        column3.add((Component)editable, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 5, 2), 0, 0));
        CComboBox choice = new CComboBox(new Object[]{"Choice"});
        choice.setEditable(false);
        choice.setFocusable(false);
        column3.add((Component)choice, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 5, 5), 0, 0));
        this.tabPage1.setLayout(new BoxLayout(this.tabPage1, 1));
        JRadioButton radio = new JRadioButton("Radio");
        radio.setSelected(true);
        radio.setMargin(new Insets(5, 5, 5, 5));
        radio.setFocusable(false);
        radio.setOpaque(false);
        this.tabPage1.add(radio);
        CCheckBox checkBox = new CCheckBox("Checkbox");
        checkBox.setSelected(true);
        checkBox.setMargin(new Insets(5, 5, 5, 5));
        checkBox.setFocusable(false);
        this.tabPage1.add(checkBox);
        CLabel label = new CLabel("Label");
        label.setHorizontalAlignment(2);
        label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.tabPage1.add(label);
        this.button.setMargin(new Insets(5, 5, 5, 5));
        this.button.setFocusable(false);
        this.tabPage1.add(this.button);
        tab.add((Component)this.tabPage1, "tab1");
        tab.add((Component)new CPanel(), "tab2");
    }

    private void setLFSelection() {
        this.m_setting = true;
        ValueNamePair plaf = null;
        LookAndFeel lookFeel = UIManager.getLookAndFeel();
        String look = lookFeel.getClass().getName();
        for (int i = 0; i < AdempierePLAF.getPLAFs().length; ++i) {
            ValueNamePair vp = AdempierePLAF.getPLAFs()[i];
            if (!vp.getValue().equals(look)) continue;
            plaf = vp;
            break;
        }
        if (plaf != null) {
            this.lookList.setSelectedValue(plaf, true);
        }
        MetalTheme metalTheme = null;
        ValueNamePair theme = null;
        boolean metal = UIManager.getLookAndFeel() instanceof MetalLookAndFeel;
        this.themeList.setModel(new DefaultComboBoxModel<ValueNamePair>(AdempierePLAF.getThemes()));
        if (metal) {
            theme = null;
            AppContext context = AppContext.getAppContext();
            metalTheme = (MetalTheme)context.get("currentMetalTheme");
            if (metalTheme != null) {
                String lookTheme = metalTheme.getName();
                for (int i = 0; i < AdempierePLAF.getThemes().length; ++i) {
                    ValueNamePair vp = AdempierePLAF.getThemes()[i];
                    if (!vp.getName().equals(lookTheme)) continue;
                    theme = vp;
                    break;
                }
            }
            if (theme != null) {
                this.themeList.setSelectedValue(theme, true);
            }
        }
        this.m_setting = false;
        log.info(lookFeel + " - " + metalTheme);
    }

    public ValueNamePair getSelectedLook() {
        return (ValueNamePair)this.lookList.getSelectedValue();
    }

    public ValueNamePair getSelectedTheme() {
        return (ValueNamePair)this.themeList.getSelectedValue();
    }
}

