/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo.handler;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo.AbstractElementHandler;
import org.adempiere.pipo.Element;
import org.adempiere.pipo.exception.DatabaseAccessException;
import org.adempiere.pipo.exception.POSaveFailedException;
import org.adempiere.pipo.handler.ReferenceListElementHandler;
import org.adempiere.pipo.handler.ReferenceTableElementHandler;
import org.compiere.model.X_AD_Reference;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ReferenceElementHandler
extends AbstractElementHandler {
    private ReferenceListElementHandler listHandler = new ReferenceListElementHandler();
    private ReferenceTableElementHandler tableHandler = new ReferenceTableElementHandler();
    private List<Integer> references = new ArrayList<Integer>();

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void startElement(Properties ctx, Element element) throws SAXException {
        String elementValue = element.getElementValue();
        int AD_Backup_ID = -1;
        String Object_Status = null;
        Attributes atts = element.attributes;
        this.log.info(elementValue + " " + atts.getValue("name"));
        String entitytype = atts.getValue("EntityType");
        String name = atts.getValue("name");
        if (!this.isProcessElement(ctx, entitytype)) {
            element.skip = true;
            return;
        }
        int id = this.get_ID(ctx, "AD_Reference", name);
        X_AD_Reference m_Reference = new X_AD_Reference(ctx, id, this.getTrxName(ctx));
        if (id <= 0 && atts.getValue("AD_Reference_ID") != null && Integer.parseInt(atts.getValue("AD_Reference_ID")) <= 999999) {
            m_Reference.setAD_Reference_ID(Integer.parseInt(atts.getValue("AD_Reference_ID")));
        }
        if (id > 0) {
            AD_Backup_ID = this.copyRecord(ctx, "AD_Reference", m_Reference);
            Object_Status = "Update";
            if (this.references.contains(id)) {
                element.skip = true;
                return;
            }
        } else {
            Object_Status = "New";
            AD_Backup_ID = 0;
        }
        m_Reference.setDescription(this.getStringValue(atts, "Description"));
        m_Reference.setEntityType(atts.getValue("EntityType"));
        m_Reference.setHelp(this.getStringValue(atts, "Help"));
        m_Reference.setIsActive(atts.getValue("isActive") != null ? Boolean.valueOf(atts.getValue("isActive")) : true);
        m_Reference.setName(atts.getValue("name"));
        m_Reference.setValidationType(atts.getValue("ValidationType"));
        if (m_Reference.save(this.getTrxName(ctx))) {
            this.record_log(ctx, 1, m_Reference.getName(), "Reference", m_Reference.get_ID(), AD_Backup_ID, Object_Status, "AD_Reference", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_Reference"));
            this.references.add(m_Reference.getAD_Reference_ID());
            element.recordId = m_Reference.getAD_Reference_ID();
            return;
        }
        this.record_log(ctx, 0, m_Reference.getName(), "Reference", m_Reference.get_ID(), AD_Backup_ID, Object_Status, "AD_Reference", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_Reference"));
        throw new POSaveFailedException("Reference");
    }

    @Override
    public void endElement(Properties ctx, Element element) throws SAXException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(Properties ctx, TransformerHandler document) throws SAXException {
        int Reference_id = Env.getContextAsInt(ctx, "AD_Reference_ID");
        if (this.references.contains(Reference_id)) {
            return;
        }
        this.references.add(Reference_id);
        AttributesImpl atts = new AttributesImpl();
        String sql = "SELECT * FROM AD_Reference WHERE AD_Reference_ID= " + Reference_id;
        CPreparedStatement pstmt = null;
        pstmt = DB.prepareStatement(sql, this.getTrxName(ctx));
        try {
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                ResultSet rs1;
                CPreparedStatement pstmt1;
                String sql1;
                X_AD_Reference m_Reference = new X_AD_Reference(ctx, rs.getInt("AD_Reference_ID"), null);
                this.createReferenceBinding(atts, m_Reference);
                document.startElement("", "", "reference", atts);
                if (m_Reference.getValidationType().compareTo("L") == 0) {
                    sql1 = "SELECT * FROM AD_Ref_List WHERE AD_Reference_ID= " + Reference_id + " ORDER BY Value, AD_Ref_List_ID";
                    pstmt1 = null;
                    pstmt1 = DB.prepareStatement(sql1, this.getTrxName(ctx));
                    try {
                        rs1 = pstmt1.executeQuery();
                        while (rs1.next()) {
                            this.createReferenceList(ctx, document, rs1.getInt("AD_REF_LIST_ID"));
                        }
                        rs1.close();
                        pstmt1.close();
                        pstmt1 = null;
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, e.getLocalizedMessage(), e);
                        if (e instanceof SAXException) {
                            throw (SAXException)e;
                        }
                        if (e instanceof SQLException) {
                            throw new DatabaseAccessException("Failed to export Reference.", e);
                        }
                        if (e instanceof RuntimeException) {
                            throw (RuntimeException)e;
                        }
                        throw new RuntimeException("Failed to export Reference.", e);
                    }
                    finally {
                        try {
                            if (pstmt1 != null) {
                                pstmt1.close();
                            }
                        }
                        catch (Exception exception) {}
                        pstmt1 = null;
                    }
                }
                if (m_Reference.getValidationType().compareTo("T") == 0) {
                    sql1 = "SELECT AD_Reference_ID FROM AD_Ref_Table WHERE AD_Reference_ID = " + Reference_id;
                    pstmt1 = null;
                    pstmt1 = DB.prepareStatement(sql1, this.getTrxName(ctx));
                    try {
                        rs1 = pstmt1.executeQuery();
                        while (rs1.next()) {
                            this.createReferenceTable(ctx, document, Reference_id);
                        }
                        rs1.close();
                        pstmt1.close();
                        pstmt1 = null;
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, "getRef_Table", e);
                    }
                    finally {
                        try {
                            if (pstmt1 != null) {
                                pstmt1.close();
                            }
                        }
                        catch (Exception exception) {}
                        pstmt1 = null;
                    }
                }
                document.endElement("", "", "reference");
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "getRefence", e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {}
            pstmt = null;
        }
    }

    private void createReferenceTable(Properties ctx, TransformerHandler document, int reference_id) throws SAXException {
        Env.setContext(ctx, "AD_Reference_ID", reference_id);
        this.tableHandler.create(ctx, document);
        ctx.remove("AD_Reference_ID");
    }

    private void createReferenceList(Properties ctx, TransformerHandler document, int AD_Ref_List_ID) throws SAXException {
        Env.setContext(ctx, "AD_Ref_List_ID", AD_Ref_List_ID);
        this.listHandler.create(ctx, document);
        ctx.remove("AD_Ref_List_ID");
    }

    private AttributesImpl createReferenceBinding(AttributesImpl atts, X_AD_Reference m_Reference) {
        String sql = null;
        String name = null;
        atts.clear();
        if (m_Reference.getAD_Reference_ID() <= 999999) {
            atts.addAttribute("", "", "AD_Reference_ID", "CDATA", Integer.toString(m_Reference.getAD_Reference_ID()));
        }
        if (m_Reference.getAD_Reference_ID() > 0) {
            sql = "SELECT Name FROM AD_Reference WHERE AD_Reference_ID=?";
            name = DB.getSQLValueString(null, sql, m_Reference.getAD_Reference_ID());
            atts.addAttribute("", "", "name", "CDATA", name);
        } else {
            atts.addAttribute("", "", "name", "CDATA", "");
        }
        atts.addAttribute("", "", "Description", "CDATA", m_Reference.getDescription() != null ? m_Reference.getDescription() : "");
        atts.addAttribute("", "", "EntityType", "CDATA", m_Reference.getEntityType() != null ? m_Reference.getEntityType() : "");
        atts.addAttribute("", "", "Help", "CDATA", m_Reference.getHelp() != null ? m_Reference.getHelp() : "");
        atts.addAttribute("", "", "Name", "CDATA", m_Reference.getName() != null ? m_Reference.getName() : "");
        atts.addAttribute("", "", "isActive", "CDATA", m_Reference.isActive() ? "true" : "false");
        atts.addAttribute("", "", "VFormat", "CDATA", m_Reference.getVFormat() != null ? m_Reference.getVFormat() : "");
        atts.addAttribute("", "", "ValidationType", "CDATA", m_Reference.getValidationType() != null ? m_Reference.getValidationType() : "");
        return atts;
    }
}

