/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo.handler;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo.AbstractElementHandler;
import org.adempiere.pipo.Element;
import org.adempiere.pipo.exception.DatabaseAccessException;
import org.adempiere.pipo.exception.POSaveFailedException;
import org.adempiere.pipo.handler.ImpFormatRowElementHandler;
import org.compiere.model.X_AD_ImpFormat;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ImpFormatElementHandler
extends AbstractElementHandler {
    private ImpFormatRowElementHandler rowHandler = new ImpFormatRowElementHandler();
    private List<Integer> formats = new ArrayList<Integer>();

    @Override
    public void startElement(Properties ctx, Element element) throws SAXException {
        String elementValue = element.getElementValue();
        int AD_Backup_ID = -1;
        String Object_Status = null;
        Attributes atts = element.attributes;
        this.log.info(elementValue + " " + atts.getValue("Name"));
        int id = this.get_ID(ctx, "AD_ImpFormat", atts.getValue("Name"));
        X_AD_ImpFormat m_ImpFormat = new X_AD_ImpFormat(ctx, id, this.getTrxName(ctx));
        if (id <= 0 && atts.getValue("AD_ImpFormat_ID") != null && Integer.parseInt(atts.getValue("AD_ImpFormat_ID")) <= 999999) {
            m_ImpFormat.setAD_ImpFormat_ID(Integer.parseInt(atts.getValue("AD_ImpFormat_ID")));
        }
        if (id > 0) {
            AD_Backup_ID = this.copyRecord(ctx, "AD_ImpFormat", m_ImpFormat);
            Object_Status = "Update";
        } else {
            Object_Status = "New";
            AD_Backup_ID = 0;
        }
        m_ImpFormat.setName(atts.getValue("Name"));
        String name = atts.getValue("ADTableNameID");
        if (name != null && name.trim().length() > 0) {
            id = this.get_IDWithColumn(ctx, "AD_Table", "TableName", name);
            if (id <= 0) {
                element.defer = true;
                return;
            }
            m_ImpFormat.setAD_Table_ID(id);
        }
        m_ImpFormat.setIsActive(atts.getValue("isActive") != null ? Boolean.valueOf(atts.getValue("isActive")) : true);
        m_ImpFormat.setProcessing(atts.getValue("isProcessing") != null ? Boolean.valueOf(atts.getValue("isProcessing")) : true);
        m_ImpFormat.setName(atts.getValue("Name"));
        m_ImpFormat.setDescription(this.getStringValue(atts, "Description"));
        m_ImpFormat.setFormatType(atts.getValue("FormatType"));
        if (!m_ImpFormat.save(this.getTrxName(ctx))) {
            this.record_log(ctx, 0, m_ImpFormat.getName(), "ImpFormat", m_ImpFormat.get_ID(), AD_Backup_ID, Object_Status, "AD_ImpFormat", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_ImpFormat"));
            throw new POSaveFailedException("Failed to save Import Format.");
        }
        this.record_log(ctx, 1, m_ImpFormat.getName(), "ImpFormat", m_ImpFormat.get_ID(), AD_Backup_ID, Object_Status, "AD_ImpFormat", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_ImpFormat"));
    }

    @Override
    public void endElement(Properties ctx, Element element) throws SAXException {
    }

    @Override
    public void create(Properties ctx, TransformerHandler document) throws SAXException {
        int import_id = Env.getContextAsInt(ctx, "AD_ImpFormat_ID");
        if (this.formats.contains(import_id)) {
            return;
        }
        this.formats.add(import_id);
        AttributesImpl atts = new AttributesImpl();
        X_AD_ImpFormat m_ImpFormat = new X_AD_ImpFormat(ctx, import_id, null);
        atts = this.createImpFormatBinding(atts, m_ImpFormat);
        document.startElement("", "", "impformat", atts);
        String sql = "SELECT * FROM AD_ImpFormat_Row WHERE AD_ImpFormat_ID= " + import_id + " ORDER BY " + "AD_ImpFormat_Row_ID";
        CPreparedStatement pstmt = null;
        pstmt = DB.prepareStatement(sql, this.getTrxName(ctx));
        try {
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                this.createImpFormatRow(ctx, document, rs.getInt("AD_ImpFormat_Row_ID"));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "ImpFormat", e);
            throw new DatabaseAccessException("Failed to export Import Format.", e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {}
            pstmt = null;
        }
        document.endElement("", "", "impformat");
    }

    private void createImpFormatRow(Properties ctx, TransformerHandler document, int AD_ImpFormat_Row_ID) throws SAXException {
        Env.setContext(ctx, "AD_ImpFormat_Row_ID", AD_ImpFormat_Row_ID);
        this.rowHandler.create(ctx, document);
        ctx.remove("AD_ImpFormat_Row_ID");
    }

    private AttributesImpl createImpFormatBinding(AttributesImpl atts, X_AD_ImpFormat m_ImpFormat) {
        atts.clear();
        if (m_ImpFormat.getAD_ImpFormat_ID() <= 999999) {
            atts.addAttribute("", "", "AD_ImpFormat_ID", "CDATA", Integer.toString(m_ImpFormat.getAD_ImpFormat_ID()));
        }
        if (m_ImpFormat.getAD_Table_ID() > 0) {
            String sql = "SELECT TableName FROM AD_Table WHERE AD_Table_ID=?";
            String name = DB.getSQLValueString(null, sql, m_ImpFormat.getAD_Table_ID());
            atts.addAttribute("", "", "ADTableNameID", "CDATA", name);
        } else {
            atts.addAttribute("", "", "ADTableNameID", "CDATA", "");
        }
        atts.addAttribute("", "", "Name", "CDATA", m_ImpFormat.getName() != null ? m_ImpFormat.getName() : "");
        atts.addAttribute("", "", "isActive", "CDATA", m_ImpFormat.isActive() ? "true" : "false");
        atts.addAttribute("", "", "isProcessing", "CDATA", m_ImpFormat.isProcessing() ? "true" : "false");
        atts.addAttribute("", "", "Description", "CDATA", m_ImpFormat.getDescription() != null ? m_ImpFormat.getDescription() : "");
        atts.addAttribute("", "", "FormatType", "CDATA", m_ImpFormat.getFormatType() != null ? m_ImpFormat.getFormatType() : "");
        return atts;
    }
}

